/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.resgen;

import java.io.File;
import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.util.HashSet;
import java.util.Set;
import org.apache.tools.ant.BuildException;
import org.eigenbase.resgen.AbstractJavaGenerator;
import org.eigenbase.resgen.ResourceDef;
import org.eigenbase.resgen.ResourceGen;
import org.eigenbase.resgen.Util;

class JavaBaseGenerator
extends AbstractJavaGenerator {
    protected final Set warnedClasses = new HashSet();
    static /* synthetic */ Class class$org$eigenbase$resgen$ResourceInstance;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Throwable;

    JavaBaseGenerator(File file, File file2, String string, String string2, ResourceDef.ResourceBundle resourceBundle) {
        super(file, file2, string, resourceBundle, string2);
    }

    public void generateModule(ResourceGen resourceGen, ResourceDef.ResourceBundle resourceBundle, PrintWriter printWriter) {
        this.generateHeader(printWriter);
        String string = this.getClassName();
        String string2 = Util.removePackage(string);
        printWriter.print("public class " + string2);
        String string3 = this.getBaseClassName();
        if (string3 != null) {
            printWriter.print(" extends " + string3);
        }
        printWriter.println(" {");
        printWriter.println("    public " + string2 + "() throws IOException {");
        printWriter.println("    }");
        printWriter.println("    private static final String baseName = " + Util.quoteForJava(this.getClassName()) + ";");
        printWriter.println("    /**");
        printWriter.println("     * Retrieves the singleton instance of {@link " + string2 + "}. If");
        printWriter.println("     * the application has called {@link #setThreadLocale}, returns the");
        printWriter.println("     * resource for the thread's locale.");
        printWriter.println("     */");
        printWriter.println("    public static synchronized " + string2 + " instance() {");
        printWriter.println("        return (" + string2 + ") instance(baseName);");
        printWriter.println("    }");
        printWriter.println("    /**");
        printWriter.println("     * Retrieves the instance of {@link " + string2 + "} for the given locale.");
        printWriter.println("     */");
        printWriter.println("    public static synchronized " + string2 + " instance(Locale locale) {");
        printWriter.println("        return (" + string2 + ") instance(baseName, locale);");
        printWriter.println("    }");
        if (resourceBundle.code != null) {
            printWriter.println("    // begin of included code");
            printWriter.print(resourceBundle.code.cdata);
            printWriter.println("    // end of included code");
        }
        for (int i = 0; i < resourceBundle.resources.length; ++i) {
            ResourceDef.Resource resource = resourceBundle.resources[i];
            this.generateResource(resource, printWriter);
        }
        printWriter.println("");
        this.postModule(printWriter);
        printWriter.println("}");
    }

    protected void postModule(PrintWriter printWriter) {
    }

    public void generateResource(ResourceDef.Resource resource, PrintWriter printWriter) {
        if (resource.text == null) {
            throw new BuildException("Resource '" + resource.name + "' has no message");
        }
        String string = resource.text.cdata;
        String string2 = ResourceGen.getComment(resource);
        String string3 = ResourceGen.getResourceInitcap(resource);
        String string4 = "org.eigenbase.resgen.ResourceDefinition";
        String string5 = this.getParameterList(string);
        String string6 = this.getArgumentList(string);
        String string7 = string6.equals("") ? "emptyObjectArray" : "new Object[] {" + string6 + "}";
        printWriter.println();
        Util.generateCommentBlock(printWriter, resource.name, string, string2);
        printWriter.println("    public static final " + string4 + " " + string3 + " = new " + string4 + "(\"" + string3 + "\", " + Util.quoteForJava(string) + ");");
        printWriter.println("    public String get" + string3 + "(" + string5 + ") {");
        printWriter.println("        return " + string3 + ".instantiate(" + JavaBaseGenerator.addLists("this", string7) + ").toString();");
        printWriter.println("    }");
        if (resource instanceof ResourceDef.Exception) {
            ResourceDef.Exception exception = (ResourceDef.Exception)resource;
            String string8 = this.getErrorClass(exception);
            ExceptionDescription exceptionDescription = new ExceptionDescription(string8);
            if (exceptionDescription.hasInstCon) {
                printWriter.println("    public " + string8 + " new" + string3 + "(" + string5 + ") {");
                printWriter.println("        return new " + string8 + "(" + string3 + ".instantiate(" + JavaBaseGenerator.addLists("this", string7) + "));");
                printWriter.println("    }");
            } else if (exceptionDescription.hasInstThrowCon) {
                printWriter.println("    public " + string8 + " new" + string3 + "(" + string5 + ") {");
                printWriter.println("        return new " + string8 + "(" + string3 + ".instantiate(" + JavaBaseGenerator.addLists("this", string7) + "), null);");
                printWriter.println("    }");
            } else if (exceptionDescription.hasStringCon) {
                printWriter.println("    public " + string8 + " new" + string3 + "(" + string5 + ") {");
                printWriter.println("        return new " + string8 + "(get" + string3 + "(" + string6 + "));");
                printWriter.println("    }");
            } else if (exceptionDescription.hasStringThrowCon) {
                printWriter.println("    public " + string8 + " new" + string3 + "(" + string5 + ") {");
                printWriter.println("        return new " + string8 + "(get" + string3 + "(" + string6 + "), null);");
                printWriter.println("    }");
            }
            if (exceptionDescription.hasInstThrowCon) {
                printWriter.println("    public " + string8 + " new" + string3 + "(" + JavaBaseGenerator.addLists(string5, "Throwable err") + ") {");
                printWriter.println("        return new " + string8 + "(" + string3 + ".instantiate(" + JavaBaseGenerator.addLists("this", string7) + "), err);");
                printWriter.println("    }");
            } else if (exceptionDescription.hasStringThrowCon) {
                printWriter.println("    public " + string8 + " new" + string3 + "(" + JavaBaseGenerator.addLists(string5, "Throwable err") + ") {");
                printWriter.println("        return new " + string8 + "(get" + string3 + "(" + string6 + "), err);");
                printWriter.println("    }");
            }
        }
    }

    protected static String addLists(String string, String string2) {
        if (string == null || string.equals("")) {
            if (string2 == null || string2.equals("")) {
                return "";
            }
            return string2;
        }
        if (string2 == null || string2.equals("")) {
            return string;
        }
        return string + ", " + string2;
    }

    protected static String addLists(String string, String string2, String string3) {
        return JavaBaseGenerator.addLists(string, JavaBaseGenerator.addLists(string2, string3));
    }

    class ExceptionDescription {
        boolean hasInstCon;
        boolean hasInstThrowCon;
        boolean hasStringCon;
        boolean hasStringThrowCon;

        ExceptionDescription(String string) {
            block8: {
                this.hasInstCon = false;
                this.hasInstThrowCon = false;
                this.hasStringCon = false;
                this.hasStringThrowCon = false;
                try {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName(string);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        clazz = Class.forName("java.lang." + string);
                    }
                    Constructor<?>[] constructorArray = clazz.getConstructors();
                    for (int i = 0; i < constructorArray.length; ++i) {
                        Constructor<?> constructor = constructorArray[i];
                        Class<?>[] classArray = constructor.getParameterTypes();
                        if (classArray.length == 1 && (class$org$eigenbase$resgen$ResourceInstance == null ? JavaBaseGenerator.class$("org.eigenbase.resgen.ResourceInstance") : class$org$eigenbase$resgen$ResourceInstance).isAssignableFrom(classArray[0])) {
                            this.hasInstCon = true;
                        }
                        if (classArray.length == 1 && (class$java$lang$String == null ? JavaBaseGenerator.class$("java.lang.String") : class$java$lang$String).isAssignableFrom(classArray[0])) {
                            this.hasStringCon = true;
                        }
                        if (classArray.length == 2 && (class$org$eigenbase$resgen$ResourceInstance == null ? JavaBaseGenerator.class$("org.eigenbase.resgen.ResourceInstance") : class$org$eigenbase$resgen$ResourceInstance).isAssignableFrom(classArray[0]) && (class$java$lang$Throwable == null ? JavaBaseGenerator.class$("java.lang.Throwable") : class$java$lang$Throwable).isAssignableFrom(classArray[1])) {
                            this.hasInstThrowCon = true;
                        }
                        if (classArray.length != 2 || !(class$java$lang$String == null ? JavaBaseGenerator.class$("java.lang.String") : class$java$lang$String).isAssignableFrom(classArray[0]) || !(class$java$lang$Throwable == null ? JavaBaseGenerator.class$("java.lang.Throwable") : class$java$lang$Throwable).isAssignableFrom(classArray[1])) continue;
                        this.hasStringThrowCon = true;
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    if (!JavaBaseGenerator.this.warnedClasses.add(string)) break block8;
                    System.out.println("Warning: Could not find exception class '" + string + "' on classpath. " + "Exception factory methods will not be generated.");
                }
            }
        }
    }
}

