/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.support;

import org.springframework.beans.BeansException;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.ConstructorArgumentValues;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.ChildBeanDefinition;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class BeanDefinitionReaderUtils {
    public static final String GENERATED_BEAN_NAME_SEPARATOR = "#";

    public static AbstractBeanDefinition createBeanDefinition(String className, String parent, ConstructorArgumentValues cargs, MutablePropertyValues pvs, ClassLoader classLoader) throws ClassNotFoundException {
        AbstractBeanDefinition bd = BeanDefinitionReaderUtils.createBeanDefinition(parent, className, classLoader);
        bd.setConstructorArgumentValues(cargs);
        bd.setPropertyValues(pvs);
        return bd;
    }

    public static AbstractBeanDefinition createBeanDefinition(String parent, String className, ClassLoader classLoader) throws ClassNotFoundException {
        AbstractBeanDefinition bd = null;
        bd = parent != null ? new ChildBeanDefinition(parent) : new RootBeanDefinition();
        if (className != null) {
            if (classLoader != null) {
                bd.setBeanClass(ClassUtils.forName((String)className, (ClassLoader)classLoader));
            } else {
                bd.setBeanClassName(className);
            }
        }
        return bd;
    }

    public static String generateBeanName(AbstractBeanDefinition beanDefinition, BeanDefinitionRegistry beanFactory, boolean isInnerBean) throws BeanDefinitionStoreException {
        String generatedId = beanDefinition.getBeanClassName();
        if (generatedId == null) {
            if (beanDefinition instanceof ChildBeanDefinition) {
                generatedId = ((ChildBeanDefinition)beanDefinition).getParentName() + "$child";
            } else if (beanDefinition.getFactoryBeanName() != null) {
                generatedId = beanDefinition.getFactoryBeanName() + "$created";
            }
        }
        if (!StringUtils.hasText((String)generatedId)) {
            throw new BeanDefinitionStoreException("Unnamed bean definition specifies neither 'class' nor 'parent' nor 'factory-bean' - can't generate bean name");
        }
        String id = generatedId;
        if (isInnerBean) {
            id = generatedId + GENERATED_BEAN_NAME_SEPARATOR + ObjectUtils.getIdentityHexString((Object)beanDefinition);
        } else {
            int counter = 0;
            while (beanFactory.containsBeanDefinition(id)) {
                id = generatedId + GENERATED_BEAN_NAME_SEPARATOR + ++counter;
            }
        }
        return id;
    }

    public static String generateBeanName(AbstractBeanDefinition beanDefinition, BeanDefinitionRegistry beanFactory) throws BeanDefinitionStoreException {
        return BeanDefinitionReaderUtils.generateBeanName(beanDefinition, beanFactory, false);
    }

    public static void registerBeanDefinition(BeanDefinitionHolder bdHolder, BeanDefinitionRegistry beanFactory) throws BeansException {
        String beanName = bdHolder.getBeanName();
        beanFactory.registerBeanDefinition(beanName, bdHolder.getBeanDefinition());
        String[] aliases = bdHolder.getAliases();
        if (aliases != null) {
            for (int i = 0; i < aliases.length; ++i) {
                beanFactory.registerAlias(beanName, aliases[i]);
            }
        }
    }

    public static String registerWithGeneratedName(AbstractBeanDefinition beanDefinition, BeanDefinitionRegistry beanFactory) throws BeanDefinitionStoreException {
        String generatedName = BeanDefinitionReaderUtils.generateBeanName(beanDefinition, beanFactory, false);
        beanFactory.registerBeanDefinition(generatedName, beanDefinition);
        return generatedName;
    }
}

