/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.provider;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.cert.Certificate;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.commons.vfs.FileContent;
import org.apache.commons.vfs.FileContentInfo;
import org.apache.commons.vfs.FileContentInfoFactory;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.RandomAccessContent;
import org.apache.commons.vfs.provider.AbstractFileObject;
import org.apache.commons.vfs.provider.AbstractFileSystem;
import org.apache.commons.vfs.provider.FileContentThreadData;
import org.apache.commons.vfs.util.MonitorInputStream;
import org.apache.commons.vfs.util.MonitorOutputStream;
import org.apache.commons.vfs.util.MonitorRandomAccessContent;
import org.apache.commons.vfs.util.RandomAccessMode;

public final class DefaultFileContent
implements FileContent {
    static final int STATE_CLOSED = 0;
    static final int STATE_OPENED = 1;
    private final AbstractFileObject file;
    private Map attrs;
    private Map roAttrs;
    private FileContentInfo fileContentInfo;
    private final FileContentInfoFactory fileContentInfoFactory;
    private final ThreadLocal threadData = new ThreadLocal();
    private int openStreams = 0;

    public DefaultFileContent(AbstractFileObject file, FileContentInfoFactory fileContentInfoFactory) {
        this.file = file;
        this.fileContentInfoFactory = fileContentInfoFactory;
    }

    private FileContentThreadData getThreadData() {
        FileContentThreadData data = (FileContentThreadData)this.threadData.get();
        if (data == null) {
            data = new FileContentThreadData();
            this.threadData.set(data);
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void streamOpened() {
        DefaultFileContent defaultFileContent = this;
        synchronized (defaultFileContent) {
            ++this.openStreams;
        }
        ((AbstractFileSystem)this.file.getFileSystem()).streamOpened();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void streamClosed() {
        DefaultFileContent defaultFileContent = this;
        synchronized (defaultFileContent) {
            if (this.openStreams > 0) {
                --this.openStreams;
                if (this.openStreams < 1) {
                    this.file.notifyAllStreamsClosed();
                }
            }
        }
        ((AbstractFileSystem)this.file.getFileSystem()).streamClosed();
    }

    public FileObject getFile() {
        return this.file;
    }

    public long getSize() throws FileSystemException {
        if (!this.file.getType().hasContent()) {
            throw new FileSystemException("vfs.provider/get-size-not-file.error", this.file);
        }
        try {
            return this.file.doGetContentSize();
        }
        catch (Exception exc) {
            throw new FileSystemException("vfs.provider/get-size.error", new Object[]{this.file}, (Throwable)exc);
        }
    }

    public long getLastModifiedTime() throws FileSystemException {
        if (!this.file.getType().hasAttributes()) {
            throw new FileSystemException("vfs.provider/get-last-modified-no-exist.error", this.file);
        }
        try {
            return this.file.doGetLastModifiedTime();
        }
        catch (Exception e) {
            throw new FileSystemException("vfs.provider/get-last-modified.error", this.file, (Throwable)e);
        }
    }

    public void setLastModifiedTime(long modTime) throws FileSystemException {
        if (!this.file.getType().hasAttributes()) {
            throw new FileSystemException("vfs.provider/set-last-modified-no-exist.error", this.file);
        }
        try {
            if (!this.file.doSetLastModTime(modTime)) {
                throw new FileSystemException("vfs.provider/set-last-modified.error", this.file);
            }
        }
        catch (Exception e) {
            throw new FileSystemException("vfs.provider/set-last-modified.error", this.file, (Throwable)e);
        }
    }

    public Map getAttributes() throws FileSystemException {
        if (!this.file.getType().hasAttributes()) {
            throw new FileSystemException("vfs.provider/get-attributes-no-exist.error", this.file);
        }
        if (this.roAttrs == null) {
            try {
                this.attrs = this.file.doGetAttributes();
                this.roAttrs = Collections.unmodifiableMap(this.attrs);
            }
            catch (Exception e) {
                throw new FileSystemException("vfs.provider/get-attributes.error", this.file, (Throwable)e);
            }
        }
        return this.roAttrs;
    }

    public String[] getAttributeNames() throws FileSystemException {
        this.getAttributes();
        Set names = this.attrs.keySet();
        return names.toArray(new String[names.size()]);
    }

    public Object getAttribute(String attrName) throws FileSystemException {
        this.getAttributes();
        if (this.attrs.containsKey(attrName)) {
            return this.attrs.get(attrName);
        }
        return this.attrs.get(attrName.toLowerCase());
    }

    public void setAttribute(String attrName, Object value) throws FileSystemException {
        if (!this.file.getType().hasAttributes()) {
            throw new FileSystemException("vfs.provider/set-attribute-no-exist.error", new Object[]{attrName, this.file});
        }
        try {
            this.file.doSetAttribute(attrName, value);
        }
        catch (Exception e) {
            throw new FileSystemException("vfs.provider/set-attribute.error", new Object[]{attrName, this.file}, (Throwable)e);
        }
        if (this.attrs != null) {
            this.attrs.put(attrName, value);
        }
    }

    public Certificate[] getCertificates() throws FileSystemException {
        if (!this.file.exists()) {
            throw new FileSystemException("vfs.provider/get-certificates-no-exist.error", this.file);
        }
        try {
            Certificate[] certs = this.file.doGetCertificates();
            if (certs != null) {
                return certs;
            }
            return new Certificate[0];
        }
        catch (Exception e) {
            throw new FileSystemException("vfs.provider/get-certificates.error", this.file, (Throwable)e);
        }
    }

    public InputStream getInputStream() throws FileSystemException {
        InputStream instr = this.file.getInputStream();
        FileContentInputStream wrappedInstr = new FileContentInputStream(this.file, instr);
        this.getThreadData().addInstr(wrappedInstr);
        this.streamOpened();
        return wrappedInstr;
    }

    public RandomAccessContent getRandomAccessContent(RandomAccessMode mode) throws FileSystemException {
        RandomAccessContent rastr = this.file.getRandomAccessContent(mode);
        FileRandomAccessContent rac = new FileRandomAccessContent(this.file, rastr);
        this.getThreadData().addRastr(rac);
        this.streamOpened();
        return rac;
    }

    public OutputStream getOutputStream() throws FileSystemException {
        return this.getOutputStream(false);
    }

    public OutputStream getOutputStream(boolean bAppend) throws FileSystemException {
        if (this.getThreadData().getOutstr() != null) {
            throw new FileSystemException("vfs.provider/write-in-use.error", this.file);
        }
        OutputStream outstr = this.file.getOutputStream(bAppend);
        this.getThreadData().setOutstr(new FileContentOutputStream(this.file, outstr));
        this.streamOpened();
        return this.getThreadData().getOutstr();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws FileSystemException {
        try {
            while (this.getThreadData().getInstrsSize() > 0) {
                FileContentInputStream instr = (FileContentInputStream)this.getThreadData().removeInstr(0);
                instr.close();
            }
            while (this.getThreadData().getRastrsSize() > 0) {
                RandomAccessContent ra = (RandomAccessContent)this.getThreadData().removeRastr(0);
                try {
                    ra.close();
                }
                catch (IOException e) {
                    throw new FileSystemException(e);
                }
            }
            if (this.getThreadData().getOutstr() != null) {
                this.getThreadData().closeOutstr();
            }
        }
        finally {
            this.threadData.set(null);
        }
    }

    private void endInput(FileContentInputStream instr) {
        this.getThreadData().removeInstr(instr);
        this.streamClosed();
    }

    private void endRandomAccess(RandomAccessContent rac) {
        this.getThreadData().removeRastr(rac);
        this.streamClosed();
    }

    private void endOutput() throws Exception {
        this.streamClosed();
        this.getThreadData().setOutstr(null);
        this.file.endOutput();
    }

    public boolean isOpen() {
        return this.getThreadData().hasStreams();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isOpenGlobal() {
        DefaultFileContent defaultFileContent = this;
        synchronized (defaultFileContent) {
            return this.openStreams > 0;
        }
    }

    public FileContentInfo getContentInfo() throws FileSystemException {
        if (this.fileContentInfo == null) {
            this.fileContentInfo = this.fileContentInfoFactory.create(this);
        }
        return this.fileContentInfo;
    }

    final class FileContentOutputStream
    extends MonitorOutputStream {
        private final FileObject file;

        FileContentOutputStream(FileObject file, OutputStream outstr) {
            super(outstr);
            this.file = file;
        }

        public void close() throws FileSystemException {
            try {
                super.close();
            }
            catch (IOException e) {
                throw new FileSystemException("vfs.provider/close-outstr.error", this.file, (Throwable)e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void onClose() throws IOException {
            try {
                super.onClose();
            }
            finally {
                try {
                    DefaultFileContent.this.endOutput();
                }
                catch (Exception e) {
                    throw new FileSystemException("vfs.provider/close-outstr.error", this.file, (Throwable)e);
                }
            }
        }
    }

    private final class FileRandomAccessContent
    extends MonitorRandomAccessContent {
        private final FileObject file;
        private final RandomAccessContent content;

        FileRandomAccessContent(FileObject file, RandomAccessContent content) {
            super(content);
            this.file = file;
            this.content = content;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void onClose() throws IOException {
            try {
                super.onClose();
            }
            finally {
                DefaultFileContent.this.endRandomAccess(this.content);
            }
        }
    }

    private final class FileContentInputStream
    extends MonitorInputStream {
        private final FileObject file;

        FileContentInputStream(FileObject file, InputStream instr) {
            super(instr);
            this.file = file;
        }

        public void close() throws FileSystemException {
            try {
                super.close();
            }
            catch (IOException e) {
                throw new FileSystemException("vfs.provider/close-instr.error", this.file, (Throwable)e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void onClose() throws IOException {
            try {
                super.onClose();
            }
            finally {
                DefaultFileContent.this.endInput(this);
            }
        }
    }
}

