/*
 * Decompiled with CFR 0.152.
 */
package mondrian.xmla;

import com.rc.retroweaver.runtime.Collections;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import mondrian.olap.Util;
import mondrian.spi.CatalogLocator;
import mondrian.spi.impl.ServletContextCatalogLocator;
import mondrian.xmla.DataSourcesConfig;
import mondrian.xmla.XmlaConstants;
import mondrian.xmla.XmlaException;
import mondrian.xmla.XmlaHandler;
import mondrian.xmla.XmlaRequestCallback;
import org.apache.log4j.Logger;
import org.eigenbase.xom.DOMWrapper;
import org.eigenbase.xom.Parser;
import org.eigenbase.xom.XOMException;
import org.eigenbase.xom.XOMUtil;
import org.w3c.dom.Element;

public abstract class XmlaServlet
extends HttpServlet
implements XmlaConstants {
    private static final Logger LOGGER = Logger.getLogger((Class)(class$mondrian$xmla$XmlaServlet == null ? (class$mondrian$xmla$XmlaServlet = XmlaServlet.class$("mondrian.xmla.XmlaServlet")) : class$mondrian$xmla$XmlaServlet));
    public static final String PARAM_DATASOURCES_CONFIG = "DataSourcesConfig";
    public static final String PARAM_OPTIONAL_DATASOURCE_CONFIG = "OptionalDataSourceConfig";
    public static final String PARAM_CHAR_ENCODING = "CharacterEncoding";
    public static final String PARAM_CALLBACKS = "Callbacks";
    public static final String DEFAULT_DATASOURCE_FILE = "datasources.xml";
    public static final int VALIDATE_HTTP_HEAD_PHASE = 1;
    public static final int INITIAL_PARSE_PHASE = 2;
    public static final int CALLBACK_PRE_ACTION_PHASE = 3;
    public static final int PROCESS_HEADER_PHASE = 4;
    public static final int PROCESS_BODY_PHASE = 5;
    public static final int CALLBACK_POST_ACTION_PHASE = 6;
    public static final int SEND_RESPONSE_PHASE = 7;
    public static final int SEND_ERROR_PHASE = 8;
    protected CatalogLocator catalogLocator = null;
    protected DataSourcesConfig.DataSources dataSources = null;
    protected XmlaHandler xmlaHandler = null;
    protected String charEncoding = null;
    private final List callbackList = new ArrayList();
    private static final /* synthetic */ Class class$mondrian$xmla$XmlaServlet;
    private static final /* synthetic */ Class class$mondrian$xmla$XmlaRequestCallback;

    public static boolean getBooleanInitParameter(ServletConfig servletConfig, String paramName) {
        String paramValue = servletConfig.getInitParameter(paramName);
        return paramValue != null && Boolean.valueOf(paramValue) != false;
    }

    public static boolean getParameter(HttpServletRequest req, String paramName) {
        String paramValue = req.getParameter(paramName);
        return paramValue != null && Boolean.valueOf(paramValue) != false;
    }

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        this.initCharEncodingHandler(servletConfig);
        this.initCallbacks(servletConfig);
        this.catalogLocator = this.makeCatalogLocator(servletConfig);
        DataSourcesConfig.DataSources dataSources = this.makeDataSources(servletConfig);
        this.addToDataSources(dataSources);
    }

    protected XmlaHandler getXmlaHandler() {
        if (this.xmlaHandler == null) {
            this.xmlaHandler = new XmlaHandler(this.dataSources, this.catalogLocator);
        }
        return this.xmlaHandler;
    }

    protected final void addCallback(XmlaRequestCallback callback) {
        this.callbackList.add(callback);
    }

    protected final List getCallbacks() {
        return Collections.unmodifiableList((List)this.callbackList);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Element[] requestSoapParts = new Element[2];
        byte[][] responseSoapParts = new byte[2][];
        int phase = 1;
        try {
            XmlaRequestCallback callback;
            Iterator it;
            if (this.charEncoding != null) {
                try {
                    request.setCharacterEncoding(this.charEncoding);
                    response.setCharacterEncoding(this.charEncoding);
                }
                catch (UnsupportedEncodingException uee) {
                    this.charEncoding = null;
                    String msg = "Unsupported character encoding '" + this.charEncoding + "': " + "Use default character encoding from HTTP client for now";
                    LOGGER.warn((Object)msg);
                }
            }
            response.setContentType("text/xml");
            HashMap context = new HashMap();
            try {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)"Invoking validate http header callbacks");
                }
                it = this.getCallbacks().iterator();
                while (it.hasNext()) {
                    callback = (XmlaRequestCallback)it.next();
                    if (callback.processHttpHeader(request, response, context)) continue;
                    return;
                }
            }
            catch (XmlaException xex) {
                LOGGER.error((Object)"Errors when invoking callbacks validateHttpHeader", (Throwable)xex);
                this.handleFault(response, responseSoapParts, phase, xex);
                phase = 8;
                this.marshallSoapMessage(response, responseSoapParts);
                return;
            }
            catch (Exception ex) {
                LOGGER.error((Object)"Errors when invoking callbacks validateHttpHeader", (Throwable)ex);
                this.handleFault(response, responseSoapParts, phase, new XmlaException("Server", "00CHHA01", "Error in Callback processHttpHeader", ex));
                phase = 8;
                this.marshallSoapMessage(response, responseSoapParts);
                return;
            }
            phase = 2;
            try {
                String contentType;
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)"Unmarshalling SOAP message");
                }
                if ((contentType = request.getContentType()) == null || contentType.indexOf("text/xml") == -1) {
                    throw new IllegalArgumentException("Only accepts content type 'text/xml', not '" + contentType + "'");
                }
                this.unmarshallSoapMessage(request, requestSoapParts);
            }
            catch (XmlaException xex) {
                LOGGER.error((Object)"Unable to unmarshall SOAP message", (Throwable)xex);
                this.handleFault(response, responseSoapParts, phase, xex);
                phase = 8;
                this.marshallSoapMessage(response, responseSoapParts);
                return;
            }
            phase = 4;
            try {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)"Handling XML/A message header");
                }
                this.handleSoapHeader(response, requestSoapParts, responseSoapParts, context);
            }
            catch (XmlaException xex) {
                LOGGER.error((Object)"Errors when handling XML/A message", (Throwable)xex);
                this.handleFault(response, responseSoapParts, phase, xex);
                phase = 8;
                this.marshallSoapMessage(response, responseSoapParts);
                return;
            }
            phase = 3;
            try {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)"Invoking callbacks preAction");
                }
                it = this.getCallbacks().iterator();
                while (it.hasNext()) {
                    callback = (XmlaRequestCallback)it.next();
                    callback.preAction(request, requestSoapParts, context);
                }
            }
            catch (XmlaException xex) {
                LOGGER.error((Object)"Errors when invoking callbacks preaction", (Throwable)xex);
                this.handleFault(response, responseSoapParts, phase, xex);
                phase = 8;
                this.marshallSoapMessage(response, responseSoapParts);
                return;
            }
            catch (Exception ex) {
                LOGGER.error((Object)"Errors when invoking callbacks preaction", (Throwable)ex);
                this.handleFault(response, responseSoapParts, phase, new XmlaException("Server", "00CPREA01", "Error in Callback PreAction", ex));
                phase = 8;
                this.marshallSoapMessage(response, responseSoapParts);
                return;
            }
            phase = 5;
            try {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)"Handling XML/A message body");
                }
                this.handleSoapBody(response, requestSoapParts, responseSoapParts, context);
            }
            catch (XmlaException xex) {
                LOGGER.error((Object)"Errors when handling XML/A message", (Throwable)xex);
                this.handleFault(response, responseSoapParts, phase, xex);
                phase = 8;
                this.marshallSoapMessage(response, responseSoapParts);
                return;
            }
            phase = 6;
            try {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)"Invoking callbacks postAction");
                }
                it = this.getCallbacks().iterator();
                while (it.hasNext()) {
                    callback = (XmlaRequestCallback)it.next();
                    callback.postAction(request, response, responseSoapParts, context);
                }
            }
            catch (XmlaException xex) {
                LOGGER.error((Object)"Errors when invoking callbacks postaction", (Throwable)xex);
                this.handleFault(response, responseSoapParts, phase, xex);
                phase = 8;
                this.marshallSoapMessage(response, responseSoapParts);
                return;
            }
            catch (Exception ex) {
                LOGGER.error((Object)"Errors when invoking callbacks postaction", (Throwable)ex);
                this.handleFault(response, responseSoapParts, phase, new XmlaException("Server", "00CPOSTA01", "Error in Callback PostAction", ex));
                phase = 8;
                this.marshallSoapMessage(response, responseSoapParts);
                return;
            }
            phase = 7;
            try {
                response.setStatus(200);
                this.marshallSoapMessage(response, responseSoapParts);
            }
            catch (XmlaException xex) {
                LOGGER.error((Object)"Errors when handling XML/A message", (Throwable)xex);
                this.handleFault(response, responseSoapParts, phase, xex);
                phase = 8;
                this.marshallSoapMessage(response, responseSoapParts);
                return;
            }
        }
        catch (Throwable t) {
            LOGGER.error((Object)"Unknown Error when handling XML/A message", t);
            this.handleFault(response, responseSoapParts, phase, t);
            this.marshallSoapMessage(response, responseSoapParts);
        }
    }

    protected abstract void unmarshallSoapMessage(HttpServletRequest var1, Element[] var2) throws XmlaException;

    protected abstract void handleSoapHeader(HttpServletResponse var1, Element[] var2, byte[][] var3, Map var4) throws XmlaException;

    protected abstract void handleSoapBody(HttpServletResponse var1, Element[] var2, byte[][] var3, Map var4) throws XmlaException;

    protected abstract void marshallSoapMessage(HttpServletResponse var1, byte[][] var2) throws XmlaException;

    protected abstract void handleFault(HttpServletResponse var1, byte[][] var2, int var3, Throwable var4);

    protected CatalogLocator makeCatalogLocator(ServletConfig servletConfig) {
        ServletContext servletContext = servletConfig.getServletContext();
        return new ServletContextCatalogLocator(servletContext);
    }

    protected DataSourcesConfig.DataSources makeDataSources(ServletConfig servletConfig) {
        String msg;
        URL dataSourcesConfigUrl;
        block12: {
            String paramValue = servletConfig.getInitParameter(PARAM_DATASOURCES_CONFIG);
            boolean optional = XmlaServlet.getBooleanInitParameter(servletConfig, PARAM_OPTIONAL_DATASOURCE_CONFIG);
            dataSourcesConfigUrl = null;
            try {
                if (paramValue == null) {
                    String defaultDS = "WEB-INF/datasources.xml";
                    ServletContext servletContext = servletConfig.getServletContext();
                    File realPath = new File(servletContext.getRealPath(defaultDS));
                    if (realPath.exists()) {
                        dataSourcesConfigUrl = realPath.toURL();
                    }
                    break block12;
                }
                paramValue = Util.replaceProperties(paramValue, System.getProperties());
                if (LOGGER.isDebugEnabled()) {
                    msg = "XmlaServlet.makeDataSources: paramValue=" + paramValue;
                    LOGGER.debug((Object)msg);
                }
                MalformedURLException mue = null;
                try {
                    dataSourcesConfigUrl = new URL(paramValue);
                }
                catch (MalformedURLException e) {
                    mue = e;
                }
                if (dataSourcesConfigUrl == null) {
                    File f = new File(paramValue);
                    if (f.exists()) {
                        dataSourcesConfigUrl = f.toURL();
                    } else if (mue != null && !optional) {
                        throw mue;
                    }
                }
            }
            catch (MalformedURLException mue) {
                throw Util.newError(mue, "invalid URL path '" + paramValue + "'");
            }
        }
        if (LOGGER.isDebugEnabled()) {
            msg = "XmlaServlet.makeDataSources: dataSourcesConfigUrl=" + dataSourcesConfigUrl;
            LOGGER.debug((Object)msg);
        }
        return dataSourcesConfigUrl == null ? null : this.parseDataSourcesUrl(dataSourcesConfigUrl);
    }

    protected void addToDataSources(DataSourcesConfig.DataSources dataSources) {
        if (this.dataSources == null) {
            this.dataSources = dataSources;
        } else if (dataSources != null) {
            DataSourcesConfig.DataSource[] ds1 = this.dataSources.dataSources;
            int len1 = ds1.length;
            DataSourcesConfig.DataSource[] ds2 = dataSources.dataSources;
            int len2 = ds2.length;
            DataSourcesConfig.DataSource[] tmp = new DataSourcesConfig.DataSource[len1 + len2];
            System.arraycopy(ds1, 0, tmp, 0, len1);
            System.arraycopy(ds2, 0, tmp, len1, len2);
            this.dataSources.dataSources = tmp;
        } else {
            LOGGER.warn((Object)"XmlaServlet.addToDataSources: DataSources is null");
        }
    }

    protected DataSourcesConfig.DataSources parseDataSourcesUrl(URL dataSourcesConfigUrl) {
        try {
            String dataSourcesConfigString = Util.readURL(dataSourcesConfigUrl, (Map)System.getProperties());
            return this.parseDataSources(dataSourcesConfigString);
        }
        catch (Exception e) {
            throw Util.newError(e, "Failed to parse data sources config '" + dataSourcesConfigUrl.toExternalForm() + "'");
        }
    }

    protected DataSourcesConfig.DataSources parseDataSources(String dataSourcesConfigString) {
        try {
            if (dataSourcesConfigString == null) {
                LOGGER.warn((Object)"XmlaServlet.parseDataSources: null input");
                return null;
            }
            dataSourcesConfigString = Util.replaceProperties(dataSourcesConfigString, System.getProperties());
            if (LOGGER.isDebugEnabled()) {
                String msg = "XmlaServlet.parseDataSources: dataSources=" + dataSourcesConfigString;
                LOGGER.debug((Object)msg);
            }
            Parser parser = XOMUtil.createDefaultParser();
            DOMWrapper doc = parser.parse(dataSourcesConfigString);
            return new DataSourcesConfig.DataSources(doc);
        }
        catch (XOMException e) {
            throw Util.newError(e, "Failed to parse data sources config: " + dataSourcesConfigString);
        }
    }

    protected void initCharEncodingHandler(ServletConfig servletConfig) {
        String paramValue = servletConfig.getInitParameter(PARAM_CHAR_ENCODING);
        if (paramValue != null) {
            this.charEncoding = paramValue;
        } else {
            this.charEncoding = null;
            LOGGER.warn((Object)"Use default character encoding from HTTP client");
        }
    }

    protected void initCallbacks(ServletConfig servletConfig) {
        String callbacksValue = servletConfig.getInitParameter(PARAM_CALLBACKS);
        if (callbacksValue != null) {
            String[] classNames = callbacksValue.split(";");
            int count = 0;
            for (int i = 0; i < classNames.length; ++i) {
                String className = classNames[i].trim();
                try {
                    Class<?> cls = Class.forName(className);
                    if ((class$mondrian$xmla$XmlaRequestCallback == null ? XmlaServlet.class$("mondrian.xmla.XmlaRequestCallback") : class$mondrian$xmla$XmlaRequestCallback).isAssignableFrom(cls)) {
                        XmlaRequestCallback callback = (XmlaRequestCallback)cls.newInstance();
                        try {
                            callback.init(servletConfig);
                        }
                        catch (Exception e) {
                            LOGGER.warn((Object)("Failed to initialize callback '" + className + "'"), (Throwable)e);
                            continue;
                        }
                        this.addCallback(callback);
                        ++count;
                        if (!LOGGER.isDebugEnabled()) continue;
                        LOGGER.info((Object)("Register callback '" + className + "'"));
                        continue;
                    }
                    LOGGER.warn((Object)("'" + className + "' is not an implementation of '" + (class$mondrian$xmla$XmlaRequestCallback == null ? XmlaServlet.class$("mondrian.xmla.XmlaRequestCallback") : class$mondrian$xmla$XmlaRequestCallback) + "'"));
                    continue;
                }
                catch (ClassNotFoundException cnfe) {
                    LOGGER.warn((Object)("Callback class '" + className + "' not found"), (Throwable)cnfe);
                    continue;
                }
                catch (InstantiationException ie) {
                    LOGGER.warn((Object)("Can't instantiate class '" + className + "'"), (Throwable)ie);
                    continue;
                }
                catch (IllegalAccessException iae) {
                    LOGGER.warn((Object)("Can't instantiate class '" + className + "'"), (Throwable)iae);
                }
            }
            LOGGER.debug((Object)("Registered " + count + " callback" + (count > 1 ? "s" : "")));
        }
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        Class<?> clazz;
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            NoClassDefFoundError noClassDefFoundError = new NoClassDefFoundError(classNotFoundException.getMessage());
            try {
                noClassDefFoundError.initCause(classNotFoundException);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
            throw noClassDefFoundError;
        }
        return clazz;
    }
}

