/*
 * Decompiled with CFR 0.152.
 */
package mondrian.xmla;

import com.rc.retroweaver.runtime.Collections;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import mondrian.olap.Axis;
import mondrian.olap.Cell;
import mondrian.olap.Connection;
import mondrian.olap.Cube;
import mondrian.olap.Dimension;
import mondrian.olap.DriverManager;
import mondrian.olap.Hierarchy;
import mondrian.olap.Id;
import mondrian.olap.Level;
import mondrian.olap.Member;
import mondrian.olap.MondrianProperties;
import mondrian.olap.Position;
import mondrian.olap.Property;
import mondrian.olap.Query;
import mondrian.olap.QueryAxis;
import mondrian.olap.Result;
import mondrian.olap.Util;
import mondrian.rolap.RolapConnection;
import mondrian.rolap.RolapUtil;
import mondrian.spi.CatalogLocator;
import mondrian.xmla.DataSourcesConfig;
import mondrian.xmla.Enumeration;
import mondrian.xmla.PropertyDefinition;
import mondrian.xmla.Rowset;
import mondrian.xmla.RowsetDefinition;
import mondrian.xmla.SaxWriter;
import mondrian.xmla.XmlaConstants;
import mondrian.xmla.XmlaException;
import mondrian.xmla.XmlaRequest;
import mondrian.xmla.XmlaResponse;
import mondrian.xmla.XmlaUtil;
import mondrian.xmla.impl.DefaultSaxWriter;
import org.apache.log4j.Logger;
import org.xml.sax.SAXException;

public class XmlaHandler
implements XmlaConstants {
    private static final Logger LOGGER = Logger.getLogger((Class)(class$mondrian$xmla$XmlaHandler == null ? (class$mondrian$xmla$XmlaHandler = XmlaHandler.class$("mondrian.xmla.XmlaHandler")) : class$mondrian$xmla$XmlaHandler));
    private final Map dataSourcesMap;
    private CatalogLocator catalogLocator = null;
    private static final int ROW_SET = 1;
    private static final int MD_DATA_SET = 2;
    private static final String ROW_SET_XML_SCHEMA = XmlaHandler.computeXsd(1);
    private static final String EMPTY_ROW_SET_XML_SCHEMA = XmlaHandler.computeEmptyXsd(1);
    private static final String MD_DATA_SET_XML_SCHEMA = XmlaHandler.computeXsd(2);
    private static final String EMPTY_MD_DATA_SET_XML_SCHEMA = XmlaHandler.computeEmptyXsd(2);
    private static final String NS_XML_SQL = "urn:schemas-microsoft-com:xml-sql";
    private static final /* synthetic */ Class class$mondrian$xmla$XmlaHandler;

    private static String computeXsd(int settype) {
        StringWriter sw = new StringWriter();
        DefaultSaxWriter writer = new DefaultSaxWriter(new PrintWriter(sw), 3);
        XmlaHandler.writeDatasetXmlSchema(writer, settype);
        writer.flush();
        return sw.toString();
    }

    private static String computeEmptyXsd(int settype) {
        StringWriter sw = new StringWriter();
        DefaultSaxWriter writer = new DefaultSaxWriter(new PrintWriter(sw), 3);
        XmlaHandler.writeEmptyDatasetXmlSchema(writer, settype);
        writer.flush();
        return sw.toString();
    }

    public XmlaHandler(DataSourcesConfig.DataSources dataSources, CatalogLocator catalogLocator) {
        this.catalogLocator = catalogLocator;
        HashMap<String, DataSourcesConfig.DataSource> map = new HashMap<String, DataSourcesConfig.DataSource>();
        if (dataSources != null) {
            for (int i = 0; i < dataSources.dataSources.length; ++i) {
                DataSourcesConfig.DataSource ds = dataSources.dataSources[i];
                if (map.containsKey(ds.getDataSourceName())) {
                    throw Util.newError("duplicated data source name '" + ds.getDataSourceName() + "'");
                }
                for (int j = 0; j < ds.catalogs.catalogs.length; ++j) {
                    ds.catalogs.catalogs[j].setDataSource(ds);
                }
                map.put(ds.getDataSourceName(), ds);
            }
        }
        this.dataSourcesMap = Collections.unmodifiableMap(map);
    }

    public Map getDataSourceEntries() {
        return this.dataSourcesMap;
    }

    public void process(XmlaRequest request, XmlaResponse response) throws XmlaException {
        int method = request.getMethod();
        long start = System.currentTimeMillis();
        switch (method) {
            case 1: {
                this.discover(request, response);
                break;
            }
            case 2: {
                this.execute(request, response);
                break;
            }
            default: {
                throw new XmlaException("Client", "00HSBB02", "XMLA SOAP bad method", new IllegalArgumentException("Unsupported XML/A method: " + method));
            }
        }
        if (LOGGER.isDebugEnabled()) {
            long end = System.currentTimeMillis();
            LOGGER.debug((Object)("XmlaHandler.process: time = " + (end - start)));
            LOGGER.debug((Object)("XmlaHandler.process: " + Util.printMemory()));
        }
    }

    private void checkFormat(XmlaRequest request) throws XmlaException {
        String propertyName = null;
        try {
            Map properties = request.getProperties();
            if (request.isDrillThrough()) {
                propertyName = PropertyDefinition.Format.name;
                String formatName = (String)properties.get(propertyName);
                Enumeration.Format format = Enumeration.Format.getValue(formatName);
                if (format != Enumeration.Format.Tabular) {
                    throw new XmlaException("Client", "00HSBE02", "XMLA Drill Through format error", new UnsupportedOperationException("<Format>: only 'Tabular' allowed when drilling through"));
                }
            } else {
                Enumeration.AxisFormat axisFormat;
                Enumeration.Format format;
                propertyName = PropertyDefinition.Format.name;
                String formatName = (String)properties.get(propertyName);
                if (formatName != null && (format = Enumeration.Format.getValue(formatName)) != Enumeration.Format.Multidimensional && format != Enumeration.Format.Tabular) {
                    throw new UnsupportedOperationException("<Format>: only 'Multidimensional', 'Tabular' currently supported");
                }
                propertyName = PropertyDefinition.AxisFormat.name;
                String axisFormatName = (String)properties.get(propertyName);
                if (axisFormatName != null && (axisFormat = Enumeration.AxisFormat.getValue(axisFormatName)) != Enumeration.AxisFormat.TupleFormat) {
                    throw new UnsupportedOperationException("<AxisFormat>: only 'TupleFormat' currently supported");
                }
            }
        }
        catch (Error e) {
            throw new XmlaException("Client", "00HSBG01", "XMLA unsupported operation", new UnsupportedOperationException("Property <" + propertyName + "> must be provided"));
        }
    }

    private void execute(XmlaRequest request, XmlaResponse response) throws XmlaException {
        Map properties = request.getProperties();
        String contentName = (String)properties.get(PropertyDefinition.Content.name);
        Enumeration.Content content = contentName == null ? CONTENT_DEFAULT : Enumeration.Content.getValue(contentName);
        QueryResult result = null;
        result = request.isDrillThrough() ? this.executeDrillThroughQuery(request) : this.executeQuery(request);
        SaxWriter writer = response.getWriter();
        writer.startDocument();
        writer.startElement("xmla:ExecuteResponse", new String[]{"xmlns:xmla", "urn:schemas-microsoft-com:xml-analysis"});
        writer.startElement("xmla:return");
        boolean rowset = request.isDrillThrough() || Enumeration.Format.Tabular.name.equals(request.getProperties().get(PropertyDefinition.Format.name));
        writer.startElement("root", new String[]{"xmlns", result == null ? "urn:schemas-microsoft-com:xml-analysis:empty" : (rowset ? "urn:schemas-microsoft-com:xml-analysis:rowset" : "urn:schemas-microsoft-com:xml-analysis:mddataset"), "xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance", "xmlns:xsd", "http://www.w3.org/2001/XMLSchema", "xmlns:EX", "urn:schemas-microsoft-com:xml-analysis:exception"});
        if (content == Enumeration.Content.Schema || content == Enumeration.Content.SchemaData) {
            if (result != null) {
                if (result instanceof MDDataSet_Tabular) {
                    MDDataSet_Tabular tabResult = (MDDataSet_Tabular)result;
                    tabResult.metadata(writer);
                } else if (rowset) {
                    writer.verbatim(ROW_SET_XML_SCHEMA);
                } else {
                    writer.verbatim(MD_DATA_SET_XML_SCHEMA);
                }
            } else if (rowset) {
                writer.verbatim(EMPTY_ROW_SET_XML_SCHEMA);
            } else {
                writer.verbatim(EMPTY_MD_DATA_SET_XML_SCHEMA);
            }
        }
        try {
            if ((content == Enumeration.Content.Data || content == Enumeration.Content.SchemaData) && result != null) {
                result.unparse(writer);
            }
        }
        catch (XmlaException xex) {
            throw xex;
        }
        catch (Throwable t) {
            throw new XmlaException("Server", "00HSBE03", "XMLA Execute unparse results error", t);
        }
        finally {
            writer.endElement();
            writer.endElement();
            writer.endElement();
        }
        writer.endDocument();
    }

    static void writeDatasetXmlSchema(SaxWriter writer, int settype) {
        String setNsXmla = settype == 1 ? "urn:schemas-microsoft-com:xml-analysis:rowset" : "urn:schemas-microsoft-com:xml-analysis:mddataset";
        writer.startElement("xsd:schema", new String[]{"xmlns:xsd", "http://www.w3.org/2001/XMLSchema", "targetNamespace", setNsXmla, "xmlns", setNsXmla, "xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance", "xmlns:sql", NS_XML_SQL, "elementFormDefault", "qualified"});
        writer.startElement("xsd:complexType", new String[]{"name", "MemberType"});
        writer.startElement("xsd:sequence");
        writer.element("xsd:element", new String[]{"name", "UName", "type", "xsd:string"});
        writer.element("xsd:element", new String[]{"name", "Caption", "type", "xsd:string"});
        writer.element("xsd:element", new String[]{"name", "LName", "type", "xsd:string"});
        writer.element("xsd:element", new String[]{"name", "LNum", "type", "xsd:unsignedInt"});
        writer.element("xsd:element", new String[]{"name", "DisplayInfo", "type", "xsd:unsignedInt"});
        writer.startElement("xsd:sequence", new String[]{"maxOccurs", "unbounded", "minOccurs", "0"});
        writer.element("xsd:any", new String[]{"processContents", "lax", "maxOccurs", "unbounded"});
        writer.endElement();
        writer.endElement();
        writer.element("xsd:attribute", new String[]{"name", "Hierarchy", "type", "xsd:string"});
        writer.endElement();
        writer.startElement("xsd:complexType", new String[]{"name", "PropType"});
        writer.element("xsd:attribute", new String[]{"name", "name", "type", "xsd:string"});
        writer.endElement();
        writer.startElement("xsd:complexType", new String[]{"name", "TupleType"});
        writer.startElement("xsd:sequence", new String[]{"maxOccurs", "unbounded"});
        writer.element("xsd:element", new String[]{"name", "Member", "type", "MemberType"});
        writer.endElement();
        writer.endElement();
        writer.startElement("xsd:complexType", new String[]{"name", "MembersType"});
        writer.startElement("xsd:sequence", new String[]{"maxOccurs", "unbounded"});
        writer.element("xsd:element", new String[]{"name", "Member", "type", "MemberType"});
        writer.endElement();
        writer.element("xsd:attribute", new String[]{"name", "Hierarchy", "type", "xsd:string"});
        writer.endElement();
        writer.startElement("xsd:complexType", new String[]{"name", "TuplesType"});
        writer.startElement("xsd:sequence", new String[]{"maxOccurs", "unbounded"});
        writer.element("xsd:element", new String[]{"name", "Tuple", "type", "TupleType"});
        writer.endElement();
        writer.endElement();
        writer.startElement("xsd:complexType", new String[]{"name", "CrossProductType"});
        writer.startElement("xsd:sequence");
        writer.startElement("xsd:choice", new String[]{"minOccurs", "0", "maxOccurs", "unbounded"});
        writer.element("xsd:element", new String[]{"name", "Members", "type", "MembersType"});
        writer.element("xsd:element", new String[]{"name", "Tuples", "type", "TuplesType"});
        writer.endElement();
        writer.endElement();
        writer.element("xsd:attribute", new String[]{"name", "Size", "type", "xsd:unsignedInt"});
        writer.endElement();
        writer.startElement("xsd:complexType", new String[]{"name", "OlapInfo"});
        writer.startElement("xsd:sequence");
        writer.startElement("xsd:element", new String[]{"name", "CubeInfo"});
        writer.startElement("xsd:complexType");
        writer.startElement("xsd:sequence");
        writer.startElement("xsd:element", new String[]{"name", "Cube", "maxOccurs", "unbounded"});
        writer.startElement("xsd:complexType");
        writer.startElement("xsd:sequence");
        writer.element("xsd:element", new String[]{"name", "CubeName", "type", "xsd:string"});
        writer.endElement();
        writer.endElement();
        writer.endElement();
        writer.endElement();
        writer.endElement();
        writer.endElement();
        writer.startElement("xsd:element", new String[]{"name", "AxesInfo"});
        writer.startElement("xsd:complexType");
        writer.startElement("xsd:sequence");
        writer.startElement("xsd:element", new String[]{"name", "AxisInfo", "maxOccurs", "unbounded"});
        writer.startElement("xsd:complexType");
        writer.startElement("xsd:sequence");
        writer.startElement("xsd:element", new String[]{"name", "HierarchyInfo", "minOccurs", "0", "maxOccurs", "unbounded"});
        writer.startElement("xsd:complexType");
        writer.startElement("xsd:sequence");
        writer.startElement("xsd:sequence", new String[]{"maxOccurs", "unbounded"});
        writer.element("xsd:element", new String[]{"name", "UName", "type", "PropType"});
        writer.element("xsd:element", new String[]{"name", "Caption", "type", "PropType"});
        writer.element("xsd:element", new String[]{"name", "LName", "type", "PropType"});
        writer.element("xsd:element", new String[]{"name", "LNum", "type", "PropType"});
        writer.element("xsd:element", new String[]{"name", "DisplayInfo", "type", "PropType", "minOccurs", "0", "maxOccurs", "unbounded"});
        writer.endElement();
        writer.startElement("xsd:sequence");
        writer.element("xsd:any", new String[]{"processContents", "lax", "minOccurs", "0", "maxOccurs", "unbounded"});
        writer.endElement();
        writer.endElement();
        writer.endElement();
        writer.element("xsd:attribute", new String[]{"name", "name", "type", "xsd:string", "use", "required"});
        writer.endElement();
        writer.endElement();
        writer.element("xsd:attribute", new String[]{"name", "name", "type", "xsd:string"});
        writer.endElement();
        writer.endElement();
        writer.endElement();
        writer.endElement();
        writer.endElement();
        writer.startElement("xsd:element", new String[]{"name", "CellInfo"});
        writer.startElement("xsd:complexType");
        writer.startElement("xsd:sequence");
        writer.startElement("xsd:sequence", new String[]{"minOccurs", "0", "maxOccurs", "unbounded"});
        writer.startElement("xsd:choice");
        writer.element("xsd:element", new String[]{"name", "Value", "type", "PropType"});
        writer.element("xsd:element", new String[]{"name", "FmtValue", "type", "PropType"});
        writer.element("xsd:element", new String[]{"name", "BackColor", "type", "PropType"});
        writer.element("xsd:element", new String[]{"name", "ForeColor", "type", "PropType"});
        writer.element("xsd:element", new String[]{"name", "FontName", "type", "PropType"});
        writer.element("xsd:element", new String[]{"name", "FontSize", "type", "PropType"});
        writer.element("xsd:element", new String[]{"name", "FontFlags", "type", "PropType"});
        writer.element("xsd:element", new String[]{"name", "FormatString", "type", "PropType"});
        writer.element("xsd:element", new String[]{"name", "NonEmptyBehavior", "type", "PropType"});
        writer.element("xsd:element", new String[]{"name", "SolveOrder", "type", "PropType"});
        writer.element("xsd:element", new String[]{"name", "Updateable", "type", "PropType"});
        writer.element("xsd:element", new String[]{"name", "Visible", "type", "PropType"});
        writer.element("xsd:element", new String[]{"name", "Expression", "type", "PropType"});
        writer.endElement();
        writer.endElement();
        writer.startElement("xsd:sequence", new String[]{"maxOccurs", "unbounded", "minOccurs", "0"});
        writer.element("xsd:any", new String[]{"processContents", "lax", "maxOccurs", "unbounded"});
        writer.endElement();
        writer.endElement();
        writer.endElement();
        writer.endElement();
        writer.endElement();
        writer.endElement();
        writer.startElement("xsd:complexType", new String[]{"name", "Axes"});
        writer.startElement("xsd:sequence", new String[]{"maxOccurs", "unbounded"});
        writer.startElement("xsd:element", new String[]{"name", "Axis"});
        writer.startElement("xsd:complexType");
        writer.startElement("xsd:choice", new String[]{"minOccurs", "0", "maxOccurs", "unbounded"});
        writer.element("xsd:element", new String[]{"name", "CrossProduct", "type", "CrossProductType"});
        writer.element("xsd:element", new String[]{"name", "Tuples", "type", "TuplesType"});
        writer.element("xsd:element", new String[]{"name", "Members", "type", "MembersType"});
        writer.endElement();
        writer.element("xsd:attribute", new String[]{"name", "name", "type", "xsd:string"});
        writer.endElement();
        writer.endElement();
        writer.endElement();
        writer.endElement();
        writer.startElement("xsd:complexType", new String[]{"name", "CellData"});
        writer.startElement("xsd:sequence");
        writer.startElement("xsd:element", new String[]{"name", "Cell", "minOccurs", "0", "maxOccurs", "unbounded"});
        writer.startElement("xsd:complexType");
        writer.startElement("xsd:sequence", new String[]{"maxOccurs", "unbounded"});
        writer.startElement("xsd:choice");
        writer.element("xsd:element", new String[]{"name", "Value"});
        writer.element("xsd:element", new String[]{"name", "FmtValue", "type", "xsd:string"});
        writer.element("xsd:element", new String[]{"name", "BackColor", "type", "xsd:unsignedInt"});
        writer.element("xsd:element", new String[]{"name", "ForeColor", "type", "xsd:unsignedInt"});
        writer.element("xsd:element", new String[]{"name", "FontName", "type", "xsd:string"});
        writer.element("xsd:element", new String[]{"name", "FontSize", "type", "xsd:unsignedShort"});
        writer.element("xsd:element", new String[]{"name", "FontFlags", "type", "xsd:unsignedInt"});
        writer.element("xsd:element", new String[]{"name", "FormatString", "type", "xsd:string"});
        writer.element("xsd:element", new String[]{"name", "NonEmptyBehavior", "type", "xsd:unsignedShort"});
        writer.element("xsd:element", new String[]{"name", "SolveOrder", "type", "xsd:unsignedInt"});
        writer.element("xsd:element", new String[]{"name", "Updateable", "type", "xsd:unsignedInt"});
        writer.element("xsd:element", new String[]{"name", "Visible", "type", "xsd:unsignedInt"});
        writer.element("xsd:element", new String[]{"name", "Expression", "type", "xsd:string"});
        writer.endElement();
        writer.endElement();
        writer.element("xsd:attribute", new String[]{"name", "CellOrdinal", "type", "xsd:unsignedInt", "use", "required"});
        writer.endElement();
        writer.endElement();
        writer.endElement();
        writer.endElement();
        writer.startElement("xsd:element", new String[]{"name", "root"});
        writer.startElement("xsd:complexType");
        writer.startElement("xsd:sequence", new String[]{"maxOccurs", "unbounded"});
        writer.element("xsd:element", new String[]{"name", "OlapInfo", "type", "OlapInfo"});
        writer.element("xsd:element", new String[]{"name", "Axes", "type", "Axes"});
        writer.element("xsd:element", new String[]{"name", "CellData", "type", "CellData"});
        writer.endElement();
        writer.endElement();
        writer.endElement();
        writer.endElement();
    }

    static void writeEmptyDatasetXmlSchema(SaxWriter writer, int settype) {
        String setNsXmla = "urn:schemas-microsoft-com:xml-analysis:rowset";
        writer.startElement("xsd:schema", new String[]{"xmlns:xsd", "http://www.w3.org/2001/XMLSchema", "targetNamespace", setNsXmla, "xmlns", setNsXmla, "xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance", "xmlns:sql", NS_XML_SQL, "elementFormDefault", "qualified"});
        writer.element("xsd:element", new String[]{"name", "root"});
        writer.endElement();
    }

    private QueryResult executeDrillThroughQuery(XmlaRequest request) throws XmlaException {
        this.checkFormat(request);
        DataSourcesConfig.DataSource ds = this.getDataSource(request);
        DataSourcesConfig.Catalog dsCatalog = this.getCatalog(request, ds);
        String role = request.getRole();
        RolapConnection connection = (RolapConnection)this.getConnection(dsCatalog, role);
        String statement = request.getStatement();
        Query query = connection.parseQuery(statement);
        Result result = connection.execute(query);
        Cell dtCell = result.getCell(new int[]{0, 0});
        if (!dtCell.canDrillThrough()) {
            throw new XmlaException("Server", "00HSBF01", "XMLA Drill Through not allowed", Util.newError("Cannot do DrillThrough operation on the cell"));
        }
        String dtSql = dtCell.getDrillThroughSQL(true);
        TabularRowSet rowset = null;
        java.sql.Connection sqlConn = null;
        ResultSet rs = null;
        try {
            int count = -1;
            if (MondrianProperties.instance().EnableTotalCount.booleanValue()) {
                count = dtCell.getDrillThroughCount();
            }
            sqlConn = connection.getDataSource().getConnection();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("drill through sql: " + dtSql));
            }
            rs = RolapUtil.executeQuery(sqlConn, dtSql, -1, "XmlaHandler.executeDrillThroughQuery", 1004, 1007);
            rowset = new TabularRowSet(rs, request.drillThroughMaxRows(), request.drillThroughFirstRowset(), count);
        }
        catch (XmlaException xex) {
            throw xex;
        }
        catch (SQLException sqle) {
            throw new XmlaException("Server", "00HSBF02", "XMLA Drill Through SQL error", Util.newError(sqle, "Error in drill through"));
        }
        catch (RuntimeException e) {
            throw new XmlaException("Server", "00HSBF02", "XMLA Drill Through SQL error", Util.newError(e, "Error in drill through"));
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException ignored) {}
            try {
                if (sqlConn != null && !sqlConn.isClosed()) {
                    sqlConn.close();
                }
            }
            catch (SQLException ignored) {}
        }
        return rowset;
    }

    private QueryResult executeQuery(XmlaRequest request) throws XmlaException {
        Result result;
        Query query;
        String statement = request.getStatement();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("mdx: \"" + statement + "\""));
        }
        if (statement == null || statement.length() == 0) {
            return null;
        }
        this.checkFormat(request);
        DataSourcesConfig.DataSource ds = this.getDataSource(request);
        DataSourcesConfig.Catalog dsCatalog = this.getCatalog(request, ds);
        String role = request.getRole();
        Connection connection = this.getConnection(dsCatalog, role);
        try {
            query = connection.parseQuery(statement);
        }
        catch (XmlaException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new XmlaException("Client", "00HSBD01", "XMLA MDX parse failed", ex);
        }
        try {
            result = connection.execute(query);
        }
        catch (XmlaException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new XmlaException("Server", "00HSBD02", "XMLA MDX execute failed", ex);
        }
        String formatName = (String)request.getProperties().get(PropertyDefinition.Format.name);
        Enumeration.Format format = Enumeration.Format.getValue(formatName);
        if (format == Enumeration.Format.Multidimensional) {
            return new MDDataSet_Multidimensional(result);
        }
        return new MDDataSet_Tabular(result);
    }

    protected static String deduceValueType(Cell cell, Object value) {
        String datatype = (String)cell.getPropertyValue(Property.DATATYPE.getName());
        if (datatype != null) {
            if (datatype.equals("Integer")) {
                return "xsd:int";
            }
            if (datatype.equals("Numeric")) {
                return "xsd:double";
            }
            return "xsd:string";
        }
        if (value instanceof Integer || value instanceof Long) {
            return "xsd:int";
        }
        if (value instanceof Double || value instanceof BigDecimal) {
            return "xsd:double";
        }
        return "xsd:string";
    }

    private void discover(XmlaRequest request, XmlaResponse response) throws XmlaException {
        RowsetDefinition rowsetDefinition = RowsetDefinition.getValue(request.getRequestType());
        Rowset rowset = rowsetDefinition.getRowset(request, this);
        try {
            String formatName = (String)request.getProperties().get(PropertyDefinition.Format.name);
            Enumeration.Format format = Enumeration.Format.getValue(formatName);
            if (format != Enumeration.Format.Tabular) {
                throw new XmlaException("Client", "00HSBE01", "XMLA Discover format error", new UnsupportedOperationException("<Format>: only 'Tabular' allowed in Discover method type"));
            }
        }
        catch (Error e) {
            // empty catch block
        }
        String contentName = (String)request.getProperties().get(PropertyDefinition.Content.name);
        Enumeration.Content content = contentName == null ? CONTENT_DEFAULT : Enumeration.Content.getValue(contentName);
        SaxWriter writer = response.getWriter();
        writer.startDocument();
        writer.startElement("xmla:DiscoverResponse", new String[]{"xmlns:xmla", "urn:schemas-microsoft-com:xml-analysis"});
        writer.startElement("xmla:return");
        writer.startElement("root", new String[]{"xmlns", "urn:schemas-microsoft-com:xml-analysis:rowset", "xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance", "xmlns:xsd", "http://www.w3.org/2001/XMLSchema", "xmlns:EX", "urn:schemas-microsoft-com:xml-analysis:exception"});
        if (content == Enumeration.Content.Schema || content == Enumeration.Content.SchemaData) {
            rowset.rowsetDefinition.writeRowsetXmlSchema(writer);
        }
        try {
            if (content == Enumeration.Content.Data || content == Enumeration.Content.SchemaData) {
                rowset.unparse(response);
            }
        }
        catch (XmlaException xex) {
            throw xex;
        }
        catch (Throwable t) {
            throw new XmlaException("Server", "00HSBE02", "XMLA Discover unparse results error", t);
        }
        finally {
            writer.endElement();
            writer.endElement();
            writer.endElement();
        }
        writer.endDocument();
    }

    protected Connection getConnection(DataSourcesConfig.Catalog catalog, String role) throws XmlaException {
        DataSourcesConfig.DataSource ds = catalog.getDataSource();
        Util.PropertyList connectProperties = Util.parseConnectString(catalog.getDataSourceInfo());
        String catalogUrl = this.catalogLocator.locate(catalog.definition);
        if (LOGGER.isDebugEnabled()) {
            if (catalogUrl == null) {
                LOGGER.debug((Object)"XmlaHandler.getConnection: catalogUrl is null");
            } else {
                LOGGER.debug((Object)("XmlaHandler.getConnection: catalogUrl=" + catalogUrl));
            }
        }
        connectProperties.put("catalog", catalogUrl);
        if (!"Unauthenticated".equalsIgnoreCase(ds.getAuthenticationMode()) && null == role) {
            throw new XmlaException("Client", "00HSBC02", "XMLA connection with role must be authenticated", new SecurityException("Access denied for data source needing authentication"));
        }
        connectProperties.put("role", role);
        RolapConnection conn = (RolapConnection)DriverManager.getConnection(connectProperties, null, false);
        if (LOGGER.isDebugEnabled()) {
            if (conn == null) {
                LOGGER.debug((Object)"XmlaHandler.getConnection: returning connection null");
            } else {
                LOGGER.debug((Object)"XmlaHandler.getConnection: returning connection not null");
            }
        }
        return conn;
    }

    public DataSourcesConfig.DataSource getDataSource(XmlaRequest request) throws XmlaException {
        Map properties = request.getProperties();
        String dataSourceInfo = (String)properties.get(PropertyDefinition.DataSourceInfo.name);
        if (!this.dataSourcesMap.containsKey(dataSourceInfo)) {
            throw new XmlaException("Client", "00HSBC01", "XMLA connection datasource not found", Util.newError("no data source is configured with name '" + dataSourceInfo + "'"));
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("XmlaHandler.getDataSource: dataSourceInfo=" + dataSourceInfo));
        }
        DataSourcesConfig.DataSource ds = (DataSourcesConfig.DataSource)((Object)this.dataSourcesMap.get(dataSourceInfo));
        if (LOGGER.isDebugEnabled()) {
            if (ds == null) {
                LOGGER.debug((Object)"XmlaHandler.getDataSource: ds is null");
            } else {
                LOGGER.debug((Object)("XmlaHandler.getDataSource: ds.dataSourceInfo=" + ds.getDataSourceInfo()));
            }
        }
        return ds;
    }

    public DataSourcesConfig.Catalog getCatalog(DataSourcesConfig.DataSource ds, String catalogName) {
        DataSourcesConfig.Catalog[] catalogs = ds.catalogs.catalogs;
        if (catalogName == null) {
            if (catalogs.length == 1) {
                return catalogs[0];
            }
        } else {
            for (int i = 0; i < catalogs.length; ++i) {
                DataSourcesConfig.Catalog dsCatalog = catalogs[i];
                if (!catalogName.equals(dsCatalog.name)) continue;
                return dsCatalog;
            }
        }
        return null;
    }

    public DataSourcesConfig.Catalog[] getCatalogs(XmlaRequest request, DataSourcesConfig.DataSource ds) {
        Map properties = request.getProperties();
        String catalogName = (String)properties.get(PropertyDefinition.Catalog.name);
        if (catalogName != null) {
            DataSourcesConfig.Catalog dsCatalog = this.getCatalog(ds, catalogName);
            return new DataSourcesConfig.Catalog[]{dsCatalog};
        }
        return ds.catalogs.catalogs;
    }

    public DataSourcesConfig.Catalog getCatalog(XmlaRequest request, DataSourcesConfig.DataSource ds) throws XmlaException {
        Map properties = request.getProperties();
        String catalogName = (String)properties.get(PropertyDefinition.Catalog.name);
        DataSourcesConfig.Catalog dsCatalog = this.getCatalog(ds, catalogName);
        if (dsCatalog == null && catalogName == null) {
            throw new XmlaException("Client", "00HSBC01", "XMLA connection datasource not found", Util.newError("no catalog named '" + catalogName + "'"));
        }
        return dsCatalog;
    }

    static Logger access$000() {
        return LOGGER;
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        Class<?> clazz;
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            NoClassDefFoundError noClassDefFoundError = new NoClassDefFoundError(classNotFoundException.getMessage());
            try {
                noClassDefFoundError.initCause(classNotFoundException);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
            throw noClassDefFoundError;
        }
        return clazz;
    }

    static class MDDataSet_Tabular
    extends MDDataSet {
        private final boolean empty;
        private final int[] pos;
        private final int axisCount;
        private int cellOrdinal;
        private static final Id[] MemberCaptionIdArray = new Id[]{new Id(new Id.Segment(Property.MEMBER_CAPTION.name, Id.Quoting.QUOTED))};
        private final Member[] members;
        private final ColumnHandler[] columnHandlers;

        public MDDataSet_Tabular(Result result) {
            super(result);
            Axis[] axes = result.getAxes();
            this.axisCount = axes.length;
            this.pos = new int[this.axisCount];
            boolean empty = false;
            int dimensionCount = 0;
            for (int i = axes.length - 1; i > 0; --i) {
                Axis axis = axes[i];
                if (axis.positions.length == 0) {
                    empty = true;
                    continue;
                }
                dimensionCount += axis.positions[0].members.length;
            }
            this.empty = empty;
            Level[] levels = new Level[dimensionCount];
            ArrayList<ColumnHandler> columnHandlerList = new ArrayList<ColumnHandler>();
            int memberOrdinal = 0;
            if (!empty) {
                for (int i = axes.length - 1; i > 0; --i) {
                    int k;
                    Axis axis = axes[i];
                    QueryAxis queryAxis = result.getQuery().getAxes()[i];
                    int z0 = memberOrdinal;
                    Position[] positions = axis.positions;
                    for (int j = 0; j < positions.length; ++j) {
                        memberOrdinal = z0;
                        Position position = positions[j];
                        Member[] members = position.members;
                        for (k = 0; k < members.length; ++k) {
                            Member member = members[k];
                            if (j != 0 && member.getLevel().getDepth() <= levels[memberOrdinal].getDepth()) continue;
                            levels[memberOrdinal] = member.getLevel();
                        }
                        ++memberOrdinal;
                    }
                    Id[] dimProps = queryAxis.getDimensionProperties();
                    if (dimProps.length == 0) {
                        dimProps = MemberCaptionIdArray;
                    }
                    for (int j = z0; j < memberOrdinal; ++j) {
                        Level level = levels[j];
                        for (k = 0; k <= level.getDepth(); ++k) {
                            Level level2 = level.getHierarchy().getLevels()[k];
                            if (level2.isAll()) continue;
                            for (int m = 0; m < dimProps.length; ++m) {
                                Id dimProp = dimProps[m];
                                columnHandlerList.add(new MemberColumnHandler(dimProp.toStringArray()[0], level2, j));
                            }
                        }
                    }
                }
            }
            this.members = new Member[memberOrdinal];
            Axis columnsAxis = axes[0];
            for (int i = 0; i < columnsAxis.positions.length; ++i) {
                Position position = columnsAxis.positions[i];
                String name = null;
                for (int j = 0; j < position.members.length; ++j) {
                    Member member = position.members[j];
                    name = j == 0 ? member.getUniqueName() : name + "." + member.getUniqueName();
                }
                columnHandlerList.add(new CellColumnHandler(name));
            }
            this.columnHandlers = columnHandlerList.toArray(new ColumnHandler[columnHandlerList.size()]);
        }

        public void metadata(SaxWriter writer) {
            if (this.empty) {
                return;
            }
            writer.startElement("xsd:schema", new String[]{"xmlns:xsd", "http://www.w3.org/2001/XMLSchema", "targetNamespace", "urn:schemas-microsoft-com:xml-analysis:rowset", "xmlns", "urn:schemas-microsoft-com:xml-analysis:rowset", "xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance", "xmlns:sql", XmlaHandler.NS_XML_SQL, "elementFormDefault", "qualified"});
            writer.startElement("xsd:element", new String[]{"name", "root"});
            writer.startElement("xsd:complexType");
            writer.startElement("xsd:sequence");
            writer.element("xsd:element", new String[]{"maxOccurs", "unbounded", "minOccurs", "0", "name", "row", "type", "row"});
            writer.endElement();
            writer.endElement();
            writer.endElement();
            writer.startElement("xsd:simpleType", new String[]{"name", "uuid"});
            writer.startElement("xsd:restriction", new String[]{"base", "xsd:string"});
            writer.element("xsd:pattern", new String[]{"value", "[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}"});
            writer.endElement();
            writer.endElement();
            writer.startElement("xsd:complexType", new String[]{"name", "row"});
            writer.startElement("xsd:sequence");
            for (int i = 0; i < this.columnHandlers.length; ++i) {
                this.columnHandlers[i].metadata(writer);
            }
            writer.endElement();
            writer.endElement();
            writer.endElement();
        }

        public void unparse(SaxWriter writer) throws SAXException {
            if (this.empty) {
                return;
            }
            this.cellData(writer);
        }

        private void cellData(SaxWriter writer) throws SAXException {
            this.cellOrdinal = 0;
            if (this.axisCount == 0) {
                this.emitCell(writer, this.result.getCell(this.pos));
            } else {
                this.recurse(writer, this.axisCount - 1, 0);
            }
        }

        private void recurse(SaxWriter writer, int axis, int headerOrdinal) throws SAXException {
            Position[] positions = this.result.getAxes()[axis].positions;
            int axisLength = positions.length;
            for (int i = 0; i < axisLength; ++i) {
                this.pos[axis] = i;
                Position position = positions[i];
                if (axis == 0) {
                    Cell cell = this.result.getCell(this.pos);
                    this.emitCell(writer, cell);
                    continue;
                }
                int ho = headerOrdinal;
                for (int j = 0; j < position.members.length; ++j) {
                    this.members[ho++] = position.members[j];
                }
                this.recurse(writer, axis - 1, ho);
            }
        }

        private void emitCell(SaxWriter writer, Cell cell) {
            ++this.cellOrdinal;
            Util.discard((int)this.cellOrdinal);
            Object cellValue = cell.getValue();
            if (cellValue == null) {
                return;
            }
            writer.startElement("row");
            for (int j = 0; j < this.columnHandlers.length; ++j) {
                this.columnHandlers[j].write(writer, cell, this.members);
            }
            writer.endElement();
        }
    }

    static class MemberColumnHandler
    extends ColumnHandler {
        private final String property;
        private final Level level;
        private final int memberOrdinal;

        public MemberColumnHandler(String property, Level level, int memberOrdinal) {
            super(level.getUniqueName() + "." + Util.quoteMdxIdentifier(property));
            this.property = property;
            this.level = level;
            this.memberOrdinal = memberOrdinal;
        }

        public void metadata(SaxWriter writer) {
            writer.element("xsd:element", new String[]{"minOccurs", "0", "name", this.encodedName, "sql:field", this.name, "type", "xsd:string"});
        }

        public void write(SaxWriter writer, Cell cell, Member[] members) {
            Member member = members[this.memberOrdinal];
            int depth = this.level.getDepth();
            if (member.getDepth() < depth) {
                return;
            }
            while (member.getDepth() > depth) {
                member = member.getParentMember();
            }
            Object propertyValue = member.getPropertyValue(this.property);
            if (propertyValue == null) {
                return;
            }
            writer.startElement(this.encodedName);
            writer.characters(propertyValue.toString());
            writer.endElement();
        }
    }

    static class CellColumnHandler
    extends ColumnHandler {
        CellColumnHandler(String name) {
            super(name);
        }

        public void metadata(SaxWriter writer) {
            writer.element("xsd:element", new String[]{"minOccurs", "0", "name", this.encodedName, "sql:field", this.name});
        }

        public void write(SaxWriter writer, Cell cell, Member[] members) {
            if (cell.isNull()) {
                return;
            }
            Object value = cell.getValue();
            String valueString = value.toString();
            String valueType = XmlaHandler.deduceValueType(cell, value);
            writer.startElement(this.encodedName, new String[]{"xsi:type", valueType});
            if (value instanceof Number) {
                valueString = XmlaUtil.normalizeNumericString(valueString);
            }
            writer.characters(valueString);
            writer.endElement();
        }
    }

    static abstract class ColumnHandler {
        protected final String name;
        protected final String encodedName;

        protected ColumnHandler(String name) {
            this.name = name;
            this.encodedName = XmlaUtil.encodeElementName(this.name);
        }

        abstract void write(SaxWriter var1, Cell var2, Member[] var3);

        abstract void metadata(SaxWriter var1);
    }

    static class MDDataSet_Multidimensional
    extends MDDataSet {
        private Hierarchy[] slicerAxisHierarchies;

        protected MDDataSet_Multidimensional(Result result) {
            super(result);
        }

        public void unparse(SaxWriter writer) throws SAXException {
            this.olapInfo(writer);
            this.axes(writer);
            this.cellData(writer);
        }

        private void olapInfo(SaxWriter writer) {
            Cube cube = this.result.getQuery().getCube();
            ArrayList<Hierarchy> hierarchyList = new ArrayList<Hierarchy>();
            Dimension[] dimensions = cube.getDimensions();
            for (int i = 0; i < dimensions.length; ++i) {
                Dimension dimension = dimensions[i];
                Hierarchy[] hierarchies = dimension.getHierarchies();
                for (int j = 0; j < hierarchies.length; ++j) {
                    Hierarchy hierarchy = hierarchies[j];
                    hierarchyList.add(hierarchy);
                }
            }
            writer.startElement("OlapInfo");
            writer.startElement("CubeInfo");
            writer.startElement("Cube");
            writer.startElement("CubeName");
            writer.characters(this.result.getQuery().getCube().getName());
            writer.endElement();
            writer.endElement();
            writer.endElement();
            writer.startElement("AxesInfo");
            Axis[] axes = this.result.getAxes();
            QueryAxis[] queryAxes = this.result.getQuery().getAxes();
            ArrayList<Hierarchy> axisHierarchyList = new ArrayList<Hierarchy>();
            for (int i = 0; i < axes.length; ++i) {
                Hierarchy[] hiers = this.axisInfo(writer, axes[i], queryAxes[i], "Axis" + i);
                for (int j = 0; j < hiers.length; ++j) {
                    axisHierarchyList.add(hiers[j]);
                }
            }
            Iterator it1 = axisHierarchyList.iterator();
            while (it1.hasNext()) {
                Hierarchy hier1 = (Hierarchy)it1.next();
                Dimension dim = hier1.getDimension();
                Hierarchy[] hiers = dim.getHierarchies();
                block5: for (int i = 0; i < hiers.length; ++i) {
                    Hierarchy h = hiers[i];
                    String uniqueName = h.getUniqueName();
                    Iterator it2 = hierarchyList.iterator();
                    while (it2.hasNext()) {
                        Hierarchy hier2 = (Hierarchy)it2.next();
                        if (!uniqueName.equals(hier2.getUniqueName())) continue;
                        it2.remove();
                        continue block5;
                    }
                }
            }
            Hierarchy[] hierarchies = hierarchyList.toArray(new Hierarchy[0]);
            writer.startElement("AxisInfo", new String[]{"name", "SlicerAxis"});
            QueryAxis slicerAxis = this.result.getQuery().getSlicerAxis();
            this.writeHierarchyInfo(writer, hierarchies, this.getProps(slicerAxis));
            writer.endElement();
            this.slicerAxisHierarchies = hierarchies;
            writer.endElement();
            writer.startElement("CellInfo");
            writer.element("Value", new String[]{"name", "VALUE"});
            writer.element("FmtValue", new String[]{"name", "FORMATTED_VALUE"});
            writer.element("FormatString", new String[]{"name", "FORMAT_STRING"});
            writer.endElement();
            writer.endElement();
        }

        private Hierarchy[] axisInfo(SaxWriter writer, Axis axis, QueryAxis queryAxis, String axisName) {
            Hierarchy[] hierarchies;
            writer.startElement("AxisInfo", new String[]{"name", axisName});
            if (axis.positions.length > 0) {
                Position position = axis.positions[0];
                hierarchies = new Hierarchy[position.members.length];
                for (int j = 0; j < position.members.length; ++j) {
                    Member member = position.members[j];
                    hierarchies[j] = member.getHierarchy();
                }
            } else {
                hierarchies = new Hierarchy[]{};
            }
            String[] props = this.getProps(queryAxis);
            this.writeHierarchyInfo(writer, hierarchies, props);
            writer.endElement();
            return hierarchies;
        }

        private void writeHierarchyInfo(SaxWriter writer, Hierarchy[] hierarchies, String[] props) {
            for (int j = 0; j < hierarchies.length; ++j) {
                writer.startElement("HierarchyInfo", new String[]{"name", hierarchies[j].getName()});
                for (int k = 0; k < props.length; ++k) {
                    String prop = props[k];
                    String longPropName = (String)longPropNames.get(prop);
                    if (longPropName == null) {
                        longPropName = prop;
                    }
                    writer.element(prop, new String[]{"name", hierarchies[j].getUniqueName() + "." + Util.quoteMdxIdentifier(longPropName)});
                }
                writer.endElement();
            }
        }

        private void axes(SaxWriter writer) {
            writer.startElement("Axes");
            Axis[] axes = this.result.getAxes();
            QueryAxis[] queryAxes = this.result.getQuery().getAxes();
            for (int i = 0; i < axes.length; ++i) {
                String[] props = this.getProps(queryAxes[i]);
                this.axis(writer, axes[i], props, "Axis" + i);
            }
            Hierarchy[] hierarchies = this.slicerAxisHierarchies;
            writer.startElement("Axis", new String[]{"name", "SlicerAxis"});
            writer.startElement("Tuples");
            writer.startElement("Tuple");
            QueryAxis slicerAxis = this.result.getQuery().getSlicerAxis();
            for (int i = 0; i < hierarchies.length; ++i) {
                Hierarchy hierarchy = hierarchies[i];
                Member member = hierarchy.getDefaultMember();
                if (member != null) {
                    this.slicerAxis(writer, member, this.getProps(slicerAxis));
                    continue;
                }
                XmlaHandler.access$000().warn((Object)("Can not create SlicerAxis: null default member for Hierarchy " + hierarchy.getUniqueName()));
            }
            writer.endElement();
            writer.endElement();
            writer.endElement();
            writer.endElement();
        }

        private String[] getProps(QueryAxis queryAxis) {
            if (queryAxis == null) {
                return defaultProps;
            }
            Id[] dimensionProperties = queryAxis.getDimensionProperties();
            if (dimensionProperties.length == 0) {
                return defaultProps;
            }
            String[] props = new String[defaultProps.length + dimensionProperties.length];
            System.arraycopy(defaultProps, 0, props, 0, defaultProps.length);
            for (int i = 0; i < dimensionProperties.length; ++i) {
                props[MDDataSet_Multidimensional.defaultProps.length + i] = dimensionProperties[i].toStringArray()[0];
            }
            return props;
        }

        private void axis(SaxWriter writer, Axis axis, String[] props, String axisName) {
            writer.startElement("Axis", new String[]{"name", axisName});
            writer.startElement("Tuples");
            Position[] positions = axis.positions;
            for (int j = 0; j < positions.length; ++j) {
                Position position = positions[j];
                writer.startElement("Tuple");
                for (int k = 0; k < position.members.length; ++k) {
                    Member member = position.members[k];
                    writer.startElement("Member", new String[]{"Hierarchy", member.getHierarchy().getName()});
                    for (int m = 0; m < props.length; ++m) {
                        Object value = null;
                        String prop = props[m];
                        String propLong = (String)longPropNames.get(prop);
                        if (propLong == null) {
                            propLong = prop;
                        }
                        if (propLong.equals(Property.DISPLAY_INFO.name)) {
                            Integer childrenCard = (Integer)member.getPropertyValue(Property.CHILDREN_CARDINALITY.name);
                            int displayInfo = this.calculateDisplayInfo(j == 0 ? null : positions[j - 1], j + 1 == positions.length ? null : positions[j + 1], member, k, childrenCard);
                            value = new Integer(displayInfo);
                        } else {
                            value = propLong.equals(Property.DEPTH.name) ? new Integer(member.getDepth()) : member.getPropertyValue(propLong);
                        }
                        if (value == null) continue;
                        writer.startElement(prop);
                        writer.characters(value.toString());
                        writer.endElement();
                    }
                    writer.endElement();
                }
                writer.endElement();
            }
            writer.endElement();
            writer.endElement();
        }

        private void slicerAxis(SaxWriter writer, Member member, String[] props) {
            writer.startElement("Member", new String[]{"Hierarchy", member.getHierarchy().getName()});
            for (int m = 0; m < props.length; ++m) {
                Object value = null;
                String prop = props[m];
                String propLong = (String)longPropNames.get(prop);
                if (propLong == null) {
                    propLong = prop;
                }
                if (propLong.equals(Property.DISPLAY_INFO.name)) {
                    Integer childrenCard = (Integer)member.getPropertyValue(Property.CHILDREN_CARDINALITY.name);
                    int displayInfo = 0xFFFF & childrenCard;
                    value = new Integer(displayInfo);
                } else {
                    value = propLong.equals(Property.DEPTH.name) ? new Integer(member.getDepth()) : member.getPropertyValue(propLong);
                }
                if (value == null) continue;
                writer.startElement(props[m]);
                writer.characters(value.toString());
                writer.endElement();
            }
            writer.endElement();
        }

        private int calculateDisplayInfo(Position prevPosition, Position nextPosition, Member currentMember, int memberOrdinal, int childrenCount) {
            int displayInfo = 0xFFFF & childrenCount;
            if (nextPosition != null) {
                String nextParentUName;
                String currentUName = currentMember.getUniqueName();
                displayInfo |= currentUName.equals(nextParentUName = nextPosition.members[memberOrdinal].getParentUniqueName()) ? 65536 : 0;
            }
            if (prevPosition != null) {
                String currentParentUName = currentMember.getParentUniqueName();
                String prevParentUName = prevPosition.members[memberOrdinal].getParentUniqueName();
                displayInfo |= currentParentUName != null && currentParentUName.equals(prevParentUName) ? 131072 : 0;
            }
            return displayInfo;
        }

        private void cellData(SaxWriter writer) {
            writer.startElement("CellData");
            int axisCount = this.result.getAxes().length;
            int[] pos = new int[axisCount];
            int[] cellOrdinal = new int[]{0};
            if (axisCount == 0) {
                this.emitCell(writer, this.result.getCell(pos), cellOrdinal[0]);
            } else {
                this.recurse(writer, pos, axisCount - 1, cellOrdinal);
            }
            writer.endElement();
        }

        private void recurse(SaxWriter writer, int[] pos, int axis, int[] cellOrdinal) {
            int axisLength = this.result.getAxes()[axis].positions.length;
            for (int i = 0; i < axisLength; ++i) {
                pos[axis] = i;
                if (axis == 0) {
                    Cell cell = this.result.getCell(pos);
                    int n = cellOrdinal[0];
                    cellOrdinal[0] = n + 1;
                    this.emitCell(writer, cell, n);
                    continue;
                }
                this.recurse(writer, pos, axis - 1, cellOrdinal);
            }
        }

        private void emitCell(SaxWriter writer, Cell cell, int ordinal) {
            if (cell.isNull()) {
                return;
            }
            writer.startElement("Cell", new String[]{"CellOrdinal", Integer.toString(ordinal)});
            for (int i = 0; i < cellProps.length; ++i) {
                String cellPropLong = cellPropLongs[i];
                Object value = cell.getPropertyValue(cellPropLong);
                if (value == null) continue;
                if (cellPropLong.equals(Property.VALUE.name)) {
                    String valueType = XmlaHandler.deduceValueType(cell, value);
                    writer.startElement(cellProps[i], new String[]{"xsi:type", valueType});
                } else {
                    writer.startElement(cellProps[i]);
                }
                String valueString = value.toString();
                if (cellPropLong.equals(Property.VALUE.name) && value instanceof Number) {
                    valueString = XmlaUtil.normalizeNumericString(valueString);
                }
                writer.characters(valueString);
                writer.endElement();
            }
            writer.endElement();
        }
    }

    static abstract class MDDataSet
    implements QueryResult {
        protected final Result result;
        protected static final String[] cellProps = new String[]{"Value", "FmtValue", "FormatString"};
        protected static final String[] cellPropLongs = new String[]{Property.VALUE.name, Property.FORMATTED_VALUE.name, Property.FORMAT_STRING.name};
        protected static final String[] defaultProps = new String[]{"UName", "Caption", "LName", "LNum", "DisplayInfo"};
        protected static final Map longPropNames = new HashMap();

        protected MDDataSet(Result result) {
            this.result = result;
        }

        static {
            longPropNames.put("UName", Property.MEMBER_UNIQUE_NAME.name);
            longPropNames.put("Caption", Property.MEMBER_CAPTION.name);
            longPropNames.put("LName", Property.LEVEL_UNIQUE_NAME.name);
            longPropNames.put("LNum", Property.LEVEL_NUMBER.name);
            longPropNames.put("DisplayInfo", Property.DISPLAY_INFO.name);
        }
    }

    static class TabularRowSet
    implements QueryResult {
        private String[] header;
        private List rows;
        private int totalCount;

        public TabularRowSet(ResultSet rs, int maxRows, int firstRowset, int totalCount) throws SQLException {
            this.totalCount = totalCount;
            ResultSetMetaData md = rs.getMetaData();
            int columnCount = md.getColumnCount();
            this.header = new String[columnCount];
            for (int i = 0; i < columnCount; ++i) {
                this.header[i] = md.getColumnLabel(i + 1);
            }
            rs.absolute(firstRowset <= 0 ? 1 : firstRowset);
            this.rows = new ArrayList();
            maxRows = maxRows <= 0 ? Integer.MAX_VALUE : maxRows;
            do {
                Object[] row = new Object[columnCount];
                for (int i = 0; i < columnCount; ++i) {
                    row[i] = rs.getObject(i + 1);
                }
                this.rows.add(row);
            } while (rs.next() && --maxRows > 0);
        }

        public void unparse(SaxWriter writer) throws SAXException {
            String[] encodedHeader = new String[this.header.length];
            for (int i = 0; i < this.header.length; ++i) {
                encodedHeader[i] = XmlaUtil.encodeElementName(this.header[i]);
            }
            if (this.totalCount >= 0) {
                String countStr = Integer.toString(this.totalCount);
                writer.startElement("row");
                for (int i = 0; i < encodedHeader.length; ++i) {
                    writer.startElement(encodedHeader[i]);
                    writer.characters(countStr);
                    writer.endElement();
                }
                writer.endElement();
            }
            Iterator it = this.rows.iterator();
            while (it.hasNext()) {
                Object[] row = (Object[])it.next();
                writer.startElement("row");
                for (int i = 0; i < row.length; ++i) {
                    writer.startElement(encodedHeader[i]);
                    Object value = row[i];
                    if (value == null) {
                        writer.characters("null");
                    } else {
                        String valueString = value.toString();
                        if (value instanceof Number) {
                            valueString = XmlaUtil.normalizeNumericString(valueString);
                        }
                        writer.characters(valueString);
                    }
                    writer.endElement();
                }
                writer.endElement();
            }
        }
    }

    private static interface QueryResult {
        public void unparse(SaxWriter var1) throws SAXException;
    }
}

