/*
 * Decompiled with CFR 0.152.
 */
package mondrian.xmla;

import com.rc.retroweaver.runtime.Collections;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import mondrian.olap.EnumeratedValues;
import mondrian.olap.Util;
import mondrian.xmla.PropertyDefinition;
import mondrian.xmla.RowsetDefinition;
import mondrian.xmla.SaxWriter;
import mondrian.xmla.XmlaConstants;
import mondrian.xmla.XmlaException;
import mondrian.xmla.XmlaHandler;
import mondrian.xmla.XmlaRequest;
import mondrian.xmla.XmlaResponse;
import org.apache.log4j.Logger;

abstract class Rowset
implements XmlaConstants {
    protected static final Logger LOGGER = Logger.getLogger((Class)(class$mondrian$xmla$Rowset == null ? (class$mondrian$xmla$Rowset = Rowset.class$("mondrian.xmla.Rowset")) : class$mondrian$xmla$Rowset));
    protected final RowsetDefinition rowsetDefinition;
    protected final Map restrictions;
    protected final Map properties;
    protected final XmlaRequest request;
    protected final XmlaHandler handler;
    private final RowsetDefinition.Column[] restrictedColumns;
    private static final /* synthetic */ Class class$mondrian$xmla$Rowset;

    Rowset(RowsetDefinition definition, XmlaRequest request, XmlaHandler handler) {
        this.rowsetDefinition = definition;
        this.restrictions = request.getRestrictions();
        this.properties = request.getProperties();
        this.request = request;
        this.handler = handler;
        ArrayList list = new ArrayList();
        Iterator restrictionsIter = this.restrictions.keySet().iterator();
        while (restrictionsIter.hasNext()) {
            String restrictedColumn = (String)restrictionsIter.next();
            LOGGER.debug((Object)("Rowset<init>: restrictedColumn=\"" + restrictedColumn + "\""));
            RowsetDefinition.Column column = definition.lookupColumn(restrictedColumn);
            if (column == null) {
                throw Util.newError("Rowset '" + definition.name + "' does not contain column '" + restrictedColumn + "'");
            }
            if (!column.restriction) {
                throw Util.newError("Rowset '" + definition.name + "' column '" + restrictedColumn + "' does not allow restrictions");
            }
            Object requiredValue = this.restrictions.get(column.name);
            if (!(requiredValue instanceof String)) {
                if (requiredValue instanceof String[]) {
                    RowsetDefinition.Type type = column.type;
                    switch (type.ordinal) {
                        case 1: 
                        case 4: 
                        case 7: {
                            break;
                        }
                        default: {
                            throw Util.newError("Rowset '" + definition.name + "' column '" + restrictedColumn + "' can only be restricted on one value at a time");
                        }
                    }
                } else {
                    throw Util.newInternal("Bad type of restricted value" + requiredValue);
                }
            }
            list.add(column);
        }
        list = this.pruneRestrictions(list);
        this.restrictedColumns = list.toArray(new RowsetDefinition.Column[0]);
        Iterator propertiesIter = this.properties.keySet().iterator();
        while (propertiesIter.hasNext()) {
            String propertyName = (String)propertiesIter.next();
            PropertyDefinition propertyDef = PropertyDefinition.getValue(propertyName);
            if (propertyDef == null) {
                throw Util.newError("Rowset '" + definition.name + "' does not support property '" + propertyName + "'");
            }
            String propertyValue = (String)this.properties.get(propertyName);
            this.setProperty(propertyDef, propertyValue);
        }
    }

    protected ArrayList pruneRestrictions(ArrayList list) {
        return list;
    }

    protected void setProperty(PropertyDefinition propertyDef, String value) {
        switch (propertyDef.ordinal) {
            case 7: {
                break;
            }
            case 5: {
                break;
            }
            case 2: {
                break;
            }
            case 8: {
                if (value != null && value.equals("1033")) {
                    return;
                }
            }
            default: {
                LOGGER.warn((Object)("Warning: Rowset '" + this.rowsetDefinition.name + "' does not support property '" + propertyDef.name + "' (value is '" + value + "')"));
            }
        }
    }

    public final void unparse(XmlaResponse response) throws XmlaException {
        ArrayList rows = new ArrayList();
        this.populate(response, rows);
        Comparator comparator = this.rowsetDefinition.getComparator();
        if (comparator != null) {
            Collections.sort(rows, (Comparator)comparator);
        }
        for (int i = 0; i < rows.size(); ++i) {
            Row row = (Row)rows.get(i);
            this.emit(row, response);
        }
    }

    public abstract void populate(XmlaResponse var1, List var2) throws XmlaException;

    private static boolean haveCommonMember(String[] a, String[] b) {
        for (int i = 0; i < a.length; ++i) {
            for (int j = 0; j < b.length; ++j) {
                if (!a[i].equals(b[j])) continue;
                return true;
            }
        }
        return false;
    }

    protected final boolean addRow(Row row, List rows) throws XmlaException {
        return rows.add(row);
    }

    protected void emit(Row row, XmlaResponse response) throws XmlaException {
        SaxWriter writer = response.getWriter();
        writer.startElement("row");
        for (int i = 0; i < this.rowsetDefinition.columnDefinitions.length; ++i) {
            int j;
            RowsetDefinition.Column column = this.rowsetDefinition.columnDefinitions[i];
            Object value = row.get(column.name);
            if (value == null) {
                if (column.nullable) continue;
                throw new XmlaException("Client", "00HSBB16", "XMLA SOAP non-nullable column", Util.newInternal("Value required for column " + column.name + " of rowset " + this.rowsetDefinition.name));
            }
            if (value instanceof XmlElement[]) {
                XmlElement[] elements = (XmlElement[])value;
                for (j = 0; j < elements.length; ++j) {
                    this.emitXmlElement(writer, elements[j]);
                }
                continue;
            }
            if (value instanceof Object[]) {
                Object[] values = (Object[])value;
                for (j = 0; j < values.length; ++j) {
                    writer.startElement(column.name);
                    writer.characters(values[j].toString());
                    writer.endElement();
                }
                continue;
            }
            writer.startElement(column.name);
            writer.characters(value.toString());
            writer.endElement();
        }
        writer.endElement();
    }

    private void emitXmlElement(SaxWriter writer, XmlElement element) {
        if (XmlElement.access$000(element) == null) {
            writer.startElement(XmlElement.access$100(element));
        } else {
            writer.startElement(XmlElement.access$100(element), XmlElement.access$000(element));
        }
        if (XmlElement.access$200(element) == null) {
            for (int i = 0; i < XmlElement.access$300(element).length; ++i) {
                this.emitXmlElement(writer, XmlElement.access$300(element)[i]);
            }
        } else {
            writer.characters(XmlElement.access$200(element));
        }
        writer.endElement();
    }

    private static boolean contains(String[] strings, String value) {
        for (int i = 0; i < strings.length; ++i) {
            if (!strings[i].equals(value)) continue;
            return true;
        }
        return false;
    }

    protected void emit(Object row, XmlaResponse response) throws XmlaException {
        SaxWriter writer = response.getWriter();
        writer.startElement("row");
        for (int i = 0; i < this.rowsetDefinition.columnDefinitions.length; ++i) {
            RowsetDefinition.Column column = this.rowsetDefinition.columnDefinitions[i];
            Object value = column.get(row);
            if (value != null) {
                writer.startElement(column.name);
                writer.characters(value.toString());
                writer.endElement();
                continue;
            }
            writer.startElement(column.name);
            writer.endElement();
        }
        writer.endElement();
    }

    protected void emit(EnumeratedValues enumeration, XmlaResponse response) throws XmlaException {
        List valuesSortedByName = enumeration.getValuesSortedByName();
        for (int i = 0; i < valuesSortedByName.size(); ++i) {
            EnumeratedValues.Value value = (EnumeratedValues.Value)valuesSortedByName.get(i);
            this.emit(value, response);
        }
    }

    RistrictionTest getRistrictionTest(RowsetDefinition.Column column) {
        final Object requiredValue = this.restrictions.get(column.name);
        if (requiredValue == null) {
            return new RistrictionTest(){

                public boolean passes(int ival) {
                    return true;
                }

                public boolean passes(Object value) {
                    return true;
                }
            };
        }
        if (requiredValue instanceof String[]) {
            final String[] requiredValueArray = (String[])requiredValue;
            return new RistrictionTest(){

                public boolean passes(Object value) {
                    return Rowset.access$400(requiredValueArray, value.toString());
                }
            };
        }
        return new RistrictionTest(){

            public boolean passes(Object value) {
                return requiredValue.equals(value);
            }
        };
    }

    Object getRestrictionValue(RowsetDefinition.Column column) {
        return this.restrictions.get(column.name);
    }

    String getRestrictionValueAsString(RowsetDefinition.Column column) {
        Object rval = this.getRestrictionValue(column);
        return rval instanceof String ? (String)rval : null;
    }

    int getRestrictionValueAsInt(RowsetDefinition.Column column) {
        Object rval = this.getRestrictionValue(column);
        if (rval instanceof String) {
            try {
                return Integer.parseInt((String)rval);
            }
            catch (NumberFormatException ex) {
                LOGGER.info((Object)("Rowset.getRestrictionValue: bad integer restriction \"" + rval + "\""));
                return -1;
            }
        }
        if (rval instanceof Integer) {
            return (Integer)rval;
        }
        return -1;
    }

    protected boolean isRestricted(RowsetDefinition.Column column) {
        return this.restrictions.get(column.name) != null;
    }

    static boolean access$400(String[] x0, String x1) {
        return Rowset.contains(x0, x1);
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        Class<?> clazz;
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            NoClassDefFoundError noClassDefFoundError = new NoClassDefFoundError(classNotFoundException.getMessage());
            try {
                noClassDefFoundError.initCause(classNotFoundException);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
            throw noClassDefFoundError;
        }
        return clazz;
    }

    protected class XmlElement {
        private final String tag;
        private final String[] attributes;
        private final String text;
        private final XmlElement[] children;

        XmlElement(String tag, String[] attributes) {
            this(tag, attributes, null, null);
        }

        XmlElement(String tag, String[] attributes, String text) {
            this(tag, attributes, text, null);
        }

        XmlElement(String tag, String[] attributes, XmlElement[] children) {
            this(tag, attributes, null, children);
        }

        private XmlElement(String tag, String[] attributes, String text, XmlElement[] children) {
            this.tag = tag;
            this.attributes = attributes;
            this.text = text;
            this.children = children;
        }

        static String[] access$000(XmlElement x0) {
            return x0.attributes;
        }

        static String access$100(XmlElement x0) {
            return x0.tag;
        }

        static String access$200(XmlElement x0) {
            return x0.text;
        }

        static XmlElement[] access$300(XmlElement x0) {
            return x0.children;
        }
    }

    protected class Row {
        private final ArrayList names = new ArrayList();
        private final ArrayList values = new ArrayList();

        Row() {
        }

        void set(String name, Object value) {
            this.names.add(name);
            this.values.add(value);
        }

        void set(String name, int value) {
            this.set(name, new Integer(value));
        }

        void set(String name, boolean value) {
            this.set(name, value ? "true" : "false");
        }

        public Object get(String name) {
            int i = this.names.indexOf(name);
            return i < 0 ? null : this.values.get(i);
        }
    }

    static abstract class RistrictionTest {
        RistrictionTest() {
        }

        public boolean passes(int ival) {
            return this.passes(new Integer(ival));
        }

        public abstract boolean passes(Object var1);
    }
}

