/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap.sql;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import mondrian.olap.MondrianDef;
import mondrian.olap.MondrianProperties;
import mondrian.olap.Util;
import org.eigenbase.util.property.Property;
import org.eigenbase.util.property.Trigger;

public class SqlQuery {
    private static boolean generateFormattedSql = MondrianProperties.instance().GenerateFormattedSql.get();
    private boolean distinct;
    private final ClauseList select = new ClauseList(true);
    private final ClauseList from = new ClauseList(true);
    private final ClauseList where = new ClauseList(false);
    private final ClauseList groupBy = new ClauseList(false);
    private final ClauseList having = new ClauseList(false);
    private final ClauseList orderBy = new ClauseList(false);
    private final List fromAliases = new ArrayList();
    private final Dialect dialect;
    private final StringBuffer buf = new StringBuffer(128);
    private static final int SINGLE_QUOTE_SIZE = 10;
    private static final int DOUBLE_QUOTE_SIZE = 21;

    public SqlQuery(Dialect dialect) {
        this.dialect = dialect;
    }

    public SqlQuery(DatabaseMetaData databaseMetaData) {
        this(Dialect.create(databaseMetaData));
    }

    public SqlQuery cloneEmpty() {
        return new SqlQuery(this.dialect);
    }

    public void setDistinct(boolean distinct) {
        this.distinct = distinct;
    }

    public boolean addFromQuery(String query, String alias, boolean failIfExists) {
        Util.assertPrecondition(alias != null);
        if (this.fromAliases.contains(alias)) {
            if (failIfExists) {
                throw Util.newInternal("query already contains alias '" + alias + "'");
            }
            return false;
        }
        this.buf.setLength(0);
        this.buf.append('(');
        this.buf.append(query);
        this.buf.append(')');
        if (alias != null) {
            Util.assertTrue(alias.length() > 0);
            if (this.dialect.allowsAs()) {
                this.buf.append(" as ");
            } else {
                this.buf.append(' ');
            }
            this.dialect.quoteIdentifier(alias, this.buf);
            this.fromAliases.add(alias);
        }
        this.from.add(this.buf.toString());
        return true;
    }

    private boolean addFromTable(String schema, String table, String alias, String filter, boolean failIfExists) {
        if (this.fromAliases.contains(alias)) {
            if (failIfExists) {
                throw Util.newInternal("query already contains alias '" + alias + "'");
            }
            return false;
        }
        this.buf.setLength(0);
        this.dialect.quoteIdentifier(schema, table, this.buf);
        if (alias != null) {
            Util.assertTrue(alias.length() > 0);
            if (this.dialect.allowsAs()) {
                this.buf.append(" as ");
            } else {
                this.buf.append(' ');
            }
            this.dialect.quoteIdentifier(alias, this.buf);
            this.fromAliases.add(alias);
        }
        this.from.add(this.buf.toString());
        if (filter != null) {
            this.addWhere("(", filter, ")");
        }
        return true;
    }

    public void addFrom(SqlQuery sqlQuery, String alias, boolean failIfExists) {
        this.addFromQuery(sqlQuery.toString(), alias, failIfExists);
    }

    public boolean addFrom(MondrianDef.Relation relation, String alias, boolean failIfExists) {
        if (relation instanceof MondrianDef.View) {
            MondrianDef.View view = (MondrianDef.View)relation;
            String viewAlias = alias == null ? view.getAlias() : alias;
            String sqlString = this.dialect.chooseQuery(view.selects);
            return this.addFromQuery(sqlString, viewAlias, false);
        }
        if (relation instanceof MondrianDef.Table) {
            MondrianDef.Table table = (MondrianDef.Table)relation;
            String tableAlias = alias == null ? table.getAlias() : alias;
            return this.addFromTable(table.schema, table.name, tableAlias, table.getFilter(), failIfExists);
        }
        if (relation instanceof MondrianDef.Join) {
            boolean added;
            MondrianDef.Join join = (MondrianDef.Join)relation;
            String leftAlias = join.getLeftAlias();
            String rightAlias = join.getRightAlias();
            boolean addLeft = this.addFrom(join.left, leftAlias, failIfExists);
            boolean addRight = this.addFrom(join.right, rightAlias, failIfExists);
            boolean bl = added = addLeft || addRight;
            if (added) {
                this.buf.setLength(0);
                this.dialect.quoteIdentifier(leftAlias, join.leftKey, this.buf);
                this.buf.append(" = ");
                this.dialect.quoteIdentifier(rightAlias, join.rightKey, this.buf);
                this.addWhere(this.buf.toString());
            }
            return added;
        }
        throw Util.newInternal("bad relation type " + (Object)((Object)relation));
    }

    public void addSelect(String expression) {
        if (this.dialect.isAS400() || this.dialect.isDerby()) {
            this.addSelect(expression, null);
        } else {
            this.addSelect(expression, this.nextColumnAlias());
        }
    }

    public String nextColumnAlias() {
        return "c" + this.select.size();
    }

    public void addSelect(String expression, String alias) {
        this.buf.setLength(0);
        this.buf.append(expression);
        if (alias != null) {
            this.buf.append(" as ");
            this.dialect.quoteIdentifier(alias, this.buf);
        }
        this.select.add(this.buf.toString());
    }

    public void addWhere(String exprLeft, String exprMid, String exprRight) {
        int len = exprLeft.length() + exprMid.length() + exprRight.length();
        StringBuffer buf = new StringBuffer(len);
        buf.append(exprLeft);
        buf.append(exprMid);
        buf.append(exprRight);
        this.addWhere(buf.toString());
    }

    public void addWhere(String expression) {
        this.where.add(expression);
    }

    public void addGroupBy(String expression) {
        this.groupBy.add(expression);
    }

    public void addHaving(String expression) {
        this.having.add(expression);
    }

    public void addOrderBy(String expr, boolean ascending, boolean prepend, boolean nullable) {
        if (nullable && !this.dialect.isNullsCollateLast()) {
            expr = this.dialect.forceNullsCollateLast(expr);
        }
        expr = ascending ? expr + " ASC" : expr + " DESC";
        if (prepend) {
            this.orderBy.add(0, expr);
        } else {
            this.orderBy.add(expr);
        }
    }

    public String toString() {
        if (generateFormattedSql) {
            StringWriter sw = new StringWriter(256);
            PrintWriter pw = new PrintWriter(sw);
            this.print(pw, "");
            pw.flush();
            return sw.toString();
        }
        this.buf.setLength(0);
        this.select.toBuffer(this.buf, this.distinct ? "select distinct " : "select ", ", ");
        this.from.toBuffer(this.buf, " from ", ", ");
        this.where.toBuffer(this.buf, " where ", " and ");
        this.groupBy.toBuffer(this.buf, " group by ", ", ");
        this.having.toBuffer(this.buf, " having ", " and ");
        this.orderBy.toBuffer(this.buf, " order by ", ", ");
        return this.buf.toString();
    }

    public void print(PrintWriter pw, String prefix) {
        pw.println();
        this.select.print(pw, prefix, this.distinct ? "select distinct " : "select ", ", ");
        this.from.print(pw, prefix, "from ", ", ");
        this.where.print(pw, prefix, "where ", " and ");
        this.groupBy.print(pw, prefix, "group by ", ", ");
        this.having.print(pw, prefix, "having ", " and ");
        this.orderBy.print(pw, prefix, "order by ", ", ");
    }

    public Dialect getDialect() {
        return this.dialect;
    }

    public String quote(boolean numeric, Object value) throws NumberFormatException {
        String string = String.valueOf(value);
        if ("#null".equalsIgnoreCase(string)) {
            return "null";
        }
        if (numeric) {
            if (value instanceof Number) {
                return string;
            }
            Double.valueOf(string);
            return string;
        }
        return Util.singleQuoteString(string);
    }

    static boolean access$002(boolean x0) {
        generateFormattedSql = x0;
        return generateFormattedSql;
    }

    static {
        MondrianProperties.instance().GenerateFormattedSql.addTrigger(new Trigger(){

            public boolean isPersistent() {
                return true;
            }

            public int phase() {
                return 1;
            }

            public void execute(Property property, String value) {
                SqlQuery.access$002(property.booleanValue());
            }
        });
    }

    public static class Dialect {
        private final String quoteIdentifierString;
        private final String productName;
        private final String productVersion;

        Dialect(String quoteIdentifierString, String productName, String productVersion) {
            this.quoteIdentifierString = quoteIdentifierString;
            this.productName = productName;
            this.productVersion = productVersion;
        }

        public static Dialect create(DatabaseMetaData databaseMetaData) {
            String productVersion;
            String quoteIdentifierString;
            String productName;
            try {
                productName = databaseMetaData.getDatabaseProductName();
            }
            catch (SQLException e1) {
                throw Util.newInternal(e1, "while detecting database product");
            }
            try {
                quoteIdentifierString = databaseMetaData.getIdentifierQuoteString();
            }
            catch (SQLException e) {
                throw Util.newInternal(e, "while quoting identifier");
            }
            if (quoteIdentifierString == null || quoteIdentifierString.trim().length() == 0) {
                quoteIdentifierString = productName.toUpperCase().equals("MYSQL") ? "`" : null;
            }
            try {
                productVersion = databaseMetaData.getDatabaseProductVersion();
            }
            catch (SQLException e11) {
                throw Util.newInternal(e11, "while detecting database product version");
            }
            return new Dialect(quoteIdentifierString, productName, productVersion);
        }

        public boolean isAccess() {
            return this.productName.equals("ACCESS");
        }

        public boolean isDerby() {
            return this.productName.trim().toUpperCase().equals("APACHE DERBY");
        }

        public boolean isCloudscape() {
            return this.productName.trim().toUpperCase().equals("DBMS:CLOUDSCAPE");
        }

        public boolean isDB2() {
            return this.productName.startsWith("DB2");
        }

        public boolean isAS400() {
            return this.productName.startsWith("DB2 UDB for AS/400");
        }

        public boolean isOldAS400() {
            if (!this.isAS400()) {
                return false;
            }
            String[] version_release = this.productVersion.split("\\.", 3);
            return "04".compareTo(version_release[0]) >= 0;
        }

        private String getBestName() {
            String best = this.isOracle() ? "oracle" : (this.isMSSQL() ? "mssql" : (this.isMySQL() ? "mysql" : (this.isAccess() ? "access" : (this.isPostgres() ? "postgres" : (this.isSybase() ? "sybase" : (this.isCloudscape() || this.isDerby() ? "derby" : (this.isDB2() ? "db2" : (this.isFirebird() ? "firebird" : (this.isInterbase() ? "interbase" : (this.isIngres() ? "ingres" : (this.isLucidDB() ? "luciddb" : (this.isTeradata() ? "teradata" : "generic"))))))))))));
            return best;
        }

        public String toUpper(String expr) {
            if (this.isDB2() || this.isAccess()) {
                return "UCASE(" + expr + ")";
            }
            return "UPPER(" + expr + ")";
        }

        public String caseWhenElse(String cond, String thenExpr, String elseExpr) {
            if (this.isAccess()) {
                return "IIF(" + cond + "," + thenExpr + "," + elseExpr + ")";
            }
            return "CASE WHEN " + cond + " THEN " + thenExpr + " ELSE " + elseExpr + " END";
        }

        public String quoteIdentifier(String val) {
            int size = val.length() + 10;
            StringBuffer buf = new StringBuffer(size);
            this.quoteIdentifier(val, buf);
            return buf.toString();
        }

        public void quoteIdentifier(String val, StringBuffer buf) {
            String q = this.getQuoteIdentifierString();
            if (q == null) {
                buf.append(val);
                return;
            }
            if (val.startsWith(q) && val.endsWith(q)) {
                buf.append(val);
                return;
            }
            int k = val.indexOf(46);
            if (k > 0) {
                String val1 = Util.replace(val.substring(0, k), q, q + q);
                String val2 = Util.replace(val.substring(k + 1), q, q + q);
                buf.append(q);
                buf.append(val1);
                buf.append(q);
                buf.append(".");
                buf.append(q);
                buf.append(val2);
                buf.append(q);
            } else {
                String val2 = Util.replace(val, q, q + q);
                buf.append(q);
                buf.append(val2);
                buf.append(q);
            }
        }

        public String quoteIdentifier(String qual, String name) {
            int size = name.length() + (qual == null ? 10 : qual.length() + 21);
            StringBuffer buf = new StringBuffer(size);
            this.quoteIdentifier(qual, name, buf);
            return buf.toString();
        }

        public void quoteIdentifier(String qual, String name, StringBuffer buf) {
            if (qual == null) {
                this.quoteIdentifier(name, buf);
            } else {
                Util.assertTrue(qual.length() != 0, "qual should probably be null, not empty");
                this.quoteIdentifier(qual, buf);
                buf.append('.');
                this.quoteIdentifier(name, buf);
            }
        }

        public String getQuoteIdentifierString() {
            if (this.isDB2()) {
                return "";
            }
            return this.quoteIdentifierString;
        }

        public String quoteString(String s) {
            return Util.singleQuoteString(s);
        }

        public boolean isFirebird() {
            return this.productName.toUpperCase().indexOf("FIREBIRD") >= 0;
        }

        public boolean isInformix() {
            return this.productName.startsWith("Informix");
        }

        public boolean isIngres() {
            return this.productName.toUpperCase().equals("INGRES");
        }

        public boolean isInterbase() {
            return this.productName.equals("Interbase");
        }

        public boolean isLucidDB() {
            return this.productName.toUpperCase().equals("LUCIDDB");
        }

        public boolean isMSSQL() {
            return this.productName.toUpperCase().indexOf("SQL SERVER") >= 0;
        }

        public boolean isOracle() {
            return this.productName.equals("Oracle");
        }

        public boolean isPostgres() {
            return this.productName.toUpperCase().indexOf("POSTGRE") >= 0;
        }

        public boolean isMySQL() {
            return this.productName.toUpperCase().equals("MYSQL");
        }

        public boolean isSybase() {
            return this.productName.toUpperCase().indexOf("SYBASE") >= 0;
        }

        public boolean isTeradata() {
            return this.productName.toUpperCase().indexOf("SYBASE") >= 0;
        }

        protected boolean requiresAliasForFromItems() {
            return this.isPostgres();
        }

        protected boolean allowsAs() {
            return !this.isOracle() && !this.isSybase() && !this.isFirebird() && !this.isInterbase();
        }

        public boolean allowsFromQuery() {
            return !this.isMySQL() && !this.isOldAS400() && !this.isInformix() && !this.isSybase() && !this.isInterbase();
        }

        public boolean allowsCompoundCountDistinct() {
            return this.isMySQL();
        }

        public boolean allowsCountDistinct() {
            return !this.isAccess();
        }

        public String chooseQuery(MondrianDef.SQL[] sqls) {
            String best = this.getBestName();
            String generic = null;
            for (int i = 0; i < sqls.length; ++i) {
                MondrianDef.SQL sql = sqls[i];
                if (sql.dialect.equals(best)) {
                    return sql.cdata;
                }
                if (!sql.dialect.equals("generic")) continue;
                generic = sql.cdata;
            }
            if (generic == null) {
                throw Util.newError("View has no 'generic' variant");
            }
            return generic;
        }

        public String generateInline(List columnNames, List columnTypes, List valueList) {
            if (this.isOracle()) {
                return this.generateInlineGeneric(columnNames, columnTypes, valueList, "from dual");
            }
            if (this.isAccess()) {
                return this.generateInlineGeneric(columnNames, columnTypes, valueList, "from [days] where [day] = 1");
            }
            if (this.isMySQL()) {
                return this.generateInlineGeneric(columnNames, columnTypes, valueList, null);
            }
            return this.generateInlineForAnsi("t", columnNames, columnTypes, valueList);
        }

        private String generateInlineGeneric(List columnNames, List columnTypes, List valueList, String fromClause) {
            StringBuffer buf = new StringBuffer();
            for (int i = 0; i < valueList.size(); ++i) {
                if (i > 0) {
                    buf.append(" union all ");
                }
                String[] values = (String[])valueList.get(i);
                buf.append("select ");
                for (int j = 0; j < values.length; ++j) {
                    String value = values[j];
                    if (j > 0) {
                        buf.append(", ");
                    }
                    String columnType = (String)columnTypes.get(j);
                    String columnName = (String)columnNames.get(j);
                    if (value == null) {
                        buf.append("null");
                    } else if (columnType.equals("String")) {
                        buf.append(this.quoteString(value));
                    } else {
                        buf.append(value);
                    }
                    if (this.allowsAs()) {
                        buf.append(" as ");
                    } else {
                        buf.append(' ');
                    }
                    this.quoteIdentifier(columnName, buf);
                }
                if (fromClause == null) continue;
                buf.append(fromClause);
            }
            return buf.toString();
        }

        private String generateInlineForAnsi(String alias, List columnNames, List columnTypes, List valueList) {
            int i;
            StringBuffer buf = new StringBuffer();
            buf.append("SELECT * FROM (VALUES ");
            String[] castTypes = null;
            if (this.isDerby()) {
                castTypes = new String[columnNames.size()];
                for (i = 0; i < columnNames.size(); ++i) {
                    String columnType = (String)columnTypes.get(i);
                    if (!columnType.equals("String")) continue;
                    castTypes[i] = Dialect.guessSqlType(columnType, valueList, i);
                }
            }
            for (i = 0; i < valueList.size(); ++i) {
                if (i > 0) {
                    buf.append(", ");
                }
                String[] values = (String[])valueList.get(i);
                buf.append("(");
                for (int j = 0; j < values.length; ++j) {
                    String value = values[j];
                    if (j > 0) {
                        buf.append(", ");
                    }
                    String columnType = (String)columnTypes.get(j);
                    if (value == null) {
                        String sqlType = Dialect.guessSqlType(columnType, valueList, j);
                        buf.append("CAST(NULL AS ").append(sqlType).append(")");
                        continue;
                    }
                    if (this.isDerby() && castTypes[j] != null) {
                        buf.append("CAST(").append(this.quote(value, columnType)).append(" AS ").append(castTypes[j]).append(")");
                        continue;
                    }
                    buf.append(this.quote(value, columnType));
                }
                buf.append(")");
            }
            buf.append(") AS ");
            this.quoteIdentifier(alias, buf);
            buf.append(" (");
            for (int j = 0; j < columnNames.size(); ++j) {
                String columnName = (String)columnNames.get(j);
                if (j > 0) {
                    buf.append(", ");
                }
                this.quoteIdentifier(columnName, buf);
            }
            buf.append(")");
            return buf.toString();
        }

        private String quote(String value, String type) {
            if (type.equals("String")) {
                value = this.quoteString(value);
            }
            return value;
        }

        private static String guessSqlType(String basicType, List valueList, int column) {
            if (basicType.equals("String")) {
                int maxLen = 1;
                for (int i = 0; i < valueList.size(); ++i) {
                    String[] values = (String[])valueList.get(i);
                    String value = values[column];
                    if (value == null) continue;
                    maxLen = Math.max(maxLen, value.length());
                }
                return "VARCHAR(" + maxLen + ")";
            }
            return "INTEGER";
        }

        public boolean allowsDdl() {
            return !this.isAccess();
        }

        public boolean isNullsCollateLast() {
            return !this.isMySQL();
        }

        public String forceNullsCollateLast(String expr) {
            if (this.isMySQL()) {
                String addIsNull = "ISNULL(" + expr + "), ";
                expr = addIsNull + expr;
            }
            return expr;
        }

        public boolean supportsGroupByExpressions() {
            return !this.isDerby() && !this.isCloudscape();
        }
    }

    private class ClauseList
    extends ArrayList {
        private final boolean allowDups;

        ClauseList(boolean allowDups) {
            this.allowDups = allowDups;
        }

        void add(String element) {
            if (this.allowDups || !this.contains(element)) {
                super.add(element);
            }
        }

        void toBuffer(StringBuffer buf, String first, String sep) {
            Iterator it = this.iterator();
            boolean firstTime = true;
            while (it.hasNext()) {
                String s = (String)it.next();
                if (firstTime) {
                    buf.append(first);
                    firstTime = false;
                } else {
                    buf.append(sep);
                }
                buf.append(s);
            }
        }

        void print(PrintWriter pw, String prefix, String first, String sep) {
            String subprefix = prefix + "    ";
            boolean firstTime = true;
            Iterator it = this.iterator();
            while (it.hasNext()) {
                String s = (String)it.next();
                if (firstTime) {
                    pw.print(prefix);
                    pw.print(first);
                    firstTime = false;
                } else {
                    pw.print(sep);
                }
                pw.println();
                pw.print(subprefix);
                pw.print(s);
            }
            if (!firstTime) {
                pw.println();
            }
        }
    }
}

