/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap.aggmatcher;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import mondrian.olap.Dimension;
import mondrian.olap.Hierarchy;
import mondrian.olap.MondrianDef;
import mondrian.recorder.MessageRecorder;
import mondrian.resource.MondrianResource;
import mondrian.rolap.HierarchyUsage;
import mondrian.rolap.RolapAggregator;
import mondrian.rolap.RolapCube;
import mondrian.rolap.RolapLevel;
import mondrian.rolap.RolapSchema;
import mondrian.rolap.RolapStar;
import mondrian.rolap.aggmatcher.JdbcSchema;
import mondrian.rolap.sql.SqlQuery;
import org.apache.log4j.Logger;

abstract class Recognizer {
    private static final MondrianResource mres = MondrianResource.instance();
    private static final Logger LOGGER = Logger.getLogger((Class)(class$mondrian$rolap$aggmatcher$Recognizer == null ? (class$mondrian$rolap$aggmatcher$Recognizer = Recognizer.class$("mondrian.rolap.aggmatcher.Recognizer")) : class$mondrian$rolap$aggmatcher$Recognizer));
    protected final RolapStar star;
    protected final JdbcSchema.Table dbFactTable;
    protected final JdbcSchema.Table aggTable;
    protected final MessageRecorder msgRecorder;
    protected boolean returnValue;
    private static final /* synthetic */ Class class$mondrian$rolap$aggmatcher$Recognizer;

    protected Recognizer(RolapStar star, JdbcSchema.Table dbFactTable, JdbcSchema.Table aggTable, MessageRecorder msgRecorder) {
        this.star = star;
        this.dbFactTable = dbFactTable;
        this.aggTable = aggTable;
        this.msgRecorder = msgRecorder;
        this.returnValue = true;
    }

    public boolean check() {
        this.checkIgnores();
        this.checkFactCount();
        int nosMeasures = this.checkMeasures();
        this.checkNosMeasures(nosMeasures);
        this.generateImpliedMeasures();
        List notSeenForeignKeys = this.checkForeignKeys();
        this.checkLevels(notSeenForeignKeys);
        if (this.returnValue) {
            this.checkUnusedColumns();
        }
        return this.returnValue;
    }

    protected abstract Matcher getIgnoreMatcher();

    protected void checkIgnores() {
        Matcher ignoreMatcher = this.getIgnoreMatcher();
        Iterator it = this.aggTable.getColumns();
        while (it.hasNext()) {
            JdbcSchema.Table.Column aggColumn = (JdbcSchema.Table.Column)it.next();
            if (!ignoreMatcher.matches(aggColumn.getName())) continue;
            this.makeIgnore(aggColumn);
        }
    }

    protected void makeIgnore(JdbcSchema.Table.Column aggColumn) {
        JdbcSchema.Table.Column.Usage usage = aggColumn.newUsage(32);
        usage.setSymbolicName("Ignore");
    }

    protected abstract Matcher getFactCountMatcher();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkFactCount() {
        this.msgRecorder.pushContextName("Recognizer.checkFactCount");
        try {
            String msg;
            Matcher factCountMatcher = this.getFactCountMatcher();
            int nosOfFactCounts = 0;
            Iterator it = this.aggTable.getColumns();
            while (it.hasNext()) {
                JdbcSchema.Table.Column aggColumn = (JdbcSchema.Table.Column)it.next();
                if (aggColumn.hasUsage(32) || !factCountMatcher.matches(aggColumn.getName())) continue;
                if (!aggColumn.isNumeric()) {
                    String msg2 = Recognizer.mres.NonNumericFactCountColumn.str(this.aggTable.getName(), this.dbFactTable.getName(), aggColumn.getName(), aggColumn.getTypeName());
                    this.msgRecorder.reportError(msg2);
                    this.returnValue = false;
                    continue;
                }
                this.makeFactCount(aggColumn);
                ++nosOfFactCounts;
            }
            if (nosOfFactCounts == 0) {
                msg = Recognizer.mres.NoFactCountColumns.str(this.aggTable.getName(), this.dbFactTable.getName());
                this.msgRecorder.reportError(msg);
                this.returnValue = false;
            } else if (nosOfFactCounts > 1) {
                msg = Recognizer.mres.TooManyFactCountColumns.str(this.aggTable.getName(), this.dbFactTable.getName(), new Integer(nosOfFactCounts));
                this.msgRecorder.reportError(msg);
                this.returnValue = false;
            }
        }
        finally {
            this.msgRecorder.popContextName();
        }
    }

    protected abstract int checkMeasures();

    protected void makeFactCount(JdbcSchema.Table.Column aggColumn) {
        JdbcSchema.Table.Column.Usage usage = aggColumn.newUsage(16);
        usage.setSymbolicName("Fact Count");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkNosMeasures(int nosMeasures) {
        this.msgRecorder.pushContextName("Recognizer.checkNosMeasures");
        try {
            if (nosMeasures == 0) {
                String msg = Recognizer.mres.NoMeasureColumns.str(this.aggTable.getName(), this.dbFactTable.getName());
                this.msgRecorder.reportError(msg);
                this.returnValue = false;
            }
        }
        finally {
            this.msgRecorder.popContextName();
        }
    }

    protected void generateImpliedMeasures() {
        Iterator it = this.dbFactTable.getColumns();
        while (it.hasNext()) {
            JdbcSchema.Table.Column factColumn = (JdbcSchema.Table.Column)it.next();
            JdbcSchema.Table.Column.Usage sumFactUsage = null;
            JdbcSchema.Table.Column.Usage avgFactUsage = null;
            Iterator mit = factColumn.getUsages(4);
            while (mit.hasNext()) {
                JdbcSchema.Table.Column.Usage factUsage = (JdbcSchema.Table.Column.Usage)mit.next();
                if (factUsage.getAggregator() == RolapAggregator.Avg) {
                    avgFactUsage = factUsage;
                    continue;
                }
                if (factUsage.getAggregator() != RolapAggregator.Sum) continue;
                sumFactUsage = factUsage;
            }
            if (avgFactUsage == null || sumFactUsage == null) continue;
            JdbcSchema.Table.Column.Usage sumAggUsage = null;
            JdbcSchema.Table.Column.Usage avgAggUsage = null;
            int nosSeen = 0;
            Iterator mit2 = this.aggTable.getColumnUsages(4);
            while (mit2.hasNext()) {
                JdbcSchema.Table.Column.Usage aggUsage = (JdbcSchema.Table.Column.Usage)mit2.next();
                if (aggUsage.rMeasure == avgFactUsage.rMeasure) {
                    avgAggUsage = aggUsage;
                    ++nosSeen;
                    continue;
                }
                if (aggUsage.rMeasure != sumFactUsage.rMeasure) continue;
                sumAggUsage = aggUsage;
                ++nosSeen;
            }
            if (nosSeen != true) continue;
            if (avgAggUsage != null) {
                this.makeMeasure(sumFactUsage, avgAggUsage);
            }
            if (sumAggUsage == null) continue;
            this.makeMeasure(avgFactUsage, sumAggUsage);
        }
    }

    protected void makeMeasure(JdbcSchema.Table.Column.Usage factUsage, JdbcSchema.Table.Column.Usage aggSiblingUsage) {
        JdbcSchema.Table.Column aggColumn = aggSiblingUsage.getColumn();
        JdbcSchema.Table.Column.Usage aggUsage = aggColumn.newUsage(4);
        aggUsage.setSymbolicName(factUsage.getSymbolicName());
        RolapAggregator ra = this.convertAggregator(aggUsage, factUsage.getAggregator(), aggSiblingUsage.getAggregator());
        aggUsage.setAggregator(ra);
        aggUsage.rMeasure = factUsage.rMeasure;
    }

    protected void makeMeasure(JdbcSchema.Table.Column.Usage factUsage, JdbcSchema.Table.Column aggColumn) {
        JdbcSchema.Table.Column.Usage aggUsage = aggColumn.newUsage(4);
        aggUsage.setSymbolicName(factUsage.getSymbolicName());
        RolapAggregator ra = this.convertAggregator(aggUsage, factUsage.getAggregator());
        aggUsage.setAggregator(ra);
        aggUsage.rMeasure = factUsage.rMeasure;
    }

    protected abstract int matchForeignKey(JdbcSchema.Table.Column.Usage var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List checkForeignKeys() {
        this.msgRecorder.pushContextName("Recognizer.checkForeignKeys");
        try {
            ArrayList<JdbcSchema.Table.Column.Usage> notSeenForeignKeys = Collections.EMPTY_LIST;
            Iterator it = this.dbFactTable.getColumnUsages(2);
            while (it.hasNext()) {
                JdbcSchema.Table.Column.Usage factUsage = (JdbcSchema.Table.Column.Usage)it.next();
                int nosMatched = this.matchForeignKey(factUsage);
                if (nosMatched > 1) {
                    String msg = Recognizer.mres.TooManyMatchingForeignKeyColumns.str(this.aggTable.getName(), this.dbFactTable.getName(), new Integer(nosMatched), factUsage.getColumn().getName());
                    this.msgRecorder.reportError(msg);
                    this.returnValue = false;
                    continue;
                }
                if (nosMatched != 0) continue;
                if (notSeenForeignKeys == Collections.EMPTY_LIST) {
                    notSeenForeignKeys = new ArrayList<JdbcSchema.Table.Column.Usage>();
                }
                notSeenForeignKeys.add(factUsage);
            }
            ArrayList<JdbcSchema.Table.Column.Usage> arrayList = notSeenForeignKeys;
            return arrayList;
        }
        finally {
            this.msgRecorder.popContextName();
        }
    }

    protected void checkLevels(List notSeenForeignKeys) {
        Iterator it = this.findCubes();
        while (it.hasNext()) {
            RolapCube cube = (RolapCube)it.next();
            Dimension[] dims = cube.getDimensions();
            for (int j = 1; j < dims.length; ++j) {
                Dimension dim = dims[j];
                String dimName = dim.getName();
                Hierarchy[] hierarchies = dim.getHierarchies();
                for (int k = 0; k < hierarchies.length; ++k) {
                    Hierarchy hierarchy = hierarchies[k];
                    HierarchyUsage[] hierarchyUsages = cube.getUsages(hierarchy);
                    for (int m = 0; m < hierarchyUsages.length; ++m) {
                        RolapLevel level;
                        HierarchyUsage hierarchyUsage = hierarchyUsages[m];
                        String foreignKey = hierarchyUsage.getForeignKey();
                        boolean b = this.inNotSeenForeignKeys(foreignKey, notSeenForeignKeys);
                        if (!b) continue;
                        RolapLevel[] levels = (RolapLevel[])hierarchy.getLevels();
                        for (int n = 0; n < levels.length && ((level = levels[n]).isAll() || this.matchLevel(hierarchy, hierarchyUsage, level)); ++n) {
                        }
                    }
                }
            }
        }
    }

    boolean inNotSeenForeignKeys(String foreignKey, List notSeenForeignKeys) {
        Iterator it = notSeenForeignKeys.iterator();
        while (it.hasNext()) {
            JdbcSchema.Table.Column.Usage usage = (JdbcSchema.Table.Column.Usage)it.next();
            if (!usage.getColumn().getName().equals(foreignKey)) continue;
            return true;
        }
        return false;
    }

    private void printNotSeenForeignKeys(List notSeenForeignKeys) {
        LOGGER.debug((Object)("Recognizer.printNotSeenForeignKeys: " + this.aggTable.getName()));
        Iterator it = notSeenForeignKeys.iterator();
        while (it.hasNext()) {
            JdbcSchema.Table.Column.Usage usage = (JdbcSchema.Table.Column.Usage)it.next();
            LOGGER.debug((Object)("  " + usage.getColumn().getName()));
        }
    }

    protected void makeForeignKey(JdbcSchema.Table.Column.Usage factUsage, JdbcSchema.Table.Column aggColumn, String rightJoinConditionColumnName) {
        JdbcSchema.Table.Column.Usage aggUsage = aggColumn.newUsage(2);
        aggUsage.setSymbolicName("FOREIGN_KEY");
        aggUsage.rTable = factUsage.rTable;
        aggUsage.rightJoinConditionColumnName = rightJoinConditionColumnName;
        aggUsage.rColumn = factUsage.rColumn;
    }

    protected abstract boolean matchLevel(Hierarchy var1, HierarchyUsage var2, RolapLevel var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void makeLevel(JdbcSchema.Table.Column aggColumn, Hierarchy hierarchy, HierarchyUsage hierarchyUsage, String factColumnName, String levelColumnName, String symbolicName) {
        this.msgRecorder.pushContextName("Recognizer.makeLevel");
        try {
            if (aggColumn.hasUsage(8)) {
                Iterator uit = aggColumn.getUsages(8);
                while (uit.hasNext()) {
                    JdbcSchema.Table.Column.Usage aggUsage = (JdbcSchema.Table.Column.Usage)uit.next();
                    MondrianDef.Relation rel = hierarchyUsage.getJoinTable();
                    String cName = levelColumnName;
                    if (aggUsage.relation.equals((Object)rel) && aggColumn.column.name.equals(cName)) continue;
                    String msg = Recognizer.mres.DoubleMatchForLevel.str(this.aggTable.getName(), this.dbFactTable.getName(), aggColumn.getName(), aggUsage.relation.toString(), aggColumn.column.name, rel.toString(), cName);
                    this.msgRecorder.reportError(msg);
                    this.returnValue = false;
                    this.msgRecorder.throwRTException();
                }
            } else {
                RolapStar.Column rc;
                JdbcSchema.Table.Column.Usage aggUsage = aggColumn.newUsage(8);
                aggUsage.relation = hierarchyUsage.getJoinTable();
                aggUsage.joinExp = hierarchyUsage.getJoinExp();
                aggUsage.levelColumnName = levelColumnName;
                aggUsage.setSymbolicName(symbolicName);
                String tableAlias = null;
                if (aggUsage.joinExp instanceof MondrianDef.Column) {
                    MondrianDef.Column mcolumn = (MondrianDef.Column)aggUsage.joinExp;
                    tableAlias = mcolumn.table;
                } else {
                    tableAlias = aggUsage.relation.getAlias();
                }
                RolapStar.Table factTable = this.star.getFactTable();
                RolapStar.Table descTable = factTable.findDescendant(tableAlias);
                if (descTable == null) {
                    StringBuffer buf = new StringBuffer(256);
                    buf.append("descendant table is null for factTable=");
                    buf.append(factTable.getAlias());
                    buf.append(", tableAlias=");
                    buf.append(tableAlias);
                    this.msgRecorder.reportError(buf.toString());
                    this.returnValue = false;
                    this.msgRecorder.throwRTException();
                }
                if ((rc = descTable.lookupColumn(factColumnName)) == null) {
                    rc = this.lookupInChildren(descTable, factColumnName);
                }
                if (rc == null) {
                    StringBuffer buf = new StringBuffer(256);
                    buf.append("Rolap.Column not found (null) for tableAlias=");
                    buf.append(tableAlias);
                    buf.append(", factColumnName=");
                    buf.append(factColumnName);
                    buf.append(", levelColumnName=");
                    buf.append(levelColumnName);
                    buf.append(", symbolicName=");
                    buf.append(symbolicName);
                    this.msgRecorder.reportError(buf.toString());
                    this.returnValue = false;
                    this.msgRecorder.throwRTException();
                } else {
                    aggUsage.rColumn = rc;
                }
            }
        }
        finally {
            this.msgRecorder.popContextName();
        }
    }

    protected RolapStar.Column lookupInChildren(RolapStar.Table table, String factColumnName) {
        RolapStar.Table child;
        RolapStar.Column rc = null;
        Iterator it = table.getChildren().iterator();
        while (it.hasNext() && (rc = (child = (RolapStar.Table)it.next()).lookupColumn(factColumnName)) == null && (rc = this.lookupInChildren(child, factColumnName)) == null) {
        }
        return rc;
    }

    protected void checkUnusedColumns() {
        this.msgRecorder.pushContextName("Recognizer.checkUnusedColumns");
        Iterator it = this.aggTable.getColumns();
        while (it.hasNext()) {
            JdbcSchema.Table.Column aggColumn = (JdbcSchema.Table.Column)it.next();
            if (aggColumn.hasUsage()) continue;
            String msg = Recognizer.mres.AggUnknownColumn.str(this.aggTable.getName(), this.dbFactTable.getName(), aggColumn.getName());
            this.msgRecorder.reportWarning(msg);
        }
        this.msgRecorder.popContextName();
    }

    protected RolapAggregator convertAggregator(JdbcSchema.Table.Column.Usage aggUsage, RolapAggregator factAgg) {
        if (factAgg == RolapAggregator.Avg) {
            String columnExpr = this.getFactCountExpr(aggUsage);
            return new RolapAggregator.AvgFromSum(columnExpr);
        }
        if (factAgg == RolapAggregator.DistinctCount) {
            return RolapAggregator.DistinctCount;
        }
        return factAgg;
    }

    protected RolapAggregator convertAggregator(JdbcSchema.Table.Column.Usage aggUsage, RolapAggregator factAgg, RolapAggregator siblingAgg) {
        this.msgRecorder.pushContextName("Recognizer.convertAggregator");
        RolapAggregator rollupAgg = null;
        String columnExpr = this.getFactCountExpr(aggUsage);
        if (factAgg == RolapAggregator.Avg) {
            if (siblingAgg == RolapAggregator.Avg) {
                rollupAgg = new RolapAggregator.AvgFromAvg(columnExpr);
            } else if (siblingAgg == RolapAggregator.Sum) {
                rollupAgg = new RolapAggregator.AvgFromSum(columnExpr);
            }
        } else if (factAgg == RolapAggregator.Sum) {
            if (siblingAgg == RolapAggregator.Avg) {
                rollupAgg = new RolapAggregator.SumFromAvg(columnExpr);
            } else if (siblingAgg instanceof RolapAggregator.AvgFromAvg) {
                rollupAgg = new RolapAggregator.SumFromAvg(columnExpr);
            }
        }
        if (rollupAgg == null) {
            rollupAgg = (RolapAggregator)factAgg.getRollup();
        }
        if (rollupAgg == null) {
            String msg = Recognizer.mres.NoAggregatorFound.str(aggUsage.getSymbolicName(), factAgg.getName(), siblingAgg.getName());
            this.msgRecorder.reportError(msg);
        }
        this.msgRecorder.popContextName();
        return rollupAgg;
    }

    private String getFactCountExpr(JdbcSchema.Table.Column.Usage aggUsage) {
        JdbcSchema.Table aggTable = aggUsage.getColumn().getTable();
        Iterator it = aggTable.getColumnUsages(16);
        it.hasNext();
        JdbcSchema.Table.Column.Usage usage = (JdbcSchema.Table.Column.Usage)it.next();
        String factCountColumnName = usage.getColumn().getName();
        String tableName = aggTable.getName();
        MondrianDef.Column column = new MondrianDef.Column(tableName, factCountColumnName);
        SqlQuery sqlQuery = this.star.getSqlQuery();
        String columnExpr = column.getExpression(sqlQuery);
        return columnExpr;
    }

    protected Iterator findCubes() {
        String name = this.dbFactTable.getName();
        ArrayList<RolapCube> l = new ArrayList<RolapCube>();
        RolapSchema schema = this.star.getSchema();
        Iterator it = schema.getCubeIterator();
        while (it.hasNext()) {
            RolapStar cubeStar;
            String factTableName;
            RolapCube cube = (RolapCube)it.next();
            if (cube.isVirtual() || !name.equals(factTableName = (cubeStar = cube.getStar()).getFactTable().getAlias())) continue;
            l.add(cube);
        }
        return l.iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getColumnName(MondrianDef.Expression expr) {
        this.msgRecorder.pushContextName("Recognizer.getColumnName");
        try {
            if (expr instanceof MondrianDef.Column) {
                MondrianDef.Column column = (MondrianDef.Column)expr;
                String string = column.getColumnName();
                return string;
            }
            if (expr instanceof MondrianDef.KeyExpression) {
                MondrianDef.KeyExpression key = (MondrianDef.KeyExpression)expr;
                String string = key.toString();
                return string;
            }
            String msg = Recognizer.mres.NoColumnNameFromExpression.str(expr.toString());
            this.msgRecorder.reportError(msg);
            String string = null;
            return string;
        }
        finally {
            this.msgRecorder.popContextName();
        }
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        Class<?> clazz;
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            NoClassDefFoundError noClassDefFoundError = new NoClassDefFoundError(classNotFoundException.getMessage());
            try {
                noClassDefFoundError.initCause(classNotFoundException);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
            throw noClassDefFoundError;
        }
        return clazz;
    }

    public static interface Matcher {
        public boolean matches(String var1);
    }
}

