/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap.aggmatcher;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import mondrian.olap.Aggregator;
import mondrian.olap.MondrianDef;
import mondrian.olap.MondrianProperties;
import mondrian.recorder.MessageRecorder;
import mondrian.resource.MondrianResource;
import mondrian.rolap.BitKey;
import mondrian.rolap.RolapAggregator;
import mondrian.rolap.RolapStar;
import mondrian.rolap.RolapUtil;
import mondrian.rolap.aggmatcher.JdbcSchema;
import mondrian.rolap.sql.SqlQuery;
import org.apache.log4j.Logger;

public class AggStar {
    private static final Logger LOGGER = Logger.getLogger((Class)(class$mondrian$rolap$aggmatcher$AggStar == null ? (class$mondrian$rolap$aggmatcher$AggStar = AggStar.class$("mondrian.rolap.aggmatcher.AggStar")) : class$mondrian$rolap$aggmatcher$AggStar));
    private static final MondrianResource mres = MondrianResource.instance();
    private final RolapStar star;
    private final FactTable aggTable;
    private final BitKey bitKey;
    private final BitKey levelBitKey;
    private final BitKey measureBitKey;
    private final BitKey foreignKeyBitKey;
    private final BitKey distinctMeasureBitKey;
    private final Table.Column[] columns;
    private static final Logger JOIN_CONDITION_LOGGER = Logger.getLogger((Class)(class$mondrian$rolap$aggmatcher$AggStar$Table$JoinCondition == null ? (class$mondrian$rolap$aggmatcher$AggStar$Table$JoinCondition = AggStar.class$("mondrian.rolap.aggmatcher.AggStar$Table$JoinCondition")) : class$mondrian$rolap$aggmatcher$AggStar$Table$JoinCondition));
    private static final /* synthetic */ Class class$mondrian$rolap$aggmatcher$AggStar;
    private static final /* synthetic */ Class class$mondrian$rolap$aggmatcher$AggStar$Table$JoinCondition;

    static Logger getLogger() {
        return LOGGER;
    }

    public static AggStar makeAggStar(RolapStar star, JdbcSchema.Table dbTable, MessageRecorder msgRecorder) {
        JdbcSchema.Table.Column.Usage usage;
        AggStar aggStar = new AggStar(star, dbTable);
        FactTable aggStarFactTable = aggStar.getFactTable();
        Iterator it = dbTable.getColumnUsages(16);
        while (it.hasNext()) {
            usage = (JdbcSchema.Table.Column.Usage)it.next();
            FactTable.access$000(aggStarFactTable, usage);
        }
        it = dbTable.getColumnUsages(4);
        while (it.hasNext()) {
            usage = (JdbcSchema.Table.Column.Usage)it.next();
            FactTable.access$100(aggStarFactTable, usage);
        }
        it = dbTable.getColumnUsages(2);
        while (it.hasNext()) {
            usage = (JdbcSchema.Table.Column.Usage)it.next();
            FactTable.access$200(aggStarFactTable, usage);
        }
        it = dbTable.getColumnUsages(8);
        while (it.hasNext()) {
            usage = (JdbcSchema.Table.Column.Usage)it.next();
            FactTable.access$300(aggStarFactTable, usage);
        }
        for (int i = 0; i < FactTable.access$400(aggStarFactTable).size(); ++i) {
            FactTable.Measure measure = (FactTable.Measure)FactTable.access$400(aggStarFactTable).get(i);
            if (!FactTable.Measure.access$500(measure).isDistinct() || !(FactTable.Measure.access$600(measure) instanceof MondrianDef.Column)) continue;
            AggStar.setLevelBits(FactTable.Measure.access$700(measure), aggStarFactTable, (MondrianDef.Column)FactTable.Measure.access$600(measure), star.getFactTable());
        }
        return aggStar;
    }

    private static void setLevelBits(BitKey bitKey, Table aggTable, MondrianDef.Column column, RolapStar.Table table) {
        HashSet columns = new HashSet();
        RolapStar.collectColumns(columns, table, column);
        ArrayList levelList = new ArrayList();
        AggStar.collectLevels(levelList, aggTable, null);
        for (int i = 0; i < levelList.size(); ++i) {
            Table.Level level = (Table.Level)levelList.get(i);
            if (!columns.contains(Table.Level.access$800(level))) continue;
            bitKey.set(level.getBitPosition());
        }
    }

    private static void collectLevels(List levelList, Table table, MondrianDef.Column joinColumn) {
        if (joinColumn == null) {
            levelList.addAll(table.levels);
        }
        for (int i = 0; i < table.children.size(); ++i) {
            Table dimTable = (Table)table.children.get(i);
            if (joinColumn != null && !Table.JoinCondition.access$900(dimTable.getJoinCondition()).equals((Object)joinColumn)) continue;
            AggStar.collectLevels(levelList, dimTable, null);
        }
    }

    AggStar(RolapStar star, JdbcSchema.Table aggTable) {
        this.star = star;
        this.bitKey = BitKey.Factory.makeBitKey(star.getColumnCount());
        this.levelBitKey = this.bitKey.emptyCopy();
        this.measureBitKey = this.bitKey.emptyCopy();
        this.foreignKeyBitKey = this.bitKey.emptyCopy();
        this.distinctMeasureBitKey = this.bitKey.emptyCopy();
        this.aggTable = new FactTable(aggTable);
        this.columns = new Table.Column[star.getColumnCount()];
    }

    public FactTable getFactTable() {
        return this.aggTable;
    }

    public int getSize() {
        return MondrianProperties.instance().ChooseAggregateByVolume.get() ? this.getFactTable().getVolume() : this.getFactTable().getNumberOfRows();
    }

    void setForeignKey(int index) {
        this.foreignKeyBitKey.set(index);
    }

    public BitKey getForeignKeyBitKey() {
        return this.foreignKeyBitKey;
    }

    public boolean superSetMatch(BitKey bitKey) {
        return this.getBitKey().isSuperSetOf(bitKey);
    }

    public boolean select(BitKey levelBitKey, BitKey coreLevelBitKey, BitKey measureBitKey) {
        if (!this.getMeasureBitKey().isSuperSetOf(measureBitKey)) {
            return false;
        }
        if (this.getLevelBitKey().equals(levelBitKey)) {
            return true;
        }
        return this.getLevelBitKey().isSuperSetOf(levelBitKey) && this.getLevelBitKey().andNot(coreLevelBitKey).equals(levelBitKey.andNot(coreLevelBitKey));
    }

    public RolapStar getStar() {
        return this.star;
    }

    public boolean hasMeasures() {
        return this.getFactTable().hasMeasures();
    }

    public boolean hasLevels() {
        return this.getFactTable().hasLevels();
    }

    public boolean hasForeignKeys() {
        return this.getFactTable().hasChildren();
    }

    public BitKey getBitKey() {
        return this.bitKey;
    }

    public BitKey getLevelBitKey() {
        return this.levelBitKey;
    }

    public BitKey getMeasureBitKey() {
        return this.measureBitKey;
    }

    public BitKey getDistinctMeasureBitKey() {
        return this.distinctMeasureBitKey;
    }

    private SqlQuery getSqlQuery() {
        return this.getStar().getSqlQuery();
    }

    public Connection getJdbcConnection() {
        return this.getStar().getJdbcConnection();
    }

    public FactTable.Measure lookupMeasure(int bitPos) {
        Table.Column column = this.lookupColumn(bitPos);
        return column instanceof FactTable.Measure ? (FactTable.Measure)column : null;
    }

    public Table.Level lookupLevel(int bitPos) {
        Table.Column column = this.lookupColumn(bitPos);
        return column instanceof Table.Level ? (Table.Level)column : null;
    }

    public Table.Column lookupColumn(int bitPos) {
        return this.columns[bitPos];
    }

    private void addColumn(Table.Column column) {
        this.columns[column.getBitPosition()] = column;
    }

    public String toString() {
        StringWriter sw = new StringWriter(256);
        PrintWriter pw = new PrintWriter(sw);
        this.print(pw, "");
        pw.flush();
        return sw.toString();
    }

    public void print(PrintWriter pw, String prefix) {
        pw.print(prefix);
        pw.println("AggStar:");
        String subprefix = prefix + "  ";
        pw.print(subprefix);
        pw.print(" bk=");
        pw.println(this.bitKey);
        pw.print(subprefix);
        pw.print("fbk=");
        pw.println(this.levelBitKey);
        pw.print(subprefix);
        pw.print("mbk=");
        pw.println(this.measureBitKey);
        pw.print(subprefix);
        pw.print("has foreign key=");
        pw.println(this.aggTable.hasChildren());
        this.aggTable.print(pw, subprefix);
    }

    static Logger access$1000() {
        return JOIN_CONDITION_LOGGER;
    }

    static BitKey access$1100(AggStar x0) {
        return x0.bitKey;
    }

    static void access$1200(AggStar x0, Table.Column x1) {
        x0.addColumn(x1);
    }

    static SqlQuery access$1300(AggStar x0) {
        return x0.getSqlQuery();
    }

    static BitKey access$1400(AggStar x0) {
        return x0.levelBitKey;
    }

    static MondrianResource access$1500() {
        return mres;
    }

    static RolapStar access$1800(AggStar x0) {
        return x0.star;
    }

    static BitKey access$1900(AggStar x0) {
        return x0.measureBitKey;
    }

    static BitKey access$2200(AggStar x0) {
        return x0.distinctMeasureBitKey;
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        Class<?> clazz;
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            NoClassDefFoundError noClassDefFoundError = new NoClassDefFoundError(classNotFoundException.getMessage());
            try {
                noClassDefFoundError.initCause(classNotFoundException);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
            throw noClassDefFoundError;
        }
        return clazz;
    }

    static class 1 {
    }

    public class DimTable
    extends Table {
        private final Table parent;
        private final Table.JoinCondition joinCondition;

        DimTable(Table parent, String name, MondrianDef.Relation relation, Table.JoinCondition joinCondition) {
            super(name, relation);
            this.parent = parent;
            this.joinCondition = joinCondition;
        }

        public Table getParent() {
            return this.parent;
        }

        public boolean hasParent() {
            return true;
        }

        public boolean hasJoinCondition() {
            return true;
        }

        public Table.JoinCondition getJoinCondition() {
            return this.joinCondition;
        }

        public void addColumnsToList(List list) {
            list.addAll(this.levels);
            Iterator it = this.getChildTables().iterator();
            while (it.hasNext()) {
                DimTable dimTable = (DimTable)it.next();
                dimTable.addColumnsToList(list);
            }
        }

        public void print(PrintWriter pw, String prefix) {
            pw.print(prefix);
            pw.println("Table:");
            String subprefix = prefix + "  ";
            String subsubprefix = subprefix + "  ";
            pw.print(subprefix);
            pw.print("name=");
            pw.println(this.getName());
            if (this.getRelation() != null) {
                pw.print(subprefix);
                pw.print("relation=");
                pw.println((Object)this.getRelation());
            }
            pw.print(subprefix);
            pw.println("Levels:");
            Iterator it = this.getLevels().iterator();
            while (it.hasNext()) {
                Table.Level level = (Table.Level)it.next();
                level.print(pw, subsubprefix);
                pw.println();
            }
            this.joinCondition.print(pw, subprefix);
            it = this.getChildTables().iterator();
            while (it.hasNext()) {
                DimTable child = (DimTable)it.next();
                child.print(pw, subprefix);
            }
        }
    }

    public class FactTable
    extends Table {
        private Table.Column factCountColumn;
        private final List measures;
        private final int totalColumnSize;
        private int numberOfRows;

        FactTable(JdbcSchema.Table aggTable) {
            this(aggTable.getName(), aggTable.table, aggTable.getTotalColumnSize(), aggTable.getNumberOfRows());
        }

        FactTable(String name, MondrianDef.Relation relation, int totalColumnSize, int numberOfRows) {
            super(name, relation);
            this.totalColumnSize = totalColumnSize;
            this.measures = new ArrayList();
            this.numberOfRows = numberOfRows;
        }

        public Table getParent() {
            return null;
        }

        public boolean hasParent() {
            return false;
        }

        public boolean hasJoinCondition() {
            return false;
        }

        public Table.JoinCondition getJoinCondition() {
            return null;
        }

        public int getVolume() {
            return this.getTotalColumnSize() * this.getNumberOfRows();
        }

        public int getTotalColumnSize() {
            return this.totalColumnSize;
        }

        public int getNumberOfRows() {
            if (this.numberOfRows == -1) {
                this.makeNumberOfRows();
            }
            return this.numberOfRows;
        }

        void setNumberOfRows(int numberOfRows) {
            this.numberOfRows = numberOfRows;
        }

        public List getMeasures() {
            return this.measures;
        }

        public boolean hasMeasures() {
            return !this.measures.isEmpty();
        }

        public List getColumns() {
            ArrayList list = new ArrayList();
            list.addAll(this.measures);
            list.addAll(this.levels);
            Iterator it = this.getChildTables().iterator();
            while (it.hasNext()) {
                DimTable dimTable = (DimTable)it.next();
                dimTable.addColumnsToList(list);
            }
            return list;
        }

        private void loadForeignKey(JdbcSchema.Table.Column.Usage usage) {
            if (usage.rTable != null) {
                DimTable child = this.convertTable(usage.rTable, usage.rightJoinConditionColumnName);
                this.addTable(child);
            } else {
                JdbcSchema.Table.Column column = usage.getColumn();
                String name = column.getName();
                String symbolicName = usage.getSymbolicName();
                if (symbolicName == null) {
                    symbolicName = name;
                }
                MondrianDef.Column expression = new MondrianDef.Column(this.getName(), name);
                boolean isNumeric = column.isNumeric();
                RolapStar.Column rColumn = usage.rColumn;
                if (rColumn == null) {
                    String msg = "loadForeignKey: for column " + name + ", rColumn == null";
                    AggStar.getLogger().warn((Object)msg);
                } else {
                    int bitPosition = rColumn.getBitPosition();
                    Table.ForeignKey c = new Table.ForeignKey(symbolicName, expression, isNumeric, bitPosition, null);
                    this.getAggStar().setForeignKey(c.getBitPosition());
                }
            }
        }

        private void loadMeasure(JdbcSchema.Table.Column.Usage usage) {
            JdbcSchema.Table.Column column = usage.getColumn();
            String name = column.getName();
            String symbolicName = usage.getSymbolicName();
            if (symbolicName == null) {
                symbolicName = name;
            }
            boolean isNumeric = column.isNumeric();
            RolapAggregator aggregator = usage.getAggregator();
            MondrianDef.Expression expression = column.hasUsage(2) && !aggregator.isDistinct() ? this.factCountColumn.getExpression() : new MondrianDef.Column(this.getName(), name);
            MondrianDef.Expression argument = aggregator.isDistinct() ? usage.rMeasure.getExpression() : null;
            int bitPosition = usage.rMeasure.getBitPosition();
            Measure aggMeasure = new Measure(symbolicName, expression, isNumeric, bitPosition, aggregator, argument, null);
            this.measures.add(aggMeasure);
            if (Measure.access$500(aggMeasure).isDistinct()) {
                AggStar.access$2200(AggStar.this).set(bitPosition);
            }
        }

        private void loadFactCount(JdbcSchema.Table.Column.Usage usage) {
            Table.Column aggColumn;
            String name = usage.getColumn().getName();
            String symbolicName = usage.getSymbolicName();
            if (symbolicName == null) {
                symbolicName = name;
            }
            MondrianDef.Column expression = new MondrianDef.Column(this.getName(), name);
            boolean isNumeric = usage.getColumn().isNumeric();
            int bitPosition = -1;
            this.factCountColumn = aggColumn = new Table.Column(symbolicName, expression, isNumeric, bitPosition);
        }

        private void loadLevel(JdbcSchema.Table.Column.Usage usage) {
            String name = usage.getSymbolicName();
            MondrianDef.Column expression = new MondrianDef.Column(this.getName(), usage.levelColumnName);
            int bitPosition = usage.rColumn.getBitPosition();
            Table.Level level = new Table.Level(name, expression, bitPosition, usage.rColumn, null);
            this.addLevel(level);
        }

        public void print(PrintWriter pw, String prefix) {
            pw.print(prefix);
            pw.println("Table:");
            String subprefix = prefix + "  ";
            String subsubprefix = subprefix + "  ";
            pw.print(subprefix);
            pw.print("name=");
            pw.println(this.getName());
            if (this.getRelation() != null) {
                pw.print(subprefix);
                pw.print("relation=");
                pw.println((Object)this.getRelation());
            }
            pw.print(subprefix);
            pw.print("numberofrows=");
            pw.println(this.getNumberOfRows());
            pw.print(subprefix);
            pw.println("FactCount:");
            this.factCountColumn.print(pw, subsubprefix);
            pw.println();
            pw.print(subprefix);
            pw.println("Measures:");
            Iterator it = this.getMeasures().iterator();
            while (it.hasNext()) {
                Table.Column column = (Table.Column)it.next();
                column.print(pw, subsubprefix);
                pw.println();
            }
            pw.print(subprefix);
            pw.println("Levels:");
            it = this.getLevels().iterator();
            while (it.hasNext()) {
                Table.Level level = (Table.Level)it.next();
                level.print(pw, subsubprefix);
                pw.println();
            }
            it = this.getChildTables().iterator();
            while (it.hasNext()) {
                DimTable child = (DimTable)it.next();
                child.print(pw, subprefix);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void makeNumberOfRows() {
            SqlQuery query = this.getSqlQuery();
            query.addSelect("count(*)");
            query.addFrom(this.getRelation(), this.getName(), false);
            Connection conn = this.getJdbcConnection();
            try {
                ResultSet rs = null;
                try {
                    rs = RolapUtil.executeQuery(conn, query.toString(), "AggStar.FactTable.makeNumberOfRows");
                    if (rs.next()) {
                        this.numberOfRows = rs.getInt(1);
                    } else {
                        String msg = AggStar.access$1500().SqlQueryFailed.str("AggStar.FactTable.makeNumberOfRows", query.toString());
                        AggStar.getLogger().warn((Object)msg);
                        this.numberOfRows = Integer.MAX_VALUE / this.getTotalColumnSize();
                    }
                }
                finally {
                    if (rs != null) {
                        rs.close();
                    }
                }
            }
            catch (SQLException ex) {
                AggStar.getLogger().error((Object)ex);
            }
            finally {
                try {
                    conn.close();
                }
                catch (SQLException sQLException) {}
            }
        }

        static void access$000(FactTable x0, JdbcSchema.Table.Column.Usage x1) {
            x0.loadFactCount(x1);
        }

        static void access$100(FactTable x0, JdbcSchema.Table.Column.Usage x1) {
            x0.loadMeasure(x1);
        }

        static void access$200(FactTable x0, JdbcSchema.Table.Column.Usage x1) {
            x0.loadForeignKey(x1);
        }

        static void access$300(FactTable x0, JdbcSchema.Table.Column.Usage x1) {
            x0.loadLevel(x1);
        }

        static List access$400(FactTable x0) {
            return x0.measures;
        }

        public class Measure
        extends Table.Column {
            private final RolapAggregator aggregator;
            private final MondrianDef.Expression argument;
            private final BitKey rollableLevelBitKey;
            static final /* synthetic */ boolean $assertionsDisabled;
            private static final /* synthetic */ Class class$mondrian$rolap$aggmatcher$AggStar;

            private Measure(String name, MondrianDef.Expression expression, boolean isNumeric, int bitPosition, RolapAggregator aggregator, MondrianDef.Expression argument) {
                super(name, expression, isNumeric, bitPosition);
                this.aggregator = aggregator;
                this.argument = argument;
                if (!$assertionsDisabled && argument != null != aggregator.isDistinct()) {
                    throw new AssertionError();
                }
                this.rollableLevelBitKey = BitKey.Factory.makeBitKey(AggStar.access$1800(AggStar.this).getColumnCount());
                AggStar.access$1900(AggStar.this).set(bitPosition);
            }

            public boolean isDistinct() {
                return this.aggregator.isDistinct();
            }

            public RolapAggregator getAggregator() {
                return this.aggregator;
            }

            public BitKey getRollableLevelBitKey() {
                return this.rollableLevelBitKey;
            }

            public String generateRollupString(SqlQuery query) {
                String expr = this.generateExprString(query);
                Aggregator rollup = null;
                BitKey fkbk = AggStar.this.getForeignKeyBitKey();
                rollup = fkbk.get(this.getBitPosition()) ? (this.getAggregator().isDistinct() ? this.getAggregator().getNonDistinctAggregator() : this.getAggregator().getRollup()) : this.getAggregator().getRollup();
                String s = ((RolapAggregator)rollup).getExpression(expr);
                return s;
            }

            public void print(PrintWriter pw, String prefix) {
                SqlQuery sqlQuery = this.getSqlQuery();
                pw.print(prefix);
                pw.print(this.getName());
                pw.print(" (");
                pw.print(this.getBitPosition());
                pw.print("): ");
                pw.print(this.generateRollupString(sqlQuery));
            }

            static RolapAggregator access$500(Measure x0) {
                return x0.aggregator;
            }

            static MondrianDef.Expression access$600(Measure x0) {
                return x0.argument;
            }

            static BitKey access$700(Measure x0) {
                return x0.rollableLevelBitKey;
            }

            Measure(String x1, MondrianDef.Expression x2, boolean x3, int x4, RolapAggregator x5, MondrianDef.Expression x6, 1 x7) {
                this(x1, x2, x3, x4, x5, x6);
            }

            static {
                $assertionsDisabled = !(class$mondrian$rolap$aggmatcher$AggStar == null ? (class$mondrian$rolap$aggmatcher$AggStar = Measure.class$("mondrian.rolap.aggmatcher.AggStar")) : class$mondrian$rolap$aggmatcher$AggStar).desiredAssertionStatus();
            }

            static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
                Class<?> clazz;
                try {
                    clazz = Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    NoClassDefFoundError noClassDefFoundError = new NoClassDefFoundError(classNotFoundException.getMessage());
                    try {
                        noClassDefFoundError.initCause(classNotFoundException);
                    }
                    catch (NoSuchMethodError noSuchMethodError) {
                        // empty catch block
                    }
                    throw noClassDefFoundError;
                }
                return clazz;
            }
        }
    }

    public abstract class Table {
        private final String name;
        private final MondrianDef.Relation relation;
        protected final List levels = new ArrayList();
        protected List children;

        Table(String name, MondrianDef.Relation relation) {
            this.name = name;
            this.relation = relation;
            this.children = Collections.EMPTY_LIST;
        }

        public String getName() {
            return this.name;
        }

        public abstract boolean hasParent();

        public abstract Table getParent();

        public abstract boolean hasJoinCondition();

        public abstract JoinCondition getJoinCondition();

        public MondrianDef.Relation getRelation() {
            return this.relation;
        }

        protected AggStar getAggStar() {
            return AggStar.this;
        }

        protected SqlQuery getSqlQuery() {
            return AggStar.access$1300(this.getAggStar());
        }

        public Connection getJdbcConnection() {
            return this.getAggStar().getJdbcConnection();
        }

        protected void addLevel(Level level) {
            this.levels.add(level);
        }

        public List getLevels() {
            return this.levels;
        }

        public boolean hasLevels() {
            return !this.levels.isEmpty();
        }

        protected void addTable(DimTable child) {
            if (this.children == Collections.EMPTY_LIST) {
                this.children = new ArrayList();
            }
            this.children.add(child);
        }

        public List getChildTables() {
            return this.children;
        }

        public boolean hasChildren() {
            return !this.children.isEmpty();
        }

        protected DimTable convertTable(RolapStar.Table rTable, String rightJoinConditionColumnName) {
            String tableName = rTable.getAlias();
            MondrianDef.Relation relation = rTable.getRelation();
            RolapStar.Condition rjoinCondition = rTable.getJoinCondition();
            MondrianDef.Expression rleft = rjoinCondition.getLeft();
            MondrianDef.Expression rright = rjoinCondition.getRight();
            MondrianDef.Column left = null;
            if (rightJoinConditionColumnName != null) {
                left = new MondrianDef.Column(this.getName(), rightJoinConditionColumnName);
            } else if (rleft instanceof MondrianDef.Column) {
                MondrianDef.Column lcolumn = (MondrianDef.Column)rleft;
                left = new MondrianDef.Column(this.getName(), lcolumn.name);
            } else {
                String msg = AggStar.access$1500().BadRolapStarLeftJoinCondition.str("AggStar.Table", ((Object)((Object)rleft)).getClass().getName(), left.toString());
                AggStar.getLogger().warn((Object)msg);
            }
            RolapStar.Column col = this.getAggStar().getStar().getFactTable().lookupColumn(left.name);
            if (col != null) {
                this.getAggStar().setForeignKey(col.getBitPosition());
            }
            JoinCondition joinCondition = new JoinCondition(left, rright, null);
            DimTable dimTable = new DimTable(this, tableName, relation, joinCondition);
            dimTable.convertColumns(rTable);
            dimTable.convertChildren(rTable);
            return dimTable;
        }

        protected void convertColumns(RolapStar.Table rTable) {
            Iterator it = rTable.getColumns().iterator();
            while (it.hasNext()) {
                RolapStar.Column column = (RolapStar.Column)it.next();
                String name = column.getName();
                MondrianDef.Expression expression = column.getExpression();
                int bitPosition = column.getBitPosition();
                Level level = new Level(name, expression, bitPosition, column, null);
                this.addLevel(level);
            }
        }

        protected void convertChildren(RolapStar.Table rTable) {
            Iterator it = rTable.getChildren().iterator();
            while (it.hasNext()) {
                RolapStar.Table rTableChild = (RolapStar.Table)it.next();
                DimTable dimChild = this.convertTable(rTableChild, null);
                this.addTable(dimChild);
            }
        }

        public void addToFrom(SqlQuery query, boolean failIfExists, boolean joinToParent) {
            query.addFrom(this.relation, this.name, failIfExists);
            if (joinToParent) {
                if (this.hasParent()) {
                    this.getParent().addToFrom(query, failIfExists, joinToParent);
                }
                if (this.hasJoinCondition()) {
                    query.addWhere(this.getJoinCondition().toString(query));
                }
            }
        }

        public String toString() {
            StringWriter sw = new StringWriter(256);
            PrintWriter pw = new PrintWriter(sw);
            this.print(pw, "");
            pw.flush();
            return sw.toString();
        }

        public abstract void print(PrintWriter var1, String var2);

        final class Level
        extends Column {
            private final RolapStar.Column starColumn;

            private Level(String name, MondrianDef.Expression expression, int bitPosition, RolapStar.Column starColumn) {
                super(name, expression, starColumn.isNumeric(), bitPosition);
                this.starColumn = starColumn;
                AggStar.access$1400(AggStar.this).set(bitPosition);
            }

            static RolapStar.Column access$800(Level x0) {
                return x0.starColumn;
            }

            Level(String x1, MondrianDef.Expression x2, int x3, RolapStar.Column x4, 1 x5) {
                this(x1, x2, x3, x4);
            }
        }

        final class ForeignKey
        extends Column {
            private ForeignKey(String name, MondrianDef.Expression expression, boolean isNumeric, int bitPosition) {
                super(name, expression, isNumeric, bitPosition);
                AggStar.access$1400(AggStar.this).set(bitPosition);
            }

            ForeignKey(String x1, MondrianDef.Expression x2, boolean x3, int x4, 1 x5) {
                this(x1, x2, x3, x4);
            }
        }

        public class Column {
            private final String name;
            private final MondrianDef.Expression expression;
            private final boolean isNumeric;
            private final Column nameColumn;
            private final int bitPosition;

            protected Column(String name, MondrianDef.Expression expression, boolean isNumeric, int bitPosition) {
                this.name = name;
                this.expression = expression;
                this.isNumeric = isNumeric;
                this.bitPosition = bitPosition;
                this.nameColumn = null;
                if (bitPosition >= 0) {
                    AggStar.access$1100(AggStar.this).set(bitPosition);
                    AggStar.access$1200(AggStar.this, this);
                }
            }

            public String getName() {
                return this.name;
            }

            public Table getTable() {
                return Table.this;
            }

            public int getBitPosition() {
                return this.bitPosition;
            }

            public boolean isNumeric() {
                return this.isNumeric;
            }

            public SqlQuery getSqlQuery() {
                return AggStar.access$1300(this.getTable().getAggStar());
            }

            public MondrianDef.Expression getExpression() {
                return this.expression;
            }

            public String generateExprString(SqlQuery query) {
                return this.getExpression().getExpression(query);
            }

            public String toString() {
                StringWriter sw = new StringWriter(256);
                PrintWriter pw = new PrintWriter(sw);
                this.print(pw, "");
                pw.flush();
                return sw.toString();
            }

            public void print(PrintWriter pw, String prefix) {
                SqlQuery sqlQuery = this.getSqlQuery();
                pw.print(prefix);
                pw.print(this.getName());
                pw.print(" (");
                pw.print(this.getBitPosition());
                pw.print("): ");
                pw.print(this.generateExprString(sqlQuery));
            }
        }

        public class JoinCondition {
            private final MondrianDef.Expression left;
            private final MondrianDef.Expression right;

            private JoinCondition(MondrianDef.Expression left, MondrianDef.Expression right) {
                if (!(left instanceof MondrianDef.Column)) {
                    AggStar.access$1000().debug((Object)("JoinCondition.left NOT Column: " + ((Object)((Object)left)).getClass().getName()));
                }
                this.left = left;
                this.right = right;
            }

            public Table getTable() {
                return Table.this;
            }

            String toString(SqlQuery query) {
                StringBuffer buf = new StringBuffer(64);
                buf.append(this.left.getExpression(query));
                buf.append(" = ");
                buf.append(this.right.getExpression(query));
                return buf.toString();
            }

            public String toString() {
                StringWriter sw = new StringWriter(128);
                PrintWriter pw = new PrintWriter(sw);
                this.print(pw, "");
                pw.flush();
                return sw.toString();
            }

            public void print(PrintWriter pw, String prefix) {
                SqlQuery sqlQueuy = this.getTable().getSqlQuery();
                pw.print(prefix);
                pw.println("JoinCondition:");
                String subprefix = prefix + "  ";
                pw.print(subprefix);
                pw.print("left=");
                if (this.left instanceof MondrianDef.Column) {
                    MondrianDef.Column c = (MondrianDef.Column)this.left;
                    RolapStar.Column col = this.getTable().getAggStar().getStar().getFactTable().lookupColumn(c.name);
                    if (col != null) {
                        pw.print(" (");
                        pw.print(col.getBitPosition());
                        pw.print(") ");
                    }
                }
                pw.println(this.left.getExpression(sqlQueuy));
                pw.print(subprefix);
                pw.print("right=");
                pw.println(this.right.getExpression(sqlQueuy));
            }

            static MondrianDef.Expression access$900(JoinCondition x0) {
                return x0.left;
            }

            JoinCondition(MondrianDef.Expression x1, MondrianDef.Expression x2, 1 x3) {
                this(x1, x2);
            }
        }
    }
}

