/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap.aggmatcher;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mondrian.olap.MondrianDef;
import mondrian.olap.Util;
import mondrian.rolap.RolapAggregator;
import mondrian.rolap.RolapStar;
import mondrian.rolap.aggmatcher.JdbcSchema;
import mondrian.rolap.sql.SqlQuery;
import org.apache.log4j.Logger;

public class AggGen {
    private static final Logger LOGGER = Logger.getLogger((Class)(class$mondrian$rolap$aggmatcher$AggGen == null ? (class$mondrian$rolap$aggmatcher$AggGen = AggGen.class$("mondrian.rolap.aggmatcher.AggGen")) : class$mondrian$rolap$aggmatcher$AggGen));
    private final RolapStar star;
    private final RolapStar.Column[] columns;
    private final Map collapsedColumnUsages;
    private final Set notLostColumnUsages;
    private final List measures;
    private boolean isReady;
    private static final String AGG_LOST_PREFIX = "agg_l_XXX_";
    private static final String AGG_COLLAPSED_PREFIX = "agg_c_XXX_";
    private static final /* synthetic */ Class class$mondrian$rolap$aggmatcher$AggGen;

    public AggGen(RolapStar star, RolapStar.Column[] columns) {
        this.star = star;
        this.columns = columns;
        this.notLostColumnUsages = new HashSet();
        this.collapsedColumnUsages = new HashMap();
        this.measures = new ArrayList();
        this.init();
    }

    private Logger getLogger() {
        return LOGGER;
    }

    public boolean isReady() {
        return this.isReady;
    }

    protected RolapStar.Table getFactTable() {
        return this.star.getFactTable();
    }

    protected String getFactTableName() {
        return this.getFactTable().getAlias();
    }

    protected SqlQuery getSqlQuery() {
        return this.star.getSqlQuery();
    }

    protected String getFactCount() {
        return "fact_count";
    }

    protected JdbcSchema.Table getTable(JdbcSchema db, RolapStar.Table rt) {
        JdbcSchema.Table jt = this.getTable(db, rt.getAlias());
        return jt == null ? this.getTable(db, rt.getTableName()) : jt;
    }

    protected JdbcSchema.Table getTable(JdbcSchema db, String name) {
        return db.getTable(name);
    }

    protected JdbcSchema.Table.Column getColumn(JdbcSchema.Table table, String name) {
        return table.getColumn(name);
    }

    protected String getRolapStarColumnName(RolapStar.Column rColumn) {
        MondrianDef.Expression expr = rColumn.getExpression();
        if (expr instanceof MondrianDef.Column) {
            MondrianDef.Column cx = (MondrianDef.Column)expr;
            String name = cx.getColumnName();
            return name;
        }
        return null;
    }

    protected void addForeignKeyToNotLostColumnUsages(JdbcSchema.Table.Column column) {
        String cname = column.getName();
        Iterator it = this.notLostColumnUsages.iterator();
        while (it.hasNext()) {
            JdbcSchema.Table.Column.Usage usage = (JdbcSchema.Table.Column.Usage)it.next();
            JdbcSchema.Table.Column c = usage.getColumn();
            if (!cname.equals(c.getName())) continue;
            return;
        }
        JdbcSchema.Table.Column.Usage usage = null;
        if (column.hasUsage(2)) {
            Iterator it2 = column.getUsages(2);
            it2.hasNext();
            usage = (JdbcSchema.Table.Column.Usage)it2.next();
        } else {
            usage = column.newUsage(2);
            usage.setSymbolicName("FOREIGN_KEY");
        }
        this.notLostColumnUsages.add(usage);
    }

    private void init() {
        JdbcSchema db = JdbcSchema.makeDB(this.star.getDataSource());
        try {
            db.load();
        }
        catch (SQLException ex) {
            this.getLogger().error((Object)ex);
            return;
        }
        JdbcSchema.Table factTable = this.getTable(db, this.getFactTableName());
        if (factTable == null) {
            StringBuffer buf = new StringBuffer(64);
            buf.append("Init: ");
            buf.append("No fact table with name \"");
            buf.append(this.getFactTableName());
            buf.append("\"");
            this.getLogger().warn((Object)buf.toString());
            return;
        }
        try {
            factTable.load();
        }
        catch (SQLException ex) {
            this.getLogger().error((Object)ex);
            return;
        }
        if (this.getLogger().isDebugEnabled()) {
            StringBuffer buf = new StringBuffer(512);
            buf.append("Init: ");
            buf.append("RolapStar:");
            buf.append(Util.nl);
            buf.append(this.getFactTable());
            buf.append(Util.nl);
            buf.append("FactTable:");
            buf.append(Util.nl);
            buf.append(factTable);
            this.getLogger().debug((Object)buf.toString());
        }
        for (int i = 0; i < this.columns.length; ++i) {
            MondrianDef.Expression left;
            RolapStar.Table table;
            RolapStar.Column column = this.columns[i];
            if (this.getLogger().isDebugEnabled()) {
                StringBuffer buf = new StringBuffer(64);
                buf.append("Init: ");
                buf.append("Column: ");
                buf.append(column);
                this.getLogger().debug((Object)buf.toString());
            }
            if ((table = column.getTable()).getParentTable() == null) {
                if (!this.addSpecialCollapsedColumn(db, column)) {
                    return;
                }
                MondrianDef.Expression expr = column.getExpression();
                if (!(expr instanceof MondrianDef.Column)) continue;
                MondrianDef.Column exprColumn = (MondrianDef.Column)expr;
                String name = exprColumn.getColumnName();
                JdbcSchema.Table.Column c = this.getColumn(factTable, name);
                if (c == null) {
                    StringBuffer buf = new StringBuffer(64);
                    buf.append("Init: ");
                    buf.append("FactTable:");
                    buf.append(this.getFactTableName());
                    buf.append(Util.nl);
                    buf.append("No Column with name \"");
                    buf.append(name);
                    buf.append("\"");
                    this.getLogger().warn((Object)buf.toString());
                    return;
                }
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug((Object)("  Jdbc Column: c=" + c));
                }
                this.addForeignKeyToNotLostColumnUsages(c);
                continue;
            }
            if (!this.addCollapsedColumn(db, column)) {
                return;
            }
            while (table.getParentTable().getParentTable() != null) {
                table = table.getParentTable();
            }
            RolapStar.Condition cond = table.getJoinCondition();
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)("  RolapStar.Condition: cond=" + cond));
            }
            if (!((left = cond.getLeft()) instanceof MondrianDef.Column)) continue;
            MondrianDef.Column leftColumn = (MondrianDef.Column)left;
            String name = leftColumn.getColumnName();
            JdbcSchema.Table.Column c = this.getColumn(factTable, name);
            if (c == null) {
                StringBuffer buf = new StringBuffer(64);
                buf.append("Init: ");
                buf.append("FactTable:");
                buf.append(this.getFactTableName());
                buf.append(Util.nl);
                buf.append("No Column with name \"");
                buf.append(name);
                buf.append("\"");
                this.getLogger().warn((Object)buf.toString());
                return;
            }
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)("  Jdbc Column: c=" + c));
            }
            this.addForeignKeyToNotLostColumnUsages(c);
        }
        Iterator it = this.getFactTable().getColumns().iterator();
        while (it.hasNext()) {
            RolapStar.Column rColumn = (RolapStar.Column)it.next();
            String name = this.getRolapStarColumnName(rColumn);
            if (name == null) {
                StringBuffer buf = new StringBuffer(64);
                buf.append("Init: ");
                buf.append("For fact table \"");
                buf.append(this.getFactTableName());
                buf.append("\", could not get column name for RolapStar.Column: ");
                buf.append(rColumn);
                this.getLogger().warn((Object)buf.toString());
                return;
            }
            RolapAggregator aggregator = null;
            Object symbolicName = null;
            if (!(rColumn instanceof RolapStar.Measure)) {
                this.getLogger().warn((Object)("not a measure: " + name));
                continue;
            }
            RolapStar.Measure rMeasure = (RolapStar.Measure)rColumn;
            aggregator = rMeasure.getAggregator();
            JdbcSchema.Table.Column c = this.getColumn(factTable, name);
            if (c == null) {
                StringBuffer buf = new StringBuffer(64);
                buf.append("For RolapStar: \"");
                buf.append(this.getFactTable().getAlias());
                buf.append("\" measure with name, ");
                buf.append(name);
                buf.append(", is not a column name. ");
                buf.append("The measure's column name may be an expression");
                buf.append(" and currently AggGen does not handle expressions.");
                buf.append(" You will have to add this measure to the");
                buf.append(" aggregate table definition by hand.");
                this.getLogger().warn((Object)buf.toString());
                continue;
            }
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)("  Jdbc Column m=" + c));
            }
            JdbcSchema.Table.Column.Usage usage = null;
            if (c.hasUsage(4)) {
                Iterator uit = c.getUsages(4);
                while (uit.hasNext()) {
                    JdbcSchema.Table.Column.Usage tmpUsage = (JdbcSchema.Table.Column.Usage)uit.next();
                    if (tmpUsage.getAggregator() != aggregator || !tmpUsage.getSymbolicName().equals(rColumn.getName())) continue;
                    usage = tmpUsage;
                    break;
                }
            }
            if (usage == null) {
                usage = c.newUsage(4);
                usage.setAggregator(aggregator);
                usage.setSymbolicName(rColumn.getName());
            }
            this.measures.add(usage);
        }
        this.isReady = true;
    }

    private boolean addSpecialCollapsedColumn(JdbcSchema db, RolapStar.Column rColumn) {
        JdbcSchema.Table.Column c;
        String rname = this.getRolapStarColumnName(rColumn);
        if (rname == null) {
            StringBuffer buf = new StringBuffer(64);
            buf.append("Adding Special Collapsed Column: ");
            buf.append("For fact table \"");
            buf.append(this.getFactTableName());
            buf.append("\", could not get column name for RolapStar.Column: ");
            buf.append(rColumn);
            this.getLogger().warn((Object)buf.toString());
            return false;
        }
        RolapStar.Table rt = rColumn.getTable();
        JdbcSchema.Table jt = this.getTable(db, rt);
        if (jt == null) {
            StringBuffer buf = new StringBuffer(64);
            buf.append("Adding Special Collapsed Column: ");
            buf.append("For fact table \"");
            buf.append(this.getFactTableName());
            buf.append("\", could not get jdbc schema table ");
            buf.append("for RolapStar.Table with alias \"");
            buf.append(rt.getAlias());
            buf.append("\"");
            this.getLogger().warn((Object)buf.toString());
            return false;
        }
        try {
            jt.load();
        }
        catch (SQLException ex) {
            this.getLogger().error((Object)ex);
            return false;
        }
        ArrayList<JdbcSchema.Table.Column.Usage> list = (ArrayList<JdbcSchema.Table.Column.Usage>)this.collapsedColumnUsages.get(rt);
        if (list == null) {
            list = new ArrayList<JdbcSchema.Table.Column.Usage>();
            this.collapsedColumnUsages.put(rt, list);
        }
        if ((c = this.getColumn(jt, rname)) == null) {
            StringBuffer buf = new StringBuffer(64);
            buf.append("Adding Special Collapsed Column: ");
            buf.append("For fact table \"");
            buf.append(this.getFactTableName());
            buf.append("\", could not get jdbc schema column ");
            buf.append("for RolapStar.Table with alias \"");
            buf.append(rt.getAlias());
            buf.append("\" and column name \"");
            buf.append(rname);
            buf.append("\"");
            this.getLogger().warn((Object)buf.toString());
            return false;
        }
        list.add(c.newUsage(2));
        RolapStar.Column prColumn = rColumn;
        while (prColumn.getParentColumn() != null) {
            rname = this.getRolapStarColumnName(prColumn = prColumn.getParentColumn());
            if (rname == null) {
                StringBuffer buf = new StringBuffer(64);
                buf.append("Adding Special Collapsed Column: ");
                buf.append("For fact table \"");
                buf.append(this.getFactTableName());
                buf.append("\", could not get parent column name");
                buf.append("for RolapStar.Column \"");
                buf.append(rname);
                buf.append("\" for RolapStar.Table with alias \"");
                buf.append(rt.getAlias());
                buf.append("\"");
                this.getLogger().warn((Object)buf.toString());
                return false;
            }
            c = this.getColumn(jt, rname);
            if (c == null) {
                this.getLogger().warn((Object)("Can not find column: " + rname));
                break;
            }
            list.add(c.newUsage(2));
        }
        return true;
    }

    private boolean addCollapsedColumn(JdbcSchema db, RolapStar.Column rColumn) {
        List l;
        String rname = this.getRolapStarColumnName(rColumn);
        if (rname == null) {
            StringBuffer buf = new StringBuffer(64);
            buf.append("Adding Collapsed Column: ");
            buf.append("For fact table \"");
            buf.append(this.getFactTableName());
            buf.append("\", could not get column name for RolapStar.Column: ");
            buf.append(rColumn);
            this.getLogger().warn((Object)buf.toString());
            return false;
        }
        RolapStar.Table rt = rColumn.getTable();
        JdbcSchema.Table jt = this.getTable(db, rt);
        if (jt == null) {
            StringBuffer buf = new StringBuffer(64);
            buf.append("Adding Collapsed Column: ");
            buf.append("For fact table \"");
            buf.append(this.getFactTableName());
            buf.append("\", could not get jdbc schema table ");
            buf.append("for RolapStar.Table with alias \"");
            buf.append(rt.getAlias());
            buf.append("\"");
            this.getLogger().warn((Object)buf.toString());
            return false;
        }
        try {
            jt.load();
        }
        catch (SQLException ex) {
            this.getLogger().error((Object)ex);
            return false;
        }
        try {
            jt.load();
        }
        catch (SQLException sqle) {
            this.getLogger().error((Object)sqle);
            return false;
        }
        ArrayList<JdbcSchema.Table.Column.Usage> list = new ArrayList<JdbcSchema.Table.Column.Usage>();
        Iterator it = rt.getColumns().iterator();
        while (it.hasNext()) {
            RolapStar.Column rc = (RolapStar.Column)it.next();
            if (rc.isNameColumn()) continue;
            String name = this.getRolapStarColumnName(rc);
            if (name == null) {
                StringBuffer buf = new StringBuffer(64);
                buf.append("Adding Collapsed Column: ");
                buf.append("For fact table \"");
                buf.append(this.getFactTableName());
                buf.append("\", could not get column name");
                buf.append(" for RolapStar.Column \"");
                buf.append(rc);
                buf.append("\" for RolapStar.Table with alias \"");
                buf.append(rt.getAlias());
                buf.append("\"");
                this.getLogger().warn((Object)buf.toString());
                return false;
            }
            JdbcSchema.Table.Column c = this.getColumn(jt, name);
            if (c == null) {
                this.getLogger().warn((Object)("Can not find column: " + name));
                break;
            }
            JdbcSchema.Table.Column.Usage usage = c.newUsage(2);
            usage.usagePrefix = rc.getUsagePrefix();
            list.add(usage);
            if (!rname.equals(name)) continue;
            break;
        }
        if ((l = (List)this.collapsedColumnUsages.get(rt)) == null || l.size() < list.size()) {
            this.collapsedColumnUsages.put(rt, list);
        }
        return true;
    }

    String makeLostAggregateTableName(String factTableName) {
        StringBuffer buf = new StringBuffer(64);
        buf.append(AGG_LOST_PREFIX);
        buf.append(factTableName);
        return buf.toString();
    }

    String makeCollapsedAggregateTableName(String factTableName) {
        StringBuffer buf = new StringBuffer(64);
        buf.append(AGG_COLLAPSED_PREFIX);
        buf.append(factTableName);
        return buf.toString();
    }

    public String createLost() {
        JdbcSchema.Table.Column.Usage usage;
        StringWriter sw = new StringWriter(512);
        PrintWriter pw = new PrintWriter(sw);
        String prefix = "    ";
        String factTableName = this.getFactTableName();
        pw.print("CREATE TABLE ");
        pw.print(this.makeLostAggregateTableName(this.getFactTableName()));
        pw.println(" (");
        Iterator it = this.notLostColumnUsages.iterator();
        while (it.hasNext()) {
            usage = (JdbcSchema.Table.Column.Usage)it.next();
            this.addColumnCreate(pw, prefix, usage);
        }
        it = this.measures.iterator();
        while (it.hasNext()) {
            usage = (JdbcSchema.Table.Column.Usage)it.next();
            this.addColumnCreate(pw, prefix, usage);
        }
        pw.print(prefix);
        pw.print(this.getFactCount());
        pw.println(" INTEGER NOT NULL");
        pw.println(");");
        return sw.toString();
    }

    public String insertIntoLost() {
        JdbcSchema.Table.Column c;
        JdbcSchema.Table.Column.Usage usage;
        StringWriter sw = new StringWriter(512);
        PrintWriter pw = new PrintWriter(sw);
        String prefix = "    ";
        String factTableName = this.getFactTableName();
        SqlQuery sqlQuery = this.getSqlQuery();
        pw.print("INSERT INTO ");
        pw.print(this.makeLostAggregateTableName(this.getFactTableName()));
        pw.println(" (");
        Iterator it = this.notLostColumnUsages.iterator();
        while (it.hasNext()) {
            usage = (JdbcSchema.Table.Column.Usage)it.next();
            c = usage.getColumn();
            pw.print(prefix);
            pw.print(c.getName());
            pw.println(',');
        }
        it = this.measures.iterator();
        while (it.hasNext()) {
            usage = (JdbcSchema.Table.Column.Usage)it.next();
            c = usage.getColumn();
            pw.print(prefix);
            String name = this.getUsageName(usage);
            pw.print(name);
            pw.println(',');
        }
        pw.print(prefix);
        pw.print(this.getFactCount());
        pw.println(")");
        pw.println("SELECT");
        it = this.notLostColumnUsages.iterator();
        while (it.hasNext()) {
            usage = (JdbcSchema.Table.Column.Usage)it.next();
            c = usage.getColumn();
            pw.print(prefix);
            pw.print(sqlQuery.getDialect().quoteIdentifier(factTableName, c.getName()));
            pw.print(" AS ");
            pw.print(sqlQuery.getDialect().quoteIdentifier(c.getName()));
            pw.println(',');
        }
        it = this.measures.iterator();
        while (it.hasNext()) {
            usage = (JdbcSchema.Table.Column.Usage)it.next();
            c = usage.getColumn();
            RolapAggregator agg = usage.getAggregator();
            pw.print(prefix);
            pw.print(agg.getExpression(sqlQuery.getDialect().quoteIdentifier(factTableName, c.getName())).toUpperCase());
            pw.print(" AS ");
            pw.print(sqlQuery.getDialect().quoteIdentifier(c.getName()));
            pw.println(',');
        }
        pw.print(prefix);
        pw.print("COUNT(*) AS ");
        pw.println(sqlQuery.getDialect().quoteIdentifier(this.getFactCount()));
        pw.println("FROM ");
        pw.print(prefix);
        pw.print(sqlQuery.getDialect().quoteIdentifier(factTableName));
        pw.print(" ");
        pw.println(sqlQuery.getDialect().quoteIdentifier(factTableName));
        pw.println("GROUP BY ");
        it = this.notLostColumnUsages.iterator();
        while (it.hasNext()) {
            usage = (JdbcSchema.Table.Column.Usage)it.next();
            c = usage.getColumn();
            pw.print(prefix);
            pw.print(sqlQuery.getDialect().quoteIdentifier(factTableName, c.getName()));
            if (it.hasNext()) {
                pw.println(',');
                continue;
            }
            pw.println(';');
        }
        return sw.toString();
    }

    public String createCollapsed() {
        StringWriter sw = new StringWriter(512);
        PrintWriter pw = new PrintWriter(sw);
        String prefix = "    ";
        pw.print("CREATE TABLE ");
        pw.print(this.makeCollapsedAggregateTableName(this.getFactTableName()));
        pw.println(" (");
        Iterator<Object> it = this.collapsedColumnUsages.values().iterator();
        while (it.hasNext()) {
            List list = (List)it.next();
            Iterator lit = list.iterator();
            while (lit.hasNext()) {
                JdbcSchema.Table.Column.Usage usage = (JdbcSchema.Table.Column.Usage)lit.next();
                this.addColumnCreate(pw, prefix, usage);
            }
        }
        it = this.measures.iterator();
        while (it.hasNext()) {
            JdbcSchema.Table.Column.Usage usage = (JdbcSchema.Table.Column.Usage)it.next();
            this.addColumnCreate(pw, prefix, usage);
        }
        pw.print(prefix);
        pw.print(this.getFactCount());
        pw.println(" INTEGER NOT NULL");
        pw.println(");");
        return sw.toString();
    }

    public String insertIntoCollapsed() {
        RolapStar.Table rt;
        String n;
        JdbcSchema.Table t;
        JdbcSchema.Table.Column c;
        JdbcSchema.Table.Column.Usage usage;
        Iterator lit;
        List list;
        StringWriter sw = new StringWriter(512);
        PrintWriter pw = new PrintWriter(sw);
        String prefix = "    ";
        String factTableName = this.getFactTableName();
        SqlQuery sqlQuery = this.getSqlQuery();
        pw.print("INSERT INTO ");
        pw.print(this.makeCollapsedAggregateTableName(this.getFactTableName()));
        pw.println(" (");
        Iterator<Object> it = this.collapsedColumnUsages.values().iterator();
        while (it.hasNext()) {
            List list2 = (List)it.next();
            Iterator lit2 = list2.iterator();
            while (lit2.hasNext()) {
                JdbcSchema.Table.Column.Usage usage2 = (JdbcSchema.Table.Column.Usage)lit2.next();
                JdbcSchema.Table.Column c2 = usage2.getColumn();
                pw.print(prefix);
                if (usage2.usagePrefix != null) {
                    pw.print(usage2.usagePrefix);
                }
                pw.print(c2.getName());
                pw.println(',');
            }
        }
        it = this.measures.iterator();
        while (it.hasNext()) {
            JdbcSchema.Table.Column.Usage usage3 = (JdbcSchema.Table.Column.Usage)it.next();
            JdbcSchema.Table.Column c3 = usage3.getColumn();
            pw.print(prefix);
            String name = this.getUsageName(usage3);
            pw.print(name);
            pw.println(',');
        }
        pw.print(prefix);
        pw.print(this.getFactCount());
        pw.println(")");
        pw.println("SELECT");
        boolean dimCnt = false;
        Iterator<Object> it2 = this.collapsedColumnUsages.values().iterator();
        while (it2.hasNext()) {
            list = (List)it2.next();
            lit = list.iterator();
            while (lit.hasNext()) {
                usage = (JdbcSchema.Table.Column.Usage)lit.next();
                c = usage.getColumn();
                t = c.getTable();
                pw.print(prefix);
                pw.print(sqlQuery.getDialect().quoteIdentifier(t.getName(), c.getName()));
                pw.print(" AS ");
                n = usage.usagePrefix == null ? c.getName() : usage.usagePrefix + c.getName();
                pw.print(sqlQuery.getDialect().quoteIdentifier(n));
                pw.println(',');
            }
        }
        it2 = this.measures.iterator();
        while (it2.hasNext()) {
            JdbcSchema.Table.Column.Usage usage4 = (JdbcSchema.Table.Column.Usage)it2.next();
            JdbcSchema.Table.Column c4 = usage4.getColumn();
            JdbcSchema.Table t2 = c4.getTable();
            RolapAggregator agg = usage4.getAggregator();
            pw.print(prefix);
            pw.print(agg.getExpression(sqlQuery.getDialect().quoteIdentifier(t2.getName(), c4.getName())).toUpperCase());
            pw.print(" AS ");
            pw.print(sqlQuery.getDialect().quoteIdentifier(c4.getName()));
            pw.println(',');
        }
        pw.print(prefix);
        pw.print("COUNT(*) AS ");
        pw.println(sqlQuery.getDialect().quoteIdentifier(this.getFactCount()));
        pw.println("FROM ");
        pw.print(prefix);
        pw.print(sqlQuery.getDialect().quoteIdentifier(factTableName));
        pw.print(" ");
        pw.print(sqlQuery.getDialect().quoteIdentifier(factTableName));
        pw.println(',');
        dimCnt = false;
        it2 = this.collapsedColumnUsages.keySet().iterator();
        while (it2.hasNext()) {
            rt = (RolapStar.Table)it2.next();
            pw.print(prefix);
            pw.print(sqlQuery.getDialect().quoteIdentifier(rt.getAlias()));
            pw.print(" AS ");
            pw.print(sqlQuery.getDialect().quoteIdentifier(rt.getAlias()));
            if (rt.getParentTable() != null) {
                while (rt.getParentTable().getParentTable() != null) {
                    rt = rt.getParentTable();
                    pw.println(',');
                    pw.print(prefix);
                    pw.print(sqlQuery.getDialect().quoteIdentifier(rt.getAlias()));
                    pw.print(" AS ");
                    pw.print(sqlQuery.getDialect().quoteIdentifier(rt.getAlias()));
                }
            }
            if (it2.hasNext()) {
                pw.println(',');
                continue;
            }
            pw.println();
        }
        pw.println("WHERE ");
        it2 = this.collapsedColumnUsages.keySet().iterator();
        while (it2.hasNext()) {
            rt = (RolapStar.Table)it2.next();
            RolapStar.Condition cond = rt.getJoinCondition();
            if (cond == null) continue;
            pw.print(prefix);
            pw.print(cond.toString(sqlQuery));
            if (rt.getParentTable() != null) {
                while (rt.getParentTable().getParentTable() != null) {
                    rt = rt.getParentTable();
                    cond = rt.getJoinCondition();
                    pw.println(" and");
                    pw.print(prefix);
                    pw.print(cond.toString(sqlQuery));
                }
            }
            if (it2.hasNext()) {
                pw.println(" and");
                continue;
            }
            pw.println();
        }
        pw.println("GROUP BY ");
        dimCnt = false;
        it2 = this.collapsedColumnUsages.values().iterator();
        while (it2.hasNext()) {
            list = (List)it2.next();
            lit = list.iterator();
            while (lit.hasNext()) {
                usage = (JdbcSchema.Table.Column.Usage)lit.next();
                c = usage.getColumn();
                t = c.getTable();
                n = usage.usagePrefix == null ? c.getName() : usage.usagePrefix + c.getName();
                pw.print(prefix);
                pw.print(sqlQuery.getDialect().quoteIdentifier(t.getName(), n));
                if (!it2.hasNext()) continue;
                pw.println(',');
            }
        }
        pw.println(';');
        return sw.toString();
    }

    private String getUsageName(JdbcSchema.Table.Column.Usage usage) {
        JdbcSchema.Table.Column c = usage.getColumn();
        String name = c.getName();
        if (usage.getColumnType() == 4 && c.hasUsage(2)) {
            name = usage.getSymbolicName().replace(' ', '_').toUpperCase();
        }
        return name;
    }

    private void addColumnCreate(PrintWriter pw, String prefix, JdbcSchema.Table.Column.Usage usage) {
        JdbcSchema.Table.Column c = usage.getColumn();
        String name = this.getUsageName(usage);
        pw.print(prefix);
        if (usage.usagePrefix != null) {
            pw.print(usage.usagePrefix);
        }
        pw.print(name);
        pw.print(' ');
        pw.print(c.getTypeName().toUpperCase());
        switch (c.getType()) {
            case 2: 
            case 3: {
                pw.print('(');
                pw.print(c.getNumPrecRadix());
                pw.print(",");
                pw.print(c.getDecimalDigits());
                pw.print(')');
                break;
            }
            case 1: 
            case 12: {
                pw.print('(');
                pw.print(c.getCharOctetLength());
                pw.print(')');
                break;
            }
        }
        if (!c.isNullable()) {
            pw.print(" NOT NULL");
        }
        pw.println(',');
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        Class<?> clazz;
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            NoClassDefFoundError noClassDefFoundError = new NoClassDefFoundError(classNotFoundException.getMessage());
            try {
                noClassDefFoundError.initCause(classNotFoundException);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
            throw noClassDefFoundError;
        }
        return clazz;
    }
}

