/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap.agg;

import java.util.ArrayList;
import java.util.List;
import mondrian.olap.Util;
import mondrian.rolap.BitKey;
import mondrian.rolap.RolapStar;
import mondrian.rolap.agg.ColumnConstraint;

public class CellRequest {
    private final RolapStar.Measure measure;
    public final boolean extendedContext;
    public final boolean drillThrough;
    private final List constrainedColumnList = new ArrayList();
    private final List valueList = new ArrayList();
    private RolapStar.Column[] columnsCache = null;
    private final BitKey constrainedColumnsBitKey;
    private boolean unsatisfiable;
    static final /* synthetic */ boolean $assertionsDisabled;
    private static final /* synthetic */ Class class$mondrian$rolap$agg$CellRequest;

    public CellRequest(RolapStar.Measure measure, boolean extendedContext, boolean drillThrough) {
        this.measure = measure;
        this.extendedContext = extendedContext;
        this.drillThrough = drillThrough;
        this.constrainedColumnList.add(measure.getStar());
        this.constrainedColumnsBitKey = BitKey.Factory.makeBitKey(measure.getStar().getColumnCount());
    }

    public void addConstrainedColumn(RolapStar.Column column, ColumnConstraint constraint) {
        if (!$assertionsDisabled && this.columnsCache != null) {
            throw new AssertionError();
        }
        int bitPosition = column.getBitPosition();
        if (this.constrainedColumnsBitKey.get(bitPosition)) {
            int index = this.constrainedColumnList.indexOf(column);
            Util.assertTrue(index >= 0);
            ColumnConstraint prevValue = (ColumnConstraint)this.valueList.get(--index);
            if (prevValue != null) {
                if (constraint == null) {
                    return;
                }
                if (constraint.equalConstraint(prevValue)) {
                    return;
                }
                constraint = null;
                this.unsatisfiable = true;
            }
            this.valueList.set(index, constraint);
        } else {
            this.constrainedColumnList.add(column);
            this.constrainedColumnsBitKey.set(bitPosition);
            this.valueList.add(constraint);
        }
    }

    public RolapStar.Measure getMeasure() {
        return this.measure;
    }

    public RolapStar.Column[] getConstrainedColumns() {
        if (this.columnsCache == null) {
            this.makeColumnsCache();
        }
        return this.columnsCache;
    }

    private void makeColumnsCache() {
        this.columnsCache = new RolapStar.Column[this.constrainedColumnList.size() - 1];
        for (int i = 0; i < this.columnsCache.length; ++i) {
            this.columnsCache[i] = (RolapStar.Column)this.constrainedColumnList.get(i + 1);
        }
    }

    public BitKey getConstrainedColumnsBitKey() {
        return this.constrainedColumnsBitKey;
    }

    public List getValueList() {
        return this.valueList;
    }

    public Object[] getSingleValues() {
        Object[] a = new Object[this.valueList.size()];
        int n = this.valueList.size();
        for (int i = 0; i < n; ++i) {
            ColumnConstraint constr = (ColumnConstraint)this.valueList.get(i);
            a[i] = constr.getValue();
        }
        return a;
    }

    public boolean isUnsatisfiable() {
        return this.unsatisfiable;
    }

    static {
        $assertionsDisabled = !(class$mondrian$rolap$agg$CellRequest == null ? (class$mondrian$rolap$agg$CellRequest = CellRequest.class$("mondrian.rolap.agg.CellRequest")) : class$mondrian$rolap$agg$CellRequest).desiredAssertionStatus();
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        Class<?> clazz;
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            NoClassDefFoundError noClassDefFoundError = new NoClassDefFoundError(classNotFoundException.getMessage());
            try {
                noClassDefFoundError.initCause(classNotFoundException);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
            throw noClassDefFoundError;
        }
        return clazz;
    }
}

