/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap.agg;

import java.util.BitSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import mondrian.olap.MondrianProperties;
import mondrian.olap.Util;
import mondrian.rolap.BitKey;
import mondrian.rolap.RolapAggregationManager;
import mondrian.rolap.RolapStar;
import mondrian.rolap.agg.AggQuerySpec;
import mondrian.rolap.agg.Aggregation;
import mondrian.rolap.agg.CellRequest;
import mondrian.rolap.agg.ColumnConstraint;
import mondrian.rolap.agg.DrillThroughQuerySpec;
import mondrian.rolap.agg.Segment;
import mondrian.rolap.agg.SegmentArrayQuerySpec;
import mondrian.rolap.aggmatcher.AggStar;
import org.apache.log4j.Logger;

public class AggregationManager
extends RolapAggregationManager {
    private static final Logger LOGGER;
    private static AggregationManager instance;
    static final /* synthetic */ boolean $assertionsDisabled;
    private static final /* synthetic */ Class class$mondrian$rolap$agg$AggregationManager;

    public static synchronized AggregationManager instance() {
        if (instance == null) {
            instance = new AggregationManager();
        }
        return instance;
    }

    AggregationManager() {
    }

    public Logger getLogger() {
        return LOGGER;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadAggregation(RolapStar.Measure[] measures, RolapStar.Column[] columns, BitKey constrainedColumnsBitKey, ColumnConstraint[][] constraintses, Collection pinnedSegments) {
        Aggregation aggregation;
        RolapStar star = measures[0].getStar();
        Aggregation aggregation2 = aggregation = star.lookupOrCreateAggregation(constrainedColumnsBitKey);
        synchronized (aggregation2) {
            constraintses = aggregation.optimizeConstraints(columns, constraintses);
            aggregation.load(columns, measures, constraintses, pinnedSegments);
        }
    }

    public Object getCellFromCache(CellRequest request) {
        RolapStar.Measure measure = request.getMeasure();
        Aggregation aggregation = measure.getStar().lookupAggregation(request.getConstrainedColumnsBitKey());
        if (aggregation == null) {
            return null;
        }
        Object o = aggregation.get(measure, request.getSingleValues(), null);
        if (o != null) {
            return o;
        }
        throw Util.newInternal("not found");
    }

    public Object getCellFromCache(CellRequest request, Set pinSet) {
        Util.assertPrecondition(pinSet != null);
        RolapStar.Measure measure = request.getMeasure();
        Aggregation aggregation = measure.getStar().lookupAggregation(request.getConstrainedColumnsBitKey());
        if (aggregation == null) {
            return null;
        }
        return aggregation.get(measure, request.getSingleValues(), pinSet);
    }

    public String getDrillThroughSql(CellRequest request, boolean countOnly) {
        DrillThroughQuerySpec spec = new DrillThroughQuerySpec(request, countOnly);
        String sql = spec.generateSqlQuery();
        if (this.getLogger().isDebugEnabled()) {
            StringBuffer buf = new StringBuffer(256);
            buf.append("DrillThroughSQL: ");
            buf.append(sql);
            buf.append(Util.nl);
            this.getLogger().debug((Object)buf.toString());
        }
        return sql;
    }

    public String generateSql(Segment[] segments, BitKey levelBitKey, BitKey measureBitKey) {
        RolapStar star;
        if (MondrianProperties.instance().UseAggregates.get()) {
            star = segments[0].aggregation.getStar();
            boolean[] rollup = new boolean[]{false};
            AggStar aggStar = this.findAgg(star, levelBitKey, measureBitKey, rollup);
            if (aggStar != null) {
                if (this.getLogger().isDebugEnabled()) {
                    StringBuffer buf = new StringBuffer(256);
                    buf.append("MATCH: ");
                    buf.append(star.getFactTable().getAlias());
                    buf.append("   foreign=");
                    buf.append(levelBitKey);
                    buf.append(Util.nl);
                    buf.append("   measure=");
                    buf.append(measureBitKey);
                    buf.append(Util.nl);
                    buf.append("   aggstar=");
                    buf.append(aggStar.getBitKey());
                    buf.append(Util.nl);
                    buf.append("AggStar=");
                    buf.append(aggStar.getFactTable().getName());
                    buf.append(Util.nl);
                    Iterator columnIter = aggStar.getFactTable().getColumns().iterator();
                    while (columnIter.hasNext()) {
                        AggStar.Table.Column column = (AggStar.Table.Column)columnIter.next();
                        buf.append("   ");
                        buf.append(column);
                        buf.append(Util.nl);
                    }
                    this.getLogger().debug((Object)buf.toString());
                }
                AggQuerySpec aggQuerySpec = new AggQuerySpec(aggStar, segments, rollup[0]);
                String sql = aggQuerySpec.generateSqlQuery();
                return sql;
            }
        }
        if (this.getLogger().isDebugEnabled()) {
            star = segments[0].aggregation.getStar();
            StringBuffer buf = new StringBuffer(256);
            buf.append("NO MATCH: ");
            buf.append(star.getFactTable().getAlias());
            buf.append(Util.nl);
            buf.append("   foreign=");
            buf.append(levelBitKey);
            buf.append(Util.nl);
            buf.append("   measure=");
            buf.append(measureBitKey);
            buf.append(Util.nl);
            this.getLogger().debug((Object)buf.toString());
        }
        SegmentArrayQuerySpec spec = new SegmentArrayQuerySpec(segments);
        String sql = spec.generateSqlQuery();
        return sql;
    }

    public AggStar findAgg(RolapStar star, BitKey levelBitKey, BitKey measureBitKey, boolean[] rollup) {
        if (!$assertionsDisabled && rollup == null) {
            throw new AssertionError();
        }
        BitKey fullBitKey = levelBitKey.or(measureBitKey);
        Iterator it = star.getAggStars().iterator();
        while (it.hasNext()) {
            AggStar aggStar = (AggStar)it.next();
            if (!aggStar.superSetMatch(fullBitKey)) continue;
            boolean isDistinct = measureBitKey.intersects(aggStar.getDistinctMeasureBitKey());
            if (!isDistinct) {
                rollup[0] = !aggStar.getLevelBitKey().equals(levelBitKey);
                return aggStar;
            }
            BitKey distinctMeasuresBitKey = measureBitKey.and(aggStar.getDistinctMeasureBitKey());
            BitSet distinctMeasures = distinctMeasuresBitKey.toBitSet();
            BitKey combinedLevelBitKey = null;
            int k = distinctMeasures.nextSetBit(0);
            while (k >= 0) {
                AggStar.FactTable.Measure distinctMeasure = aggStar.lookupMeasure(k);
                BitKey rollableLevelBitKey = distinctMeasure.getRollableLevelBitKey();
                combinedLevelBitKey = combinedLevelBitKey == null ? rollableLevelBitKey : combinedLevelBitKey.and(rollableLevelBitKey);
                k = distinctMeasures.nextSetBit(k + 1);
            }
            if (aggStar.hasForeignKeys()) {
                Iterator mit = aggStar.getFactTable().getMeasures().iterator();
                BitKey fkBitKey = aggStar.getForeignKeyBitKey().copy();
                while (mit.hasNext()) {
                    AggStar.FactTable.Measure m = (AggStar.FactTable.Measure)mit.next();
                    if (!m.isDistinct() || !measureBitKey.get(m.getBitPosition())) continue;
                    fkBitKey.clear(m.getBitPosition());
                }
                if (!fkBitKey.isEmpty()) continue;
            }
            if (!aggStar.select(levelBitKey, combinedLevelBitKey, measureBitKey)) continue;
            rollup[0] = !aggStar.getLevelBitKey().equals(levelBitKey);
            return aggStar;
        }
        return null;
    }

    static {
        $assertionsDisabled = !(class$mondrian$rolap$agg$AggregationManager == null ? (class$mondrian$rolap$agg$AggregationManager = AggregationManager.class$("mondrian.rolap.agg.AggregationManager")) : class$mondrian$rolap$agg$AggregationManager).desiredAssertionStatus();
        LOGGER = Logger.getLogger((Class)(class$mondrian$rolap$agg$AggregationManager == null ? (class$mondrian$rolap$agg$AggregationManager = AggregationManager.class$("mondrian.rolap.agg.AggregationManager")) : class$mondrian$rolap$agg$AggregationManager));
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        Class<?> clazz;
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            NoClassDefFoundError noClassDefFoundError = new NoClassDefFoundError(classNotFoundException.getMessage());
            try {
                noClassDefFoundError.initCause(classNotFoundException);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
            throw noClassDefFoundError;
        }
        return clazz;
    }
}

