/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap.agg;

import com.rc.retroweaver.runtime.Arrays;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mondrian.olap.Level;
import mondrian.olap.Member;
import mondrian.olap.MondrianProperties;
import mondrian.olap.SchemaReader;
import mondrian.olap.Util;
import mondrian.rolap.BitKey;
import mondrian.rolap.RolapMember;
import mondrian.rolap.RolapStar;
import mondrian.rolap.agg.ColumnConstraint;
import mondrian.rolap.agg.Segment;

public class Aggregation {
    private int maxConstraints;
    private final RolapStar star;
    private final BitKey constrainedColumnsBitKey;
    private final List segmentRefs;
    private RolapStar.Column[] columns;

    public Aggregation(RolapStar star, BitKey constrainedColumnsBitKey) {
        this.star = star;
        this.constrainedColumnsBitKey = constrainedColumnsBitKey;
        this.segmentRefs = new ArrayList();
        this.maxConstraints = MondrianProperties.instance().MaxConstraints.get();
    }

    public synchronized void load(RolapStar.Column[] columns, RolapStar.Measure[] measures, ColumnConstraint[][] constraintses, Collection pinnedSegments) {
        this.columns = columns;
        BitKey measureBitKey = this.constrainedColumnsBitKey.emptyCopy();
        int axisCount = columns.length;
        Util.assertTrue(constraintses.length == axisCount);
        Axis[] axes = new Axis[axisCount];
        for (int i = 0; i < axisCount; ++i) {
            axes[i] = new Axis(columns[i], constraintses[i]);
        }
        Segment[] segments = new Segment[measures.length];
        for (int i = 0; i < measures.length; ++i) {
            Segment segment;
            RolapStar.Measure measure = measures[i];
            measureBitKey.set(measure.getBitPosition());
            segments[i] = segment = new Segment(this, measure, constraintses, axes);
            SoftReference<Segment> ref = new SoftReference<Segment>(segment);
            this.segmentRefs.add(ref);
            pinnedSegments.add(segment);
        }
        BitKey levelBitKey = this.constrainedColumnsBitKey;
        Segment.load(segments, levelBitKey, measureBitKey, pinnedSegments, axes);
    }

    public synchronized ColumnConstraint[][] optimizeConstraints(RolapStar.Column[] columns, ColumnConstraint[][] constraintses) {
        int j;
        int i;
        Util.assertTrue(constraintses.length == columns.length);
        ColumnConstraint[][] newConstraintses = (ColumnConstraint[][])constraintses.clone();
        double[] bloats = new double[columns.length];
        ArrayList<RolapMember> potentialParents = new ArrayList<RolapMember>();
        for (i = 0; i < constraintses.length; ++i) {
            RolapMember m;
            ColumnConstraint[] constraints = constraintses[i];
            if (constraints == null || constraints.length != 1 || (m = constraints[0].getMember()) == null) continue;
            potentialParents.add(m);
        }
        for (i = 0; i < newConstraintses.length; ++i) {
            SchemaReader scr;
            int memberCount;
            ColumnConstraint[] newConstraints = newConstraintses[i];
            if (newConstraints == null || newConstraints.length < 2) {
                bloats[i] = 0.0;
                continue;
            }
            if (newConstraints.length > this.maxConstraints) {
                bloats[i] = 1.0;
                continue;
            }
            double constraintLength = newConstraints.length;
            Member parent = null;
            Level level = null;
            for (int j2 = 0; j2 < newConstraints.length; ++j2) {
                RolapMember m = newConstraints[j2].getMember();
                if (m == null) {
                    parent = null;
                    level = null;
                    bloats[i] = constraintLength / (double)columns[i].getCardinality();
                    break;
                }
                if (j2 == 0) {
                    parent = m.getParentMember();
                    level = m.getLevel();
                    continue;
                }
                if (parent != null && !parent.equals(m.getParentMember())) {
                    parent = null;
                }
                if (level == null || level.equals(m.getLevel())) continue;
                level = null;
            }
            boolean done = false;
            if (parent != null && (parent.isAll() || potentialParents.contains(parent))) {
                int nChildren = -1;
                SchemaReader scr2 = this.star.getSchema().getSchemaReader();
                nChildren = scr2.getChildrenCountFromCache(parent);
                if (nChildren == -1) {
                    if (!parent.isAll()) {
                        bloats[i] = 0.0;
                        done = true;
                    }
                } else {
                    bloats[i] = constraintLength / (double)nChildren;
                    done = true;
                }
            }
            if (!done && level != null && (memberCount = (scr = this.star.getSchema().getSchemaReader()).getLevelCardinality(level, true, false)) > 0) {
                bloats[i] = constraintLength / (double)memberCount;
                done = true;
            }
            if (done) continue;
            bloats[i] = constraintLength / (double)columns[i].getCardinality();
        }
        ConstraintComparator comparator = new ConstraintComparator(bloats);
        Object[] indexes = new Integer[columns.length];
        for (int i2 = 0; i2 < columns.length; ++i2) {
            indexes[i2] = new Integer(i2);
        }
        Arrays.sort((Object[])indexes, (Comparator)comparator);
        double abloat = 1.0;
        double aBloatLimit = 0.5;
        for (int i3 = 0; i3 < indexes.length && (abloat *= bloats[j = ((Integer)indexes[i3]).intValue()]) > 0.5; ++i3) {
            newConstraintses[j] = null;
        }
        return newConstraintses;
    }

    public synchronized Object get(RolapStar.Measure measure, Object[] keys, Collection pinSet) {
        Iterator it = this.segmentRefs.iterator();
        while (it.hasNext()) {
            SoftReference ref = (SoftReference)it.next();
            Segment segment = (Segment)ref.get();
            if (segment == null) {
                it.remove();
                continue;
            }
            if (segment.measure != measure) continue;
            if (segment.isReady()) {
                Object o = segment.get(keys);
                if (o == null) continue;
                if (pinSet != null) {
                    pinSet.add(segment);
                }
                return o;
            }
            if (pinSet == null || pinSet.contains(segment) || !segment.wouldContain(keys)) continue;
            pinSet.add(segment);
        }
        return null;
    }

    RolapStar.Column[] getColumns() {
        return this.columns;
    }

    RolapStar getStar() {
        return this.star;
    }

    static class Axis {
        private final ColumnConstraint[] constraints;
        private final Map mapKeyToOffset;
        private Object[] keys;
        private Set valueSet;

        Axis(RolapStar.Column column, ColumnConstraint[] constraints) {
            this.constraints = constraints;
            this.mapKeyToOffset = new HashMap();
            if (constraints != null) {
                this.valueSet = new HashSet();
                for (int i = 0; i < constraints.length; ++i) {
                    this.valueSet.add(constraints[i].getValue());
                }
            }
        }

        ColumnConstraint[] getConstraints() {
            return this.constraints;
        }

        Object[] getKeys() {
            return this.keys;
        }

        int loadKeys() {
            int size = this.mapKeyToOffset.size();
            this.keys = new Object[size];
            Iterator it = this.mapKeyToOffset.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry e = it.next();
                Object key = e.getKey();
                Integer offsetInteger = (Integer)e.getValue();
                int offset = offsetInteger;
                this.keys[offset] = key;
            }
            return size;
        }

        Integer getOffset(Object key) {
            return (Integer)this.mapKeyToOffset.get(key);
        }

        void addNextOffset(Object key) {
            int size = this.mapKeyToOffset.size();
            this.mapKeyToOffset.put(key, new Integer(size));
        }

        boolean contains(Object key) {
            if (this.constraints == null) {
                return true;
            }
            return this.valueSet.contains(key);
        }
    }

    private class ConstraintComparator
    implements Comparator {
        private final double[] bloats;

        ConstraintComparator(double[] bloats) {
            this.bloats = bloats;
        }

        public int compare(Object o0, Object o1) {
            double bloat1;
            double bloat0 = this.bloats[(Integer)o0];
            return bloat0 == (bloat1 = this.bloats[(Integer)o1]) ? 0 : (bloat0 < bloat1 ? 1 : -1);
        }
    }
}

