/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;
import mondrian.olap.Evaluator;
import mondrian.olap.MondrianDef;
import mondrian.olap.MondrianProperties;
import mondrian.olap.Query;
import mondrian.olap.Util;
import mondrian.olap.fun.FunUtil;
import mondrian.resource.MondrianResource;
import mondrian.rolap.MemberCache;
import mondrian.rolap.RolapCube;
import mondrian.rolap.RolapHierarchy;
import mondrian.rolap.RolapLevel;
import mondrian.rolap.RolapMember;
import mondrian.rolap.RolapProperty;
import mondrian.rolap.RolapStoredMeasure;
import mondrian.rolap.RolapUtil;
import mondrian.rolap.SqlContextConstraint;
import mondrian.rolap.TupleReader;
import mondrian.rolap.sql.MemberChildrenConstraint;
import mondrian.rolap.sql.SqlQuery;
import mondrian.rolap.sql.TupleConstraint;

public class SqlTupleReader
implements TupleReader {
    TupleConstraint constraint;
    List targets = new ArrayList();
    int maxRows = 0;
    static final /* synthetic */ boolean $assertionsDisabled;
    private static final /* synthetic */ Class class$mondrian$rolap$SqlTupleReader;

    public SqlTupleReader(TupleConstraint constraint) {
        this.constraint = constraint;
    }

    public void addLevelMembers(RolapLevel level, TupleReader.MemberBuilder memberBuilder, RolapMember[] srcMembers) {
        this.targets.add(new Target(level, memberBuilder, srcMembers));
    }

    public Object getCacheKey() {
        ArrayList<Object> key = new ArrayList<Object>();
        key.add(this.constraint.getCacheKey());
        key.add(class$mondrian$rolap$SqlTupleReader == null ? (class$mondrian$rolap$SqlTupleReader = SqlTupleReader.class$("mondrian.rolap.SqlTupleReader")) : class$mondrian$rolap$SqlTupleReader);
        Iterator it = this.targets.iterator();
        while (it.hasNext()) {
            Target t = (Target)it.next();
            if (Target.access$000(t) == null) continue;
            key.add(t.getLevel());
        }
        return key;
    }

    public int getEnumTargetCount() {
        int nEnumTargets = 0;
        Iterator it = this.targets.iterator();
        while (it.hasNext()) {
            Target t = (Target)it.next();
            if (Target.access$000(t) == null) continue;
            ++nEnumTargets;
        }
        return nEnumTargets;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List readTuples(DataSource dataSource, List partialResult, List newPartialResult) {
        Connection con;
        try {
            con = dataSource.getConnection();
        }
        catch (SQLException e) {
            throw Util.newInternal(e, "could not connect to DB");
        }
        try {
            List list = this.readTuples(con, partialResult, newPartialResult);
            return list;
        }
        finally {
            try {
                con.close();
            }
            catch (SQLException e) {
                throw Util.newInternal(e, "could not close connection");
            }
        }
    }

    public List readTuples(Connection jdbcConnection, List partialResult, List newPartialResult) {
        ArrayList<RolapMember[]> arrayList;
        String sql = this.makeLevelMembersSql(jdbcConnection);
        ResultSet resultSet = null;
        boolean execQuery = partialResult == null;
        try {
            List partialRow;
            boolean moreRows;
            if (execQuery) {
                ArrayList<Target> partialTargets = new ArrayList<Target>();
                Iterator it = this.targets.iterator();
                while (it.hasNext()) {
                    Target t = (Target)it.next();
                    if (Target.access$000(t) != null) continue;
                    partialTargets.add(t);
                }
                resultSet = RolapUtil.executeQuery(jdbcConnection, sql, this.maxRows, "SqlTupleReader.readTuples " + partialTargets, -1, -1);
            }
            Iterator it = this.targets.iterator();
            while (it.hasNext()) {
                ((Target)it.next()).open();
            }
            int limit = MondrianProperties.instance().ResultLimit.get();
            int fetchCount = 0;
            int enumTargetCount = this.getEnumTargetCount();
            int[] srcMemberIdxes = null;
            if (enumTargetCount > 0) {
                srcMemberIdxes = new int[enumTargetCount];
            }
            int currPartialResultIdx = 0;
            if (execQuery) {
                moreRows = resultSet.next();
            } else {
                boolean bl = moreRows = currPartialResultIdx < partialResult.size();
            }
            while (moreRows) {
                if (limit > 0 && limit < ++fetchCount) {
                    throw MondrianResource.instance().MemberFetchLimitExceeded.ex(new Long(limit));
                }
                if (enumTargetCount == 0) {
                    int column = 0;
                    Iterator it2 = this.targets.iterator();
                    while (it2.hasNext()) {
                        Target t = (Target)it2.next();
                        Target.access$102(t, null);
                        column = t.addRow(resultSet, column);
                    }
                } else {
                    int firstEnumTarget;
                    for (firstEnumTarget = 0; firstEnumTarget < this.targets.size() && Target.access$000((Target)this.targets.get(firstEnumTarget)) == null; ++firstEnumTarget) {
                    }
                    partialRow = execQuery ? null : (List)partialResult.get(currPartialResultIdx);
                    this.resetCurrMembers(partialRow);
                    this.addTargets(0, firstEnumTarget, enumTargetCount, srcMemberIdxes, resultSet, sql);
                    if (newPartialResult != null) {
                        this.savePartialResult(newPartialResult);
                    }
                }
                if (execQuery) {
                    moreRows = resultSet.next();
                    continue;
                }
                moreRows = ++currPartialResultIdx < partialResult.size();
            }
            int n = this.targets.size();
            if (n == 1) {
                partialRow = ((Target)this.targets.get(0)).close();
                return partialRow;
            }
            ArrayList<RolapMember[]> tupleList = new ArrayList<RolapMember[]>();
            Iterator[] iter = new Iterator[n];
            for (int i = 0; i < n; ++i) {
                Target t = (Target)this.targets.get(i);
                iter[i] = t.close().iterator();
            }
            while (iter[0].hasNext()) {
                RolapMember[] tuples = new RolapMember[n];
                for (int i = 0; i < n; ++i) {
                    tuples[i] = (RolapMember)iter[i].next();
                }
                tupleList.add(tuples);
            }
            if (enumTargetCount > 0) {
                FunUtil.hierarchize(tupleList, false);
            }
            arrayList = tupleList;
        }
        catch (Throwable e) {
            throw Util.newInternal(e, "while populating member cache with members for " + this.targets + "'; sql=[" + sql + "]");
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.getStatement().close();
                    resultSet.close();
                }
            }
            catch (SQLException e) {}
        }
        return arrayList;
    }

    private void resetCurrMembers(List partialRow) {
        int nativeTarget = 0;
        for (int i = 0; i < this.targets.size(); ++i) {
            Target t = (Target)this.targets.get(i);
            if (Target.access$000(t) != null) continue;
            if (partialRow != null) {
                Target.access$102(t, (RolapMember)partialRow.get(nativeTarget++));
                continue;
            }
            Target.access$102(t, null);
        }
    }

    private void addTargets(int currEnumTargetIdx, int currTargetIdx, int nEnumTargets, int[] srcMemberIdxes, ResultSet resultSet, String sql) {
        Target currTarget = (Target)this.targets.get(currTargetIdx);
        for (int i = 0; i < Target.access$000(currTarget).length; ++i) {
            srcMemberIdxes[currEnumTargetIdx] = i;
            if (currEnumTargetIdx < nEnumTargets - 1) {
                int nextTargetIdx;
                for (nextTargetIdx = currTargetIdx + 1; nextTargetIdx < this.targets.size() && Target.access$000((Target)this.targets.get(nextTargetIdx)) == null; ++nextTargetIdx) {
                }
                this.addTargets(currEnumTargetIdx + 1, nextTargetIdx, nEnumTargets, srcMemberIdxes, resultSet, sql);
                continue;
            }
            int column = 0;
            int enumTargetIdx = 0;
            Iterator it = this.targets.iterator();
            while (it.hasNext()) {
                Target t = (Target)it.next();
                if (Target.access$000(t) == null) {
                    try {
                        column = t.addRow(resultSet, column);
                        continue;
                    }
                    catch (Throwable e) {
                        throw Util.newInternal(e, "while populating member cache with members for " + this.targets + "'; sql=[" + sql + "]");
                    }
                }
                RolapMember member = Target.access$000(t)[srcMemberIdxes[enumTargetIdx++]];
                t.list.add(member);
            }
        }
    }

    private void savePartialResult(List partialResult) {
        ArrayList<RolapMember> row = new ArrayList<RolapMember>();
        Iterator it = this.targets.iterator();
        while (it.hasNext()) {
            Target t = (Target)it.next();
            if (Target.access$000(t) != null) continue;
            row.add(Target.access$100(t));
        }
        partialResult.add(row);
    }

    String makeLevelMembersSql(Connection jdbcConnection) {
        Query query;
        SqlContextConstraint sqlConstraint;
        boolean virtualCube = false;
        if (this.constraint instanceof SqlContextConstraint && (sqlConstraint = (SqlContextConstraint)this.constraint).isJoinRequired()) {
            query = this.constraint.getEvaluator().getQuery();
            RolapCube cube = (RolapCube)query.getCube();
            virtualCube = cube.isVirtual();
        }
        if (virtualCube) {
            String selectString = "";
            query = this.constraint.getEvaluator().getQuery();
            Set baseCubesLevelToColumnMaps = query.getVirtualCubeBaseCubeMaps();
            Map measureMap = query.getLevelMapToMeasureMap();
            Iterator it = baseCubesLevelToColumnMaps.iterator();
            while (it.hasNext()) {
                Map map = (Map)it.next();
                boolean finalSelect = !it.hasNext();
                RolapMember measure = (RolapMember)measureMap.get(map);
                if (!$assertionsDisabled && !(measure instanceof RolapStoredMeasure)) {
                    throw new AssertionError();
                }
                Evaluator evaluator = this.constraint.getEvaluator();
                evaluator.push();
                evaluator.setContext(measure);
                selectString = selectString + this.generateSelectForLevels(jdbcConnection, map, finalSelect);
                evaluator = evaluator.pop();
                if (finalSelect) continue;
                selectString = selectString + " union ";
            }
            return selectString;
        }
        return this.generateSelectForLevels(jdbcConnection, null, true);
    }

    private String generateSelectForLevels(Connection jdbcConnection, Map levelToColumnMap, boolean finalSelect) {
        String s = "while generating query to retrieve members of level(s) " + this.targets;
        SqlQuery sqlQuery = SqlTupleReader.newQuery(jdbcConnection, s);
        int orderByColNo = 1;
        Iterator it = this.targets.iterator();
        while (it.hasNext()) {
            Target t = (Target)it.next();
            if (Target.access$000(t) != null) continue;
            orderByColNo = this.addLevelMemberSql(sqlQuery, t.getLevel(), levelToColumnMap, finalSelect, orderByColNo);
        }
        this.constraint.addConstraint(sqlQuery);
        return sqlQuery.toString();
    }

    private int addLevelMemberSql(SqlQuery sqlQuery, RolapLevel level, Map levelToColumnMap, boolean finalSelect, int orderByColNo) {
        RolapHierarchy hierarchy = (RolapHierarchy)level.getHierarchy();
        RolapLevel[] levels = (RolapLevel[])hierarchy.getLevels();
        int levelDepth = level.getDepth();
        for (int i = 0; i <= levelDepth; ++i) {
            RolapLevel level2 = levels[i];
            if (level2.isAll()) continue;
            hierarchy.addToFrom(sqlQuery, level2.getKeyExp());
            String keySql = level2.getKeyExp().getExpression(sqlQuery);
            sqlQuery.addSelect(keySql);
            sqlQuery.addGroupBy(keySql);
            hierarchy.addToFrom(sqlQuery, level2.getOrdinalExp());
            this.constraint.addLevelConstraint(sqlQuery, null, level2, levelToColumnMap);
            if (level2.hasCaptionColumn()) {
                MondrianDef.Expression captionExp = level2.getCaptionExp();
                hierarchy.addToFrom(sqlQuery, captionExp);
                String captionSql = captionExp.getExpression(sqlQuery);
                sqlQuery.addSelect(captionSql);
                sqlQuery.addGroupBy(captionSql);
            }
            String ordinalSql = level2.getOrdinalExp().getExpression(sqlQuery);
            sqlQuery.addGroupBy(ordinalSql);
            if (finalSelect) {
                if (levelToColumnMap != null) {
                    Integer obyCol = new Integer(orderByColNo);
                    ordinalSql = obyCol.toString();
                    ++orderByColNo;
                }
                sqlQuery.addOrderBy(ordinalSql, true, false, true);
            }
            RolapProperty[] properties = level2.getRolapProperties();
            for (int j = 0; j < properties.length; ++j) {
                RolapProperty property = properties[j];
                String propSql = property.getExp().getExpression(sqlQuery);
                sqlQuery.addSelect(propSql);
                sqlQuery.addGroupBy(propSql);
            }
        }
        return orderByColNo;
    }

    static SqlQuery newQuery(Connection jdbcConnection, String err) {
        try {
            SqlQuery.Dialect dialect = SqlQuery.Dialect.create(jdbcConnection.getMetaData());
            return new SqlQuery(dialect);
        }
        catch (SQLException e) {
            throw Util.newInternal(e, err);
        }
    }

    int getMaxRows() {
        return this.maxRows;
    }

    void setMaxRows(int maxRows) {
        this.maxRows = maxRows;
    }

    static {
        $assertionsDisabled = !(class$mondrian$rolap$SqlTupleReader == null ? (class$mondrian$rolap$SqlTupleReader = SqlTupleReader.class$("mondrian.rolap.SqlTupleReader")) : class$mondrian$rolap$SqlTupleReader).desiredAssertionStatus();
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        Class<?> clazz;
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            NoClassDefFoundError noClassDefFoundError = new NoClassDefFoundError(classNotFoundException.getMessage());
            try {
                noClassDefFoundError.initCause(classNotFoundException);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
            throw noClassDefFoundError;
        }
        return clazz;
    }

    private class Target {
        final RolapLevel level;
        final MemberCache cache;
        RolapLevel[] levels;
        List list;
        int levelDepth;
        boolean parentChild;
        RolapMember[] members;
        List[] siblings;
        final TupleReader.MemberBuilder memberBuilder;
        private final RolapMember[] srcMembers;
        private RolapMember currMember;

        public Target(RolapLevel level, TupleReader.MemberBuilder memberBuilder, RolapMember[] srcMembers) {
            this.level = level;
            this.cache = memberBuilder.getMemberCache();
            this.memberBuilder = memberBuilder;
            this.srcMembers = srcMembers;
        }

        public void open() {
            this.levels = (RolapLevel[])this.level.getHierarchy().getLevels();
            this.list = new ArrayList();
            this.levelDepth = this.level.getDepth();
            this.parentChild = this.level.isParentChild();
            this.members = new RolapMember[this.levels.length];
            this.siblings = new ArrayList[this.levels.length + 1];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int addRow(ResultSet resultSet, int column) throws SQLException {
            MemberCache memberCache = this.cache;
            synchronized (memberCache) {
                return this.internalAddRow(resultSet, column);
            }
        }

        private int internalAddRow(ResultSet resultSet, int column) throws SQLException {
            RolapMember member = null;
            if (this.currMember != null) {
                member = this.currMember;
            } else {
                for (int i = 0; i <= this.levelDepth; ++i) {
                    MemberChildrenConstraint mcc;
                    Object value;
                    RolapLevel childLevel = this.levels[i];
                    if (childLevel.isAll()) {
                        member = ((RolapHierarchy)this.level.getHierarchy()).getAllMember();
                        continue;
                    }
                    if ((value = resultSet.getObject(++column)) == null) {
                        value = RolapUtil.sqlNullValue;
                    }
                    Object captionValue = childLevel.hasCaptionColumn() ? resultSet.getObject(++column) : null;
                    RolapMember parentMember = member;
                    Object key = this.cache.makeKey(parentMember, value);
                    if ((member = this.cache.getMember(key)) == null) {
                        member = this.memberBuilder.makeMember(parentMember, childLevel, value, captionValue, this.parentChild, resultSet, key, column);
                    }
                    column += childLevel.getProperties().length;
                    if (member == this.members[i]) continue;
                    List children = this.siblings[i + 1];
                    if (children != null && (mcc = SqlTupleReader.this.constraint.getMemberChildrenConstraint(this.members[i])) != null) {
                        this.cache.putChildren(this.members[i], mcc, children);
                    }
                    mcc = SqlTupleReader.this.constraint.getMemberChildrenConstraint(member);
                    List cachedChildren = this.cache.getChildrenFromCache(member, mcc);
                    this.siblings[i + 1] = i < this.levelDepth && cachedChildren == null ? new ArrayList() : null;
                    this.members[i] = member;
                    if (this.siblings[i] == null) continue;
                    if (value == RolapUtil.sqlNullValue) {
                        this.addAsOldestSibling(this.siblings[i], member);
                        continue;
                    }
                    this.siblings[i].add(member);
                }
                this.currMember = member;
            }
            this.list.add(member);
            return column;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List close() {
            MemberCache memberCache = this.cache;
            synchronized (memberCache) {
                return this.internalClose();
            }
        }

        public List internalClose() {
            for (int i = 0; i < this.members.length; ++i) {
                MemberChildrenConstraint mcc;
                RolapMember member = this.members[i];
                List children = this.siblings[i + 1];
                if (member == null || children == null || (mcc = SqlTupleReader.this.constraint.getMemberChildrenConstraint(member)) == null) continue;
                this.cache.putChildren(member, mcc, children);
            }
            return this.list;
        }

        private void addAsOldestSibling(List list, RolapMember member) {
            RolapMember sibling;
            int i = list.size();
            while (--i >= 0 && (sibling = (RolapMember)list.get(i)).getParentMember() == member.getParentMember()) {
            }
            list.add(i + 1, member);
        }

        public RolapLevel getLevel() {
            return this.level;
        }

        public String toString() {
            return this.level.getUniqueName();
        }

        static RolapMember[] access$000(Target x0) {
            return x0.srcMembers;
        }

        static RolapMember access$102(Target x0, RolapMember x1) {
            x0.currMember = x1;
            return x0.currMember;
        }

        static RolapMember access$100(Target x0) {
            return x0.currMember;
        }
    }
}

