/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import mondrian.olap.Member;
import mondrian.olap.Util;
import mondrian.rolap.MemberCache;
import mondrian.rolap.MemberKey;
import mondrian.rolap.MemberReader;
import mondrian.rolap.RolapHierarchy;
import mondrian.rolap.RolapLevel;
import mondrian.rolap.RolapMember;
import mondrian.rolap.RolapUtil;
import mondrian.rolap.SmartMemberListCache;
import mondrian.rolap.SqlConstraintFactory;
import mondrian.rolap.TupleReader;
import mondrian.rolap.cache.SmartCache;
import mondrian.rolap.cache.SoftSmartCache;
import mondrian.rolap.sql.MemberChildrenConstraint;
import mondrian.rolap.sql.TupleConstraint;

public class SmartMemberReader
implements MemberReader,
MemberCache {
    private final SqlConstraintFactory sqlConstraintFactory = SqlConstraintFactory.instance();
    private final MemberReader source;
    final SmartMemberListCache mapMemberToChildren;
    final SmartCache mapKeyToMember;
    final SmartMemberListCache mapLevelToMembers;
    private List rootMembers;
    static final /* synthetic */ boolean $assertionsDisabled;
    private static final /* synthetic */ Class class$mondrian$rolap$SmartMemberReader;

    SmartMemberReader(MemberReader source) {
        this.source = source;
        if (!source.setCache(this)) {
            throw Util.newInternal("MemberSource (" + source + ", " + source.getClass() + ") does not support cache-writeback");
        }
        this.mapLevelToMembers = new SmartMemberListCache();
        this.mapKeyToMember = new SoftSmartCache();
        this.mapMemberToChildren = new SmartMemberListCache();
    }

    public RolapHierarchy getHierarchy() {
        return this.source.getHierarchy();
    }

    public boolean setCache(MemberCache cache) {
        return false;
    }

    public Object makeKey(RolapMember parent, Object key) {
        return new MemberKey(parent, key);
    }

    public synchronized RolapMember getMember(Object key) {
        return (RolapMember)this.mapKeyToMember.get(key);
    }

    public synchronized Object putMember(Object key, RolapMember value) {
        return this.mapKeyToMember.put(key, value);
    }

    public RolapMember[] getMembers() {
        ArrayList v = new ArrayList();
        RolapLevel[] levels = (RolapLevel[])this.getHierarchy().getLevels();
        for (int i = 0; i < levels.length; ++i) {
            List membersInLevel = this.getMembersInLevel(levels[i], 0, Integer.MAX_VALUE);
            v.addAll(membersInLevel);
        }
        return RolapUtil.toArray(v);
    }

    public List getRootMembers() {
        if (this.rootMembers == null) {
            this.rootMembers = this.source.getRootMembers();
        }
        return this.rootMembers;
    }

    public synchronized List getMembersInLevel(RolapLevel level, int startOrdinal, int endOrdinal) {
        TupleConstraint constraint = this.sqlConstraintFactory.getLevelMembersConstraint(null);
        return this.getMembersInLevel(level, startOrdinal, endOrdinal, constraint);
    }

    public synchronized List getMembersInLevel(RolapLevel level, int startOrdinal, int endOrdinal, TupleConstraint constraint) {
        List members = this.mapLevelToMembers.get(level, constraint);
        if (members != null) {
            return members;
        }
        members = this.source.getMembersInLevel(level, startOrdinal, endOrdinal, constraint);
        this.mapLevelToMembers.put(level, constraint, members);
        return members;
    }

    public void getMemberChildren(RolapMember parentMember, List children) {
        MemberChildrenConstraint constraint = this.sqlConstraintFactory.getMemberChildrenConstraint(null);
        this.getMemberChildren(parentMember, children, constraint);
    }

    public void getMemberChildren(RolapMember parentMember, List children, MemberChildrenConstraint constraint) {
        ArrayList<RolapMember> parentMembers = new ArrayList<RolapMember>();
        parentMembers.add(parentMember);
        this.getMemberChildren(parentMembers, children, constraint);
    }

    public synchronized void getMemberChildren(List parentMembers, List children) {
        MemberChildrenConstraint constraint = this.sqlConstraintFactory.getMemberChildrenConstraint(null);
        this.getMemberChildren(parentMembers, children, constraint);
    }

    public synchronized void getMemberChildren(List parentMembers, List children, MemberChildrenConstraint constraint) {
        ArrayList<RolapMember> missed = new ArrayList<RolapMember>();
        Iterator it = parentMembers.iterator();
        while (it.hasNext()) {
            RolapMember parent = (RolapMember)it.next();
            List list = this.mapMemberToChildren.get(parent, constraint);
            if (list == null) {
                if (parent.isNull()) continue;
                missed.add(parent);
                continue;
            }
            children.addAll(list);
        }
        if (missed.size() > 0) {
            this.readMemberChildren(missed, children, constraint);
        }
    }

    public RolapMember lookupMember(String[] uniqueNameParts, boolean failIfNotFound) {
        return RolapUtil.lookupMember(this, uniqueNameParts, failIfNotFound);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readMemberChildren(List members, List result, MemberChildrenConstraint constraint) {
        int i;
        ArrayList children = new ArrayList();
        this.source.getMemberChildren(members, children, constraint);
        HashMap<Object, List> tempMap = new HashMap<Object, List>();
        int n = members.size();
        for (i = 0; i < n; ++i) {
            tempMap.put(members.get(i), Collections.EMPTY_LIST);
        }
        int childrenCount = children.size();
        for (i = 0; i < childrenCount; ++i) {
            RolapMember child = (RolapMember)children.get(i);
            if (!$assertionsDisabled && child == null) {
                throw new AssertionError((Object)"child");
            }
            if (!$assertionsDisabled && tempMap == null) {
                throw new AssertionError((Object)"tempMap");
            }
            Member parentMember = child.getParentMember();
            ArrayList<RolapMember> list = (ArrayList<RolapMember>)tempMap.get(parentMember);
            if (list == null) continue;
            if (list == Collections.EMPTY_LIST) {
                list = new ArrayList<RolapMember>();
                tempMap.put(parentMember, list);
            }
            list.add(child);
            result.add(child);
        }
        SmartMemberReader smartMemberReader = this;
        synchronized (smartMemberReader) {
            Iterator keys = tempMap.keySet().iterator();
            while (keys.hasNext()) {
                RolapMember member = (RolapMember)keys.next();
                if (this.getChildrenFromCache(member, constraint) != null) continue;
                List list = (List)tempMap.get(member);
                this.putChildren(member, constraint, list);
            }
        }
    }

    public boolean isSorted(List members) {
        int count = members.size();
        if (count == 0) {
            return true;
        }
        RolapMember m1 = (RolapMember)members.get(0);
        if (m1 == null) {
            return false;
        }
        for (int i = 1; i < count; ++i) {
            RolapMember m0 = m1;
            m1 = (RolapMember)members.get(i);
            if (m1 != null && this.compare(m0, m1, false) < 0) continue;
            return false;
        }
        return true;
    }

    public synchronized List getChildrenFromCache(RolapMember member, MemberChildrenConstraint constraint) {
        if (constraint == null) {
            constraint = this.sqlConstraintFactory.getMemberChildrenConstraint(null);
        }
        return this.mapMemberToChildren.get(member, constraint);
    }

    public synchronized List getLevelMembersFromCache(RolapLevel level, TupleConstraint constraint) {
        if (constraint == null) {
            constraint = this.sqlConstraintFactory.getLevelMembersConstraint(null);
        }
        return this.mapLevelToMembers.get(level, constraint);
    }

    public synchronized void putChildren(RolapMember member, MemberChildrenConstraint constraint, List children) {
        if (constraint == null) {
            constraint = this.sqlConstraintFactory.getMemberChildrenConstraint(null);
        }
        this.mapMemberToChildren.put(member, constraint, children);
    }

    public synchronized RolapMember getLeadMember(RolapMember member, int n) {
        if (n == 0 || member.isNull()) {
            return member;
        }
        SiblingIterator iter = new SiblingIterator(this, member);
        if (n > 0) {
            RolapMember sibling = null;
            while (n-- > 0) {
                if (!iter.hasNext()) {
                    return (RolapMember)member.getHierarchy().getNullMember();
                }
                sibling = iter.nextMember();
            }
            return sibling;
        }
        n = -n;
        RolapMember sibling = null;
        while (n-- > 0) {
            if (!iter.hasPrevious()) {
                return (RolapMember)member.getHierarchy().getNullMember();
            }
            sibling = iter.previousMember();
        }
        return sibling;
    }

    public void getMemberRange(RolapLevel level, RolapMember startMember, RolapMember endMember, List list) {
        Util.assertPrecondition(startMember != null, "startMember != null");
        Util.assertPrecondition(endMember != null, "endMember != null");
        Util.assertPrecondition(startMember.getLevel() == endMember.getLevel(), "startMember.getLevel() == endMember.getLevel()");
        if (this.compare(startMember, endMember, false) > 0) {
            return;
        }
        list.add(startMember);
        if (startMember == endMember) {
            return;
        }
        SiblingIterator siblings = new SiblingIterator(this, startMember);
        while (siblings.hasNext()) {
            RolapMember member = siblings.nextMember();
            list.add(member);
            if (member != endMember) continue;
            return;
        }
        throw Util.newInternal("sibling iterator did not hit end point, start=" + startMember + ", end=" + endMember);
    }

    public int getMemberCount() {
        return this.source.getMemberCount();
    }

    public int compare(RolapMember m1, RolapMember m2, boolean siblingsAreEqual) {
        int levelDepth2;
        if (m1 == m2) {
            return 0;
        }
        if (m1.getParentMember() == m2.getParentMember()) {
            if (siblingsAreEqual) {
                return 0;
            }
            if (m1.getParentMember() == null) {
                int pos1 = -1;
                int pos2 = -1;
                List siblingList = this.getRootMembers();
                int n = siblingList.size();
                for (int i = 0; i < n; ++i) {
                    RolapMember child = (RolapMember)siblingList.get(i);
                    if (child == m1) {
                        pos1 = i;
                    }
                    if (child != m2) continue;
                    pos2 = i;
                }
                if (pos1 == -1) {
                    throw Util.newInternal(m1 + " not found among siblings");
                }
                if (pos2 == -1) {
                    throw Util.newInternal(m2 + " not found among siblings");
                }
                Util.assertTrue(pos1 != pos2);
                return pos1 < pos2 ? -1 : 1;
            }
            ArrayList children = new ArrayList();
            this.getMemberChildren((RolapMember)m1.getParentMember(), children);
            int pos1 = -1;
            int pos2 = -1;
            int n = children.size();
            for (int i = 0; i < n; ++i) {
                RolapMember child = (RolapMember)children.get(i);
                if (child == m1) {
                    pos1 = i;
                }
                if (child != m2) continue;
                pos2 = i;
            }
            if (pos1 == -1) {
                throw Util.newInternal(m1 + " not found among siblings");
            }
            if (pos2 == -1) {
                throw Util.newInternal(m2 + " not found among siblings");
            }
            Util.assertTrue(pos1 != pos2);
            return pos1 < pos2 ? -1 : 1;
        }
        int levelDepth1 = m1.getLevel().getDepth();
        if (levelDepth1 < (levelDepth2 = m2.getLevel().getDepth())) {
            int c = this.compare(m1, (RolapMember)m2.getParentMember(), false);
            return c == 0 ? -1 : c;
        }
        if (levelDepth1 > levelDepth2) {
            int c = this.compare((RolapMember)m1.getParentMember(), m2, false);
            return c == 0 ? 1 : c;
        }
        return this.compare((RolapMember)m1.getParentMember(), (RolapMember)m2.getParentMember(), false);
    }

    public TupleReader.MemberBuilder getMemberBuilder() {
        return this.source.getMemberBuilder();
    }

    static {
        $assertionsDisabled = !(class$mondrian$rolap$SmartMemberReader == null ? (class$mondrian$rolap$SmartMemberReader = SmartMemberReader.class$("mondrian.rolap.SmartMemberReader")) : class$mondrian$rolap$SmartMemberReader).desiredAssertionStatus();
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        Class<?> clazz;
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            NoClassDefFoundError noClassDefFoundError = new NoClassDefFoundError(classNotFoundException.getMessage());
            try {
                noClassDefFoundError.initCause(classNotFoundException);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
            throw noClassDefFoundError;
        }
        return clazz;
    }

    class SiblingIterator {
        private final MemberReader reader;
        private final SiblingIterator parentIterator;
        private RolapMember[] siblings;
        private int position;

        SiblingIterator(MemberReader reader, RolapMember member) {
            ArrayList siblingList;
            this.reader = reader;
            RolapMember parent = (RolapMember)member.getParentMember();
            if (parent == null) {
                siblingList = reader.getRootMembers();
                this.parentIterator = null;
            } else {
                siblingList = new ArrayList();
                reader.getMemberChildren(parent, siblingList);
                this.parentIterator = new SiblingIterator(reader, parent);
            }
            this.siblings = RolapUtil.toArray(siblingList);
            this.position = -1;
            for (int i = 0; i < this.siblings.length; ++i) {
                if (this.siblings[i] != member) continue;
                this.position = i;
                break;
            }
            if (this.position == -1) {
                throw Util.newInternal("member " + member + " not found among its siblings");
            }
        }

        boolean hasNext() {
            return this.position < this.siblings.length - 1 || this.parentIterator != null && this.parentIterator.hasNext();
        }

        Object next() {
            return this.nextMember();
        }

        RolapMember nextMember() {
            if (++this.position >= this.siblings.length) {
                if (this.parentIterator == null) {
                    throw Util.newInternal("there is no next member");
                }
                RolapMember parent = this.parentIterator.nextMember();
                ArrayList siblingList = new ArrayList();
                this.reader.getMemberChildren(parent, siblingList);
                this.siblings = RolapUtil.toArray(siblingList);
                this.position = 0;
            }
            return this.siblings[this.position];
        }

        boolean hasPrevious() {
            return this.position > 0 || this.parentIterator != null && this.parentIterator.hasPrevious();
        }

        Object previous() {
            return this.previousMember();
        }

        RolapMember previousMember() {
            if (--this.position < 0) {
                if (this.parentIterator == null) {
                    throw Util.newInternal("there is no next member");
                }
                RolapMember parent = this.parentIterator.previousMember();
                ArrayList siblingList = new ArrayList();
                this.reader.getMemberChildren(parent, siblingList);
                this.siblings = RolapUtil.toArray(siblingList);
                this.position = this.siblings.length - 1;
            }
            return this.siblings[this.position];
        }
    }
}

