/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Array;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.StringTokenizer;
import mondrian.calc.ExpCompiler;
import mondrian.olap.Evaluator;
import mondrian.olap.Member;
import mondrian.olap.MondrianProperties;
import mondrian.olap.Query;
import mondrian.olap.Util;
import mondrian.olap.fun.FunUtil;
import mondrian.resource.MondrianResource;
import mondrian.rolap.MemberReader;
import mondrian.rolap.RolapDependencyTestingEvaluator;
import mondrian.rolap.RolapLevel;
import mondrian.rolap.RolapMember;
import mondrian.rolap.RolapResult;
import org.apache.log4j.Logger;

public class RolapUtil {
    private static final Logger LOGGER = Logger.getLogger((Class)(class$mondrian$rolap$RolapUtil == null ? (class$mondrian$rolap$RolapUtil = RolapUtil.class$("mondrian.rolap.RolapUtil")) : class$mondrian$rolap$RolapUtil));
    static final RolapMember[] emptyMemberArray = new RolapMember[0];
    public static PrintWriter debugOut = null;
    public static Boolean produceDebugOut = null;
    private static Semaphore querySemaphore;
    public static final Object valueNotReadyException;
    static final ThreadLocal threadHooks;
    public static final Object sqlNullValue;
    public static final String mdxNullLiteral = "#null";
    public static final String sqlNullLiteral = "null";
    private static final HashSet loadedDrivers;
    private static final /* synthetic */ Class class$mondrian$rolap$RolapUtil;

    static final void add(List list, Object[] array) {
        for (int i = 0; i < array.length; ++i) {
            list.add(array[i]);
        }
    }

    static final RolapMember[] toArray(List v) {
        return v.isEmpty() ? emptyMemberArray : v.toArray(new RolapMember[v.size()]);
    }

    static RolapMember lookupMember(MemberReader reader, String[] uniqueNameParts, boolean failIfNotFound) {
        RolapMember rootMember;
        RolapMember member = RolapUtil.xxx(uniqueNameParts, null, reader, failIfNotFound);
        if (member != null) {
            return member;
        }
        List rootMembers = reader.getRootMembers();
        if (rootMembers.size() == 1 && (rootMember = (RolapMember)rootMembers.get(0)).isAll()) {
            member = RolapUtil.xxx(uniqueNameParts, rootMember, reader, failIfNotFound);
        }
        return member;
    }

    private static RolapMember xxx(String[] uniqueNameParts, RolapMember member, MemberReader reader, boolean failIfNotFound) {
        for (int i = 0; i < uniqueNameParts.length; ++i) {
            ArrayList children;
            String name = uniqueNameParts[i];
            if (member == null) {
                children = reader.getRootMembers();
            } else {
                children = new ArrayList();
                reader.getMemberChildren(member, children);
                member = null;
            }
            int n = children.size();
            for (int j = 0; j < n; ++j) {
                RolapMember child = (RolapMember)children.get(j);
                if (!child.getName().equals(name)) continue;
                member = child;
                break;
            }
            if (member == null) break;
        }
        if (member == null && failIfNotFound) {
            throw MondrianResource.instance().MdxCantFindMember.ex(Util.implode(uniqueNameParts));
        }
        return member;
    }

    static Object[] addElement(Object[] a, Object o) {
        Class<?> clazz = a.getClass().getComponentType();
        Object[] a2 = (Object[])Array.newInstance(clazz, a.length + 1);
        System.arraycopy(a, 0, a2, 0, a.length);
        a2[a.length] = o;
        return a2;
    }

    static Object[] addElements(Object[] a, Object[] b) {
        Class<?> clazz = a.getClass().getComponentType();
        Object[] c = (Object[])Array.newInstance(clazz, a.length + b.length);
        System.arraycopy(a, 0, c, 0, a.length);
        System.arraycopy(b, 0, c, a.length, b.length);
        return c;
    }

    public static void checkTracing() {
        if (produceDebugOut == null) {
            int trace = MondrianProperties.instance().TraceLevel.get();
            if (trace > 0) {
                String debugOutFile = MondrianProperties.instance().DebugOutFile.get();
                if (debugOutFile != null) {
                    try {
                        File f = new File(debugOutFile);
                        RolapUtil.setDebugOut(new PrintWriter(new FileOutputStream(f), true));
                    }
                    catch (Exception e) {
                        RolapUtil.setDebugOut(new PrintWriter(System.out, true));
                    }
                } else {
                    RolapUtil.setDebugOut(new PrintWriter(System.out, true));
                }
                produceDebugOut = Boolean.TRUE;
            } else {
                produceDebugOut = Boolean.FALSE;
            }
        }
    }

    public static void setDebugOut(PrintWriter pw) {
        debugOut = pw;
    }

    public static ResultSet executeQuery(Connection jdbcConnection, String sql, String component) throws SQLException {
        return RolapUtil.executeQuery(jdbcConnection, sql, -1, component, -1, -1);
    }

    public static ResultSet executeQuery(Connection jdbcConnection, String sql, int maxRows, String component, int resultSetType, int resultSetConcurrency) throws SQLException {
        ExecuteQueryHook hook;
        RolapUtil.checkTracing();
        RolapUtil.getQuerySemaphore().enter();
        Statement statement = null;
        ResultSet resultSet = null;
        String status = "failed";
        if (produceDebugOut == Boolean.TRUE) {
            debugOut.print(component + ": executing sql [" + sql + "]");
            debugOut.flush();
        }
        if ((hook = (ExecuteQueryHook)threadHooks.get()) != null) {
            hook.onExecuteQuery(sql);
        }
        try {
            long start = System.currentTimeMillis();
            statement = resultSetType < 0 || resultSetConcurrency < 0 ? jdbcConnection.createStatement() : jdbcConnection.createStatement(resultSetType, resultSetConcurrency);
            if (maxRows > 0) {
                statement.setMaxRows(maxRows);
            }
            resultSet = statement.executeQuery(sql);
            long end = System.currentTimeMillis();
            long elapsed = end - start;
            Util.addDatabaseTime(elapsed);
            status = ", " + elapsed + " ms";
            ResultSet resultSet2 = resultSet;
            return resultSet2;
        }
        catch (SQLException e) {
            status = ", failed (" + e + ")";
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException e2) {
                // empty catch block
            }
            throw (SQLException)e.fillInStackTrace();
        }
        finally {
            if (produceDebugOut == Boolean.TRUE) {
                debugOut.println(status);
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)(component + ": executing sql [" + sql + "]" + status));
            }
            RolapUtil.getQuerySemaphore().leave();
        }
    }

    public static synchronized void loadDrivers(String jdbcDrivers) {
        StringTokenizer tok = new StringTokenizer(jdbcDrivers, ",");
        while (tok.hasMoreTokens()) {
            String jdbcDriver = tok.nextToken();
            if (!loadedDrivers.add(jdbcDriver)) continue;
            try {
                Class.forName(jdbcDriver);
                LOGGER.info((Object)("Mondrian: JDBC driver " + jdbcDriver + " loaded successfully"));
            }
            catch (ClassNotFoundException e) {
                LOGGER.warn((Object)("Mondrian: Warning: JDBC driver " + jdbcDriver + " not found"));
            }
        }
    }

    public static ExpCompiler createDependencyTestingCompiler(ExpCompiler compiler) {
        return new RolapDependencyTestingEvaluator.DteCompiler(compiler);
    }

    public static Member findBestMemberMatch(Member[] members, RolapMember parent, RolapLevel level, String searchName, int matchType, boolean caseInsensitive) {
        RolapMember searchMember = new RolapMember(parent, level, searchName);
        int bestMatch = -1;
        for (int i = 0; i < members.length; ++i) {
            Member member = members[i];
            int rc = matchType == 1 ? (caseInsensitive ? Util.compareName(member.getName(), searchName) : member.getName().compareTo(searchName)) : FunUtil.compareSiblingMembers(member, searchMember);
            if (rc == 0) {
                return member;
            }
            if (matchType == 2) {
                if (rc >= 0 || bestMatch != -1 && FunUtil.compareSiblingMembers(member, members[bestMatch]) <= 0) continue;
                bestMatch = i;
                continue;
            }
            if (matchType != 3 || rc <= 0 || bestMatch != -1 && FunUtil.compareSiblingMembers(member, members[bestMatch]) >= 0) continue;
            bestMatch = i;
        }
        if (matchType != 1 && bestMatch != -1) {
            return members[bestMatch];
        }
        return null;
    }

    public static synchronized TeeWriter startTracing() {
        TeeWriter tw = debugOut == null ? new TeeWriter(new NullWriter(null)) : new TeeWriter(debugOut);
        debugOut = new PrintWriter(tw);
        return tw;
    }

    static synchronized Semaphore getQuerySemaphore() {
        if (querySemaphore == null) {
            int queryCount = MondrianProperties.instance().QueryLimit.get();
            querySemaphore = new Semaphore(queryCount);
        }
        return querySemaphore;
    }

    public static Evaluator createEvaluator(Query query) {
        RolapResult result = new RolapResult(query, false);
        return result.getRootEvaluator();
    }

    static {
        valueNotReadyException = new Double(0.0);
        threadHooks = new ThreadLocal();
        sqlNullValue = new Object(){

            public boolean equals(Object o) {
                return o == this;
            }

            public int hashCode() {
                return super.hashCode();
            }

            public String toString() {
                return RolapUtil.mdxNullLiteral;
            }
        };
        loadedDrivers = new HashSet();
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        Class<?> clazz;
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            NoClassDefFoundError noClassDefFoundError = new NoClassDefFoundError(classNotFoundException.getMessage());
            try {
                noClassDefFoundError.initCause(classNotFoundException);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
            throw noClassDefFoundError;
        }
        return clazz;
    }

    static interface ExecuteQueryHook {
        public void onExecuteQuery(String var1);
    }

    static class Semaphore {
        private int count;

        Semaphore(int count) {
            if (count < 0) {
                count = Integer.MAX_VALUE;
            }
            this.count = count;
        }

        synchronized void enter() {
            if (this.count == Integer.MAX_VALUE) {
                return;
            }
            if (this.count == 0) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    throw Util.newInternal(e, "while waiting for semaphore");
                }
            }
            Util.assertTrue(this.count > 0);
            --this.count;
        }

        synchronized void leave() {
            if (this.count == Integer.MAX_VALUE) {
                return;
            }
            ++this.count;
            this.notify();
        }
    }

    private static class NullWriter
    extends Writer {
        private NullWriter() {
        }

        public void write(char[] cbuf, int off, int len) throws IOException {
        }

        public void flush() throws IOException {
        }

        public void close() throws IOException {
        }

        NullWriter(1 x0) {
            this();
        }
    }

    public static class TeeWriter
    extends FilterWriter {
        StringWriter buf = new StringWriter();

        public TeeWriter(Writer out) {
            super(out);
        }

        public String toString() {
            return this.buf.toString();
        }

        public Writer getWriter() {
            return this.out;
        }

        public void write(int c) throws IOException {
            super.write(c);
            this.buf.write(c);
        }

        public void write(char[] cbuf) throws IOException {
            super.write(cbuf);
            this.buf.write(cbuf);
        }

        public void write(char[] cbuf, int off, int len) throws IOException {
            super.write(cbuf, off, len);
            this.buf.write(cbuf, off, len);
        }

        public void write(String str) throws IOException {
            super.write(str);
            this.buf.write(str);
        }

        public void write(String str, int off, int len) throws IOException {
            super.write(str, off, len);
            this.buf.write(str, off, len);
        }
    }
}

