/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.sql.DataSource;
import mondrian.olap.Member;
import mondrian.olap.MondrianDef;
import mondrian.olap.MondrianProperties;
import mondrian.olap.Util;
import mondrian.rolap.BitKey;
import mondrian.rolap.RolapAggregator;
import mondrian.rolap.RolapBaseCubeMeasure;
import mondrian.rolap.RolapCube;
import mondrian.rolap.RolapLevel;
import mondrian.rolap.RolapSchema;
import mondrian.rolap.RolapStoredMeasure;
import mondrian.rolap.RolapUtil;
import mondrian.rolap.agg.Aggregation;
import mondrian.rolap.agg.CellRequest;
import mondrian.rolap.agg.ColumnConstraint;
import mondrian.rolap.aggmatcher.AggStar;
import mondrian.rolap.sql.SqlQuery;
import org.apache.log4j.Logger;
import org.eigenbase.util.property.Property;
import org.eigenbase.util.property.Trigger;
import org.eigenbase.util.property.TriggerBase;

public class RolapStar {
    private static final Logger LOGGER = Logger.getLogger((Class)(class$mondrian$rolap$RolapStar == null ? (class$mondrian$rolap$RolapStar = RolapStar.class$("mondrian.rolap.RolapStar")) : class$mondrian$rolap$RolapStar));
    private static boolean disableCaching = MondrianProperties.instance().DisableCaching.get();
    private final RolapSchema schema;
    private DataSource dataSource;
    private final Table factTable;
    private final Map mapCubeToMapLevelToColumn;
    private Map aggregations;
    private int columnCount;
    private final SqlQuery.Dialect sqlQueryDialect;
    private boolean cacheAggregations = true;
    private List aggStars;
    private static final /* synthetic */ Class class$mondrian$rolap$RolapStar;

    RolapStar(RolapSchema schema, DataSource dataSource, MondrianDef.Relation fact) {
        this.schema = schema;
        this.dataSource = dataSource;
        this.factTable = new Table(this, fact, null, null, null);
        this.mapCubeToMapLevelToColumn = new HashMap();
        this.aggregations = new HashMap();
        this.clearAggStarList();
        this.sqlQueryDialect = schema.getDialect();
    }

    public int getColumnCount() {
        return this.columnCount;
    }

    private int nextColumnCount() {
        return this.columnCount++;
    }

    private int decrementColumnCount() {
        return this.columnCount--;
    }

    public void prepareToLoadAggregates() {
        this.aggStars = Collections.EMPTY_LIST;
    }

    public void addAggStar(AggStar aggStar) {
        if (this.aggStars == Collections.EMPTY_LIST) {
            this.aggStars = new LinkedList();
        }
        int size = aggStar.getSize();
        ListIterator<AggStar> lit = this.aggStars.listIterator();
        while (lit.hasNext()) {
            AggStar as = (AggStar)lit.next();
            if (as.getSize() < size) continue;
            lit.previous();
            lit.add(aggStar);
            return;
        }
        this.aggStars.add(aggStar);
    }

    void clearAggStarList() {
        this.aggStars = Collections.EMPTY_LIST;
    }

    public void reOrderAggStarList() {
        List l = this.aggStars;
        this.clearAggStarList();
        Iterator it = l.iterator();
        while (it.hasNext()) {
            AggStar aggStar = (AggStar)it.next();
            this.addAggStar(aggStar);
        }
    }

    public List getAggStars() {
        return this.aggStars;
    }

    public Table getFactTable() {
        return this.factTable;
    }

    public SqlQuery getSqlQuery() {
        return new SqlQuery(this.getSqlQueryDialect());
    }

    public SqlQuery.Dialect getSqlQueryDialect() {
        return this.sqlQueryDialect;
    }

    Map getMapLevelToColumn(RolapCube cube) {
        HashMap mapLevelToColumn = (HashMap)this.mapCubeToMapLevelToColumn.get(cube);
        if (mapLevelToColumn == null) {
            mapLevelToColumn = new HashMap();
            this.mapCubeToMapLevelToColumn.put(cube, mapLevelToColumn);
        }
        return mapLevelToColumn;
    }

    void setCacheAggregations(boolean b) {
        this.cacheAggregations = b;
        this.clearCachedAggregations(false);
    }

    boolean isCacheAggregations() {
        return this.cacheAggregations;
    }

    void clearCachedAggregations(boolean forced) {
        if (forced || !this.cacheAggregations || disableCaching) {
            if (LOGGER.isDebugEnabled()) {
                StringBuffer buf = new StringBuffer(100);
                buf.append("RolapStar.clearCachedAggregations: schema=");
                buf.append(this.schema.getName());
                buf.append(", star=");
                buf.append(this.getFactTable().getAlias());
                LOGGER.debug((Object)buf.toString());
            }
            this.aggregations.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Aggregation lookupOrCreateAggregation(BitKey bitKey) {
        Map map = this.aggregations;
        synchronized (map) {
            Aggregation aggregation = this.lookupAggregation(bitKey);
            if (aggregation == null) {
                aggregation = new Aggregation(this, bitKey);
                this.aggregations.put(bitKey, aggregation);
            }
            return aggregation;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Aggregation lookupAggregation(BitKey bitKey) {
        Map map = this.aggregations;
        synchronized (map) {
            return (Aggregation)this.aggregations.get(bitKey);
        }
    }

    public Connection getJdbcConnection() {
        Connection jdbcConnection;
        try {
            jdbcConnection = this.dataSource.getConnection();
        }
        catch (SQLException e) {
            throw Util.newInternal(e, "Error while creating connection from data source");
        }
        return jdbcConnection;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public static Measure getStarMeasure(Member member) {
        return (Measure)((RolapStoredMeasure)member).getStarMeasure();
    }

    public Column[] lookupColumns(String tableAlias, String columnName) {
        Table table = this.factTable.findDescendant(tableAlias);
        return table == null ? null : table.lookupColumns(columnName);
    }

    public Column[] lookupColumns(BitKey bitKey) {
        ArrayList list = new ArrayList();
        Table.access$200(this.factTable, bitKey, list);
        return list.toArray(new Column[0]);
    }

    public Column lookupColumn(String tableAlias, String columnName) {
        Table table = this.factTable.findDescendant(tableAlias);
        return table == null ? null : table.lookupColumn(columnName);
    }

    public List getAliasList() {
        ArrayList aliasList = new ArrayList();
        if (this.factTable != null) {
            RolapStar.collectAliases(aliasList, this.factTable);
        }
        return aliasList;
    }

    private static void collectAliases(List aliasList, Table table) {
        aliasList.add(table.getAlias());
        for (int i = 0; i < Table.access$300(table).size(); ++i) {
            Table child = (Table)Table.access$300(table).get(i);
            RolapStar.collectAliases(aliasList, child);
        }
    }

    public static void collectColumns(Collection columnList, Table table, MondrianDef.Column joinColumn) {
        if (joinColumn == null) {
            columnList.addAll(Table.access$400(table));
        }
        for (int i = 0; i < Table.access$300(table).size(); ++i) {
            Table child = (Table)Table.access$300(table).get(i);
            if (joinColumn != null && !Condition.access$500(child.getJoinCondition()).equals((Object)joinColumn)) continue;
            RolapStar.collectColumns(columnList, child, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object getCell(CellRequest request) {
        Connection jdbcConnection = this.getJdbcConnection();
        try {
            Object object = this.getCell(request, jdbcConnection);
            return object;
        }
        finally {
            try {
                jdbcConnection.close();
            }
            catch (SQLException e) {}
        }
    }

    private Object getCell(CellRequest request, Connection jdbcConnection) {
        Object[] values;
        Measure measure = request.getMeasure();
        Column[] columns = request.getConstrainedColumns();
        Util.assertTrue(columns.length == (values = request.getSingleValues()).length);
        SqlQuery sqlQuery = this.getSqlQuery();
        Util.assertTrue(measure.getTable() == this.factTable);
        this.factTable.addToFrom(sqlQuery, true, true);
        sqlQuery.addSelect(Measure.access$600(measure).getExpression(measure.generateExprString(sqlQuery)));
        for (int i = 0; i < columns.length; ++i) {
            Column column;
            Table table;
            Object value = values[i];
            if (value == null || (table = (column = columns[i]).getTable()).isFunky()) continue;
            table.addToFrom(sqlQuery, true, true);
        }
        String sql = sqlQuery.toString();
        ResultSet resultSet = null;
        try {
            resultSet = RolapUtil.executeQuery(jdbcConnection, sql, "RolapStar.getCell");
            Object o = null;
            if (resultSet.next()) {
                o = resultSet.getObject(1);
            }
            if (o == null) {
                o = Util.nullValue;
            }
            Object object = o;
            return object;
        }
        catch (SQLException e) {
            throw Util.newInternal(e, "while computing single cell; sql=[" + sql + "]");
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.getStatement().close();
                    resultSet.close();
                }
            }
            catch (SQLException e) {}
        }
    }

    private boolean containsColumn(String tableName, String columnName) {
        Connection jdbcConnection = this.getJdbcConnection();
        try {
            boolean hasNext;
            DatabaseMetaData metaData = jdbcConnection.getMetaData();
            ResultSet columns = metaData.getColumns(null, null, tableName, columnName);
            boolean bl = hasNext = columns.next();
            return bl;
        }
        catch (SQLException e) {
            throw Util.newInternal("Error while retrieving metadata for table '" + tableName + "', column '" + columnName + "'");
        }
        finally {
            try {
                jdbcConnection.close();
            }
            catch (SQLException e) {}
        }
    }

    public RolapSchema getSchema() {
        return this.schema;
    }

    public String toString() {
        StringWriter sw = new StringWriter(256);
        PrintWriter pw = new PrintWriter(sw);
        this.print(pw, "");
        pw.flush();
        return sw.toString();
    }

    public void print(PrintWriter pw, String prefix) {
        pw.print(prefix);
        pw.println("RolapStar:");
        String subprefix = prefix + "  ";
        this.factTable.print(pw, subprefix);
        Iterator it = this.getAggStars().iterator();
        while (it.hasNext()) {
            AggStar aggStar = (AggStar)it.next();
            aggStar.print(pw, subprefix);
        }
    }

    static boolean access$002(boolean x0) {
        disableCaching = x0;
        return disableCaching;
    }

    static boolean access$000() {
        return disableCaching;
    }

    static int access$800(RolapStar x0) {
        return x0.nextColumnCount();
    }

    static int access$1200(RolapStar x0) {
        return x0.decrementColumnCount();
    }

    static boolean access$1400(RolapStar x0, String x1, String x2) {
        return x0.containsColumn(x1, x2);
    }

    static {
        MondrianProperties.instance().DisableCaching.addTrigger((Trigger)new TriggerBase(true){

            public void execute(Property property, String value) {
                RolapStar.access$002(property.booleanValue());
                if (RolapStar.access$000()) {
                    RolapSchema.flushAllRolapStarCachedAggregations();
                }
            }
        });
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        Class<?> clazz;
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            NoClassDefFoundError noClassDefFoundError = new NoClassDefFoundError(classNotFoundException.getMessage());
            try {
                noClassDefFoundError.initCause(classNotFoundException);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
            throw noClassDefFoundError;
        }
        return clazz;
    }

    public static class AliasReplacer {
        private final String oldAlias;
        private final String newAlias;

        public AliasReplacer(String oldAlias, String newAlias) {
            this.oldAlias = oldAlias;
            this.newAlias = newAlias;
        }

        private Condition visit(Condition condition) {
            if (condition == null) {
                return null;
            }
            if (this.newAlias.equals(this.oldAlias)) {
                return condition;
            }
            return new Condition(this.visit(Condition.access$500(condition)), this.visit(Condition.access$1600(condition)));
        }

        public MondrianDef.Expression visit(MondrianDef.Expression expression) {
            if (expression == null) {
                return null;
            }
            if (this.newAlias.equals(this.oldAlias)) {
                return expression;
            }
            if (expression instanceof MondrianDef.Column) {
                MondrianDef.Column column = (MondrianDef.Column)expression;
                return new MondrianDef.Column(this.visit(column.table), column.name);
            }
            throw Util.newInternal("need to implement " + (Object)((Object)expression));
        }

        private String visit(String table) {
            return table.equals(this.oldAlias) ? this.newAlias : table;
        }

        static Condition access$1000(AliasReplacer x0, Condition x1) {
            return x0.visit(x1);
        }
    }

    public static class Condition {
        private static final Logger LOGGER = Logger.getLogger((Class)(class$mondrian$rolap$RolapStar$Condition == null ? (class$mondrian$rolap$RolapStar$Condition = Condition.class$("mondrian.rolap.RolapStar$Condition")) : class$mondrian$rolap$RolapStar$Condition));
        private final MondrianDef.Expression left;
        private final MondrianDef.Expression right;
        Table table;
        private static final /* synthetic */ Class class$mondrian$rolap$RolapStar$Condition;

        Condition(MondrianDef.Expression left, MondrianDef.Expression right) {
            Util.assertPrecondition(left != null);
            Util.assertPrecondition(right != null);
            if (!(left instanceof MondrianDef.Column)) {
                LOGGER.debug((Object)("Condition.left NOT Column: " + ((Object)((Object)left)).getClass().getName()));
            }
            this.left = left;
            this.right = right;
        }

        public MondrianDef.Expression getLeft() {
            return this.left;
        }

        public MondrianDef.Expression getRight() {
            return this.right;
        }

        public String toString(SqlQuery query) {
            return this.left.getExpression(query) + " = " + this.right.getExpression(query);
        }

        public int hashCode() {
            return this.left.hashCode() ^ this.right.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Condition)) {
                return false;
            }
            Condition that = (Condition)obj;
            return this.left.equals((Object)that.left) && this.right.equals((Object)that.right);
        }

        public String toString() {
            StringWriter sw = new StringWriter(256);
            PrintWriter pw = new PrintWriter(sw);
            this.print(pw, "");
            pw.flush();
            return sw.toString();
        }

        public void print(PrintWriter pw, String prefix) {
            SqlQuery sqlQueuy = Table.access$1500(this.table);
            pw.print(prefix);
            pw.println("Condition:");
            String subprefix = prefix + "  ";
            pw.print(subprefix);
            pw.print("left=");
            if (this.left instanceof MondrianDef.Column) {
                MondrianDef.Column c = (MondrianDef.Column)this.left;
                Column col = Table.access$700(this.table).getFactTable().lookupColumn(c.name);
                if (col != null) {
                    pw.print(" (");
                    pw.print(col.getBitPosition());
                    pw.print(") ");
                }
            }
            pw.println(this.left.getExpression(sqlQueuy));
            pw.print(subprefix);
            pw.print("right=");
            pw.println(this.right.getExpression(sqlQueuy));
        }

        static MondrianDef.Expression access$500(Condition x0) {
            return x0.left;
        }

        static MondrianDef.Expression access$1600(Condition x0) {
            return x0.right;
        }

        static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
            Class<?> clazz;
            try {
                clazz = Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                NoClassDefFoundError noClassDefFoundError = new NoClassDefFoundError(classNotFoundException.getMessage());
                try {
                    noClassDefFoundError.initCause(classNotFoundException);
                }
                catch (NoSuchMethodError noSuchMethodError) {
                    // empty catch block
                }
                throw noClassDefFoundError;
            }
            return clazz;
        }
    }

    public static class Table {
        private final RolapStar star;
        private final MondrianDef.Relation relation;
        private final List columnList;
        private final Table parent;
        private List children;
        private final Condition joinCondition;
        private final String alias;
        static final /* synthetic */ boolean $assertionsDisabled;
        private static final /* synthetic */ Class class$mondrian$rolap$RolapStar;

        private Table(RolapStar star, MondrianDef.Relation relation, Table parent, Condition joinCondition) {
            this.star = star;
            this.relation = relation;
            Util.assertTrue(relation instanceof MondrianDef.Table || relation instanceof MondrianDef.View, "todo: allow dimension which is not a Table or View, [" + (Object)((Object)relation) + "]");
            this.alias = this.chooseAlias();
            this.parent = parent;
            AliasReplacer aliasReplacer = new AliasReplacer(relation.getAlias(), this.alias);
            this.joinCondition = AliasReplacer.access$1000(aliasReplacer, joinCondition);
            if (this.joinCondition != null) {
                this.joinCondition.table = this;
            }
            this.columnList = new ArrayList();
            this.children = Collections.EMPTY_LIST;
            Util.assertTrue(parent == null == (joinCondition == null));
        }

        public Condition getJoinCondition() {
            return this.joinCondition;
        }

        public Table getParentTable() {
            return this.parent;
        }

        private void addColumn(Column column) {
            this.columnList.add(column);
        }

        private void collectColumns(BitKey bitKey, List list) {
            Iterator it = this.getColumns().iterator();
            while (it.hasNext()) {
                Column column = (Column)it.next();
                if (!bitKey.get(column.getBitPosition())) continue;
                list.add(column);
            }
            it = this.getChildren().iterator();
            while (it.hasNext()) {
                Table child = (Table)it.next();
                child.collectColumns(bitKey, list);
            }
        }

        public Column[] lookupColumns(String columnName) {
            ArrayList<Column> l = new ArrayList<Column>();
            Iterator it = this.getColumns().iterator();
            while (it.hasNext()) {
                Column column = (Column)it.next();
                if (!(column.getExpression() instanceof MondrianDef.Column)) continue;
                MondrianDef.Column columnExpr = (MondrianDef.Column)column.getExpression();
                if (!columnExpr.name.equals(columnName)) continue;
                l.add(column);
            }
            return l.toArray(new Column[0]);
        }

        public Column lookupColumn(String columnName) {
            Iterator it = this.getColumns().iterator();
            while (it.hasNext()) {
                Column column = (Column)it.next();
                if (!(column.getExpression() instanceof MondrianDef.Column)) continue;
                MondrianDef.Column columnExpr = (MondrianDef.Column)column.getExpression();
                if (!columnExpr.name.equals(columnName)) continue;
                return column;
            }
            return null;
        }

        public Column lookupColumnByExpression(MondrianDef.Expression xmlExpr) {
            Iterator it = this.getColumns().iterator();
            while (it.hasNext()) {
                Column column = (Column)it.next();
                if (!column.getExpression().equals((Object)xmlExpr)) continue;
                return column;
            }
            return null;
        }

        public boolean containsColumn(Column column) {
            Iterator it = this.getColumns().iterator();
            while (it.hasNext()) {
                Column other = (Column)it.next();
                if (!column.equals(other)) continue;
                return true;
            }
            return false;
        }

        public Measure lookupMeasureByName(String name) {
            Iterator it = this.getColumns().iterator();
            while (it.hasNext()) {
                Measure measure;
                Column column = (Column)it.next();
                if (!(column instanceof Measure) || !(measure = (Measure)column).getName().equals(name)) continue;
                return measure;
            }
            return null;
        }

        RolapStar getStar() {
            return this.star;
        }

        private SqlQuery getSqlQuery() {
            return this.getStar().getSqlQuery();
        }

        public MondrianDef.Relation getRelation() {
            return this.relation;
        }

        private String chooseAlias() {
            List aliasList = this.star.getAliasList();
            int i = 0;
            while (true) {
                String candidateAlias = this.relation.getAlias();
                if (i > 0) {
                    candidateAlias = candidateAlias + "_" + i;
                }
                if (!aliasList.contains(candidateAlias)) {
                    return candidateAlias;
                }
                ++i;
            }
        }

        public String getAlias() {
            return this.alias;
        }

        public String getTableName() {
            if (this.relation instanceof MondrianDef.Table) {
                MondrianDef.Table t = (MondrianDef.Table)this.relation;
                return t.name;
            }
            return null;
        }

        synchronized void makeMeasure(RolapBaseCubeMeasure measure) {
            Measure starMeasure = new Measure(measure.getName(), measure.getAggregator(), this, measure.getMondrianDefExpression(), measure.isNumeric(), null);
            measure.setStarMeasure(starMeasure);
            if (this.containsColumn(starMeasure)) {
                RolapStar.access$1200(this.star);
            } else {
                this.addColumn(starMeasure);
            }
        }

        synchronized Column makeColumns(RolapCube cube, RolapLevel level, Column parentColumn, String usagePrefix) {
            String name;
            Column column;
            Column nameColumn = null;
            if (level.getNameExp() != null) {
                nameColumn = this.makeColumnForLevelExpr(cube, level, level.getName(), level.getNameExp(), false, null, null, null);
            }
            if ((column = this.makeColumnForLevelExpr(cube, level, name = level.getNameExp() == null ? level.getName() : level.getName() + " (Key)", level.getKeyExp(), (level.getFlags() & 1) != 0, nameColumn, parentColumn, usagePrefix)) != null) {
                Map map = this.star.getMapLevelToColumn(cube);
                map.put(level, column);
            }
            return column;
        }

        private Column makeColumnForLevelExpr(RolapCube cube, RolapLevel level, String name, MondrianDef.Expression xmlExpr, boolean isNumeric, Column nameColumn, Column parentColumn, String usagePrefix) {
            Table table = this;
            if (xmlExpr instanceof MondrianDef.Column) {
                MondrianDef.Column xmlColumn = (MondrianDef.Column)xmlExpr;
                String tableName = xmlColumn.table;
                table = this.findAncestor(tableName);
                if (table == null) {
                    throw Util.newError("Level '" + level.getUniqueName() + "' of cube '" + this + "' is invalid: table '" + tableName + "' is not found in current scope" + Util.nl + ", star:" + Util.nl + this.getStar());
                }
                AliasReplacer aliasReplacer = new AliasReplacer(tableName, table.getAlias());
                xmlExpr = aliasReplacer.visit(xmlExpr);
            }
            Column c = this.lookupColumnByExpression(xmlExpr);
            Column column = null;
            if (c != null) {
                column = c;
            } else {
                column = new Column(name, table, xmlExpr, isNumeric, nameColumn, parentColumn, usagePrefix, null);
                this.addColumn(column);
            }
            return column;
        }

        synchronized Table addJoin(MondrianDef.Relation relation, Condition joinCondition) {
            if (relation instanceof MondrianDef.Table || relation instanceof MondrianDef.View) {
                Table starTable = this.findChild(relation, joinCondition);
                if (starTable == null) {
                    starTable = new Table(this.star, relation, this, joinCondition);
                    if (this.children == Collections.EMPTY_LIST) {
                        this.children = new ArrayList();
                    }
                    this.children.add(starTable);
                }
                return starTable;
            }
            if (relation instanceof MondrianDef.Join) {
                MondrianDef.Join join = (MondrianDef.Join)relation;
                Table leftTable = this.addJoin(join.left, joinCondition);
                String leftAlias = join.leftAlias;
                if (leftAlias == null && (leftAlias = join.left.getAlias()) == null) {
                    throw Util.newError("missing leftKeyAlias in " + (Object)((Object)relation));
                }
                if (!$assertionsDisabled && leftTable.findAncestor(leftAlias) != leftTable) {
                    throw new AssertionError();
                }
                leftAlias = leftTable.getAlias();
                String rightAlias = join.rightAlias;
                if (rightAlias == null && (rightAlias = join.right.getAlias()) == null) {
                    throw Util.newError("missing rightKeyAlias in " + (Object)((Object)relation));
                }
                joinCondition = new Condition(new MondrianDef.Column(leftAlias, join.leftKey), new MondrianDef.Column(rightAlias, join.rightKey));
                Table rightTable = leftTable.addJoin(join.right, joinCondition);
                return rightTable;
            }
            throw Util.newInternal("bad relation type " + (Object)((Object)relation));
        }

        public Table findChild(MondrianDef.Relation relation, Condition joinCondition) {
            Iterator it = this.getChildren().iterator();
            while (it.hasNext()) {
                Table child = (Table)it.next();
                if (!child.relation.equals((Object)relation)) continue;
                Condition condition = joinCondition;
                if (!Util.equalName(relation.getAlias(), child.alias)) {
                    AliasReplacer aliasReplacer = new AliasReplacer(relation.getAlias(), child.alias);
                    condition = AliasReplacer.access$1000(aliasReplacer, joinCondition);
                }
                if (!child.joinCondition.equals(condition)) continue;
                return child;
            }
            return null;
        }

        public Table findDescendant(String seekAlias) {
            if (this.getAlias().equals(seekAlias)) {
                return this;
            }
            Iterator it = this.getChildren().iterator();
            while (it.hasNext()) {
                Table child = (Table)it.next();
                Table found = child.findDescendant(seekAlias);
                if (found == null) continue;
                return found;
            }
            return null;
        }

        public Table findAncestor(String tableName) {
            Table t = this;
            while (t != null) {
                if (t.relation.getAlias().equals(tableName)) {
                    return t;
                }
                t = t.parent;
            }
            return null;
        }

        public boolean equalsTableName(String tableName) {
            if (this.relation instanceof MondrianDef.Table) {
                MondrianDef.Table mt = (MondrianDef.Table)this.relation;
                if (mt.name.equals(tableName)) {
                    return true;
                }
            }
            return false;
        }

        public void addToFrom(SqlQuery query, boolean failIfExists, boolean joinToParent) {
            query.addFrom(this.relation, this.alias, failIfExists);
            Util.assertTrue(this.parent == null == (this.joinCondition == null));
            if (joinToParent) {
                if (this.parent != null) {
                    this.parent.addToFrom(query, failIfExists, joinToParent);
                }
                if (this.joinCondition != null) {
                    query.addWhere(this.joinCondition.toString(query));
                }
            }
        }

        public List getChildren() {
            return this.children;
        }

        public List getColumns() {
            return this.columnList;
        }

        public Table findTableWithLeftJoinCondition(String columnName) {
            Iterator it = this.getChildren().iterator();
            while (it.hasNext()) {
                Table child = (Table)it.next();
                Condition condition = child.joinCondition;
                if (condition == null || !(Condition.access$500(condition) instanceof MondrianDef.Column)) continue;
                MondrianDef.Column mcolumn = (MondrianDef.Column)Condition.access$500(condition);
                if (!mcolumn.name.equals(columnName)) continue;
                return child;
            }
            return null;
        }

        public Table findTableWithLeftCondition(MondrianDef.Expression left) {
            Iterator it = this.getChildren().iterator();
            while (it.hasNext()) {
                MondrianDef.Column mcolumn;
                Table child = (Table)it.next();
                Condition condition = child.joinCondition;
                if (condition == null || !(Condition.access$500(condition) instanceof MondrianDef.Column) || !(mcolumn = (MondrianDef.Column)Condition.access$500(condition)).equals((Object)left)) continue;
                return child;
            }
            return null;
        }

        public boolean isFunky() {
            return this.relation == null;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Table)) {
                return false;
            }
            Table other = (Table)obj;
            return this.getAlias().equals(other.getAlias());
        }

        public int hashCode() {
            return this.getAlias().hashCode();
        }

        public String toString() {
            StringWriter sw = new StringWriter(256);
            PrintWriter pw = new PrintWriter(sw);
            this.print(pw, "");
            pw.flush();
            return sw.toString();
        }

        public void print(PrintWriter pw, String prefix) {
            pw.print(prefix);
            pw.println("Table:");
            String subprefix = prefix + "  ";
            pw.print(subprefix);
            pw.print("alias=");
            pw.println(this.getAlias());
            if (this.relation != null) {
                pw.print(subprefix);
                pw.print("relation=");
                pw.println((Object)this.relation);
            }
            pw.print(subprefix);
            pw.println("Columns:");
            String subsubprefix = subprefix + "  ";
            Iterator it = this.getColumns().iterator();
            while (it.hasNext()) {
                Column column = (Column)it.next();
                column.print(pw, subsubprefix);
                pw.println();
            }
            if (this.joinCondition != null) {
                this.joinCondition.print(pw, subprefix);
            }
            it = this.getChildren().iterator();
            while (it.hasNext()) {
                Table child = (Table)it.next();
                child.print(pw, subprefix);
            }
        }

        public boolean containsColumn(String columnName) {
            if (this.relation instanceof MondrianDef.Table) {
                return RolapStar.access$1400(this.star, ((MondrianDef.Table)this.relation).name, columnName);
            }
            return false;
        }

        Table(RolapStar x0, MondrianDef.Relation x1, Table x2, Condition x3, 1 x4) {
            this(x0, x1, x2, x3);
        }

        static void access$200(Table x0, BitKey x1, List x2) {
            x0.collectColumns(x1, x2);
        }

        static List access$300(Table x0) {
            return x0.children;
        }

        static List access$400(Table x0) {
            return x0.columnList;
        }

        static RolapStar access$700(Table x0) {
            return x0.star;
        }

        static SqlQuery access$1500(Table x0) {
            return x0.getSqlQuery();
        }

        static {
            $assertionsDisabled = !(class$mondrian$rolap$RolapStar == null ? (class$mondrian$rolap$RolapStar = Table.class$("mondrian.rolap.RolapStar")) : class$mondrian$rolap$RolapStar).desiredAssertionStatus();
        }

        static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
            Class<?> clazz;
            try {
                clazz = Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                NoClassDefFoundError noClassDefFoundError = new NoClassDefFoundError(classNotFoundException.getMessage());
                try {
                    noClassDefFoundError.initCause(classNotFoundException);
                }
                catch (NoSuchMethodError noSuchMethodError) {
                    // empty catch block
                }
                throw noClassDefFoundError;
            }
            return clazz;
        }
    }

    public static class Measure
    extends Column {
        private final RolapAggregator aggregator;

        private Measure(String name, RolapAggregator aggregator, Table table, MondrianDef.Expression expression, boolean isNumeric) {
            super(name, table, expression, isNumeric, null);
            this.aggregator = aggregator;
        }

        public RolapAggregator getAggregator() {
            return this.aggregator;
        }

        public boolean equals(Object obj) {
            if (!super.equals(obj)) {
                return false;
            }
            if (!(obj instanceof Measure)) {
                return false;
            }
            Measure other = (Measure)obj;
            return other.aggregator == this.aggregator;
        }

        public void print(PrintWriter pw, String prefix) {
            SqlQuery sqlQuery = this.getSqlQuery();
            pw.print(prefix);
            pw.print(this.getName());
            pw.print(" (");
            pw.print(this.getBitPosition());
            pw.print("): ");
            pw.print(this.aggregator.getExpression(this.generateExprString(sqlQuery)));
        }

        static RolapAggregator access$600(Measure x0) {
            return x0.aggregator;
        }

        Measure(String x0, RolapAggregator x1, Table x2, MondrianDef.Expression x3, boolean x4, 1 x5) {
            this(x0, x1, x2, x3, x4);
        }
    }

    public static class Column {
        private final Table table;
        private final MondrianDef.Expression expression;
        private final boolean isNumeric;
        private final String name;
        private final Column parentColumn;
        private final String usagePrefix;
        private final Column nameColumn;
        private boolean isNameColumn;
        private final int bitPosition;
        private int cardinality = -1;

        private Column(String name, Table table, MondrianDef.Expression expression, boolean isNumeric) {
            this(name, table, expression, isNumeric, null, null, null);
        }

        private Column(String name, Table table, MondrianDef.Expression expression, boolean isNumeric, Column nameColumn, Column parentColumn, String usagePrefix) {
            this.name = name;
            this.table = table;
            this.expression = expression;
            this.isNumeric = isNumeric;
            this.bitPosition = RolapStar.access$800(Table.access$700(table));
            this.nameColumn = nameColumn;
            this.parentColumn = parentColumn;
            this.usagePrefix = usagePrefix;
            if (nameColumn != null) {
                nameColumn.isNameColumn = true;
            }
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Column)) {
                return false;
            }
            Column other = (Column)obj;
            return other.table == this.table && other.expression.equals((Object)this.expression) && other.isNumeric == this.isNumeric && other.name.equals(this.name);
        }

        public String getName() {
            return this.name;
        }

        public boolean isNumeric() {
            return this.isNumeric;
        }

        public int getBitPosition() {
            return this.bitPosition;
        }

        public RolapStar getStar() {
            return Table.access$700(this.table);
        }

        public Table getTable() {
            return this.table;
        }

        public SqlQuery getSqlQuery() {
            return this.getTable().getStar().getSqlQuery();
        }

        public Column getNameColumn() {
            return this.nameColumn;
        }

        public Column getParentColumn() {
            return this.parentColumn;
        }

        public String getUsagePrefix() {
            return this.usagePrefix;
        }

        public boolean isNameColumn() {
            return this.isNameColumn;
        }

        public MondrianDef.Expression getExpression() {
            return this.expression;
        }

        public String generateExprString(SqlQuery query) {
            return this.getExpression().getExpression(query);
        }

        private static void quoteValue(Object o, StringBuffer buf, boolean isNumeric) {
            String s = o.toString();
            if (isNumeric) {
                buf.append(s);
            } else if (s == null) {
                buf.append("NULL");
            } else {
                Util.singleQuoteString(s, buf);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getCardinality() {
            if (this.cardinality == -1) {
                Connection jdbcConnection = this.getStar().getJdbcConnection();
                try {
                    this.cardinality = this.getCardinality(jdbcConnection);
                }
                finally {
                    try {
                        jdbcConnection.close();
                    }
                    catch (SQLException sQLException) {}
                }
            }
            return this.cardinality;
        }

        private int getCardinality(Connection jdbcConnection) {
            int joinToParent;
            SqlQuery sqlQuery = this.getSqlQuery();
            if (sqlQuery.getDialect().allowsCountDistinct()) {
                sqlQuery.addSelect("count(distinct " + this.generateExprString(sqlQuery) + ")");
                this.table.addToFrom(sqlQuery, true, false);
            } else if (sqlQuery.getDialect().allowsFromQuery()) {
                SqlQuery inner = sqlQuery.cloneEmpty();
                inner.setDistinct(true);
                inner.addSelect(this.generateExprString(inner));
                boolean failIfExists = true;
                joinToParent = 0;
                this.table.addToFrom(inner, failIfExists, joinToParent != 0);
                sqlQuery.addSelect("count(*)");
                sqlQuery.addFrom(inner, "init", failIfExists);
            } else {
                throw Util.newInternal("Cannot compute cardinality: this database neither supports COUNT DISTINCT nor SELECT in the FROM clause.");
            }
            String sql = sqlQuery.toString();
            ResultSet resultSet = null;
            try {
                resultSet = RolapUtil.executeQuery(jdbcConnection, sql, "RolapStar.Column.getCardinality");
                Util.assertTrue(resultSet.next());
                joinToParent = resultSet.getInt(1);
                return joinToParent;
            }
            catch (SQLException e) {
                throw Util.newInternal(e, "while counting distinct values of column '" + this.expression.getGenericExpression() + "'; sql=[" + sql + "]");
            }
            finally {
                try {
                    if (resultSet != null) {
                        resultSet.getStatement().close();
                        resultSet.close();
                    }
                }
                catch (SQLException e) {}
            }
        }

        public static String createInExpr(String expr, ColumnConstraint[] constraints, boolean isNumeric) {
            ColumnConstraint constraint;
            Object key;
            if (constraints.length == 1 && (key = (constraint = constraints[0]).getValue()) != RolapUtil.sqlNullValue) {
                StringBuffer buf = new StringBuffer(64);
                buf.append(expr);
                buf.append(" = ");
                Column.quoteValue(key, buf, isNumeric);
                return buf.toString();
            }
            int notNullCount = 0;
            StringBuffer sb = new StringBuffer(expr);
            sb.append(" in (");
            for (int i = 0; i < constraints.length; ++i) {
                ColumnConstraint constraint2 = constraints[i];
                Object key2 = constraint2.getValue();
                if (key2 == RolapUtil.sqlNullValue) continue;
                if (notNullCount > 0) {
                    sb.append(", ");
                }
                ++notNullCount;
                Column.quoteValue(key2, sb, isNumeric);
            }
            sb.append(')');
            if (notNullCount < constraints.length) {
                switch (notNullCount) {
                    case 0: {
                        return expr + " is null";
                    }
                    case 1: {
                        StringBuffer buf = new StringBuffer(64);
                        buf.append('(');
                        buf.append(expr);
                        buf.append(" = ");
                        Column.quoteValue(constraints[0].getValue(), buf, isNumeric);
                        buf.append(" or ");
                        buf.append(expr);
                        buf.append(" is null)");
                        return buf.toString();
                    }
                }
                StringBuffer buf = new StringBuffer(64);
                buf.append('(');
                buf.append(sb.toString());
                buf.append(" or ");
                buf.append(expr);
                buf.append(" is null)");
                return buf.toString();
            }
            return sb.toString();
        }

        public String toString() {
            StringWriter sw = new StringWriter(256);
            PrintWriter pw = new PrintWriter(sw);
            this.print(pw, "");
            pw.flush();
            return sw.toString();
        }

        public void print(PrintWriter pw, String prefix) {
            SqlQuery sqlQuery = this.getSqlQuery();
            pw.print(prefix);
            pw.print(this.getName());
            pw.print(" (");
            pw.print(this.getBitPosition());
            pw.print("): ");
            pw.print(this.generateExprString(sqlQuery));
        }

        Column(String x0, Table x1, MondrianDef.Expression x2, boolean x3, 1 x4) {
            this(x0, x1, x2, x3);
        }

        Column(String x0, Table x1, MondrianDef.Expression x2, boolean x3, Column x4, Column x5, String x6, 1 x7) {
            this(x0, x1, x2, x3, x4, x5, x6);
        }
    }
}

