/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import com.rc.retroweaver.runtime.Arrays;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import mondrian.calc.Calc;
import mondrian.calc.DummyExp;
import mondrian.calc.ExpCompiler;
import mondrian.calc.impl.AbstractCalc;
import mondrian.calc.impl.GenericCalc;
import mondrian.olap.Cube;
import mondrian.olap.Evaluator;
import mondrian.olap.Exp;
import mondrian.olap.FunDef;
import mondrian.olap.Hierarchy;
import mondrian.olap.Level;
import mondrian.olap.Literal;
import mondrian.olap.Member;
import mondrian.olap.MondrianProperties;
import mondrian.olap.NamedSet;
import mondrian.olap.NativeEvaluator;
import mondrian.olap.OlapElement;
import mondrian.olap.Parameter;
import mondrian.olap.ParameterImpl;
import mondrian.olap.Role;
import mondrian.olap.SchemaReader;
import mondrian.olap.Util;
import mondrian.olap.type.StringType;
import mondrian.rolap.MemberCache;
import mondrian.rolap.MemberReader;
import mondrian.rolap.RolapEvaluator;
import mondrian.rolap.RolapHierarchy;
import mondrian.rolap.RolapLevel;
import mondrian.rolap.RolapMember;
import mondrian.rolap.RolapSchema;
import mondrian.rolap.RolapSchemaParameter;
import mondrian.rolap.RolapUtil;
import mondrian.rolap.SqlConstraintFactory;
import mondrian.rolap.sql.MemberChildrenConstraint;
import mondrian.rolap.sql.TupleConstraint;
import org.apache.log4j.Logger;
import org.eigenbase.util.property.Property;

public abstract class RolapSchemaReader
implements SchemaReader {
    private final Role role;
    private final Map hierarchyReaders = new HashMap();
    private final RolapSchema schema;
    private final SqlConstraintFactory sqlConstraintFactory = SqlConstraintFactory.instance();
    private static final Logger LOGGER;
    static final /* synthetic */ boolean $assertionsDisabled;
    private static final /* synthetic */ Class class$mondrian$rolap$RolapSchemaReader;

    RolapSchemaReader(Role role, RolapSchema schema) {
        if (!$assertionsDisabled && role == null) {
            throw new AssertionError((Object)"precondition: role != null");
        }
        this.role = role;
        this.schema = schema;
    }

    public Role getRole() {
        return this.role;
    }

    public Member[] getHierarchyRootMembers(Hierarchy hierarchy) {
        Level firstLevel;
        Role.HierarchyAccess hierarchyAccess = this.role.getAccessDetails(hierarchy);
        if (hierarchyAccess == null) {
            firstLevel = hierarchy.getLevels()[0];
        } else {
            firstLevel = hierarchyAccess.getTopLevel();
            if (firstLevel == null) {
                firstLevel = hierarchy.getLevels()[0];
            }
        }
        return this.getLevelMembers(firstLevel, true);
    }

    synchronized MemberReader getMemberReader(Hierarchy hierarchy) {
        MemberReader memberReader = (MemberReader)this.hierarchyReaders.get(hierarchy);
        if (memberReader == null) {
            memberReader = ((RolapHierarchy)hierarchy).getMemberReader(this.role);
            this.hierarchyReaders.put(hierarchy, memberReader);
        }
        return memberReader;
    }

    public void getMemberRange(Level level, Member startMember, Member endMember, List list) {
        this.getMemberReader(level.getHierarchy()).getMemberRange((RolapLevel)level, (RolapMember)startMember, (RolapMember)endMember, list);
    }

    public int compareMembersHierarchically(Member m1, Member m2) {
        RolapHierarchy hierarchy = (RolapHierarchy)m1.getHierarchy();
        Util.assertPrecondition(hierarchy == m2.getHierarchy());
        return this.getMemberReader(hierarchy).compare((RolapMember)m1, (RolapMember)m2, true);
    }

    public Member getMemberParent(Member member) {
        Role.HierarchyAccess hierarchyAccess;
        Member parentMember;
        for (parentMember = member.getParentMember(); parentMember != null && parentMember.isHidden(); parentMember = parentMember.getParentMember()) {
        }
        if (parentMember != null && (hierarchyAccess = this.role.getAccessDetails(member.getHierarchy())) != null && hierarchyAccess.getAccess(parentMember) == 1) {
            return null;
        }
        return parentMember;
    }

    public int getMemberDepth(Member member) {
        Role.HierarchyAccess hierarchyAccess = this.role.getAccessDetails(member.getHierarchy());
        if (hierarchyAccess != null) {
            int memberDepth = member.getLevel().getDepth();
            Level topLevel = hierarchyAccess.getTopLevel();
            if (topLevel != null) {
                memberDepth -= topLevel.getDepth();
            }
            return memberDepth;
        }
        if (((RolapLevel)member.getLevel()).isParentChild()) {
            int depth = 0;
            for (Member m = member.getParentMember(); m != null; m = m.getParentMember()) {
                ++depth;
            }
            return depth;
        }
        return member.getLevel().getDepth();
    }

    public Member[] getMemberChildren(Member member) {
        return this.getMemberChildren(member, null);
    }

    public Member[] getMemberChildren(Member member, Evaluator context) {
        MemberChildrenConstraint constraint = this.sqlConstraintFactory.getMemberChildrenConstraint(context);
        return this.internalGetMemberChildren(member, constraint);
    }

    private Member[] internalGetMemberChildren(Member member, MemberChildrenConstraint constraint) {
        ArrayList children = new ArrayList();
        Hierarchy hierarchy = member.getHierarchy();
        MemberReader memberReader = this.getMemberReader(hierarchy);
        memberReader.getMemberChildren((RolapMember)member, children, constraint);
        return RolapUtil.toArray(children);
    }

    public int getChildrenCountFromCache(Member member) {
        Hierarchy hierarchy = member.getHierarchy();
        MemberReader memberReader = this.getMemberReader(hierarchy);
        if (!(memberReader instanceof MemberCache)) {
            return -1;
        }
        List list = ((MemberCache)((Object)memberReader)).getChildrenFromCache((RolapMember)member, null);
        if (list == null) {
            return -1;
        }
        return list.size();
    }

    private int getLevelCardinalityFromCache(Level level) {
        Hierarchy hierarchy = level.getHierarchy();
        MemberReader memberReader = this.getMemberReader(hierarchy);
        if (!(memberReader instanceof MemberCache)) {
            return Integer.MIN_VALUE;
        }
        List list = ((MemberCache)((Object)memberReader)).getLevelMembersFromCache((RolapLevel)level, null);
        if (list == null) {
            return Integer.MIN_VALUE;
        }
        return list.size();
    }

    public int getLevelCardinality(Level level, boolean approximate, boolean materialize) {
        int rowCount = Integer.MIN_VALUE;
        if (approximate) {
            rowCount = level.getApproxRowCount();
        }
        if (rowCount == Integer.MIN_VALUE) {
            rowCount = this.getLevelCardinalityFromCache(level);
        }
        if (rowCount == Integer.MIN_VALUE && materialize) {
            rowCount = this.getLevelMembers(level, false).length;
            ((RolapLevel)level).setApproxRowCount(rowCount);
        }
        return rowCount;
    }

    public Member[] getMemberChildren(Member[] members) {
        return this.getMemberChildren(members, null);
    }

    public Member[] getMemberChildren(Member[] members, Evaluator context) {
        if (members.length == 0) {
            return RolapUtil.emptyMemberArray;
        }
        MemberChildrenConstraint constraint = this.sqlConstraintFactory.getMemberChildrenConstraint(context);
        Hierarchy hierarchy = members[0].getHierarchy();
        MemberReader memberReader = this.getMemberReader(hierarchy);
        ArrayList children = new ArrayList();
        memberReader.getMemberChildren(Arrays.asList((Object[])members), children, constraint);
        return RolapUtil.toArray(children);
    }

    public abstract Cube getCube();

    public OlapElement getElementChild(OlapElement parent, String name) {
        return this.getElementChild(parent, name, 1);
    }

    public OlapElement getElementChild(OlapElement parent, String name, int matchType) {
        return parent.lookupChild(this, name, matchType);
    }

    public Member getMemberByUniqueName(String[] uniqueNameParts, boolean failIfNotFound) {
        return this.getMemberByUniqueName(uniqueNameParts, failIfNotFound, 1);
    }

    public Member getMemberByUniqueName(String[] uniqueNameParts, boolean failIfNotFound, int matchType) {
        return null;
    }

    public OlapElement lookupCompound(OlapElement parent, String[] names, boolean failIfNotFound, int category) {
        return this.lookupCompound(parent, names, failIfNotFound, category, 1);
    }

    public OlapElement lookupCompound(OlapElement parent, String[] names, boolean failIfNotFound, int category, int matchType) {
        return Util.lookupCompound(this, parent, names, failIfNotFound, category, matchType);
    }

    public Member lookupMemberChildByName(Member parent, String childName) {
        return this.lookupMemberChildByName(parent, childName, 1);
    }

    public Member lookupMemberChildByName(Member parent, String childName, int matchType) {
        LOGGER.debug((Object)("looking for child \"" + childName + "\" of " + parent));
        try {
            MemberChildrenConstraint constraint = matchType == 1 ? this.sqlConstraintFactory.getChildByNameConstraint((RolapMember)parent, childName) : this.sqlConstraintFactory.getMemberChildrenConstraint(null);
            Member[] children = this.internalGetMemberChildren(parent, constraint);
            if (children.length > 0) {
                return RolapUtil.findBestMemberMatch(children, (RolapMember)parent, ((RolapMember)children[0]).getRolapLevel(), childName, matchType, true);
            }
        }
        catch (NumberFormatException e) {
            LOGGER.debug((Object)("NumberFormatException in lookupMemberChildByName for parent = \"" + parent + "\", childName=\"" + childName + "\", exception: " + e.getMessage()));
        }
        return null;
    }

    public Member getCalculatedMember(String[] nameParts) {
        return null;
    }

    public NamedSet getNamedSet(String[] nameParts) {
        if (nameParts.length != 1) {
            return null;
        }
        String name = nameParts[0];
        return this.schema.getNamedSet(name);
    }

    public Member getLeadMember(Member member, int n) {
        MemberReader memberReader = this.getMemberReader(member.getHierarchy());
        return memberReader.getLeadMember((RolapMember)member, n);
    }

    public Member[] getLevelMembers(Level level, boolean includeCalculated) {
        return this.getLevelMembers(level, null);
    }

    public Member[] getLevelMembers(Level level, Evaluator context) {
        TupleConstraint constraint = this.sqlConstraintFactory.getLevelMembersConstraint(context, new Level[]{level});
        MemberReader memberReader = this.getMemberReader(level.getHierarchy());
        List membersInLevel = memberReader.getMembersInLevel((RolapLevel)level, 0, Integer.MAX_VALUE, constraint);
        return RolapUtil.toArray(membersInLevel);
    }

    public Level[] getHierarchyLevels(Hierarchy hierarchy) {
        Util.assertPrecondition(hierarchy != null, "hierarchy != null");
        Role.HierarchyAccess hierarchyAccess = this.role.getAccessDetails(hierarchy);
        Level[] levels = hierarchy.getLevels();
        if (hierarchyAccess == null) {
            return levels;
        }
        Level topLevel = hierarchyAccess.getTopLevel();
        Level bottomLevel = hierarchyAccess.getBottomLevel();
        if (topLevel == null && bottomLevel == null) {
            return levels;
        }
        if (topLevel == null) {
            topLevel = levels[0];
        }
        if (bottomLevel == null) {
            bottomLevel = levels[levels.length - 1];
        }
        int levelCount = bottomLevel.getDepth() - topLevel.getDepth() + 1;
        Level[] restrictedLevels = new Level[levelCount];
        System.arraycopy(levels, topLevel.getDepth(), restrictedLevels, 0, levelCount);
        Util.assertPostcondition(restrictedLevels.length >= 1, "return.length >= 1");
        return restrictedLevels;
    }

    public Member getHierarchyDefaultMember(Hierarchy hierarchy) {
        Util.assertPrecondition(hierarchy != null, "hierarchy != null");
        Member defaultMember = hierarchy.getDefaultMember();
        if (!(this.role.getAccess(hierarchy) == 1 || defaultMember != null && this.role.canAccess(defaultMember))) {
            Member[] rootMembers = this.getHierarchyRootMembers(hierarchy);
            defaultMember = rootMembers.length > 0 ? rootMembers[0] : null;
        }
        return defaultMember;
    }

    public boolean isDrillable(Member member) {
        RolapLevel level = (RolapLevel)member.getLevel();
        if (level.getParentExp() != null) {
            return this.getMemberChildren(member).length > 0;
        }
        Level childLevel = level.getChildLevel();
        return childLevel != null && this.role.getAccess(childLevel) != 1;
    }

    public boolean isVisible(Member member) {
        return !member.isHidden() && this.role.canAccess(member);
    }

    public Cube[] getCubes() {
        Cube[] cubes = this.schema.getCubes();
        ArrayList<Cube> visibleCubes = new ArrayList<Cube>(cubes.length);
        for (int idx = 0; idx < cubes.length; ++idx) {
            if (!this.role.canAccess(cubes[idx])) continue;
            visibleCubes.add(cubes[idx]);
        }
        Cube[] result = new Cube[visibleCubes.size()];
        visibleCubes.toArray(result);
        return result;
    }

    public List getCalculatedMembers(Hierarchy hierarchy) {
        return Collections.EMPTY_LIST;
    }

    public List getCalculatedMembers(Level level) {
        return Collections.EMPTY_LIST;
    }

    public List getCalculatedMembers() {
        return Collections.EMPTY_LIST;
    }

    public NativeEvaluator getNativeSetEvaluator(FunDef fun, Exp[] args, Evaluator evaluator, Calc calc) {
        RolapEvaluator revaluator = (RolapEvaluator)AbstractCalc.simplifyEvaluator(calc, evaluator);
        return this.schema.getNativeRegistry().createEvaluator(revaluator, fun, args);
    }

    public Parameter getParameter(String name) {
        for (int i = 0; i < this.schema.parameterList.size(); ++i) {
            RolapSchemaParameter parameter = (RolapSchemaParameter)this.schema.parameterList.get(i);
            if (!Util.equalName(parameter.getName(), name)) continue;
            return parameter;
        }
        List propertyList = MondrianProperties.instance().getPropertyList();
        for (int i = 0; i < propertyList.size(); ++i) {
            Property property = (Property)propertyList.get(i);
            if (!property.getPath().equals(name)) continue;
            return new SystemPropertyParameter(name, false);
        }
        if (System.getProperty(name) != null) {
            return new SystemPropertyParameter(name, true);
        }
        return null;
    }

    public DataSource getDataSource() {
        return this.schema.getInternalConnection().getDataSource();
    }

    RolapSchema getSchema() {
        return this.schema;
    }

    static {
        $assertionsDisabled = !(class$mondrian$rolap$RolapSchemaReader == null ? (class$mondrian$rolap$RolapSchemaReader = RolapSchemaReader.class$("mondrian.rolap.RolapSchemaReader")) : class$mondrian$rolap$RolapSchemaReader).desiredAssertionStatus();
        LOGGER = Logger.getLogger((Class)(class$mondrian$rolap$RolapSchemaReader == null ? (class$mondrian$rolap$RolapSchemaReader = RolapSchemaReader.class$("mondrian.rolap.RolapSchemaReader")) : class$mondrian$rolap$RolapSchemaReader));
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        Class<?> clazz;
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            NoClassDefFoundError noClassDefFoundError = new NoClassDefFoundError(classNotFoundException.getMessage());
            try {
                noClassDefFoundError.initCause(classNotFoundException);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
            throw noClassDefFoundError;
        }
        return clazz;
    }

    private static class SystemPropertyParameter
    extends ParameterImpl {
        private final boolean system;
        private final Property propertyDefinition;

        public SystemPropertyParameter(String name, boolean system) {
            super(name, Literal.nullValue, "System property '" + name + "'", new StringType());
            this.system = system;
            this.propertyDefinition = system ? null : MondrianProperties.instance().getPropertyDefinition(name);
        }

        public Parameter.Scope getScope() {
            return Parameter.Scope.System;
        }

        public boolean isModifiable() {
            return false;
        }

        public Calc compile(ExpCompiler compiler) {
            return new GenericCalc(new DummyExp(this.getType())){

                public Calc[] getCalcs() {
                    return new Calc[0];
                }

                public Object evaluate(Evaluator evaluator) {
                    if (SystemPropertyParameter.access$000(SystemPropertyParameter.this)) {
                        String name = SystemPropertyParameter.this.getName();
                        return System.getProperty(name);
                    }
                    return SystemPropertyParameter.access$100(SystemPropertyParameter.this).stringValue();
                }
            };
        }

        static boolean access$000(SystemPropertyParameter x0) {
            return x0.system;
        }

        static Property access$100(SystemPropertyParameter x0) {
            return x0.propertyDefinition;
        }
    }
}

