/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import mondrian.mdx.MemberExpr;
import mondrian.olap.Exp;
import mondrian.olap.FunCall;
import mondrian.olap.Literal;
import mondrian.olap.Member;
import mondrian.rolap.RolapCalculatedMember;
import mondrian.rolap.RolapStar;
import mondrian.rolap.RolapStoredMeasure;
import mondrian.rolap.sql.SqlQuery;

public class RolapNativeSql {
    private SqlQuery sqlQuery;
    private SqlQuery.Dialect dialect;
    CompositeSqlCompiler numericCompiler;
    CompositeSqlCompiler booleanCompiler;
    RolapStoredMeasure storedMeasure;

    private boolean saveStoredMeasure(RolapStoredMeasure m) {
        RolapStar star2;
        RolapStar star1;
        if (this.storedMeasure != null && (star1 = this.getStar(this.storedMeasure)) != (star2 = this.getStar(m))) {
            return false;
        }
        this.storedMeasure = m;
        return true;
    }

    private RolapStar getStar(RolapStoredMeasure m) {
        return ((RolapStar.Measure)m.getStarMeasure()).getStar();
    }

    RolapNativeSql(SqlQuery sqlQuery) {
        this.sqlQuery = sqlQuery;
        this.dialect = sqlQuery.getDialect();
        this.numericCompiler = new CompositeSqlCompiler();
        this.booleanCompiler = new CompositeSqlCompiler();
        this.numericCompiler.add(new NumberSqlCompiler());
        this.numericCompiler.add(new StoredMeasureSqlCompiler());
        this.numericCompiler.add(new CalculatedMemberSqlCompiler(this.numericCompiler));
        this.numericCompiler.add(new ParenthesisSqlCompiler(7, this.numericCompiler));
        this.numericCompiler.add(new InfixOpSqlCompiler(7, "+", "+", this.numericCompiler));
        this.numericCompiler.add(new InfixOpSqlCompiler(7, "-", "-", this.numericCompiler));
        this.numericCompiler.add(new InfixOpSqlCompiler(7, "/", "/", this.numericCompiler));
        this.numericCompiler.add(new InfixOpSqlCompiler(7, "*", "*", this.numericCompiler));
        this.numericCompiler.add(new IifSqlCompiler(7, this.numericCompiler));
        this.booleanCompiler.add(new InfixOpSqlCompiler(5, "<", "<", this.numericCompiler));
        this.booleanCompiler.add(new InfixOpSqlCompiler(5, "<=", "<=", this.numericCompiler));
        this.booleanCompiler.add(new InfixOpSqlCompiler(5, ">", ">", this.numericCompiler));
        this.booleanCompiler.add(new InfixOpSqlCompiler(5, ">=", ">=", this.numericCompiler));
        this.booleanCompiler.add(new InfixOpSqlCompiler(5, "=", "=", this.numericCompiler));
        this.booleanCompiler.add(new InfixOpSqlCompiler(5, "<>", "<>", this.numericCompiler));
        this.booleanCompiler.add(new InfixOpSqlCompiler(5, "and", "AND", this.booleanCompiler));
        this.booleanCompiler.add(new InfixOpSqlCompiler(5, "or", "OR", this.booleanCompiler));
        this.booleanCompiler.add(new UnaryOpSqlCompiler(5, "not", "NOT", this.booleanCompiler));
        this.booleanCompiler.add(new ParenthesisSqlCompiler(5, this.booleanCompiler));
        this.booleanCompiler.add(new IifSqlCompiler(5, this.booleanCompiler));
    }

    public String generateTopCountOrderBy(Exp exp) {
        return this.numericCompiler.compile(exp);
    }

    public String generateFilterCondition(Exp exp) {
        return this.booleanCompiler.compile(exp);
    }

    public RolapStoredMeasure getStoredMeasure() {
        return this.storedMeasure;
    }

    static SqlQuery.Dialect access$000(RolapNativeSql x0) {
        return x0.dialect;
    }

    static boolean access$100(RolapNativeSql x0, RolapStoredMeasure x1) {
        return x0.saveStoredMeasure(x1);
    }

    static SqlQuery access$200(RolapNativeSql x0) {
        return x0.sqlQuery;
    }

    class IifSqlCompiler
    extends FunCallSqlCompilerBase {
        SqlCompiler valueCompiler;

        IifSqlCompiler(int category, SqlCompiler valueCompiler) {
            super(category, "iif", 3);
            this.valueCompiler = valueCompiler;
        }

        public String compile(Exp exp) {
            if (!this.match(exp)) {
                return null;
            }
            Exp[] args = ((FunCall)exp).getArgs();
            String cond = RolapNativeSql.this.booleanCompiler.compile(args[0]);
            String val1 = this.valueCompiler.compile(args[1]);
            String val2 = this.valueCompiler.compile(args[2]);
            if (cond == null || val1 == null || val2 == null) {
                return null;
            }
            return RolapNativeSql.access$200(RolapNativeSql.this).getDialect().caseWhenElse(cond, val1, val2);
        }
    }

    class InfixOpSqlCompiler
    extends FunCallSqlCompilerBase {
        private final String sql;
        private final SqlCompiler compiler;

        protected InfixOpSqlCompiler(int category, String mdx, String sql, SqlCompiler argumentCompiler) {
            super(category, mdx, 2);
            this.sql = sql;
            this.compiler = argumentCompiler;
        }

        public String compile(Exp exp) {
            String[] args = this.compileArgs(exp, this.compiler);
            if (args == null) {
                return null;
            }
            return "(" + args[0] + " " + this.sql + " " + args[1] + ")";
        }

        public String toString() {
            return "InfixSqlCompiler[" + this.mdx + "]";
        }
    }

    class ParenthesisSqlCompiler
    extends FunCallSqlCompiler {
        protected ParenthesisSqlCompiler(int category, SqlCompiler argumentCompiler) {
            super(category, "()", "", 1, argumentCompiler);
        }

        public String toString() {
            return "ParenthesisSqlCompiler";
        }
    }

    class UnaryOpSqlCompiler
    extends FunCallSqlCompiler {
        protected UnaryOpSqlCompiler(int category, String mdx, String sql, SqlCompiler argumentCompiler) {
            super(category, mdx, sql, 1, argumentCompiler);
        }
    }

    class FunCallSqlCompiler
    extends FunCallSqlCompilerBase {
        SqlCompiler compiler;
        String sql;

        protected FunCallSqlCompiler(int category, String mdx, String sql, int argCount, SqlCompiler argumentCompiler) {
            super(category, mdx, argCount);
            this.sql = sql;
            this.compiler = argumentCompiler;
        }

        public String compile(Exp exp) {
            String[] args = this.compileArgs(exp, this.compiler);
            if (args == null) {
                return null;
            }
            StringBuffer sb = new StringBuffer();
            sb.append(this.sql);
            sb.append("(");
            for (int i = 0; i < args.length; ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(args[i]);
            }
            sb.append(") ");
            return sb.toString();
        }

        public String toString() {
            return "FunCallSqlCompiler[" + this.mdx + "]";
        }
    }

    abstract class FunCallSqlCompilerBase
    implements SqlCompiler {
        int category;
        String mdx;
        int argCount;

        FunCallSqlCompilerBase(int category, String mdx, int argCount) {
            this.category = category;
            this.mdx = mdx;
            this.argCount = argCount;
        }

        protected boolean match(Exp exp) {
            if ((exp.getCategory() & this.category) == 0) {
                return false;
            }
            if (!(exp instanceof FunCall)) {
                return false;
            }
            FunCall fc = (FunCall)exp;
            if (!this.mdx.equalsIgnoreCase(fc.getFunName())) {
                return false;
            }
            Exp[] args = fc.getArgs();
            return args.length == this.argCount;
        }

        protected String[] compileArgs(Exp exp, SqlCompiler compiler) {
            if (!this.match(exp)) {
                return null;
            }
            Exp[] args = ((FunCall)exp).getArgs();
            String[] sqls = new String[args.length];
            for (int i = 0; i < args.length; ++i) {
                sqls[i] = compiler.compile(args[i]);
                if (sqls[i] != null) continue;
                return null;
            }
            return sqls;
        }
    }

    class CalculatedMemberSqlCompiler
    extends MemberSqlCompiler {
        SqlCompiler compiler;

        CalculatedMemberSqlCompiler(SqlCompiler argumentCompiler) {
            this.compiler = argumentCompiler;
        }

        public String compile(Exp exp) {
            if (!((exp = this.unwind(exp)) instanceof MemberExpr)) {
                return null;
            }
            Member member = ((MemberExpr)exp).getMember();
            if (!(member instanceof RolapCalculatedMember)) {
                return null;
            }
            exp = member.getExpression();
            if (exp == null) {
                return null;
            }
            return this.compiler.compile(exp);
        }

        public String toString() {
            return "CalculatedMemberSqlCompiler";
        }
    }

    class StoredMeasureSqlCompiler
    extends MemberSqlCompiler {
        StoredMeasureSqlCompiler() {
        }

        public String compile(Exp exp) {
            if (!((exp = this.unwind(exp)) instanceof MemberExpr)) {
                return null;
            }
            Member member = ((MemberExpr)exp).getMember();
            if (!(member instanceof RolapStoredMeasure)) {
                return null;
            }
            RolapStoredMeasure measure = (RolapStoredMeasure)member;
            if (measure.isCalculated()) {
                return null;
            }
            if (!RolapNativeSql.access$100(RolapNativeSql.this, measure)) {
                return null;
            }
            String exprInner = measure.getMondrianDefExpression().getExpression(RolapNativeSql.access$200(RolapNativeSql.this));
            String expr = measure.getAggregator().getExpression(exprInner);
            if (RolapNativeSql.access$000(RolapNativeSql.this).isDB2()) {
                expr = "FLOAT(" + expr + ")";
            }
            return expr;
        }

        public String toString() {
            return "StoredMeasureSqlCompiler";
        }
    }

    abstract class MemberSqlCompiler
    implements SqlCompiler {
        MemberSqlCompiler() {
        }

        protected Exp unwind(Exp exp) {
            return exp;
        }
    }

    class NumberSqlCompiler
    implements SqlCompiler {
        NumberSqlCompiler() {
        }

        public String compile(Exp exp) {
            if (!(exp instanceof Literal)) {
                return null;
            }
            if ((exp.getCategory() & 7) == 0) {
                return null;
            }
            Literal literal = (Literal)exp;
            String expr = String.valueOf(literal.getValue());
            if (RolapNativeSql.access$000(RolapNativeSql.this).isDB2()) {
                expr = "FLOAT(" + expr + ")";
            }
            return expr;
        }

        public String toString() {
            return "NumberSqlCompiler";
        }
    }

    class CompositeSqlCompiler
    implements SqlCompiler {
        List compilers = new ArrayList();

        CompositeSqlCompiler() {
        }

        public void add(SqlCompiler compiler) {
            this.compilers.add(compiler);
        }

        public String compile(Exp exp) {
            Iterator it = this.compilers.iterator();
            while (it.hasNext()) {
                SqlCompiler compiler = (SqlCompiler)it.next();
                String s = compiler.compile(exp);
                if (s == null) continue;
                return s;
            }
            return null;
        }

        public String toString() {
            return this.compilers.toString();
        }
    }

    static interface SqlCompiler {
        public String compile(Exp var1);
    }
}

