/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import mondrian.olap.Hierarchy;
import mondrian.olap.Level;
import mondrian.olap.Member;
import mondrian.olap.MemberBase;
import mondrian.olap.OlapElement;
import mondrian.olap.Property;
import mondrian.olap.PropertyFormatter;
import mondrian.olap.Schema;
import mondrian.olap.SchemaReader;
import mondrian.olap.Util;
import mondrian.rolap.HierarchyUsage;
import mondrian.rolap.RolapHierarchy;
import mondrian.rolap.RolapLevel;
import mondrian.rolap.RolapUtil;
import org.apache.log4j.Logger;

public class RolapMember
extends MemberBase {
    private static final Logger LOGGER;
    private int ordinal;
    private final Object key;
    private Map mapPropertyNameToValue;
    static final /* synthetic */ boolean $assertionsDisabled;
    private static final /* synthetic */ Class class$mondrian$rolap$RolapMember;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Member[][] getAllMembers(SchemaReader schemaReader, Hierarchy hierarchy) {
        long start = System.currentTimeMillis();
        try {
            ArrayList<Member[]> list = new ArrayList<Member[]>(500);
            Level[] levels = hierarchy.getLevels();
            for (int i = 0; i < levels.length; ++i) {
                Level level = levels[i];
                Member[] members = schemaReader.getLevelMembers(level, false);
                if (members == null) continue;
                list.add(members);
            }
            Member[][] memberArray = (Member[][])list.toArray((T[])new Member[list.size()][]);
            return memberArray;
        }
        finally {
            if (LOGGER.isDebugEnabled()) {
                long end = System.currentTimeMillis();
                LOGGER.debug((Object)("RolapMember.getAllMembers: time=" + (end - start)));
            }
        }
    }

    public static int getHierarchyCardinality(SchemaReader schemaReader, Hierarchy hierarchy) {
        int cardinality = 0;
        Level[] levels = hierarchy.getLevels();
        for (int i = 0; i < levels.length; ++i) {
            cardinality += schemaReader.getLevelCardinality(levels[i], true, true);
        }
        return cardinality;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setOrdinals(SchemaReader schemaReader, Member seedMember) {
        long start = System.currentTimeMillis();
        try {
            Member member;
            int j;
            Member[] members;
            int i;
            Hierarchy hierarchy = seedMember.getHierarchy();
            int ordinal = hierarchy.hasAll() ? 1 : 0;
            Member[][] membersArray = RolapMember.getAllMembers(schemaReader, hierarchy);
            Member[] leafMembers = membersArray[membersArray.length - 1];
            for (int i2 = 0; i2 < leafMembers.length; ++i2) {
                Member child = leafMembers[i2];
                ordinal = RolapMember.bottomUpSetParentOrdinals(ordinal, child);
                ordinal = RolapMember.setOrdinal(child, ordinal);
            }
            boolean needsFullTopDown = false;
            block4: for (i = 0; i < membersArray.length - 1; ++i) {
                members = membersArray[i];
                for (j = 0; j < members.length; ++j) {
                    member = members[j];
                    if (member.getOrdinal() != -1) continue;
                    needsFullTopDown = true;
                    continue block4;
                }
            }
            if (needsFullTopDown) {
                for (i = 0; i < membersArray.length - 1; ++i) {
                    members = membersArray[i];
                    for (j = 0; j < members.length; ++j) {
                        member = members[j];
                        if (!(member instanceof RolapMember)) continue;
                        ((RolapMember)member).resetOrdinal();
                    }
                }
                RolapMember.setOrdinalsTopDown(schemaReader, seedMember);
            }
        }
        finally {
            if (LOGGER.isDebugEnabled()) {
                long end = System.currentTimeMillis();
                LOGGER.debug((Object)("RolapMember.setOrdinals: time=" + (end - start)));
            }
        }
    }

    private static int bottomUpSetParentOrdinals(int ordinal, Member child) {
        Member parent = child.getParentMember();
        if (parent != null && parent.getOrdinal() == -1) {
            ordinal = RolapMember.bottomUpSetParentOrdinals(ordinal, parent);
            ordinal = RolapMember.setOrdinal(parent, ordinal);
        }
        return ordinal;
    }

    private static int setOrdinal(Member member, int ordinal) {
        if (member instanceof RolapMember) {
            ((RolapMember)member).setOrdinal(ordinal++);
        } else {
            LOGGER.warn((Object)("RolapMember.setAllChildren: NOT RolapMember member.name=" + member.getName() + ", member.class=" + member.getClass().getName() + ", ordinal=" + ordinal));
            ++ordinal;
        }
        return ordinal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setOrdinalsTopDown(SchemaReader schemaReader, Member member) {
        long start = System.currentTimeMillis();
        try {
            Member parent = schemaReader.getMemberParent(member);
            if (parent == null) {
                int ordinal = 0;
                Member[] siblings = schemaReader.getHierarchyRootMembers(member.getHierarchy());
                for (int i = 0; i < siblings.length; ++i) {
                    Member sibling = siblings[i];
                    ordinal = RolapMember.setAllChildren(ordinal, schemaReader, sibling);
                }
            } else {
                RolapMember.setOrdinalsTopDown(schemaReader, parent);
            }
        }
        finally {
            if (LOGGER.isDebugEnabled()) {
                long end = System.currentTimeMillis();
                LOGGER.debug((Object)("RolapMember.setOrdinalsTopDown: time=" + (end - start)));
            }
        }
    }

    private static int setAllChildren(int ordinal, SchemaReader schemaReader, Member member) {
        ordinal = RolapMember.setOrdinal(member, ordinal);
        Member[] children = schemaReader.getMemberChildren(member);
        for (int i = 0; i < children.length; ++i) {
            Member child = children[i];
            ordinal = RolapMember.setAllChildren(ordinal, schemaReader, child);
        }
        return ordinal;
    }

    private static String keyToString(Object key) {
        String name = null;
        name = key == null ? "#null" : key.toString();
        if (key instanceof Number && name.endsWith(".0")) {
            name = name.substring(0, name.length() - 2);
        }
        return name;
    }

    protected RolapMember(RolapMember parentMember, RolapLevel level, Object key, String name, int flags) {
        super(parentMember, level, flags);
        this.key = key;
        this.ordinal = -1;
        this.mapPropertyNameToValue = Collections.EMPTY_MAP;
        if (!(name == null || key != null && name.equals(key.toString()))) {
            this.setProperty(Property.NAME.name, name);
        } else {
            this.setUniqueName(key);
        }
    }

    RolapMember(RolapMember parentMember, RolapLevel level, Object value) {
        this(parentMember, level, value, null, 1);
    }

    protected Logger getLogger() {
        return LOGGER;
    }

    RolapLevel getRolapLevel() {
        return (RolapLevel)this.level;
    }

    RolapHierarchy getRolapHierarchy() {
        return (RolapHierarchy)this.getHierarchy();
    }

    public boolean equals(Object o) {
        return o instanceof RolapMember && this.equals((RolapMember)o);
    }

    public boolean equals(OlapElement o) {
        return o instanceof RolapMember && this.equals((RolapMember)o);
    }

    private boolean equals(RolapMember that) {
        if (!$assertionsDisabled && that == null) {
            throw new AssertionError();
        }
        return this.getUniqueName().equalsIgnoreCase(that.getUniqueName());
    }

    void makeUniqueName(HierarchyUsage hierarchyUsage) {
        String n;
        if (this.parentMember == null && this.key != null && (n = hierarchyUsage.getName()) != null) {
            String name = RolapMember.keyToString(this.key);
            n = Util.quoteMdxIdentifier(n);
            this.uniqueName = Util.makeFqName(n, name);
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)("RolapMember.makeUniqueName: uniqueName=" + this.uniqueName));
            }
        }
    }

    private void setUniqueName(Object key) {
        String name = RolapMember.keyToString(key);
        this.uniqueName = this.parentMember == null ? Util.makeFqName(this.getHierarchy(), name) : Util.makeFqName(this.parentMember, name);
    }

    public boolean isCalculatedInQuery() {
        return false;
    }

    public String getName() {
        String name = (String)this.getPropertyValue(Property.NAME.name);
        return name != null ? name : RolapMember.keyToString(this.key);
    }

    public void setName(String name) {
        throw new Error("unsupported");
    }

    public synchronized void setProperty(String name, Object value) {
        if (name.equals(Property.CAPTION.name)) {
            this.setCaption((String)value);
            return;
        }
        if (this.mapPropertyNameToValue.isEmpty()) {
            this.mapPropertyNameToValue = new HashMap();
        }
        if (name.equals(Property.NAME.name)) {
            if (value == null) {
                value = "#null";
            }
            this.setUniqueName(value);
        }
        if (name.equals(Property.MEMBER_ORDINAL.name)) {
            String ordinal = (String)value;
            if (ordinal.startsWith("\"") && ordinal.endsWith("\"")) {
                ordinal = ordinal.substring(1, ordinal.length() - 1);
            }
            double d = Double.parseDouble(ordinal);
            this.setOrdinal((int)d);
        }
        this.mapPropertyNameToValue.put(name, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getPropertyValue(String name) {
        Property property = Property.lookup(name);
        if (property != null) {
            switch (property.ordinal) {
                case 2: {
                    break;
                }
                case 3: {
                    return this.getCaption();
                }
                case 4: {
                    ArrayList list = new ArrayList();
                    this.getRolapHierarchy().getMemberReader().getMemberChildren(this, list);
                    return list;
                }
                case 10: {
                    break;
                }
                case 11: {
                    Schema schema = this.getHierarchy().getDimension().getSchema();
                    return schema.getName();
                }
                case 12: {
                    break;
                }
                case 13: {
                    return this.getHierarchy().getDimension().getUniqueName();
                }
                case 14: {
                    return this.getHierarchy().getUniqueName();
                }
                case 15: {
                    return this.getLevel().getUniqueName();
                }
                case 16: {
                    return new Integer(this.getLevel().getDepth());
                }
                case 19: {
                    return this.getUniqueName();
                }
                case 18: {
                    return this.getName();
                }
                case 20: {
                    return new Integer(this.getMemberType());
                }
                case 21: {
                    return null;
                }
                case 22: {
                    return this.getCaption();
                }
                case 17: {
                    return new Integer(this.getOrdinal());
                }
                case 23: {
                    Integer cardinality;
                    if (this.isAllMember() && this.childLevelHasApproxRowCount()) {
                        cardinality = new Integer(this.getLevel().getChildLevel().getApproxRowCount());
                    } else {
                        ArrayList list = new ArrayList();
                        this.getRolapHierarchy().getMemberReader().getMemberChildren(this, list);
                        cardinality = new Integer(list.size());
                    }
                    return cardinality;
                }
                case 24: {
                    Member parentMember = this.getParentMember();
                    return new Integer(parentMember == null ? 0 : parentMember.getLevel().getDepth());
                }
                case 25: {
                    Member parentMember = this.getParentMember();
                    return parentMember == null ? null : parentMember.getUniqueName();
                }
                case 26: {
                    Member parentMember = this.getParentMember();
                    return new Integer(parentMember == null ? 0 : 1);
                }
                case 27: {
                    return this.getDescription();
                }
                case 28: {
                    break;
                }
            }
        }
        RolapMember rolapMember = this;
        synchronized (rolapMember) {
            return this.mapPropertyNameToValue.get(name);
        }
    }

    private boolean childLevelHasApproxRowCount() {
        return this.getLevel().getChildLevel().getApproxRowCount() > Integer.MIN_VALUE;
    }

    private boolean isAllMember() {
        return this.getLevel().getHierarchy().hasAll() && this.getLevel().getDepth() == 0;
    }

    public Property[] getProperties() {
        return this.level.getInheritedProperties();
    }

    String quoteKeyForSql() {
        return (this.getRolapLevel().getFlags() & 1) != 0 ? this.key.toString() : Util.singleQuoteString(this.key.toString());
    }

    public int getOrdinal() {
        return this.ordinal;
    }

    void setOrdinal(int ordinal) {
        if (this.ordinal == -1) {
            this.ordinal = ordinal;
        }
    }

    private void resetOrdinal() {
        this.ordinal = -1;
    }

    Object getKey() {
        return this.key;
    }

    public int compareTo(Object o) {
        RolapMember other = (RolapMember)o;
        if (this.key != null && other.key == null) {
            return 1;
        }
        if (this.key == null && other.key != null) {
            return -1;
        }
        if (this.key == null && other.key == null) {
            return this.getUniqueName().compareTo(other.getUniqueName());
        }
        if (this.key == RolapUtil.sqlNullValue || other.key == RolapUtil.sqlNullValue) {
            return this.getUniqueName().compareTo(other.getUniqueName());
        }
        if (this.key.getClass().equals(other.key.getClass())) {
            if (this.key instanceof String) {
                return Util.compareName((String)this.key, (String)other.key);
            }
            return ((Comparable)this.key).compareTo(other.key);
        }
        return this.getUniqueName().compareTo(other.getUniqueName());
    }

    public boolean isHidden() {
        RolapLevel rolapLevel = this.getRolapLevel();
        switch (rolapLevel.getHideMemberCondition().ordinal) {
            case 0: {
                return false;
            }
            case 1: {
                String name = this.getName();
                return name.equals("#null") || name.equals("");
            }
            case 2: {
                Member parentMember = this.getParentMember();
                if (parentMember == null) {
                    return false;
                }
                String parentName = parentMember.getName();
                String name = this.getName();
                return (parentName == null ? "" : parentName).equals(name == null ? "" : name);
            }
        }
        throw rolapLevel.getHideMemberCondition().unexpected();
    }

    public int getDepth() {
        return this.level.getDepth();
    }

    public Object getSqlKey() {
        return this.key;
    }

    public String getPropertyFormattedValue(String propertyName) {
        PropertyFormatter pf;
        Property[] props = this.getLevel().getProperties();
        Property prop = null;
        for (int i = 0; i < props.length; ++i) {
            if (!props[i].getName().equals(propertyName)) continue;
            prop = props[i];
            break;
        }
        if (prop != null && (pf = prop.getFormatter()) != null) {
            return pf.formatProperty(this, propertyName, this.getPropertyValue(propertyName));
        }
        Object val = this.getPropertyValue(propertyName);
        return val == null ? "" : val.toString();
    }

    static {
        $assertionsDisabled = !(class$mondrian$rolap$RolapMember == null ? (class$mondrian$rolap$RolapMember = RolapMember.class$("mondrian.rolap.RolapMember")) : class$mondrian$rolap$RolapMember).desiredAssertionStatus();
        LOGGER = Logger.getLogger((Class)(class$mondrian$rolap$RolapMember == null ? (class$mondrian$rolap$RolapMember = RolapMember.class$("mondrian.rolap.RolapMember")) : class$mondrian$rolap$RolapMember));
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        Class<?> clazz;
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            NoClassDefFoundError noClassDefFoundError = new NoClassDefFoundError(classNotFoundException.getMessage());
            try {
                noClassDefFoundError.initCause(classNotFoundException);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
            throw noClassDefFoundError;
        }
        return clazz;
    }
}

