/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import mondrian.olap.Cube;
import mondrian.olap.DimensionBase;
import mondrian.olap.DimensionType;
import mondrian.olap.Hierarchy;
import mondrian.olap.Level;
import mondrian.olap.MondrianDef;
import mondrian.olap.Schema;
import mondrian.olap.Util;
import mondrian.resource.MondrianResource;
import mondrian.rolap.RolapCube;
import mondrian.rolap.RolapHierarchy;
import mondrian.rolap.RolapSchema;
import mondrian.rolap.RolapUtil;
import org.apache.log4j.Logger;

class RolapDimension
extends DimensionBase {
    private static final Logger LOGGER = Logger.getLogger((Class)(class$mondrian$rolap$RolapDimension == null ? (class$mondrian$rolap$RolapDimension = RolapDimension.class$("mondrian.rolap.RolapDimension")) : class$mondrian$rolap$RolapDimension));
    private final Schema schema;
    private static final /* synthetic */ Class class$mondrian$rolap$RolapDimension;

    synchronized int getNextOrdinal() {
        return this.schema.getNextDimensionOrdinal();
    }

    RolapDimension(Schema schema, String name, int globalOrdinal, DimensionType dimensionType) {
        super(name, globalOrdinal, dimensionType);
        this.schema = schema;
        Util.assertTrue(globalOrdinal == 0 == name.equals("Measures"));
        this.hierarchies = new RolapHierarchy[0];
    }

    RolapDimension(RolapSchema schema, RolapCube cube, MondrianDef.Dimension xmlDimension, MondrianDef.CubeDimension xmlCubeDimension) {
        this((Schema)schema, xmlDimension.name, RolapDimension.chooseOrdinal(cube, xmlCubeDimension), xmlDimension.getDimensionType());
        int i;
        Util.assertPrecondition(schema != null);
        if (cube != null) {
            Util.assertTrue(cube.getSchema() == schema);
        }
        if (!Util.isEmpty(xmlDimension.caption)) {
            this.setCaption(xmlDimension.caption);
        }
        this.hierarchies = new RolapHierarchy[xmlDimension.hierarchies.length];
        for (i = 0; i < xmlDimension.hierarchies.length; ++i) {
            RolapHierarchy hierarchy = new RolapHierarchy(cube, this, xmlDimension.hierarchies[i], xmlCubeDimension);
            this.hierarchies[i] = hierarchy;
        }
        if (this.dimensionType == null) {
            for (i = 0; i < this.hierarchies.length; ++i) {
                Level[] levels = this.hierarchies[i].getLevels();
                for (int j = 0; j < levels.length; ++j) {
                    Level lev = levels[j];
                    if (lev.isAll()) continue;
                    if (this.dimensionType == null) {
                        this.dimensionType = lev.getLevelType().isTime() ? DimensionType.TimeDimension : DimensionType.StandardDimension;
                        continue;
                    }
                    if (this.dimensionType == DimensionType.TimeDimension && !lev.getLevelType().isTime() && !lev.isAll()) {
                        throw MondrianResource.instance().NonTimeLevelInTimeHierarchy.ex(this.getUniqueName());
                    }
                    if (this.dimensionType == DimensionType.TimeDimension || !lev.getLevelType().isTime()) continue;
                    throw MondrianResource.instance().TimeLevelInNonTimeHierarchy.ex(this.getUniqueName());
                }
            }
        }
    }

    protected Logger getLogger() {
        return LOGGER;
    }

    private static int chooseOrdinal(RolapCube cube, MondrianDef.CubeDimension xmlCubeDimension) {
        if (xmlCubeDimension.name.equals("Measures")) {
            return 0;
        }
        RolapSchema schema = (RolapSchema)cube.getSchema();
        if (xmlCubeDimension instanceof MondrianDef.DimensionUsage) {
            MondrianDef.DimensionUsage usage = (MondrianDef.DimensionUsage)xmlCubeDimension;
            RolapHierarchy hierarchy = schema.getSharedHierarchy(usage.source);
            if (hierarchy != null) {
                cube.createUsage(hierarchy, usage);
                RolapDimension dimension = (RolapDimension)hierarchy.getDimension();
                return dimension.getGlobalOrdinal();
            }
        }
        return schema.getNextDimensionOrdinal();
    }

    void init(RolapCube cube, MondrianDef.CubeDimension xmlDimension) {
        for (int i = 0; i < this.hierarchies.length; ++i) {
            if (this.hierarchies[i] == null) continue;
            ((RolapHierarchy)this.hierarchies[i]).init(cube, xmlDimension);
        }
    }

    RolapHierarchy newHierarchy(String subName, boolean hasAll) {
        RolapHierarchy hierarchy = new RolapHierarchy(this, subName, hasAll);
        this.hierarchies = (RolapHierarchy[])RolapUtil.addElement(this.hierarchies, hierarchy);
        return hierarchy;
    }

    public Hierarchy getHierarchy() {
        return this.hierarchies[0];
    }

    public int getOrdinal(Cube cube) {
        return ((RolapCube)cube).getOrdinal(this.globalOrdinal);
    }

    public Schema getSchema() {
        return this.schema;
    }

    int getGlobalOrdinal() {
        return this.globalOrdinal;
    }

    public RolapDimension copy(RolapCube cube, String name, MondrianDef.CubeDimension xmlCubeDimension) {
        RolapDimension dimension = new RolapDimension(this.schema, name, this.getNextOrdinal(), this.dimensionType);
        dimension.hierarchies = (Hierarchy[])this.hierarchies.clone();
        for (int i = 0; i < this.hierarchies.length; ++i) {
            RolapHierarchy hierarchy = (RolapHierarchy)this.hierarchies[i];
            dimension.hierarchies[i] = new RolapHierarchy(cube, dimension, hierarchy.xmlHierarchy, xmlCubeDimension);
        }
        return dimension;
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        Class<?> clazz;
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            NoClassDefFoundError noClassDefFoundError = new NoClassDefFoundError(classNotFoundException.getMessage());
            try {
                noClassDefFoundError.initCause(classNotFoundException);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
            throw noClassDefFoundError;
        }
        return clazz;
    }
}

