/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import mondrian.olap.Cell;
import mondrian.olap.CellFormatter;
import mondrian.olap.Dimension;
import mondrian.olap.Evaluator;
import mondrian.olap.Member;
import mondrian.olap.Property;
import mondrian.olap.Util;
import mondrian.rolap.RolapAggregationManager;
import mondrian.rolap.RolapConnection;
import mondrian.rolap.RolapCube;
import mondrian.rolap.RolapEvaluator;
import mondrian.rolap.RolapMeasure;
import mondrian.rolap.RolapResult;
import mondrian.rolap.RolapStoredMeasure;
import mondrian.rolap.RolapUtil;
import mondrian.rolap.agg.AggregationManager;
import mondrian.rolap.agg.CellRequest;

class RolapCell
implements Cell {
    private final RolapResult result;
    protected final Object value;
    protected String cachedFormatString;
    private final int ordinal;

    RolapCell(RolapResult result, int ordinal, Object value) {
        this.result = result;
        this.value = value;
        this.ordinal = ordinal;
        this.cachedFormatString = null;
    }

    RolapCell(RolapResult result, int ordinal, Object value, String cachedFormatString) {
        this.result = result;
        this.value = value;
        this.ordinal = ordinal;
        this.cachedFormatString = cachedFormatString;
    }

    public Object getValue() {
        return this.value;
    }

    public String getCachedFormatString() {
        return this.cachedFormatString;
    }

    public String getFormattedValue() {
        RolapCube c;
        Dimension measuresDim;
        int[] pos = this.result.getCellPos(this.ordinal);
        Evaluator evaluator = this.result.getEvaluator(pos);
        RolapMeasure m = (RolapMeasure)evaluator.getContext(measuresDim = (c = (RolapCube)evaluator.getCube()).getMeasuresHierarchy().getDimension());
        CellFormatter cf = m.getFormatter();
        if (cf != null) {
            return cf.formatCell(this.value);
        }
        if (this.cachedFormatString == null) {
            this.cachedFormatString = evaluator.getFormatString();
        }
        return evaluator.format(this.value, this.cachedFormatString);
    }

    public boolean isNull() {
        return this.value == Util.nullValue;
    }

    public boolean isError() {
        return this.value instanceof Throwable;
    }

    public String getDrillThroughSQL(boolean extendedContext) {
        AggregationManager aggMan = AggregationManager.instance();
        RolapEvaluator evaluator = this.getEvaluator();
        Member[] currentMembers = evaluator.getCurrentMembers();
        CellRequest cellRequest = RolapAggregationManager.makeRequest(currentMembers, extendedContext, true);
        return cellRequest == null ? null : ((RolapAggregationManager)aggMan).getDrillThroughSql(cellRequest, false);
    }

    public int getDrillThroughCount() {
        AggregationManager aggMan = AggregationManager.instance();
        RolapEvaluator evaluator = this.getEvaluator();
        Member[] currentMembers = evaluator.getCurrentMembers();
        CellRequest cellRequest = RolapAggregationManager.makeRequest(currentMembers, false, true);
        if (cellRequest == null) {
            return -1;
        }
        RolapConnection connection = (RolapConnection)evaluator.getQuery().getConnection();
        Connection jdbcConnection = null;
        ResultSet rs = null;
        String sql = ((RolapAggregationManager)aggMan).getDrillThroughSql(cellRequest, true);
        try {
            jdbcConnection = connection.getDataSource().getConnection();
            rs = RolapUtil.executeQuery(jdbcConnection, sql, "RolapCell.getDrillThroughCount");
            rs.next();
            int count = rs.getInt(1);
            rs.close();
            int n = count;
            return n;
        }
        catch (SQLException e) {
            throw Util.newError(e, "Error while counting drill-through, SQL ='" + sql + "'");
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException ignored) {}
            try {
                if (jdbcConnection != null && !jdbcConnection.isClosed()) {
                    jdbcConnection.close();
                }
            }
            catch (SQLException ignored) {}
        }
    }

    public boolean canDrillThrough() {
        if (((RolapCube)this.getEvaluator().getCube()).isVirtual()) {
            return false;
        }
        Member[] currentMembers = this.getEvaluator().getCurrentMembers();
        return currentMembers[0] instanceof RolapStoredMeasure;
    }

    private RolapEvaluator getEvaluator() {
        int[] pos = this.result.getCellPos(this.ordinal);
        return this.result.getCellEvaluator(pos);
    }

    public Object getPropertyValue(String propertyName) {
        Property property = Property.lookup(propertyName);
        Integer defaultValue = null;
        if (property != null) {
            switch (property.ordinal) {
                case 32: {
                    return new Integer(this.ordinal);
                }
                case 41: {
                    return this.getValue();
                }
                case 38: {
                    return this.getEvaluator().getFormatString();
                }
                case 37: {
                    return this.getFormattedValue();
                }
                case 36: {
                    defaultValue = new Integer(0);
                    break;
                }
                case 40: {
                    defaultValue = new Integer(0);
                    break;
                }
            }
        }
        return this.getEvaluator().getProperty(propertyName, defaultValue);
    }

    public Member getContextMember(Dimension dimension) {
        return this.result.getMember(this.result.getCellPos(this.ordinal), dimension);
    }
}

