/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import java.util.BitSet;

public interface BitKey {
    public void set(int var1, boolean var2);

    public void set(int var1);

    public boolean get(int var1);

    public void clear(int var1);

    public void clear();

    public boolean isSuperSetOf(BitKey var1);

    public BitKey or(BitKey var1);

    public BitKey and(BitKey var1);

    public BitKey andNot(BitKey var1);

    public BitKey copy();

    public BitKey emptyCopy();

    public boolean isEmpty();

    public boolean intersects(BitKey var1);

    public BitSet toBitSet();

    static class 1 {
    }

    public static class Big
    extends AbstractBitKey {
        private long[] bits;

        private Big(int size) {
            this.bits = new long[Big.chunkCount(size)];
        }

        private Big(Big big) {
            this.bits = (long[])big.bits.clone();
        }

        private int size() {
            return this.bits.length;
        }

        public void set(int pos) {
            int n = Big.chunkPos(pos);
            this.bits[n] = this.bits[n] | Big.bit(pos);
        }

        public boolean get(int pos) {
            return (this.bits[Big.chunkPos(pos)] & Big.bit(pos)) != 0L;
        }

        public void clear(int pos) {
            int n = Big.chunkPos(pos);
            this.bits[n] = this.bits[n] & (Big.bit(pos) ^ 0xFFFFFFFFFFFFFFFFL);
        }

        public void clear() {
            for (int i = 0; i < this.bits.length; ++i) {
                this.bits[i] = 0L;
            }
        }

        private void or(long bits0) {
            this.bits[0] = this.bits[0] | bits0;
        }

        private void or(long bits0, long bits1) {
            this.bits[0] = this.bits[0] | bits0;
            this.bits[1] = this.bits[1] | bits1;
        }

        private void or(long[] bits) {
            for (int i = 0; i < bits.length; ++i) {
                int n = i;
                this.bits[n] = this.bits[n] | bits[i];
            }
        }

        private void and(long[] bits) {
            int i;
            int length = Math.min(bits.length, this.bits.length);
            for (i = 0; i < length; ++i) {
                int n = i;
                this.bits[n] = this.bits[n] & bits[i];
            }
            for (i = bits.length; i < this.bits.length; ++i) {
                this.bits[i] = 0L;
            }
        }

        public BitKey or(BitKey bitKey) {
            if (bitKey instanceof Small) {
                Small other = (Small)bitKey;
                Big bk = (Big)this.copy();
                bk.or(Small.access$800(other));
                return bk;
            }
            if (bitKey instanceof Mid128) {
                Mid128 other = (Mid128)bitKey;
                Big bk = (Big)this.copy();
                bk.or(Mid128.access$500(other), Mid128.access$700(other));
                return bk;
            }
            if (bitKey instanceof Big) {
                Big other = (Big)bitKey;
                if (other.size() > this.size()) {
                    Big bk = (Big)other.copy();
                    bk.or(this.bits);
                    return bk;
                }
                Big bk = (Big)this.copy();
                bk.or(other.bits);
                return bk;
            }
            throw this.createException(bitKey);
        }

        public BitKey and(BitKey bitKey) {
            if (bitKey instanceof Small) {
                Small bk = (Small)bitKey.copy();
                Small.access$1000(bk, this.bits[0]);
                return bk;
            }
            if (bitKey instanceof Mid128) {
                Mid128 bk = (Mid128)bitKey.copy();
                Mid128.access$1100(bk, this.bits[0], this.bits[1]);
                return bk;
            }
            if (bitKey instanceof Big) {
                Big other = (Big)bitKey;
                if (other.size() < this.size()) {
                    Big bk = (Big)other.copy();
                    bk.and(this.bits);
                    return bk;
                }
                Big bk = (Big)this.copy();
                bk.and(other.bits);
                return bk;
            }
            throw this.createException(bitKey);
        }

        public BitKey andNot(BitKey bitKey) {
            if (bitKey instanceof Small) {
                Small other = (Small)bitKey;
                Big bk = (Big)this.copy();
                bk.andNot(Small.access$800(other));
                return bk;
            }
            if (bitKey instanceof Mid128) {
                Mid128 other = (Mid128)bitKey;
                Big bk = (Big)this.copy();
                bk.andNot(Mid128.access$500(other), Mid128.access$700(other));
                return bk;
            }
            if (bitKey instanceof Big) {
                Big other = (Big)bitKey;
                Big bk = (Big)this.copy();
                bk.andNot(other.bits);
                return bk;
            }
            throw this.createException(bitKey);
        }

        private void andNot(long[] bits) {
            for (int i = 0; i < bits.length; ++i) {
                int n = i;
                this.bits[n] = this.bits[n] & (bits[i] ^ 0xFFFFFFFFFFFFFFFFL);
            }
        }

        private void andNot(long bits0, long bits1) {
            this.bits[0] = this.bits[0] & (bits0 ^ 0xFFFFFFFFFFFFFFFFL);
            this.bits[1] = this.bits[1] & (bits1 ^ 0xFFFFFFFFFFFFFFFFL);
        }

        private void andNot(long bits) {
            this.bits[0] = this.bits[0] & (bits ^ 0xFFFFFFFFFFFFFFFFL);
        }

        public boolean isSuperSetOf(BitKey bitKey) {
            if (bitKey instanceof Small) {
                Small other = (Small)bitKey;
                return (this.bits[0] | Small.access$800(other)) == this.bits[0];
            }
            if (bitKey instanceof Mid128) {
                Mid128 other = (Mid128)bitKey;
                return (this.bits[0] | Mid128.access$500(other)) == this.bits[0] && (this.bits[1] | Mid128.access$700(other)) == this.bits[1];
            }
            if (bitKey instanceof Big) {
                int i;
                Big other = (Big)bitKey;
                int len = Math.min(this.bits.length, other.bits.length);
                for (i = 0; i < len; ++i) {
                    if ((this.bits[i] | other.bits[i]) == this.bits[i]) continue;
                    return false;
                }
                if (other.bits.length > this.bits.length) {
                    for (i = len; i < other.bits.length; ++i) {
                        if (other.bits[i] == 0L) continue;
                        return false;
                    }
                }
                return true;
            }
            return false;
        }

        public boolean intersects(BitKey bitKey) {
            if (bitKey instanceof Small) {
                Small other = (Small)bitKey;
                return (this.bits[0] & Small.access$800(other)) != 0L;
            }
            if (bitKey instanceof Mid128) {
                Mid128 other = (Mid128)bitKey;
                return (this.bits[0] & Mid128.access$500(other)) != 0L || (this.bits[1] & Mid128.access$700(other)) != 0L;
            }
            if (bitKey instanceof Big) {
                Big other = (Big)bitKey;
                int len = Math.min(this.bits.length, other.bits.length);
                for (int i = 0; i < len; ++i) {
                    if ((this.bits[i] & other.bits[i]) == 0L) continue;
                    return true;
                }
                return false;
            }
            return false;
        }

        public BitSet toBitSet() {
            BitSet bitSet = new BitSet(64);
            int pos = 0;
            for (int i = 0; i < this.bits.length; ++i) {
                Big.copyFromLong(bitSet, pos, this.bits[i]);
                pos += 64;
            }
            return bitSet;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof Small) {
                Small other = (Small)o;
                if (this.bits[0] != Small.access$800(other)) {
                    return false;
                }
                for (int i = 1; i < this.bits.length; ++i) {
                    if (this.bits[i] == 0L) continue;
                    return false;
                }
                return true;
            }
            if (o instanceof Mid128) {
                Mid128 other = (Mid128)o;
                if (this.bits[0] != Mid128.access$500(other)) {
                    return false;
                }
                if (this.bits[1] != Mid128.access$700(other)) {
                    return false;
                }
                for (int i = 2; i < this.bits.length; ++i) {
                    if (this.bits[i] == 0L) continue;
                    return false;
                }
                return true;
            }
            if (o instanceof Big) {
                int i;
                Big other = (Big)o;
                int len = Math.min(this.bits.length, other.bits.length);
                for (i = 0; i < len; ++i) {
                    if (this.bits[i] == other.bits[i]) continue;
                    return false;
                }
                if (this.bits.length > other.bits.length) {
                    for (i = len; i < this.bits.length; ++i) {
                        if (this.bits[i] == 0L) continue;
                        return false;
                    }
                } else if (other.bits.length > this.bits.length) {
                    for (i = len; i < other.bits.length; ++i) {
                        if (other.bits[i] == 0L) continue;
                        return false;
                    }
                }
                return true;
            }
            return false;
        }

        public int hashCode() {
            long h = 1234L;
            int i = this.bits.length;
            while (--i >= 0) {
                h ^= this.bits[i] * (long)(i + 1);
            }
            return (int)(h >> 32 ^ h);
        }

        public String toString() {
            int start;
            StringBuffer buf = new StringBuffer(64);
            buf.append("0x");
            for (int i = start = this.bits.length * 64 - 1; i >= 0; --i) {
                buf.append(this.get(i) ? (char)'1' : '0');
            }
            return buf.toString();
        }

        public BitKey copy() {
            return new Big(this);
        }

        public BitKey emptyCopy() {
            return new Big(this.bits.length << 6);
        }

        public boolean isEmpty() {
            for (int i = 0; i < this.bits.length; ++i) {
                if (this.bits[i] == 0L) continue;
                return false;
            }
            return true;
        }

        Big(int x0, 1 x1) {
            this(x0);
        }

        static void access$400(Big x0, long x1) {
            x0.or(x1);
        }

        static long[] access$600(Big x0) {
            return x0.bits;
        }

        static void access$900(Big x0, long x1, long x2) {
            x0.or(x1, x2);
        }
    }

    public static class Mid128
    extends AbstractBitKey {
        private long bits0;
        private long bits1;

        private Mid128() {
        }

        private Mid128(Mid128 mid) {
            this.bits0 = mid.bits0;
            this.bits1 = mid.bits1;
        }

        public void set(int pos) {
            if (pos < 64) {
                this.bits0 |= Mid128.bit(pos);
            } else if (pos < 128) {
                this.bits1 |= Mid128.bit(pos);
            } else {
                throw new IllegalArgumentException("pos " + pos + " exceeds capacity 128");
            }
        }

        public boolean get(int pos) {
            if (pos < 64) {
                return (this.bits0 & Mid128.bit(pos)) != 0L;
            }
            if (pos < 128) {
                return (this.bits1 & Mid128.bit(pos)) != 0L;
            }
            return false;
        }

        public void clear(int pos) {
            if (pos < 64) {
                this.bits0 &= Mid128.bit(pos) ^ 0xFFFFFFFFFFFFFFFFL;
            } else if (pos < 128) {
                this.bits1 &= Mid128.bit(pos) ^ 0xFFFFFFFFFFFFFFFFL;
            } else {
                throw new IndexOutOfBoundsException("pos " + pos + " exceeds size " + 128);
            }
        }

        public void clear() {
            this.bits0 = 0L;
            this.bits1 = 0L;
        }

        private void or(long bits0, long bits1) {
            this.bits0 |= bits0;
            this.bits1 |= bits1;
        }

        private void and(long bits0, long bits1) {
            this.bits0 &= bits0;
            this.bits1 &= bits1;
        }

        public BitKey or(BitKey bitKey) {
            if (bitKey instanceof Small) {
                Small other = (Small)bitKey;
                Mid128 bk = (Mid128)this.copy();
                bk.or(Small.access$800(other), 0L);
                return bk;
            }
            if (bitKey instanceof Mid128) {
                Mid128 other = (Mid128)bitKey;
                Mid128 bk = (Mid128)this.copy();
                bk.or(other.bits0, other.bits1);
                return bk;
            }
            if (bitKey instanceof Big) {
                Big other = (Big)bitKey;
                Big bk = (Big)other.copy();
                Big.access$900(bk, this.bits0, this.bits1);
                return bk;
            }
            throw this.createException(bitKey);
        }

        public BitKey and(BitKey bitKey) {
            if (bitKey instanceof Small) {
                Small other = (Small)bitKey;
                Mid128 bk = (Mid128)this.copy();
                bk.and(Small.access$800(other), 0L);
                return bk;
            }
            if (bitKey instanceof Mid128) {
                Mid128 other = (Mid128)bitKey;
                Mid128 bk = (Mid128)this.copy();
                bk.and(other.bits0, other.bits1);
                return bk;
            }
            if (bitKey instanceof Big) {
                Big other = (Big)bitKey;
                Mid128 bk = (Mid128)this.copy();
                bk.and(Big.access$600(other)[0], Big.access$600(other)[1]);
                return bk;
            }
            throw this.createException(bitKey);
        }

        public BitKey andNot(BitKey bitKey) {
            if (bitKey instanceof Small) {
                Small other = (Small)bitKey;
                Mid128 bk = (Mid128)this.copy();
                bk.andNot(Small.access$800(other), 0L);
                return bk;
            }
            if (bitKey instanceof Mid128) {
                Mid128 other = (Mid128)bitKey;
                Mid128 bk = (Mid128)this.copy();
                bk.andNot(other.bits0, other.bits1);
                return bk;
            }
            if (bitKey instanceof Big) {
                Big other = (Big)bitKey;
                Mid128 bk = (Mid128)this.copy();
                bk.andNot(Big.access$600(other)[0], Big.access$600(other)[1]);
                return bk;
            }
            throw this.createException(bitKey);
        }

        private void andNot(long bits0, long bits1) {
            this.bits0 &= bits0 ^ 0xFFFFFFFFFFFFFFFFL;
            this.bits1 &= bits1 ^ 0xFFFFFFFFFFFFFFFFL;
        }

        public boolean isSuperSetOf(BitKey bitKey) {
            if (bitKey instanceof Small) {
                Small other = (Small)bitKey;
                return (this.bits0 | Small.access$800(other)) == this.bits0;
            }
            if (bitKey instanceof Mid128) {
                Mid128 other = (Mid128)bitKey;
                return (this.bits0 | other.bits0) == this.bits0 && (this.bits1 | other.bits1) == this.bits1;
            }
            if (bitKey instanceof Big) {
                Big other = (Big)bitKey;
                if ((this.bits0 | Big.access$600(other)[0]) != this.bits0) {
                    return false;
                }
                if ((this.bits1 | Big.access$600(other)[1]) != this.bits1) {
                    return false;
                }
                for (int i = 2; i < Big.access$600(other).length; ++i) {
                    if (Big.access$600(other)[i] == 0L) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        public boolean intersects(BitKey bitKey) {
            if (bitKey instanceof Small) {
                Small other = (Small)bitKey;
                return (this.bits0 & Small.access$800(other)) != 0L;
            }
            if (bitKey instanceof Mid128) {
                Mid128 other = (Mid128)bitKey;
                return (this.bits0 & other.bits0) != 0L || (this.bits1 & other.bits1) != 0L;
            }
            if (bitKey instanceof Big) {
                Big other = (Big)bitKey;
                if ((this.bits0 & Big.access$600(other)[0]) != 0L) {
                    return true;
                }
                return (this.bits1 & Big.access$600(other)[1]) != 0L;
            }
            return false;
        }

        public BitSet toBitSet() {
            BitSet bitSet = new BitSet(128);
            Mid128.copyFromLong(bitSet, 0, this.bits0);
            Mid128.copyFromLong(bitSet, 64, this.bits1);
            return bitSet;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof Small) {
                Small other = (Small)o;
                return this.bits0 == Small.access$800(other) && this.bits1 == 0L;
            }
            if (o instanceof Mid128) {
                Mid128 other = (Mid128)o;
                return this.bits0 == other.bits0 && this.bits1 == other.bits1;
            }
            if (o instanceof Big) {
                Big other = (Big)o;
                if (this.bits0 != Big.access$600(other)[0]) {
                    return false;
                }
                if (this.bits1 != Big.access$600(other)[1]) {
                    return false;
                }
                for (int i = 2; i < Big.access$600(other).length; ++i) {
                    if (Big.access$600(other)[i] == 0L) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        public int hashCode() {
            long h = 1234L;
            h ^= this.bits0;
            return (int)((h ^= this.bits1 * 2L) >> 32 ^ h);
        }

        public String toString() {
            StringBuffer buf = new StringBuffer(64);
            buf.append("0x");
            for (int i = 127; i >= 0; --i) {
                buf.append(this.get(i) ? (char)'1' : '0');
            }
            return buf.toString();
        }

        public BitKey copy() {
            return new Mid128(this);
        }

        public BitKey emptyCopy() {
            return new Mid128();
        }

        public boolean isEmpty() {
            return this.bits0 == 0L && this.bits1 == 0L;
        }

        Mid128(1 x0) {
            this();
        }

        static void access$300(Mid128 x0, long x1, long x2) {
            x0.or(x1, x2);
        }

        static long access$500(Mid128 x0) {
            return x0.bits0;
        }

        static long access$700(Mid128 x0) {
            return x0.bits1;
        }

        static void access$1100(Mid128 x0, long x1, long x2) {
            x0.and(x1, x2);
        }
    }

    public static class Small
    extends AbstractBitKey {
        private long bits;

        private Small() {
        }

        private Small(long bits) {
            this.bits = bits;
        }

        public void set(int pos) {
            if (pos < 64) {
                this.bits |= Small.bit(pos);
            } else {
                throw new IllegalArgumentException("pos " + pos + " exceeds capacity 64");
            }
        }

        public boolean get(int pos) {
            return pos < 64 && (this.bits & Small.bit(pos)) != 0L;
        }

        public void clear(int pos) {
            this.bits &= Small.bit(pos) ^ 0xFFFFFFFFFFFFFFFFL;
        }

        public void clear() {
            this.bits = 0L;
        }

        private void or(long bits) {
            this.bits |= bits;
        }

        private void and(long bits) {
            this.bits &= bits;
        }

        public BitKey or(BitKey bitKey) {
            if (bitKey instanceof Small) {
                Small other = (Small)bitKey;
                Small bk = (Small)this.copy();
                bk.or(other.bits);
                return bk;
            }
            if (bitKey instanceof Mid128) {
                Mid128 other = (Mid128)bitKey;
                Mid128 bk = (Mid128)other.copy();
                Mid128.access$300(bk, this.bits, 0L);
                return bk;
            }
            if (bitKey instanceof Big) {
                Big other = (Big)bitKey;
                Big bk = (Big)other.copy();
                Big.access$400(bk, this.bits);
                return bk;
            }
            throw this.createException(bitKey);
        }

        public BitKey and(BitKey bitKey) {
            if (bitKey instanceof Small) {
                Small other = (Small)bitKey;
                Small bk = (Small)this.copy();
                bk.and(other.bits);
                return bk;
            }
            if (bitKey instanceof Mid128) {
                Mid128 other = (Mid128)bitKey;
                Small bk = (Small)this.copy();
                bk.and(Mid128.access$500(other));
                return bk;
            }
            if (bitKey instanceof Big) {
                Big other = (Big)bitKey;
                Small bk = (Small)this.copy();
                bk.and(Big.access$600(other)[0]);
                return bk;
            }
            throw this.createException(bitKey);
        }

        public BitKey andNot(BitKey bitKey) {
            if (bitKey instanceof Small) {
                Small other = (Small)bitKey;
                Small bk = (Small)this.copy();
                bk.andNot(other.bits);
                return bk;
            }
            if (bitKey instanceof Mid128) {
                Mid128 other = (Mid128)bitKey;
                Small bk = (Small)this.copy();
                bk.andNot(Mid128.access$500(other));
                return bk;
            }
            if (bitKey instanceof Big) {
                Big other = (Big)bitKey;
                Small bk = (Small)this.copy();
                bk.andNot(Big.access$600(other)[0]);
                return bk;
            }
            throw this.createException(bitKey);
        }

        private void andNot(long bits) {
            this.bits &= bits ^ 0xFFFFFFFFFFFFFFFFL;
        }

        public boolean isSuperSetOf(BitKey bitKey) {
            if (bitKey instanceof Small) {
                Small other = (Small)bitKey;
                return (this.bits | other.bits) == this.bits;
            }
            if (bitKey instanceof Mid128) {
                Mid128 other = (Mid128)bitKey;
                return (this.bits | Mid128.access$500(other)) == this.bits && Mid128.access$700(other) == 0L;
            }
            if (bitKey instanceof Big) {
                Big other = (Big)bitKey;
                if ((this.bits | Big.access$600(other)[0]) != this.bits) {
                    return false;
                }
                for (int i = 1; i < Big.access$600(other).length; ++i) {
                    if (Big.access$600(other)[i] == 0L) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        public boolean intersects(BitKey bitKey) {
            if (bitKey instanceof Small) {
                Small other = (Small)bitKey;
                return (this.bits & other.bits) != 0L;
            }
            if (bitKey instanceof Mid128) {
                Mid128 other = (Mid128)bitKey;
                return (this.bits & Mid128.access$500(other)) != 0L;
            }
            if (bitKey instanceof Big) {
                Big other = (Big)bitKey;
                return (this.bits & Big.access$600(other)[0]) != 0L;
            }
            return false;
        }

        public BitSet toBitSet() {
            BitSet bitSet = new BitSet(64);
            long x = this.bits;
            int pos = 0;
            while (x != 0L) {
                Small.copyFromByte(bitSet, pos, (byte)(x & 0xFFL));
                x >>= 8;
                pos += 8;
            }
            return bitSet;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof Small) {
                Small other = (Small)o;
                return this.bits == other.bits;
            }
            if (o instanceof Mid128) {
                Mid128 other = (Mid128)o;
                return this.bits == Mid128.access$500(other) && Mid128.access$700(other) == 0L;
            }
            if (o instanceof Big) {
                Big other = (Big)o;
                if (this.bits != Big.access$600(other)[0]) {
                    return false;
                }
                for (int i = 1; i < Big.access$600(other).length; ++i) {
                    if (Big.access$600(other)[i] == 0L) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        public int hashCode() {
            return (int)(this.bits ^ this.bits >>> 32);
        }

        public String toString() {
            StringBuffer buf = new StringBuffer(64);
            buf.append("0x");
            for (int i = 63; i >= 0; --i) {
                buf.append(this.get(i) ? (char)'1' : '0');
            }
            return buf.toString();
        }

        public BitKey copy() {
            return new Small(this.bits);
        }

        public BitKey emptyCopy() {
            return new Small();
        }

        public boolean isEmpty() {
            return this.bits == 0L;
        }

        Small(1 x0) {
            this();
        }

        static long access$800(Small x0) {
            return x0.bits;
        }

        static void access$1000(Small x0, long x1) {
            x0.and(x1);
        }
    }

    public static abstract class AbstractBitKey
    implements BitKey {
        protected static final int ChunkBitCount = 6;
        protected static final int Mask = 63;

        protected AbstractBitKey() {
        }

        protected static long bit(int pos) {
            return 1L << (pos & 0x3F);
        }

        protected static int chunkPos(int size) {
            return size >> 6;
        }

        protected static int chunkCount(int size) {
            return size + 63 >> 6;
        }

        public final void set(int pos, boolean value) {
            if (value) {
                this.set(pos);
            } else {
                this.clear(pos);
            }
        }

        protected static void copyFromByte(BitSet bitSet, int pos, byte x) {
            if (x == 0) {
                return;
            }
            if ((x & 1) != 0) {
                bitSet.set(pos, true);
            }
            ++pos;
            if ((x & 2) != 0) {
                bitSet.set(pos, true);
            }
            ++pos;
            if ((x & 4) != 0) {
                bitSet.set(pos, true);
            }
            ++pos;
            if ((x & 8) != 0) {
                bitSet.set(pos, true);
            }
            ++pos;
            if ((x & 0x10) != 0) {
                bitSet.set(pos, true);
            }
            ++pos;
            if ((x & 0x20) != 0) {
                bitSet.set(pos, true);
            }
            ++pos;
            if ((x & 0x40) != 0) {
                bitSet.set(pos, true);
            }
            ++pos;
            if ((x & 0x80) != 0) {
                bitSet.set(pos, true);
            }
        }

        protected static void copyFromLong(BitSet bitSet, int pos, long x) {
            while (x != 0L) {
                AbstractBitKey.copyFromByte(bitSet, pos, (byte)(x & 0xFFL));
                x >>= 8;
                pos += 8;
            }
        }

        protected IllegalArgumentException createException(BitKey bitKey) {
            String msg = bitKey == null ? "Null BitKey" : "Bad BitKey type: " + bitKey.getClass().getName();
            return new IllegalArgumentException(msg);
        }
    }

    public static abstract class Factory {
        public static BitKey makeBitKey(int size) {
            if (size < 0) {
                String msg = "Negative size \"" + size + "\" not allowed";
                throw new IllegalArgumentException(msg);
            }
            switch (AbstractBitKey.chunkCount(size)) {
                case 0: 
                case 1: {
                    return new Small(null);
                }
                case 2: {
                    return new Mid128(null);
                }
            }
            return new Big(size, null);
        }

        public static BitKey makeBitKey(BitSet bitSet) {
            BitKey bitKey = Factory.makeBitKey(bitSet.length());
            int i = bitSet.nextSetBit(0);
            while (i >= 0) {
                bitKey.set(i);
                i = bitSet.nextSetBit(i + 1);
            }
            return bitKey;
        }
    }
}

