/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.type;

import mondrian.olap.Dimension;
import mondrian.olap.Hierarchy;
import mondrian.olap.Level;
import mondrian.olap.Member;
import mondrian.olap.Util;
import mondrian.olap.type.ScalarType;
import mondrian.olap.type.Type;

public class MemberType
implements Type {
    private final Hierarchy hierarchy;
    private final Dimension dimension;
    private final Level level;
    private final Member member;
    private final String digest;
    public static final MemberType Unknown = new MemberType(null, null, null, null);

    public MemberType(Dimension dimension, Hierarchy hierarchy, Level level, Member member) {
        this.dimension = dimension;
        this.hierarchy = hierarchy;
        this.level = level;
        this.member = member;
        if (member != null) {
            Util.assertPrecondition(level != null);
            Util.assertPrecondition(member.getLevel() == level);
        }
        if (level != null) {
            Util.assertPrecondition(hierarchy != null);
            Util.assertPrecondition(level.getHierarchy() == hierarchy);
        }
        if (hierarchy != null) {
            Util.assertPrecondition(dimension != null);
            Util.assertPrecondition(hierarchy.getDimension() == dimension);
        }
        StringBuffer buf = new StringBuffer("MemberType<");
        if (member != null) {
            buf.append("member=").append(member.getUniqueName());
        } else if (level != null) {
            buf.append("level=").append(level.getUniqueName());
        } else if (hierarchy != null) {
            buf.append("hierarchy=").append(hierarchy.getUniqueName());
        } else if (dimension != null) {
            buf.append("dimension=").append(dimension.getUniqueName());
        }
        buf.append(">");
        this.digest = buf.toString();
    }

    public static MemberType forDimension(Dimension dimension) {
        return new MemberType(dimension, null, null, null);
    }

    public static MemberType forHierarchy(Hierarchy hierarchy) {
        return new MemberType(hierarchy.getDimension(), hierarchy, null, null);
    }

    public static MemberType forLevel(Level level) {
        return new MemberType(level.getDimension(), level.getHierarchy(), level, null);
    }

    public static MemberType forMember(Member member) {
        return new MemberType(member.getDimension(), member.getHierarchy(), member.getLevel(), member);
    }

    public String toString() {
        return this.digest;
    }

    public Hierarchy getHierarchy() {
        return this.hierarchy;
    }

    public Level getLevel() {
        return this.level;
    }

    public boolean usesDimension(Dimension dimension, boolean maybe) {
        if (this.dimension == null) {
            return maybe;
        }
        return this.dimension == dimension || maybe && this.dimension == null;
    }

    public Type getValueType() {
        return new ScalarType();
    }

    public Dimension getDimension() {
        return this.dimension;
    }

    public static MemberType forType(Type type) {
        if (type instanceof MemberType) {
            return (MemberType)type;
        }
        return new MemberType(type.getDimension(), type.getHierarchy(), type.getLevel(), null);
    }
}

