/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.type;

import mondrian.olap.Dimension;
import mondrian.olap.Hierarchy;
import mondrian.olap.Level;
import mondrian.olap.Util;
import mondrian.olap.type.Type;

public class LevelType
implements Type {
    private final Dimension dimension;
    private final Hierarchy hierarchy;
    private final Level level;
    private final String digest;

    public LevelType(Dimension dimension, Hierarchy hierarchy, Level level) {
        this.dimension = dimension;
        this.hierarchy = hierarchy;
        this.level = level;
        if (level != null) {
            Util.assertPrecondition(hierarchy != null, "hierarchy != null");
            Util.assertPrecondition(level.getHierarchy() == hierarchy, "level.getHierarchy() == hierarchy");
        }
        if (hierarchy != null) {
            Util.assertPrecondition(dimension != null, "dimension != null");
            Util.assertPrecondition(hierarchy.getDimension() == dimension, "hierarchy.getDimension() == dimension");
        }
        StringBuffer buf = new StringBuffer("LevelType<");
        if (level != null) {
            buf.append("level=").append(level.getUniqueName());
        } else if (hierarchy != null) {
            buf.append("hierarchy=").append(hierarchy.getUniqueName());
        } else if (dimension != null) {
            buf.append("dimension=").append(dimension.getUniqueName());
        }
        buf.append(">");
        this.digest = buf.toString();
    }

    public static LevelType forType(Type type) {
        return new LevelType(type.getDimension(), type.getHierarchy(), type.getLevel());
    }

    public static LevelType forLevel(Level level) {
        return new LevelType(level.getDimension(), level.getHierarchy(), level);
    }

    public boolean usesDimension(Dimension dimension, boolean maybe) {
        if (this.dimension == null) {
            return maybe;
        }
        return this.dimension == dimension;
    }

    public Dimension getDimension() {
        return this.dimension;
    }

    public Hierarchy getHierarchy() {
        return this.hierarchy;
    }

    public Level getLevel() {
        return this.level;
    }

    public String toString() {
        return this.digest;
    }
}

