/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.fun;

import java.util.List;
import java.util.Map;
import mondrian.calc.Calc;
import mondrian.calc.DoubleCalc;
import mondrian.calc.ExpCompiler;
import mondrian.calc.ListCalc;
import mondrian.calc.impl.AbstractListCalc;
import mondrian.mdx.ResolvedFunCall;
import mondrian.olap.Dimension;
import mondrian.olap.Evaluator;
import mondrian.olap.Exp;
import mondrian.olap.FunDef;
import mondrian.olap.Member;
import mondrian.olap.Util;
import mondrian.olap.fun.FunDefBase;
import mondrian.olap.fun.FunUtil;
import mondrian.olap.fun.MultiResolver;

class TopBottomPercentSumFunDef
extends FunDefBase {
    final boolean top;
    final boolean percent;
    static final ResolverImpl TopPercentResolver = new ResolverImpl("TopPercent", "TopPercent(<Set>, <Percentage>, <Numeric Expression>)", "Sorts a set and returns the top N elements whose cumulative total is at least a specified percentage.", new String[]{"fxxnn"}, true, true);
    static final ResolverImpl BottomPercentResolver = new ResolverImpl("BottomPercent", "BottomPercent(<Set>, <Percentage>, <Numeric Expression>)", "Sorts a set and returns the bottom N elements whose cumulative total is at least a specified percentage.", new String[]{"fxxnn"}, false, true);
    static final ResolverImpl TopSumResolver = new ResolverImpl("TopSum", "TopSum(<Set>, <Value>, <Numeric Expression>)", "Sorts a set and returns the top N elements whose cumulative total is at least a specified value.", new String[]{"fxxnn"}, true, false);
    static final ResolverImpl BottomSumResolver = new ResolverImpl("BottomSum", "BottomSum(<Set>, <Value>, <Numeric Expression>)", "Sorts a set and returns the bottom N elements whose cumulative total is at least a specified value.", new String[]{"fxxnn"}, false, false);

    public TopBottomPercentSumFunDef(FunDef dummyFunDef, boolean top, boolean percent) {
        super(dummyFunDef);
        this.top = top;
        this.percent = percent;
    }

    public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
        ListCalc listCalc = compiler.compileList(call.getArg(0));
        DoubleCalc doubleCalc = compiler.compileDouble(call.getArg(1));
        Calc calc = compiler.compileScalar(call.getArg(2), true);
        return new CalcImpl(call, listCalc, doubleCalc, calc);
    }

    private class CalcImpl
    extends AbstractListCalc {
        private final ListCalc listCalc;
        private final DoubleCalc doubleCalc;
        private final Calc calc;

        public CalcImpl(ResolvedFunCall call, ListCalc listCalc, DoubleCalc doubleCalc, Calc calc) {
            super(call, new Calc[]{listCalc, doubleCalc, calc});
            this.listCalc = listCalc;
            this.doubleCalc = doubleCalc;
            this.calc = calc;
        }

        public List evaluateList(Evaluator evaluator) {
            List list = this.listCalc.evaluateList(evaluator);
            double target = this.doubleCalc.evaluateDouble(evaluator);
            if (list.isEmpty()) {
                return list;
            }
            Object first = list.get(0);
            Map mapMemberToValue = first instanceof Member ? FunUtil.evaluateMembers(evaluator, this.calc, list, false) : FunUtil.evaluateTuples(evaluator, this.calc, list);
            FunUtil.sort(evaluator, list, this.calc, TopBottomPercentSumFunDef.this.top, true);
            if (TopBottomPercentSumFunDef.this.percent) {
                FunUtil.toPercent(list, mapMemberToValue);
            }
            double runningTotal = 0.0;
            int memberCount = list.size();
            int nullCount = 0;
            for (int i = 0; i < memberCount; ++i) {
                if (runningTotal >= target) {
                    list = list.subList(0, i);
                    break;
                }
                Object o = mapMemberToValue.get(list.get(i));
                if (o == Util.nullValue) {
                    ++nullCount;
                    continue;
                }
                if (o instanceof Number) {
                    runningTotal += ((Number)o).doubleValue();
                    continue;
                }
                if (o instanceof Exception) continue;
                throw Util.newInternal("got " + o + " when expecting Number");
            }
            if (memberCount > 0 && TopBottomPercentSumFunDef.this.percent && nullCount == memberCount) {
                return TopBottomPercentSumFunDef.this.top ? list.subList(0, 1) : list.subList(memberCount - 1, memberCount);
            }
            return list;
        }

        public boolean dependsOn(Dimension dimension) {
            return CalcImpl.anyDependsButFirst(this.getCalcs(), dimension);
        }
    }

    private static class ResolverImpl
    extends MultiResolver {
        private final boolean top;
        private final boolean percent;

        public ResolverImpl(String name, String signature, String description, String[] signatures, boolean top, boolean percent) {
            super(name, signature, description, signatures);
            this.top = top;
            this.percent = percent;
        }

        protected FunDef createFunDef(Exp[] args, FunDef dummyFunDef) {
            return new TopBottomPercentSumFunDef(dummyFunDef, this.top, this.percent);
        }
    }
}

