/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.fun;

import java.util.ArrayList;
import mondrian.calc.Calc;
import mondrian.calc.ExpCompiler;
import mondrian.mdx.DimensionExpr;
import mondrian.mdx.HierarchyExpr;
import mondrian.mdx.ResolvedFunCall;
import mondrian.olap.Dimension;
import mondrian.olap.Exp;
import mondrian.olap.Hierarchy;
import mondrian.olap.Util;
import mondrian.olap.Validator;
import mondrian.olap.fun.FunDefBase;
import mondrian.olap.type.TupleType;
import mondrian.olap.type.Type;
import mondrian.resource.MondrianResource;

class StrToTupleFunDef
extends FunDefBase {
    static final StrToTupleFunDef instance = new StrToTupleFunDef();

    private StrToTupleFunDef() {
        super("StrToTuple", "StrToTuple(<String Expression>)", "Constructs a tuple from a string.", "ftS");
    }

    public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
        throw Util.needToImplement(this);
    }

    public Exp createCall(Validator validator, Exp[] args) {
        int argCount = args.length;
        if (argCount <= 1) {
            throw MondrianResource.instance().MdxFuncArgumentsNum.ex(this.getName());
        }
        for (int i = 1; i < argCount; ++i) {
            Exp arg = args[i];
            if (arg instanceof DimensionExpr) {
                DimensionExpr dimensionExpr = (DimensionExpr)arg;
                Dimension dimension = dimensionExpr.getDimension();
                args[i] = new HierarchyExpr(dimension.getHierarchy());
                continue;
            }
            if (arg instanceof Hierarchy) continue;
            throw MondrianResource.instance().MdxFuncNotHier.ex(new Integer(i + 1), this.getName());
        }
        return super.createCall(validator, args);
    }

    public Type getResultType(Validator validator, Exp[] args) {
        if (args.length == 1) {
            return new TupleType(null);
        }
        ArrayList<Type> list = new ArrayList<Type>();
        for (int i = 1; i < args.length; ++i) {
            Exp arg = args[i];
            Type type = arg.getType();
            list.add(type);
        }
        Type[] types = list.toArray(new Type[list.size()]);
        return new TupleType(types);
    }
}

