/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.fun;

import java.util.ArrayList;
import mondrian.calc.Calc;
import mondrian.calc.ExpCompiler;
import mondrian.mdx.DimensionExpr;
import mondrian.mdx.HierarchyExpr;
import mondrian.mdx.ResolvedFunCall;
import mondrian.olap.Dimension;
import mondrian.olap.Exp;
import mondrian.olap.FunDef;
import mondrian.olap.Syntax;
import mondrian.olap.Validator;
import mondrian.olap.fun.FunDefBase;
import mondrian.olap.fun.ResolverBase;
import mondrian.olap.type.SetType;
import mondrian.olap.type.StringType;
import mondrian.olap.type.TupleType;
import mondrian.olap.type.Type;
import mondrian.resource.MondrianResource;

class StrToSetFunDef
extends FunDefBase {
    static final ResolverImpl Resolver = new ResolverImpl();

    public StrToSetFunDef(int[] parameterTypes) {
        super("StrToSet", "<Set> StrToSet(<String>[, <Dimension>...])", "Constructs a set from a string expression.", Syntax.Function, 8, parameterTypes);
    }

    public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
        throw new UnsupportedOperationException();
    }

    public Exp createCall(Validator validator, Exp[] args) {
        int argCount = args.length;
        if (argCount <= 1) {
            throw MondrianResource.instance().MdxFuncArgumentsNum.ex(this.getName());
        }
        for (int i = 1; i < argCount; ++i) {
            Exp arg = args[i];
            if (arg instanceof DimensionExpr) {
                DimensionExpr dimensionExpr = (DimensionExpr)arg;
                Dimension dimension = dimensionExpr.getDimension();
                args[i] = new HierarchyExpr(dimension.getHierarchy());
                continue;
            }
            if (arg instanceof HierarchyExpr) continue;
            throw MondrianResource.instance().MdxFuncNotHier.ex(new Integer(i + 1), this.getName());
        }
        return super.createCall(validator, args);
    }

    public Type getResultType(Validator validator, Exp[] args) {
        if (args.length == 1) {
            return new SetType(null);
        }
        ArrayList<Type> list = new ArrayList<Type>();
        for (int i = 1; i < args.length; ++i) {
            Exp arg = args[i];
            Type type = arg.getType();
            list.add(type);
        }
        Type[] types = list.toArray(new Type[list.size()]);
        return new SetType(new TupleType(types));
    }

    private static class ResolverImpl
    extends ResolverBase {
        ResolverImpl() {
            super("StrToSet", "StrToSet(<String Expression>)", "Constructs a set from a string expression.", Syntax.Function);
        }

        public FunDef resolve(Exp[] args, Validator validator, int[] conversionCount) {
            if (args.length < 1) {
                return null;
            }
            Type type = args[0].getType();
            if (!(type instanceof StringType)) {
                return null;
            }
            for (int i = 1; i < args.length; ++i) {
                Exp exp = args[i];
                if (exp instanceof DimensionExpr) continue;
                return null;
            }
            int[] argTypes = new int[args.length];
            argTypes[0] = 9;
            for (int i = 1; i < argTypes.length; ++i) {
                argTypes[i] = 3;
            }
            return new StrToSetFunDef(argTypes);
        }
    }
}

