/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.fun;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import mondrian.calc.Calc;
import mondrian.calc.ExpCompiler;
import mondrian.calc.ListCalc;
import mondrian.calc.MemberCalc;
import mondrian.calc.TupleCalc;
import mondrian.calc.VoidCalc;
import mondrian.calc.impl.AbstractListCalc;
import mondrian.calc.impl.AbstractVoidCalc;
import mondrian.mdx.ResolvedFunCall;
import mondrian.olap.Evaluator;
import mondrian.olap.Exp;
import mondrian.olap.ExpBase;
import mondrian.olap.FunDef;
import mondrian.olap.Member;
import mondrian.olap.Syntax;
import mondrian.olap.Validator;
import mondrian.olap.fun.FunDefBase;
import mondrian.olap.fun.FunUtil;
import mondrian.olap.fun.Resolver;
import mondrian.olap.fun.ResolverBase;
import mondrian.olap.type.MemberType;
import mondrian.olap.type.SetType;
import mondrian.olap.type.Type;
import mondrian.olap.type.TypeUtil;
import mondrian.resource.MondrianResource;

public class SetFunDef
extends FunDefBase {
    static final ResolverImpl Resolver = new ResolverImpl();

    SetFunDef(Resolver resolver, int[] argTypes) {
        super(resolver, 8, argTypes);
    }

    public void unparse(Exp[] args, PrintWriter pw) {
        ExpBase.unparseList(pw, args, "{", ", ", "}");
    }

    public Type getResultType(Validator validator, Exp[] args) {
        Type type0 = null;
        if (args.length == 0) {
            type0 = MemberType.Unknown;
        } else {
            for (int i = 0; i < args.length; ++i) {
                Exp arg = args[i];
                Type type = arg.getType();
                type = TypeUtil.toMemberOrTupleType(type);
                if (i == 0) {
                    type0 = type;
                    continue;
                }
                if (TypeUtil.isUnionCompatible(type0, type)) continue;
                throw MondrianResource.instance().ArgsMustHaveSameHierarchy.ex(this.getName());
            }
        }
        return new SetType(type0);
    }

    public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
        Exp[] args = call.getArgs();
        return new SetCalc((Exp)call, args, compiler);
    }

    private static class ResolverImpl
    extends ResolverBase {
        public ResolverImpl() {
            super("{}", "{<Member> [, <Member>...]}", "Brace operator constructs a set.", Syntax.Braces);
        }

        public FunDef resolve(Exp[] args, Validator validator, int[] conversionCount) {
            int[] parameterTypes = new int[args.length];
            for (int i = 0; i < args.length; ++i) {
                if (validator.canConvert(args[i], 6, conversionCount)) {
                    parameterTypes[i] = 6;
                    continue;
                }
                if (validator.canConvert(args[i], 8, conversionCount)) {
                    parameterTypes[i] = 8;
                    continue;
                }
                if (validator.canConvert(args[i], 10, conversionCount)) {
                    parameterTypes[i] = 10;
                    continue;
                }
                return null;
            }
            return new SetFunDef(this, parameterTypes);
        }
    }

    public static class SetCalc
    extends AbstractListCalc {
        private final List result = new ArrayList();
        private final VoidCalc[] voidCalcs;

        public SetCalc(Exp exp, Exp[] args, ExpCompiler compiler) {
            super(exp, null);
            this.voidCalcs = this.compileSelf(args, compiler);
        }

        public Calc[] getCalcs() {
            return this.voidCalcs;
        }

        private VoidCalc[] compileSelf(Exp[] args, ExpCompiler compiler) {
            VoidCalc[] voidCalcs = new VoidCalc[args.length];
            for (int i = 0; i < args.length; ++i) {
                voidCalcs[i] = this.createCalc(args[i], compiler);
            }
            return voidCalcs;
        }

        private VoidCalc createCalc(Exp arg, ExpCompiler compiler) {
            Type type = arg.getType();
            if (type instanceof SetType) {
                final ListCalc listCalc = compiler.compileList(arg);
                Type elementType = ((SetType)type).getElementType();
                if (elementType instanceof MemberType) {
                    return new AbstractVoidCalc(arg, new Calc[]{listCalc}){

                        public void evaluateVoid(Evaluator evaluator) {
                            List list = listCalc.evaluateList(evaluator);
                            for (int i = 0; i < list.size(); ++i) {
                                Member member = (Member)list.get(i);
                                if (member == null || member.isNull()) continue;
                                SetCalc.access$000(SetCalc.this).add(member);
                            }
                        }

                        protected String getName() {
                            return "Sublist";
                        }
                    };
                }
                return new AbstractVoidCalc(arg, new Calc[]{listCalc}){

                    public void evaluateVoid(Evaluator evaluator) {
                        List list = listCalc.evaluateList(evaluator);
                        for (int i = 0; i < list.size(); ++i) {
                            Member member;
                            Member[] members = (Member[])list.get(i);
                            for (int j = 0; j < members.length && (member = members[j]) != null && !member.isNull(); ++j) {
                            }
                        }
                        SetCalc.access$000(SetCalc.this).addAll(list);
                    }

                    protected String getName() {
                        return "Sublist";
                    }
                };
            }
            if (TypeUtil.couldBeMember(type)) {
                final MemberCalc listCalc = compiler.compileMember(arg);
                return new AbstractVoidCalc(arg, new Calc[]{listCalc}){

                    public void evaluateVoid(Evaluator evaluator) {
                        Member member = listCalc.evaluateMember(evaluator);
                        if (member == null || member.isNull()) {
                            return;
                        }
                        SetCalc.access$000(SetCalc.this).add(member);
                    }

                    protected String getName() {
                        return "Sublist";
                    }
                };
            }
            final TupleCalc tupleCalc = compiler.compileTuple(arg);
            return new AbstractVoidCalc(arg, new Calc[]{tupleCalc}){
                static final /* synthetic */ boolean $assertionsDisabled;
                private static final /* synthetic */ Class class$mondrian$olap$fun$SetFunDef;

                public void evaluateVoid(Evaluator evaluator) {
                    Member[] members = tupleCalc.evaluateTuple(evaluator);
                    if (members == null) {
                        return;
                    }
                    if (!$assertionsDisabled && FunUtil.tupleContainsNullMember(members)) {
                        throw new AssertionError();
                    }
                    SetCalc.access$000(SetCalc.this).add(members);
                }

                static {
                    $assertionsDisabled = !(class$mondrian$olap$fun$SetFunDef == null ? (class$mondrian$olap$fun$SetFunDef = 4.class$("mondrian.olap.fun.SetFunDef")) : class$mondrian$olap$fun$SetFunDef).desiredAssertionStatus();
                }

                static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName(string);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        NoClassDefFoundError noClassDefFoundError = new NoClassDefFoundError(classNotFoundException.getMessage());
                        try {
                            noClassDefFoundError.initCause(classNotFoundException);
                        }
                        catch (NoSuchMethodError noSuchMethodError) {
                            // empty catch block
                        }
                        throw noClassDefFoundError;
                    }
                    return clazz;
                }
            };
        }

        public List evaluateList(Evaluator evaluator) {
            this.result.clear();
            for (int i = 0; i < this.voidCalcs.length; ++i) {
                this.voidCalcs[i].evaluateVoid(evaluator);
            }
            return new ArrayList(this.result);
        }

        static List access$000(SetCalc x0) {
            return x0.result;
        }
    }
}

