/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.fun;

import com.rc.retroweaver.runtime.Collections;
import java.util.ArrayList;
import java.util.List;
import mondrian.calc.Calc;
import mondrian.calc.DummyExp;
import mondrian.calc.ExpCompiler;
import mondrian.calc.ListCalc;
import mondrian.calc.MemberCalc;
import mondrian.calc.impl.AbstractListCalc;
import mondrian.calc.impl.ConstantCalc;
import mondrian.calc.impl.GenericCalc;
import mondrian.calc.impl.MemberValueCalc;
import mondrian.calc.impl.ValueCalc;
import mondrian.mdx.ResolvedFunCall;
import mondrian.olap.Dimension;
import mondrian.olap.EnumeratedValues;
import mondrian.olap.Evaluator;
import mondrian.olap.FunDef;
import mondrian.olap.Member;
import mondrian.olap.fun.FunDefBase;
import mondrian.olap.fun.FunUtil;
import mondrian.olap.fun.ReflectiveMultiResolver;
import mondrian.olap.type.MemberType;

class OrderFunDef
extends FunDefBase {
    static final ReflectiveMultiResolver Resolver = new ReflectiveMultiResolver("Order", "Order(<Set>, <Value Expression>[, ASC | DESC | BASC | BDESC])", "Arranges members of a set, optionally preserving or breaking the hierarchy.", new String[]{"fxxvy", "fxxv"}, class$mondrian$olap$fun$OrderFunDef == null ? (class$mondrian$olap$fun$OrderFunDef = OrderFunDef.class$("mondrian.olap.fun.OrderFunDef")) : class$mondrian$olap$fun$OrderFunDef, Flags.instance.getNames());
    private static final /* synthetic */ Class class$mondrian$olap$fun$OrderFunDef;

    public OrderFunDef(FunDef dummyFunDef) {
        super(dummyFunDef);
    }

    public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
        ListCalc listCalc = compiler.compileList(call.getArg(0), true);
        Calc expCalc = compiler.compileScalar(call.getArg(1), true);
        int order = OrderFunDef.getLiteralArg(call, 2, 0, Flags.instance);
        boolean desc = Flags.isDescending(order);
        boolean brk = Flags.isBreak(order);
        if (expCalc instanceof MemberValueCalc) {
            MemberValueCalc memberValueCalc = (MemberValueCalc)expCalc;
            ArrayList<MemberCalc> constantList = new ArrayList<MemberCalc>();
            ArrayList<MemberCalc> variableList = new ArrayList<MemberCalc>();
            MemberCalc[] calcs = (MemberCalc[])memberValueCalc.getCalcs();
            for (int i = 0; i < calcs.length; ++i) {
                MemberCalc memberCalc = calcs[i];
                if (memberCalc instanceof ConstantCalc && !listCalc.dependsOn(((MemberType)memberCalc.getType()).getHierarchy().getDimension())) {
                    constantList.add(memberCalc);
                    continue;
                }
                variableList.add(memberCalc);
            }
            if (!constantList.isEmpty()) {
                if (variableList.isEmpty()) {
                    return new ContextCalc(calcs, new CalcImpl(call, listCalc, new ValueCalc(new DummyExp(expCalc.getType())), desc, brk));
                }
                return new ContextCalc(constantList.toArray(new MemberCalc[constantList.size()]), new CalcImpl(call, listCalc, new MemberValueCalc(new DummyExp(expCalc.getType()), variableList.toArray(new MemberCalc[variableList.size()])), desc, brk));
            }
        }
        return new CalcImpl(call, listCalc, expCalc, desc, brk);
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        Class<?> clazz;
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            NoClassDefFoundError noClassDefFoundError = new NoClassDefFoundError(classNotFoundException.getMessage());
            try {
                noClassDefFoundError.initCause(classNotFoundException);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
            throw noClassDefFoundError;
        }
        return clazz;
    }

    private static class ContextCalc
    extends GenericCalc {
        private final MemberCalc[] memberCalcs;
        private final Calc calc;
        private final Calc[] calcs;
        private final Member[] members;

        protected ContextCalc(MemberCalc[] memberCalcs, Calc calc) {
            super(new DummyExp(calc.getType()));
            this.memberCalcs = memberCalcs;
            this.calc = calc;
            this.calcs = new Calc[memberCalcs.length + 1];
            System.arraycopy(memberCalcs, 0, this.calcs, 0, memberCalcs.length);
            this.calcs[this.calcs.length - 1] = calc;
            this.members = new Member[memberCalcs.length];
        }

        public Calc[] getCalcs() {
            return this.calcs;
        }

        public Object evaluate(Evaluator evaluator) {
            for (int i = 0; i < this.memberCalcs.length; ++i) {
                this.members[i] = this.memberCalcs[i].evaluateMember(evaluator);
            }
            Evaluator subEval = evaluator.push(this.members);
            return this.calc.evaluate(subEval);
        }

        public boolean dependsOn(Dimension dimension) {
            if (ContextCalc.anyDepends(this.memberCalcs, dimension)) {
                return true;
            }
            for (int i = 0; i < this.memberCalcs.length; ++i) {
                MemberCalc memberCalc = this.memberCalcs[i];
                if (!memberCalc.getType().usesDimension(dimension, true)) continue;
                return false;
            }
            return this.calc.dependsOn(dimension);
        }
    }

    private class CalcImpl
    extends AbstractListCalc {
        private final ListCalc listCalc;
        private final Calc expCalc;
        private final boolean desc;
        private final boolean brk;
        static final /* synthetic */ boolean $assertionsDisabled;
        private static final /* synthetic */ Class class$mondrian$olap$fun$OrderFunDef;

        public CalcImpl(ResolvedFunCall call, ListCalc listCalc, Calc expCalc, boolean desc, boolean brk) {
            super(call, new Calc[]{listCalc, expCalc});
            if (!$assertionsDisabled && listCalc.getResultStyle() != ExpCompiler.ResultStyle.MUTABLE_LIST) {
                throw new AssertionError();
            }
            this.listCalc = listCalc;
            this.expCalc = expCalc;
            this.desc = desc;
            this.brk = brk;
        }

        public List evaluateList(Evaluator evaluator) {
            List list = this.listCalc.evaluateList(evaluator);
            FunUtil.sort(evaluator.push(), list, this.expCalc, this.desc, this.brk);
            return list;
        }

        public Calc[] getCalcs() {
            return new Calc[]{this.listCalc, this.expCalc};
        }

        public List getArguments() {
            return Collections.singletonList((Object)(this.desc ? (this.brk ? "BDESC" : "DESC") : (this.brk ? "BASC" : "ASC")));
        }

        public boolean dependsOn(Dimension dimension) {
            return CalcImpl.anyDependsButFirst(this.getCalcs(), dimension);
        }

        static {
            $assertionsDisabled = !(class$mondrian$olap$fun$OrderFunDef == null ? (class$mondrian$olap$fun$OrderFunDef = CalcImpl.class$("mondrian.olap.fun.OrderFunDef")) : class$mondrian$olap$fun$OrderFunDef).desiredAssertionStatus();
        }

        static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
            Class<?> clazz;
            try {
                clazz = Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                NoClassDefFoundError noClassDefFoundError = new NoClassDefFoundError(classNotFoundException.getMessage());
                try {
                    noClassDefFoundError.initCause(classNotFoundException);
                }
                catch (NoSuchMethodError noSuchMethodError) {
                    // empty catch block
                }
                throw noClassDefFoundError;
            }
            return clazz;
        }
    }

    static class Flags
    extends EnumeratedValues {
        static final Flags instance = new Flags();
        public static final int ASC = 0;
        public static final int DESC = 1;
        public static final int BASC = 2;
        public static final int BDESC = 3;

        private Flags() {
            super(new String[]{"ASC", "DESC", "BASC", "BDESC"});
        }

        public static final boolean isDescending(int value) {
            return (value & 1) == 1;
        }

        public static final boolean isBreak(int value) {
            return (value & 2) == 2;
        }
    }
}

