/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.fun;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import mondrian.calc.Calc;
import mondrian.calc.DoubleCalc;
import mondrian.calc.ExpCompiler;
import mondrian.calc.ListCalc;
import mondrian.calc.impl.AbstractDoubleCalc;
import mondrian.calc.impl.ValueCalc;
import mondrian.mdx.ResolvedFunCall;
import mondrian.olap.Evaluator;
import mondrian.olap.FunDef;
import mondrian.olap.Util;
import mondrian.olap.fun.FunDefBase;
import mondrian.olap.fun.FunUtil;
import mondrian.olap.fun.ReflectiveMultiResolver;
import mondrian.olap.fun.Resolver;
import mondrian.olap.type.SetType;
import mondrian.olap.type.TupleType;

public abstract class LinReg
extends FunDefBase {
    final int regType;
    public static final int Point = 0;
    public static final int R2 = 1;
    public static final int Intercept = 2;
    public static final int Slope = 3;
    public static final int Variance = 4;
    static final Resolver InterceptResolver = new ReflectiveMultiResolver("LinRegIntercept", "LinRegIntercept(<Set>, <Numeric Expression>[, <Numeric Expression>])", "Calculates the linear regression of a set and returns the value of b in the regression line y = ax + b.", new String[]{"fnxn", "fnxnn"}, class$mondrian$olap$fun$LinReg$InterceptFunDef == null ? (class$mondrian$olap$fun$LinReg$InterceptFunDef = LinReg.class$("mondrian.olap.fun.LinReg$InterceptFunDef")) : class$mondrian$olap$fun$LinReg$InterceptFunDef);
    static final Resolver PointResolver = new ReflectiveMultiResolver("LinRegPoint", "LinRegPoint(<Numeric Expression>, <Set>, <Numeric Expression>[, <Numeric Expression>])", "Calculates the linear regression of a set and returns the value of y in the regression line y = ax + b.", new String[]{"fnnxn", "fnnxnn"}, class$mondrian$olap$fun$LinReg$PointFunDef == null ? (class$mondrian$olap$fun$LinReg$PointFunDef = LinReg.class$("mondrian.olap.fun.LinReg$PointFunDef")) : class$mondrian$olap$fun$LinReg$PointFunDef);
    static final Resolver SlopeResolver = new ReflectiveMultiResolver("LinRegSlope", "LinRegSlope(<Set>, <Numeric Expression>[, <Numeric Expression>])", "Calculates the linear regression of a set and returns the value of a in the regression line y = ax + b.", new String[]{"fnxn", "fnxnn"}, class$mondrian$olap$fun$LinReg$SlopeFunDef == null ? (class$mondrian$olap$fun$LinReg$SlopeFunDef = LinReg.class$("mondrian.olap.fun.LinReg$SlopeFunDef")) : class$mondrian$olap$fun$LinReg$SlopeFunDef);
    static final Resolver R2Resolver = new ReflectiveMultiResolver("LinRegR2", "LinRegR2(<Set>, <Numeric Expression>[, <Numeric Expression>])", "Calculates the linear regression of a set and returns R2 (the coefficient of determination).", new String[]{"fnxn", "fnxnn"}, class$mondrian$olap$fun$LinReg$R2FunDef == null ? (class$mondrian$olap$fun$LinReg$R2FunDef = LinReg.class$("mondrian.olap.fun.LinReg$R2FunDef")) : class$mondrian$olap$fun$LinReg$R2FunDef);
    static final Resolver VarianceResolver = new ReflectiveMultiResolver("LinRegVariance", "LinRegVariance(<Set>, <Numeric Expression>[, <Numeric Expression>])", "Calculates the linear regression of a set and returns the variance associated with the regression line y = ax + b.", new String[]{"fnxn", "fnxnn"}, class$mondrian$olap$fun$LinReg$VarianceFunDef == null ? (class$mondrian$olap$fun$LinReg$VarianceFunDef = LinReg.class$("mondrian.olap.fun.LinReg$VarianceFunDef")) : class$mondrian$olap$fun$LinReg$VarianceFunDef);
    private static final /* synthetic */ Class class$mondrian$olap$fun$LinReg$SlopeFunDef;
    private static final /* synthetic */ Class class$mondrian$olap$fun$LinReg$VarianceFunDef;
    private static final /* synthetic */ Class class$mondrian$olap$fun$LinReg$PointFunDef;
    private static final /* synthetic */ Class class$mondrian$olap$fun$LinReg$InterceptFunDef;
    private static final /* synthetic */ Class class$mondrian$olap$fun$LinReg$R2FunDef;

    public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
        ListCalc listCalc = compiler.compileList(call.getArg(0));
        DoubleCalc yCalc = compiler.compileDouble(call.getArg(1));
        DoubleCalc xCalc = call.getArgCount() > 2 ? compiler.compileDouble(call.getArg(2)) : new ValueCalc(call);
        boolean isTuples = ((SetType)listCalc.getType()).getElementType() instanceof TupleType;
        return new LinRegCalc(call, listCalc, yCalc, xCalc, isTuples, this.regType);
    }

    protected static void debug(String type, String msg) {
    }

    protected LinReg(FunDef funDef, int regType) {
        super(funDef);
        this.regType = regType;
    }

    protected static Value process(Evaluator evaluator, ListCalc listCalc, DoubleCalc yCalc, DoubleCalc xCalc, boolean isTuples) {
        List members = listCalc.evaluateList(evaluator);
        evaluator = evaluator.push();
        FunUtil.SetWrapper[] sws = LinReg.evaluateSet(evaluator, members, new DoubleCalc[]{yCalc, xCalc}, isTuples);
        FunUtil.SetWrapper swY = sws[0];
        FunUtil.SetWrapper swX = sws[1];
        if (swY.errorCount > 0) {
            LinReg.debug("LinReg.process", "ERROR error(s) count =" + swY.errorCount);
            return null;
        }
        if (swY.v.size() == 0) {
            return null;
        }
        return LinReg.linearReg(swX.v, swY.v);
    }

    public static Value accuracy(Value value) {
        double sumErrSquared = 0.0;
        double sumErr = 0.0;
        double sumSquaredY = 0.0;
        double sumY = 0.0;
        double sumSquaredYF = 0.0;
        double sumYF = 0.0;
        List yfs = LinReg.forecast(value);
        Iterator ity = Value.access$000(value).iterator();
        Iterator ityf = yfs.iterator();
        while (ity.hasNext()) {
            Double dyf;
            Double dy = (Double)ity.next();
            if (dy == null || (dyf = (Double)ityf.next()) == null) continue;
            double y = dy;
            double yf = dyf;
            double error = yf - y;
            sumErr += error;
            sumErrSquared += error * error;
            sumY += y;
            sumSquaredY += y * y;
            sumYF = yf;
            sumSquaredYF = yf * yf;
        }
        int n = Value.access$000(value).size();
        if (n > 2) {
            double variance = sumErrSquared / (double)(n - 2);
            value.setVariance(variance);
        }
        double MSE = sumErr / (double)n;
        double MST = sumY / (double)n;
        double SSE = 0.0;
        double SST = 0.0;
        ity = Value.access$000(value).iterator();
        ityf = yfs.iterator();
        while (ity.hasNext()) {
            Double dyf;
            Double dy = (Double)ity.next();
            if (dy == null || (dyf = (Double)ityf.next()) == null) continue;
            double y = dy;
            double yf = dyf;
            double error = yf - y;
            SSE += (error - MSE) * (error - MSE);
            SST += (y - MST) * (y - MST);
        }
        if (SST != 0.0) {
            double rSquared = 1.0 - SSE / SST;
            value.setRSquared(rSquared);
        }
        return value;
    }

    public static Value linearReg(List xlist, List ylist) {
        int size = ylist.size();
        double sumX = 0.0;
        double sumY = 0.0;
        double sumXX = 0.0;
        double sumXY = 0.0;
        LinReg.debug("LinReg.linearReg", "ylist.size()=" + ylist.size());
        LinReg.debug("LinReg.linearReg", "xlist.size()=" + xlist.size());
        int n = 0;
        for (int i = 0; i < size; ++i) {
            Object yo = ylist.get(i);
            Object xo = xlist.get(i);
            if (yo == null || xo == null) continue;
            ++n;
            double y = (Double)yo;
            double x = (Double)xo;
            LinReg.debug("LinReg.linearReg", " " + i + " (" + x + "," + y + ")");
            sumX += x;
            sumY += y;
            sumXX += x * x;
            sumXY += x * y;
        }
        double xMean = sumX / (double)n;
        double yMean = sumY / (double)n;
        LinReg.debug("LinReg.linearReg", "yMean=" + yMean);
        LinReg.debug("LinReg.linearReg", "(n*sumXX - sumX*sumX)=" + ((double)n * sumXX - sumX * sumX));
        double slope = ((double)n * sumXY - sumX * sumY) / ((double)n * sumXX - sumX * sumX);
        double intercept = yMean - slope * xMean;
        Value value = new Value(intercept, slope, xlist, ylist);
        LinReg.debug("LinReg.linearReg", "value=" + value);
        return value;
    }

    public static List forecast(Value value) {
        ArrayList<Double> yfs = new ArrayList<Double>(Value.access$100(value).size());
        Iterator it = Value.access$100(value).iterator();
        while (it.hasNext()) {
            Double d = (Double)it.next();
            if (d == null) {
                yfs.add(null);
                continue;
            }
            double x = d;
            double yf = value.intercept + value.slope * x;
            yfs.add(new Double(yf));
        }
        return yfs;
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        Class<?> clazz;
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            NoClassDefFoundError noClassDefFoundError = new NoClassDefFoundError(classNotFoundException.getMessage());
            try {
                noClassDefFoundError.initCause(classNotFoundException);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
            throw noClassDefFoundError;
        }
        return clazz;
    }

    private static class LinRegCalc
    extends AbstractDoubleCalc {
        private final ListCalc listCalc;
        private final DoubleCalc yCalc;
        private final DoubleCalc xCalc;
        private final boolean tuples;
        private final int regType;

        public LinRegCalc(ResolvedFunCall call, ListCalc listCalc, DoubleCalc yCalc, DoubleCalc xCalc, boolean tuples, int regType) {
            super(call, new Calc[]{listCalc, yCalc, xCalc});
            this.listCalc = listCalc;
            this.yCalc = yCalc;
            this.xCalc = xCalc;
            this.tuples = tuples;
            this.regType = regType;
        }

        public double evaluateDouble(Evaluator evaluator) {
            Value value = LinReg.process(evaluator, this.listCalc, this.yCalc, this.xCalc, this.tuples);
            if (value == null) {
                return 1.2345E-8;
            }
            switch (this.regType) {
                case 2: {
                    return value.getIntercept();
                }
                case 3: {
                    return value.getSlope();
                }
                case 4: {
                    return value.getVariance();
                }
                case 1: {
                    return value.getRSquared();
                }
            }
            throw Util.newInternal("unexpected value " + this.regType);
        }
    }

    public static class VarianceFunDef
    extends LinReg {
        public VarianceFunDef(FunDef funDef) {
            super(funDef, 4);
        }
    }

    public static class R2FunDef
    extends LinReg {
        public R2FunDef(FunDef funDef) {
            super(funDef, 1);
        }
    }

    public static class SlopeFunDef
    extends LinReg {
        public SlopeFunDef(FunDef funDef) {
            super(funDef, 3);
        }
    }

    private static class PointCalc
    extends AbstractDoubleCalc {
        private final DoubleCalc xPointCalc;
        private final ListCalc listCalc;
        private final DoubleCalc yCalc;
        private final DoubleCalc xCalc;
        private final boolean tuples;

        public PointCalc(ResolvedFunCall call, DoubleCalc xPointCalc, ListCalc listCalc, DoubleCalc yCalc, DoubleCalc xCalc, boolean tuples) {
            super(call, new Calc[]{xPointCalc, listCalc, yCalc, xCalc});
            this.xPointCalc = xPointCalc;
            this.listCalc = listCalc;
            this.yCalc = yCalc;
            this.xCalc = xCalc;
            this.tuples = tuples;
        }

        public double evaluateDouble(Evaluator evaluator) {
            double xPoint = this.xPointCalc.evaluateDouble(evaluator);
            Value value = LinReg.process(evaluator, this.listCalc, this.yCalc, this.xCalc, this.tuples);
            if (value == null) {
                return 1.2345E-8;
            }
            double yPoint = xPoint * value.getSlope() + value.getIntercept();
            return yPoint;
        }
    }

    public static class PointFunDef
    extends LinReg {
        public PointFunDef(FunDef funDef) {
            super(funDef, 0);
        }

        public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
            DoubleCalc xPointCalc = compiler.compileDouble(call.getArg(0));
            ListCalc listCalc = compiler.compileList(call.getArg(1));
            DoubleCalc yCalc = compiler.compileDouble(call.getArg(2));
            DoubleCalc xCalc = call.getArgCount() > 3 ? compiler.compileDouble(call.getArg(3)) : new ValueCalc(call);
            boolean isTuples = ((SetType)listCalc.getType()).getElementType() instanceof TupleType;
            return new PointCalc(call, xPointCalc, listCalc, yCalc, xCalc, isTuples);
        }
    }

    public static class InterceptFunDef
    extends LinReg {
        public InterceptFunDef(FunDef funDef) {
            super(funDef, 2);
        }
    }

    static class Value {
        private List xs;
        private List ys;
        double intercept;
        double slope;
        double rSquared = Double.MAX_VALUE;
        double variance = Double.MAX_VALUE;

        Value(double intercept, double slope, List xs, List ys) {
            this.intercept = intercept;
            this.slope = slope;
            this.xs = xs;
            this.ys = ys;
        }

        public double getIntercept() {
            return this.intercept;
        }

        public double getSlope() {
            return this.slope;
        }

        public double getRSquared() {
            return this.rSquared;
        }

        public void setRSquared(double rSquared) {
            this.rSquared = rSquared;
        }

        public double getVariance() {
            return this.variance;
        }

        public void setVariance(double variance) {
            this.variance = variance;
        }

        public String toString() {
            return "LinReg.Value: slope of " + this.slope + " and an intercept of " + this.intercept + ". That is, y=" + this.intercept + (this.slope > 0.0 ? " +" : " ") + this.slope + " * x.";
        }

        static List access$000(Value x0) {
            return x0.ys;
        }

        static List access$100(Value x0) {
            return x0.xs;
        }
    }
}

