/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.fun;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import mondrian.olap.Syntax;
import mondrian.olap.Util;
import mondrian.olap.fun.BuiltinFunTable;
import mondrian.olap.fun.FunTableImpl;
import mondrian.olap.fun.Resolver;
import mondrian.olap.fun.UdfResolver;
import mondrian.olap.type.Type;
import mondrian.resource.MondrianResource;
import mondrian.spi.UserDefinedFunction;
import org.apache.log4j.Logger;

public class GlobalFunTable
extends FunTableImpl {
    private static Logger logger = Logger.getLogger((Class)(class$mondrian$olap$fun$GlobalFunTable == null ? (class$mondrian$olap$fun$GlobalFunTable = GlobalFunTable.class$("mondrian.olap.fun.GlobalFunTable")) : class$mondrian$olap$fun$GlobalFunTable));
    private static GlobalFunTable instance = new GlobalFunTable();
    private static final /* synthetic */ Class class$mondrian$olap$fun$GlobalFunTable;
    private static final /* synthetic */ Class class$mondrian$spi$UserDefinedFunction;

    public static GlobalFunTable instance() {
        return instance;
    }

    private GlobalFunTable() {
        this.init();
    }

    protected void defineFunctions() {
        BuiltinFunTable builtinFunTable = BuiltinFunTable.instance();
        List reservedWords = builtinFunTable.getReservedWords();
        for (int i = 0; i < reservedWords.size(); ++i) {
            String reservedWord = (String)reservedWords.get(i);
            this.defineReserved(reservedWord);
        }
        List resolvers = builtinFunTable.getResolvers();
        for (int i = 0; i < resolvers.size(); ++i) {
            Resolver resolver = (Resolver)resolvers.get(i);
            this.define(resolver);
        }
        Iterator it = this.lookupUdfImplClasses().iterator();
        while (it.hasNext()) {
            String className = (String)it.next();
            this.defineUdf(className);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection lookupUdfImplClasses() {
        ClassLoader cl = this.getClass().getClassLoader();
        ArrayList<URL> serviceUrls = new ArrayList<URL>();
        try {
            Enumeration<URL> serviceEnum = cl.getResources("META-INF/services/mondrian.spi.UserDefinedFunction");
            while (serviceEnum.hasMoreElements()) {
                serviceUrls.add(serviceEnum.nextElement());
            }
        }
        catch (IOException e) {
            logger.warn((Object)"Error while finding service files for user-defined functions", (Throwable)e);
        }
        HashSet<String> classNames = new HashSet<String>();
        Iterator it = serviceUrls.iterator();
        while (it.hasNext()) {
            URL url = (URL)it.next();
            BufferedReader reader = null;
            try {
                reader = new BufferedReader(new InputStreamReader(url.openStream(), "UTF-8"));
                String line = null;
                while ((line = reader.readLine()) != null) {
                    if ((line = line.trim()).length() <= 0 || line.charAt(0) == '#') continue;
                    int comment = line.indexOf(35);
                    if (comment != -1) {
                        line = line.substring(0, comment).trim();
                    }
                    classNames.add(line);
                }
            }
            catch (IOException e) {
                logger.warn((Object)("Error when loading service file '" + url + "'"), (Throwable)e);
            }
            finally {
                if (reader == null) continue;
                try {
                    reader.close();
                }
                catch (IOException ignored) {}
            }
        }
        return classNames;
    }

    private void defineUdf(String className) {
        UserDefinedFunction udf;
        Class<?> udfClass;
        try {
            udfClass = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw MondrianResource.instance().UdfClassNotFound.ex("", className);
        }
        try {
            udf = (UserDefinedFunction)udfClass.newInstance();
        }
        catch (InstantiationException e) {
            throw MondrianResource.instance().UdfClassWrongIface.ex("", className, (class$mondrian$spi$UserDefinedFunction == null ? (class$mondrian$spi$UserDefinedFunction = GlobalFunTable.class$("mondrian.spi.UserDefinedFunction")) : class$mondrian$spi$UserDefinedFunction).getName());
        }
        catch (IllegalAccessException e) {
            throw MondrianResource.instance().UdfClassWrongIface.ex("", className, (class$mondrian$spi$UserDefinedFunction == null ? (class$mondrian$spi$UserDefinedFunction = GlobalFunTable.class$("mondrian.spi.UserDefinedFunction")) : class$mondrian$spi$UserDefinedFunction).getName());
        }
        catch (ClassCastException e) {
            throw MondrianResource.instance().UdfClassWrongIface.ex("", className, (class$mondrian$spi$UserDefinedFunction == null ? (class$mondrian$spi$UserDefinedFunction = GlobalFunTable.class$("mondrian.spi.UserDefinedFunction")) : class$mondrian$spi$UserDefinedFunction).getName());
        }
        this.validateFunction(udf);
        this.define(new UdfResolver(udf));
    }

    private void validateFunction(UserDefinedFunction udf) {
        String udfName = udf.getName();
        if (udfName == null || udfName.equals("")) {
            throw Util.newInternal("User-defined function defined by class '" + udf.getClass() + "' has empty name");
        }
        Type[] parameterTypes = udf.getParameterTypes();
        for (int i = 0; i < parameterTypes.length; ++i) {
            Type parameterType = parameterTypes[i];
            if (parameterType != null) continue;
            throw Util.newInternal("Invalid user-defined function '" + udfName + "': parameter type #" + i + " is null");
        }
        Type returnType = udf.getReturnType(parameterTypes);
        if (returnType == null) {
            throw Util.newInternal("Invalid user-defined function '" + udfName + "': return type is null");
        }
        Syntax syntax = udf.getSyntax();
        if (syntax == null) {
            throw Util.newInternal("Invalid user-defined function '" + udfName + "': syntax is null");
        }
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        Class<?> clazz;
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            NoClassDefFoundError noClassDefFoundError = new NoClassDefFoundError(classNotFoundException.getMessage());
            try {
                noClassDefFoundError.initCause(classNotFoundException);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
            throw noClassDefFoundError;
        }
        return clazz;
    }
}

