/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.fun;

import com.rc.retroweaver.runtime.Collections;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import mondrian.mdx.UnresolvedFunCall;
import mondrian.olap.Exp;
import mondrian.olap.ExpBase;
import mondrian.olap.FunDef;
import mondrian.olap.FunTable;
import mondrian.olap.Syntax;
import mondrian.olap.Util;
import mondrian.olap.Validator;
import mondrian.olap.fun.FunInfo;
import mondrian.olap.fun.Resolver;
import mondrian.olap.fun.SimpleResolver;
import mondrian.resource.MondrianResource;

public abstract class FunTableImpl
implements FunTable {
    protected final Map mapNameToResolvers = new HashMap();
    private final HashSet reservedWords = new HashSet();
    private final HashSet propertyWords = new HashSet();
    protected static final Resolver[] emptyResolverArray = new Resolver[0];
    protected final List resolverList = new ArrayList();
    protected final List funInfoList = new ArrayList();

    protected FunTableImpl() {
    }

    public void init() {
        this.defineFunctions();
        this.organizeFunctions();
    }

    protected static String makeResolverKey(String name, Syntax syntax) {
        return name.toUpperCase() + "$" + syntax;
    }

    protected void define(FunDef funDef) {
        this.define(new SimpleResolver(funDef));
    }

    protected void define(Resolver resolver) {
        this.addFunInfo(resolver);
        if (resolver.getSyntax() == Syntax.Property) {
            this.defineProperty(resolver.getName());
        }
        this.resolverList.add(resolver);
        String[] reservedWords = resolver.getReservedWords();
        for (int i = 0; i < reservedWords.length; ++i) {
            String reservedWord = reservedWords[i];
            this.defineReserved(reservedWord);
        }
    }

    protected void addFunInfo(Resolver resolver) {
        this.funInfoList.add(FunInfo.make(resolver));
    }

    public FunDef getDef(Exp[] args, Validator validator, String funName, Syntax syntax) {
        String key = FunTableImpl.makeResolverKey(funName, syntax);
        String signature = syntax.getSignature(funName, 0, ExpBase.getTypes(args));
        Resolver[] resolvers = (Resolver[])this.mapNameToResolvers.get(key);
        if (resolvers == null) {
            resolvers = emptyResolverArray;
        }
        int[] conversionCount = new int[]{0};
        int minConversions = Integer.MAX_VALUE;
        int matchCount = 0;
        FunDef matchDef = null;
        for (int i = 0; i < resolvers.length; ++i) {
            conversionCount[0] = 0;
            FunDef def = resolvers[i].resolve(args, validator, conversionCount);
            if (def == null) continue;
            int conversions = conversionCount[0];
            if (conversions < minConversions) {
                minConversions = conversions;
                matchCount = 1;
                matchDef = def;
                continue;
            }
            if (conversions != minConversions) continue;
            ++matchCount;
        }
        switch (matchCount) {
            case 0: {
                throw MondrianResource.instance().NoFunctionMatchesSignature.ex(signature);
            }
            case 1: {
                String matchKey = FunTableImpl.makeResolverKey(matchDef.getName(), matchDef.getSyntax());
                Util.assertTrue(matchKey.equals(key), matchKey);
                return matchDef;
            }
        }
        throw MondrianResource.instance().MoreThanOneFunctionMatchesSignature.ex(signature);
    }

    public boolean requiresExpression(UnresolvedFunCall call, int k, Validator validator) {
        String key = FunTableImpl.makeResolverKey(call.getFunName(), call.getSyntax());
        Resolver[] resolvers = (Resolver[])this.mapNameToResolvers.get(key);
        if (resolvers == null) {
            resolvers = emptyResolverArray;
        }
        for (int i = 0; i < resolvers.length; ++i) {
            Resolver resolver2 = resolvers[i];
            if (resolver2.requiresExpression(k)) continue;
            return false;
        }
        return true;
    }

    public List getReservedWords() {
        return new ArrayList(this.reservedWords);
    }

    public boolean isReserved(String s) {
        return this.reservedWords.contains(s.toUpperCase());
    }

    protected void defineReserved(String s) {
        this.reservedWords.add(s.toUpperCase());
    }

    public List getResolvers() {
        ArrayList<Resolver> list = new ArrayList<Resolver>();
        Collection c = this.mapNameToResolvers.values();
        Iterator iterator = c.iterator();
        while (iterator.hasNext()) {
            Resolver[] resolvers = (Resolver[])iterator.next();
            for (int i = 0; i < resolvers.length; ++i) {
                Resolver resolver = resolvers[i];
                list.add(resolver);
            }
        }
        return list;
    }

    public boolean isProperty(String s) {
        return this.propertyWords.contains(s.toUpperCase());
    }

    protected void defineProperty(String s) {
        this.propertyWords.add(s.toUpperCase());
    }

    public List getFunInfoList() {
        return Collections.unmodifiableList((List)this.funInfoList);
    }

    protected void organizeFunctions() {
        Collections.sort((List)this.funInfoList);
        int n = this.resolverList.size();
        for (int i = 0; i < n; ++i) {
            Resolver resolver = (Resolver)this.resolverList.get(i);
            String key = FunTableImpl.makeResolverKey(resolver.getName(), resolver.getSyntax());
            Object value = this.mapNameToResolvers.get(key);
            if (value instanceof Resolver[]) continue;
            ArrayList<Resolver> v2 = (ArrayList<Resolver>)value;
            if (v2 == null) {
                v2 = new ArrayList<Resolver>();
                this.mapNameToResolvers.put(key, v2);
            }
            v2.add(resolver);
        }
        Iterator keys = this.mapNameToResolvers.keySet().iterator();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            Object value = this.mapNameToResolvers.get(key);
            if (value instanceof Resolver[]) continue;
            List v2 = (List)value;
            this.mapNameToResolvers.put(key, v2.toArray(new Resolver[v2.size()]));
        }
    }

    protected abstract void defineFunctions();
}

