/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.fun;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import mondrian.olap.FunDef;
import mondrian.olap.Syntax;
import mondrian.olap.fun.FunUtil;
import mondrian.olap.fun.MultiResolver;
import mondrian.olap.fun.Resolver;
import mondrian.olap.fun.SimpleResolver;

public class FunInfo
implements Comparable {
    private final Syntax syntax;
    private final String name;
    private final String description;
    private final int[] returnTypes;
    private final int[][] parameterTypes;
    private String[] sigs;

    static FunInfo make(Resolver resolver) {
        if (resolver instanceof SimpleResolver) {
            FunDef funDef = ((SimpleResolver)resolver).getFunDef();
            return new FunInfo(funDef);
        }
        if (resolver instanceof MultiResolver) {
            return new FunInfo((MultiResolver)resolver);
        }
        return new FunInfo(resolver);
    }

    FunInfo(FunDef funDef) {
        this.syntax = funDef.getSyntax();
        this.name = funDef.getName();
        this.returnTypes = new int[]{funDef.getReturnCategory()};
        this.parameterTypes = new int[][]{funDef.getParameterCategories()};
        this.sigs = FunInfo.makeSigs(this.syntax, this.name, this.returnTypes, this.parameterTypes);
        this.description = funDef.getDescription();
    }

    FunInfo(MultiResolver multiResolver) {
        this.syntax = multiResolver.getSyntax();
        this.name = multiResolver.getName();
        this.description = multiResolver.getDescription();
        String[] signatures = multiResolver.getSignatures();
        this.returnTypes = new int[signatures.length];
        this.parameterTypes = new int[signatures.length][];
        for (int i = 0; i < signatures.length; ++i) {
            this.returnTypes[i] = FunUtil.decodeReturnCategory(signatures[i]);
            this.parameterTypes[i] = FunUtil.decodeParameterCategories(signatures[i]);
        }
        this.sigs = FunInfo.makeSigs(this.syntax, this.name, this.returnTypes, this.parameterTypes);
    }

    FunInfo(Resolver resolver) {
        String[] stringArray;
        this.syntax = resolver.getSyntax();
        this.name = resolver.getName();
        this.description = resolver.getDescription();
        this.returnTypes = null;
        this.parameterTypes = null;
        String signature = resolver.getSignature();
        if (signature == null) {
            stringArray = new String[]{};
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = signature;
        }
        this.sigs = stringArray;
    }

    public String[] getSignatures() {
        return this.sigs;
    }

    private static String[] makeSigs(Syntax syntax, String name, int[] returnTypes, int[][] parameterTypes) {
        if (parameterTypes == null) {
            return null;
        }
        String[] sigs = new String[parameterTypes.length];
        for (int i = 0; i < sigs.length; ++i) {
            sigs[i] = syntax.getSignature(name, returnTypes[i], parameterTypes[i]);
        }
        return sigs;
    }

    public Syntax getSyntax() {
        return this.syntax;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public int[] getReturnCategories() {
        return this.returnTypes;
    }

    public int[][] getParameterCategories() {
        return this.parameterTypes;
    }

    public int compareTo(Object o) {
        FunInfo fi = (FunInfo)o;
        int c = this.name.compareTo(fi.name);
        if (c == 0) {
            String pc = FunInfo.toList(this.getParameterCategories()).toString();
            String otherPc = FunInfo.toList(fi.getParameterCategories()).toString();
            c = pc.compareTo(otherPc);
        }
        return c;
    }

    private static List toList(Object a) {
        ArrayList<Object> list = new ArrayList<Object>();
        if (a == null) {
            return list;
        }
        int length = Array.getLength(a);
        for (int i = 0; i < length; ++i) {
            Object o = Array.get(a, i);
            if (o.getClass().isArray()) {
                list.add(FunInfo.toList(o));
                continue;
            }
            list.add(o);
        }
        return list;
    }
}

