/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.fun;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import mondrian.calc.Calc;
import mondrian.calc.DummyExp;
import mondrian.calc.ExpCompiler;
import mondrian.calc.ListCalc;
import mondrian.calc.impl.AbstractListCalc;
import mondrian.mdx.DimensionExpr;
import mondrian.mdx.HierarchyExpr;
import mondrian.mdx.LevelExpr;
import mondrian.mdx.MdxVisitor;
import mondrian.mdx.MemberExpr;
import mondrian.mdx.NamedSetExpr;
import mondrian.mdx.ParameterExpr;
import mondrian.mdx.ResolvedFunCall;
import mondrian.mdx.UnresolvedFunCall;
import mondrian.olap.Evaluator;
import mondrian.olap.Exp;
import mondrian.olap.Formula;
import mondrian.olap.FunDef;
import mondrian.olap.Id;
import mondrian.olap.Literal;
import mondrian.olap.Member;
import mondrian.olap.MondrianProperties;
import mondrian.olap.NativeEvaluator;
import mondrian.olap.Query;
import mondrian.olap.QueryAxis;
import mondrian.olap.SchemaReader;
import mondrian.olap.Util;
import mondrian.olap.Validator;
import mondrian.olap.fun.FunDefBase;
import mondrian.olap.fun.MultiResolver;
import mondrian.olap.fun.ReflectiveMultiResolver;
import mondrian.olap.fun.SetFunDef;
import mondrian.olap.type.SetType;
import mondrian.olap.type.TupleType;
import mondrian.olap.type.Type;
import mondrian.resource.MondrianResource;
import mondrian.util.Bug;

class CrossJoinFunDef
extends FunDefBase {
    static final ReflectiveMultiResolver Resolver = new ReflectiveMultiResolver("Crossjoin", "Crossjoin(<Set1>, <Set2>)", "Returns the cross product of two sets.", new String[]{"fxxx"}, class$mondrian$olap$fun$CrossJoinFunDef == null ? (class$mondrian$olap$fun$CrossJoinFunDef = CrossJoinFunDef.class$("mondrian.olap.fun.CrossJoinFunDef")) : class$mondrian$olap$fun$CrossJoinFunDef);
    static final StarCrossJoinResolver StarResolver = new StarCrossJoinResolver();
    private static final /* synthetic */ Class class$mondrian$olap$fun$CrossJoinFunDef;

    public CrossJoinFunDef(FunDef dummyFunDef) {
        super(dummyFunDef);
    }

    public Type getResultType(Validator validator, Exp[] args) {
        ArrayList list = new ArrayList();
        for (int i = 0; i < args.length; ++i) {
            Exp arg = args[i];
            Type type = arg.getType();
            if (type instanceof SetType) {
                CrossJoinFunDef.addTypes(type, list);
                continue;
            }
            if (this.getName().equals("*")) {
                CrossJoinFunDef.addTypes(type, list);
                continue;
            }
            throw Util.newInternal("arg to crossjoin must be a set");
        }
        Type[] types = list.toArray(new Type[list.size()]);
        TupleType tupleType = new TupleType(types);
        return new SetType(tupleType);
    }

    private static void addTypes(Type type, List list) {
        if (type instanceof SetType) {
            SetType setType = (SetType)type;
            CrossJoinFunDef.addTypes(setType.getElementType(), list);
        } else if (type instanceof TupleType) {
            TupleType tupleType = (TupleType)type;
            for (int i = 0; i < tupleType.elementTypes.length; ++i) {
                CrossJoinFunDef.addTypes(tupleType.elementTypes[i], list);
            }
        } else {
            list.add(type);
        }
    }

    public Calc compileCall(final ResolvedFunCall call, ExpCompiler compiler) {
        final ListCalc listCalc1 = this.toList(compiler, call.getArg(0));
        final ListCalc listCalc2 = this.toList(compiler, call.getArg(1));
        return new AbstractListCalc(call, new Calc[]{listCalc1, listCalc2}){
            static final /* synthetic */ boolean $assertionsDisabled;
            private static final /* synthetic */ Class class$mondrian$olap$fun$CrossJoinFunDef;

            public List evaluateList(Evaluator evaluator) {
                SchemaReader schemaReader = evaluator.getSchemaReader();
                NativeEvaluator nativeEvaluator = schemaReader.getNativeSetEvaluator(call.getFunDef(), call.getArgs(), evaluator, this);
                if (nativeEvaluator != null) {
                    return (List)nativeEvaluator.execute();
                }
                Evaluator oldEval = null;
                if (!$assertionsDisabled && (oldEval = evaluator.push()) == null) {
                    throw new AssertionError();
                }
                List list1 = listCalc1.evaluateList(evaluator);
                if (!$assertionsDisabled && !oldEval.equals(evaluator)) {
                    throw new AssertionError((Object)"listCalc1 changed context");
                }
                if (list1.isEmpty()) {
                    return Collections.EMPTY_LIST;
                }
                List list2 = listCalc2.evaluateList(evaluator.push());
                if (!$assertionsDisabled && !oldEval.equals(evaluator)) {
                    throw new AssertionError((Object)"listCalc2 changed context");
                }
                return CrossJoinFunDef.this.crossJoin(list1, list2, evaluator);
            }

            static {
                $assertionsDisabled = !(class$mondrian$olap$fun$CrossJoinFunDef == null ? (class$mondrian$olap$fun$CrossJoinFunDef = 1.class$("mondrian.olap.fun.CrossJoinFunDef")) : class$mondrian$olap$fun$CrossJoinFunDef).desiredAssertionStatus();
            }

            static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
                Class<?> clazz;
                try {
                    clazz = Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    NoClassDefFoundError noClassDefFoundError = new NoClassDefFoundError(classNotFoundException.getMessage());
                    try {
                        noClassDefFoundError.initCause(classNotFoundException);
                    }
                    catch (NoSuchMethodError noSuchMethodError) {
                        // empty catch block
                    }
                    throw noClassDefFoundError;
                }
                return clazz;
            }
        };
    }

    private ListCalc toList(ExpCompiler compiler, Exp exp) {
        Type type = exp.getType();
        if (type instanceof SetType) {
            return compiler.compileList(exp);
        }
        return new SetFunDef.SetCalc((Exp)new DummyExp(new SetType(type)), new Exp[]{exp}, compiler);
    }

    List crossJoin(List list1, List list2, Evaluator evaluator) {
        if (list1.isEmpty() || list2.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        long size = (long)list1.size() * (long)list2.size();
        int resultLimit = MondrianProperties.instance().ResultLimit.get();
        int opSize = Bug.Checkin7634Size;
        boolean useOptimizer = Bug.Checkin7634UseOptimizer;
        boolean doOld = Bug.Checkin7634DoOld;
        if (useOptimizer && size > (long)opSize && evaluator.isNonEmpty()) {
            int missCount = evaluator.getMissCount();
            if (doOld) {
                list1 = CrossJoinFunDef.nonEmptyListOld(evaluator, list1);
                list2 = CrossJoinFunDef.nonEmptyListOld(evaluator, list2);
            } else {
                list1 = CrossJoinFunDef.nonEmptyList(evaluator, list1);
                list2 = CrossJoinFunDef.nonEmptyList(evaluator, list2);
            }
            size = (long)list1.size() * (long)list2.size();
            if (size == 0L) {
                return Collections.EMPTY_LIST;
            }
            int missCount2 = evaluator.getMissCount();
            if (missCount2 > missCount && size > 1000L) {
                return Collections.EMPTY_LIST;
            }
        }
        if (resultLimit > 0 && (long)resultLimit < size) {
            throw MondrianResource.instance().LimitExceededDuringCrossjoin.ex(new Long(size), new Long(resultLimit));
        }
        if (size > Integer.MAX_VALUE) {
            throw MondrianResource.instance().LimitExceededDuringCrossjoin.ex(new Long(size), new Long(Integer.MAX_VALUE));
        }
        ArrayList<Object> result = new ArrayList<Object>((int)size);
        boolean neitherSideIsTuple = true;
        int arity0 = 1;
        int arity1 = 1;
        if (list1.get(0) instanceof Member[]) {
            arity0 = ((Member[])list1.get(0)).length;
            neitherSideIsTuple = false;
        }
        if (list2.get(0) instanceof Member[]) {
            arity1 = ((Member[])list2.get(0)).length;
            neitherSideIsTuple = false;
        }
        if (neitherSideIsTuple) {
            int m = list1.size();
            for (int i = 0; i < m; ++i) {
                Member o0 = (Member)list1.get(i);
                int n = list2.size();
                for (int j = 0; j < n; ++j) {
                    Member o1 = (Member)list2.get(j);
                    result.add(new Member[]{o0, o1});
                }
            }
        } else {
            Member[] row = new Member[arity0 + arity1];
            int m = list1.size();
            for (int i = 0; i < m; ++i) {
                int x = 0;
                Object o0 = list1.get(i);
                if (o0 instanceof Member) {
                    row[x++] = (Member)o0;
                } else {
                    CrossJoinFunDef.assertTrue(o0 instanceof Member[]);
                    Member[] members = (Member[])o0;
                    for (int k = 0; k < members.length; ++k) {
                        row[x++] = members[k];
                    }
                }
                int n = list2.size();
                for (int j = 0; j < n; ++j) {
                    Object o1 = list2.get(j);
                    if (o1 instanceof Member) {
                        row[x++] = (Member)o1;
                    } else {
                        CrossJoinFunDef.assertTrue(o1 instanceof Member[]);
                        Member[] members = (Member[])o1;
                        for (int k = 0; k < members.length; ++k) {
                            row[x++] = members[k];
                        }
                    }
                    result.add(row.clone());
                    x = arity0;
                }
            }
        }
        return result;
    }

    protected static List nonEmptyListOld(Evaluator evaluator, List list) {
        if (list.isEmpty()) {
            return list;
        }
        ArrayList<Object> result = new ArrayList<Object>();
        evaluator = evaluator.push();
        if (list.get(0) instanceof Member[]) {
            Iterator it = list.iterator();
            while (it.hasNext()) {
                Member[] m = (Member[])it.next();
                evaluator.setContext(m);
                Object value = evaluator.evaluateCurrent();
                if (value == Util.nullValue || value instanceof Throwable) continue;
                result.add(m);
            }
        } else {
            Iterator it = list.iterator();
            while (it.hasNext()) {
                Member m = (Member)it.next();
                evaluator.setContext(m);
                Object value = evaluator.evaluateCurrent();
                if (value == null || value instanceof Throwable) continue;
                result.add(m);
            }
        }
        return result;
    }

    protected static List nonEmptyList(Evaluator evaluator, List list) {
        Iterator measureIter;
        Object value;
        Iterator listItr;
        if (list.isEmpty()) {
            return list;
        }
        ArrayList<Object> result = new ArrayList<Object>(list.size() + 2 >> 1);
        Query query = evaluator.getQuery();
        Set measureSet = null;
        Set queryMeasureSet = query.getMeasuresMembers();
        if (queryMeasureSet.size() > 0) {
            MeasureVisitor visitor = new MeasureVisitor(queryMeasureSet);
            QueryAxis[] axes = query.getAxes();
            QueryAxis slicerAxis = query.getSlicerAxis();
            if (slicerAxis != null) {
                slicerAxis.accept(visitor);
            }
            if (visitor.measureSet != null) {
                measureSet = visitor.measureSet;
            } else if (axes.length > 1) {
                for (int i = 0; i < axes.length; ++i) {
                    if (axes[i] == null) continue;
                    axes[i].accept(visitor);
                }
                measureSet = visitor.measureSet;
            }
        }
        evaluator = evaluator.push();
        if (list.get(0) instanceof Member[]) {
            listItr = list.iterator();
            block1: while (listItr.hasNext()) {
                Member[] ms = (Member[])listItr.next();
                evaluator.setContext(ms);
                if (measureSet == null) {
                    value = evaluator.evaluateCurrent();
                    if (value == null || value instanceof Throwable) continue;
                    result.add(ms);
                    continue;
                }
                measureIter = measureSet.iterator();
                while (measureIter.hasNext()) {
                    Member measure = (Member)measureIter.next();
                    evaluator.setContext(measure);
                    Object value2 = evaluator.evaluateCurrent();
                    if (value2 == null || value2 instanceof Throwable) continue;
                    result.add(ms);
                    continue block1;
                }
            }
        } else {
            listItr = list.iterator();
            block3: while (listItr.hasNext()) {
                Member m = (Member)listItr.next();
                evaluator.setContext(m);
                if (measureSet == null) {
                    value = evaluator.evaluateCurrent();
                    if (value == null || value instanceof Throwable) continue;
                    result.add(m);
                    continue;
                }
                measureIter = measureSet.iterator();
                while (measureIter.hasNext()) {
                    Member measure = (Member)measureIter.next();
                    evaluator.setContext(measure);
                    Object value3 = evaluator.evaluateCurrent();
                    if (value3 == null || value3 instanceof Throwable) continue;
                    result.add(m);
                    continue block3;
                }
            }
        }
        return result;
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        Class<?> clazz;
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            NoClassDefFoundError noClassDefFoundError = new NoClassDefFoundError(classNotFoundException.getMessage());
            try {
                noClassDefFoundError.initCause(classNotFoundException);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
            throw noClassDefFoundError;
        }
        return clazz;
    }

    private static class StarCrossJoinResolver
    extends MultiResolver {
        public StarCrossJoinResolver() {
            super("*", "<Set1> * <Set2>", "Returns the cross product of two sets.", new String[]{"ixxx", "ixmx", "ixxm", "ixmm"});
        }

        public FunDef resolve(Exp[] args, Validator validator, int[] conversionCount) {
            if (validator.requiresExpression()) {
                return null;
            }
            return super.resolve(args, validator, conversionCount);
        }

        protected FunDef createFunDef(Exp[] args, FunDef dummyFunDef) {
            return new CrossJoinFunDef(dummyFunDef);
        }
    }

    static class MeasureVisitor
    implements MdxVisitor {
        Set measureSet;
        Set queryMeasureSet;

        MeasureVisitor(Set queryMeasureSet) {
            this.queryMeasureSet = queryMeasureSet;
        }

        public Object visit(Query query) {
            return null;
        }

        public Object visit(QueryAxis queryAxis) {
            return null;
        }

        public Object visit(Formula formula) {
            return null;
        }

        public Object visit(UnresolvedFunCall call) {
            return null;
        }

        public Object visit(ResolvedFunCall call) {
            return null;
        }

        public Object visit(Id id) {
            return null;
        }

        public Object visit(ParameterExpr parameterExpr) {
            return null;
        }

        public Object visit(DimensionExpr dimensionExpr) {
            return null;
        }

        public Object visit(HierarchyExpr hierarchyExpr) {
            return null;
        }

        public Object visit(LevelExpr levelExpr) {
            return null;
        }

        public Object visit(MemberExpr memberExpr) {
            Member member = memberExpr.getMember();
            Iterator mit = this.queryMeasureSet.iterator();
            while (mit.hasNext()) {
                Member measure = (Member)mit.next();
                if (!measure.equals(member)) continue;
                if (this.measureSet == null) {
                    this.measureSet = new HashSet();
                }
                this.measureSet.add(measure);
                break;
            }
            return null;
        }

        public Object visit(NamedSetExpr namedSetExpr) {
            return null;
        }

        public Object visit(Literal literal) {
            return null;
        }
    }
}

