/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.fun;

import java.util.List;
import mondrian.calc.Calc;
import mondrian.calc.ExpCompiler;
import mondrian.calc.ListCalc;
import mondrian.calc.impl.AbstractIntegerCalc;
import mondrian.mdx.ResolvedFunCall;
import mondrian.olap.Dimension;
import mondrian.olap.Evaluator;
import mondrian.olap.FunDef;
import mondrian.olap.Literal;
import mondrian.olap.fun.AbstractAggregateFunDef;
import mondrian.olap.fun.FunUtil;
import mondrian.olap.fun.ReflectiveMultiResolver;

class CountFunDef
extends AbstractAggregateFunDef {
    static final String[] ReservedWords = new String[]{"INCLUDEEMPTY", "EXCLUDEEMPTY"};
    static final ReflectiveMultiResolver Resolver = new ReflectiveMultiResolver("Count", "Count(<Set>[, EXCLUDEEMPTY | INCLUDEEMPTY])", "Returns the number of tuples in a set, empty cells included unless the optional EXCLUDEEMPTY flag is used.", new String[]{"fnx", "fnxy"}, class$mondrian$olap$fun$CountFunDef == null ? (class$mondrian$olap$fun$CountFunDef = CountFunDef.class$("mondrian.olap.fun.CountFunDef")) : class$mondrian$olap$fun$CountFunDef, ReservedWords);
    private static final /* synthetic */ Class class$mondrian$olap$fun$CountFunDef;

    public CountFunDef(FunDef dummyFunDef) {
        super(dummyFunDef);
    }

    public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
        final ListCalc memberListCalc = compiler.compileList(call.getArg(0));
        final boolean includeEmpty = call.getArgCount() < 2 || ((Literal)call.getArg(1)).getValue().equals("INCLUDEEMPTY");
        return new AbstractIntegerCalc(call, new Calc[]{memberListCalc}){

            public int evaluateInteger(Evaluator evaluator) {
                List memberList = memberListCalc.evaluateList(evaluator);
                return FunUtil.count(evaluator, memberList, includeEmpty);
            }

            public boolean dependsOn(Dimension dimension) {
                if (super.dependsOn(dimension)) {
                    return true;
                }
                if (includeEmpty) {
                    return false;
                }
                return !memberListCalc.getType().usesDimension(dimension, true);
            }
        };
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        Class<?> clazz;
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            NoClassDefFoundError noClassDefFoundError = new NoClassDefFoundError(classNotFoundException.getMessage());
            try {
                noClassDefFoundError.initCause(classNotFoundException);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
            throw noClassDefFoundError;
        }
        return clazz;
    }
}

