/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.fun;

import mondrian.calc.Calc;
import mondrian.calc.ExpCompiler;
import mondrian.calc.IntegerCalc;
import mondrian.calc.LevelCalc;
import mondrian.calc.MemberCalc;
import mondrian.calc.impl.AbstractMemberCalc;
import mondrian.mdx.ResolvedFunCall;
import mondrian.olap.Evaluator;
import mondrian.olap.FunDef;
import mondrian.olap.Level;
import mondrian.olap.Member;
import mondrian.olap.fun.FunDefBase;
import mondrian.olap.fun.FunUtil;
import mondrian.olap.fun.ReflectiveMultiResolver;
import mondrian.olap.type.LevelType;
import mondrian.olap.type.Type;

class AncestorFunDef
extends FunDefBase {
    static final ReflectiveMultiResolver Resolver = new ReflectiveMultiResolver("Ancestor", "Ancestor(<Member>, {<Level>|<Numeric Expression>})", "Returns the ancestor of a member at a specified level.", new String[]{"fmml", "fmmn"}, class$mondrian$olap$fun$AncestorFunDef == null ? (class$mondrian$olap$fun$AncestorFunDef = AncestorFunDef.class$("mondrian.olap.fun.AncestorFunDef")) : class$mondrian$olap$fun$AncestorFunDef);
    private static final /* synthetic */ Class class$mondrian$olap$fun$AncestorFunDef;

    public AncestorFunDef(FunDef dummyFunDef) {
        super(dummyFunDef);
    }

    public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
        final MemberCalc memberCalc = compiler.compileMember(call.getArg(0));
        Type type1 = call.getArg(1).getType();
        if (type1 instanceof LevelType) {
            final LevelCalc levelCalc = compiler.compileLevel(call.getArg(1));
            return new AbstractMemberCalc(call, new Calc[]{memberCalc, levelCalc}){

                public Member evaluateMember(Evaluator evaluator) {
                    Level level = levelCalc.evaluateLevel(evaluator);
                    Member member = memberCalc.evaluateMember(evaluator);
                    int distance = member.getLevel().getDepth() - level.getDepth();
                    return FunUtil.ancestor(evaluator, member, distance, level);
                }
            };
        }
        final IntegerCalc distanceCalc = compiler.compileInteger(call.getArg(1));
        return new AbstractMemberCalc(call, new Calc[]{memberCalc, distanceCalc}){

            public Member evaluateMember(Evaluator evaluator) {
                int distance = distanceCalc.evaluateInteger(evaluator);
                Member member = memberCalc.evaluateMember(evaluator);
                return FunUtil.ancestor(evaluator, member, distance, null);
            }
        };
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        Class<?> clazz;
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            NoClassDefFoundError noClassDefFoundError = new NoClassDefFoundError(classNotFoundException.getMessage());
            try {
                noClassDefFoundError.initCause(classNotFoundException);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
            throw noClassDefFoundError;
        }
        return clazz;
    }
}

