/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java_cup.runtime.Symbol;
import org.apache.log4j.Logger;

public class Scanner {
    private static final Logger LOGGER = Logger.getLogger((Class)(class$mondrian$olap$Scanner == null ? (class$mondrian$olap$Scanner = Scanner.class$("mondrian.olap.Scanner")) : class$mondrian$olap$Scanner));
    protected int nextChar;
    private int[] lookaheadChars = new int[16];
    private int firstLookaheadChar = 0;
    private int lastLookaheadChar = 0;
    private Hashtable m_resWordsTable;
    private int iMaxResword;
    private String[] m_aResWords;
    protected boolean debug;
    private List lines;
    private int iChar;
    private int iPrevChar;
    private int previousSymbol;
    private boolean inFormula;
    private static final String[][] commentDelim = new String[][]{{"//", null}, {"--", null}, {"/*", "*/"}};
    private static final boolean allowNestedComments = true;
    private static final /* synthetic */ Class class$mondrian$olap$Scanner;

    Scanner(boolean debug) {
        this.debug = debug;
    }

    public static boolean getNestedCommentsState() {
        return true;
    }

    public static String[][] getCommentDelimiters() {
        return commentDelim;
    }

    private final void advance() throws IOException {
        if (this.firstLookaheadChar == this.lastLookaheadChar) {
            this.nextChar = this.getChar();
        } else {
            this.nextChar = this.lookaheadChars[this.firstLookaheadChar++];
            if (this.firstLookaheadChar == this.lastLookaheadChar) {
                this.firstLookaheadChar = 0;
                this.lastLookaheadChar = 0;
            }
        }
        if (this.nextChar == 10) {
            this.lines.add(new Integer(this.iChar));
        }
        ++this.iChar;
    }

    private final int lookahead() throws IOException {
        return this.lookahead(1);
    }

    private final int lookahead(int n) throws IOException {
        if (n == 0) {
            return this.nextChar;
        }
        if (n > this.lastLookaheadChar - this.firstLookaheadChar) {
            int len = this.lastLookaheadChar - this.firstLookaheadChar;
            if (n + this.firstLookaheadChar > this.lookaheadChars.length) {
                int[] t = n > this.lookaheadChars.length ? new int[n * 2] : this.lookaheadChars;
                for (int x = 0; x < len; ++x) {
                    t[x] = this.lookaheadChars[x + this.firstLookaheadChar];
                }
                this.lookaheadChars = t;
                this.firstLookaheadChar = 0;
                this.lastLookaheadChar = len;
            }
            while (n > this.lastLookaheadChar - this.firstLookaheadChar) {
                this.lookaheadChars[this.lastLookaheadChar++] = this.getChar();
            }
        }
        return this.lookaheadChars[n - 1 + this.firstLookaheadChar];
    }

    protected int getChar() throws IOException {
        return System.in.read();
    }

    public void init() throws IOException {
        this.initReswords();
        this.lines = new ArrayList();
        this.iPrevChar = 0;
        this.iChar = 0;
        this.advance();
    }

    void getLocation(Symbol symbol, int[] loc) {
        int iLineStart;
        int iTarget = symbol.left;
        int iLine = -1;
        int iLineEnd = 0;
        do {
            iLineStart = iLineEnd;
            iLineEnd = Integer.MAX_VALUE;
            if (++iLine >= this.lines.size()) continue;
            iLineEnd = (Integer)this.lines.get(iLine);
        } while (iLineEnd < iTarget);
        loc[0] = iLine;
        loc[1] = iTarget - iLineStart;
    }

    private Symbol trace(Symbol s) {
        if (this.debug) {
            String name = null;
            if (s.sym < this.m_aResWords.length) {
                name = this.m_aResWords[s.sym];
            }
            LOGGER.error((Object)("Scanner returns #" + s.sym + (name == null ? "" : ":" + name) + (s.value == null ? "" : "(" + s.value.toString() + ")")));
        }
        return s;
    }

    private void initResword(int id, String s) {
        this.m_resWordsTable.put(s, new Integer(id));
        if (id > this.iMaxResword) {
            this.iMaxResword = id;
        }
    }

    private void initReswords() {
        this.m_resWordsTable = new Hashtable();
        this.iMaxResword = 0;
        this.initResword(2, "AND");
        this.initResword(3, "AS");
        this.initResword(4, "AXIS");
        this.initResword(6, "CAST");
        this.initResword(5, "CASE");
        this.initResword(7, "CELL");
        this.initResword(8, "DIMENSION");
        this.initResword(9, "ELSE");
        this.initResword(10, "EMPTY");
        this.initResword(11, "END");
        this.initResword(12, "FROM");
        this.initResword(14, "IS");
        this.initResword(13, "IN");
        this.initResword(15, "MATCHES");
        this.initResword(16, "MEMBER");
        this.initResword(17, "NON");
        this.initResword(18, "NOT");
        this.initResword(19, "NULL");
        this.initResword(20, "ON");
        this.initResword(21, "OR");
        this.initResword(22, "PROPERTIES");
        this.initResword(23, "SELECT");
        this.initResword(24, "SET");
        this.initResword(25, "THEN");
        this.initResword(26, "WHEN");
        this.initResword(27, "WHERE");
        this.initResword(29, "WITH");
        this.initResword(28, "XOR");
        this.m_aResWords = new String[this.iMaxResword + 1];
        Enumeration e = this.m_resWordsTable.keys();
        while (e.hasMoreElements()) {
            Object o = e.nextElement();
            String s = (String)o;
            int i = (Integer)this.m_resWordsTable.get(s);
            this.m_aResWords[i] = s;
        }
    }

    public String lookupReserved(int i) {
        return this.m_aResWords[i];
    }

    private Symbol makeSymbol(int id, Object o) {
        int iPrevPrevChar = this.iPrevChar;
        this.iPrevChar = this.iChar;
        this.previousSymbol = id;
        return this.trace(new Symbol(id, iPrevPrevChar, this.iChar, o));
    }

    private Symbol makeNumber(double mantissa, int exponent) {
        double d = mantissa * Math.pow(10.0, exponent);
        return this.makeSymbol(49, new Double(d));
    }

    private Symbol makeId(String s, boolean quoted, boolean ampersand) {
        return this.makeSymbol(quoted && ampersand ? 52 : (quoted ? 51 : 50), s);
    }

    private Symbol makeRes(int i) {
        return this.makeSymbol(i, this.m_aResWords[i]);
    }

    private Symbol makeToken(int i, String s) {
        return this.makeSymbol(i, s);
    }

    private Symbol makeString(String s) {
        if (this.inFormula) {
            this.inFormula = false;
            return this.makeSymbol(54, s);
        }
        return this.makeSymbol(53, s);
    }

    private void skipToEOL() throws IOException {
        while (this.nextChar != -1 && this.nextChar != 10) {
            this.advance();
        }
    }

    private void skipComment(String startDelim, String endDelim) throws IOException {
        int x;
        int depth = 1;
        for (x = 0; x < startDelim.length(); ++x) {
            this.advance();
        }
        while (this.nextChar != -1) {
            if (this.checkForSymbol(endDelim)) {
                for (x = 0; x < endDelim.length(); ++x) {
                    this.advance();
                }
                if (--depth != 0) continue;
                return;
            }
            if (this.checkForSymbol(startDelim)) {
                for (x = 0; x < startDelim.length(); ++x) {
                    this.advance();
                }
                ++depth;
                continue;
            }
            this.advance();
        }
        return;
    }

    private void searchForComments() throws IOException {
        boolean foundComment;
        do {
            foundComment = false;
            for (int x = 0; x < commentDelim.length; ++x) {
                if (!this.checkForSymbol(commentDelim[x][0])) continue;
                if (commentDelim[x][1] == null) {
                    foundComment = true;
                    this.skipToEOL();
                    continue;
                }
                foundComment = true;
                this.skipComment(commentDelim[x][0], commentDelim[x][1]);
            }
        } while (foundComment);
    }

    private boolean checkForSymbol(String symb) throws IOException {
        for (int x = 0; x < symb.length(); ++x) {
            if (symb.charAt(x) == this.lookahead(x)) continue;
            return false;
        }
        return true;
    }

    public Symbol next_token() throws IOException {
        boolean ampersandId = false;
        while (true) {
            this.searchForComments();
            switch (this.nextChar) {
                case 46: {
                    switch (this.lookahead()) {
                        case 48: 
                        case 49: 
                        case 50: 
                        case 51: 
                        case 52: 
                        case 53: 
                        case 54: 
                        case 55: 
                        case 56: 
                        case 57: {
                            break;
                        }
                        default: {
                            this.advance();
                            return this.makeToken(35, ".");
                        }
                    }
                }
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    boolean leftOfPoint = false;
                    boolean rightOfPoint = true;
                    int inExponent = 2;
                    int n = 0;
                    int nDigits = 0;
                    int nSign = 0;
                    int exponent = 0;
                    double mantissa = 0.0;
                    int state = 0;
                    while (true) {
                        if (this.nextChar == 46) {
                            if (state == 0) {
                                state = 1;
                                mantissa = n;
                                nDigits = 0;
                                n = 0;
                                nSign = 1;
                                this.advance();
                                continue;
                            }
                            if (state == 1) {
                                mantissa += (double)n * Math.pow(10.0, -nDigits);
                            } else {
                                exponent = n * nSign;
                            }
                            return this.makeNumber(mantissa, exponent);
                        }
                        if (this.nextChar == 69 || this.nextChar == 101) {
                            if (state == 2) {
                                exponent = n * nSign;
                                return this.makeNumber(mantissa, exponent);
                            }
                            mantissa = state == 0 ? (double)n : (mantissa += (double)n * Math.pow(10.0, -nDigits));
                            nDigits = 0;
                            n = 0;
                            nSign = 1;
                            this.advance();
                            state = 2;
                            continue;
                        }
                        if ((this.nextChar == 43 || this.nextChar == 45) && state == 2 && nDigits == 0) {
                            nSign = -nSign;
                            this.advance();
                            continue;
                        }
                        if (this.nextChar < 48 || this.nextChar > 57) break;
                        n = n * 10 + (this.nextChar - 48);
                        ++nDigits;
                        this.advance();
                    }
                    if (state == 0) {
                        mantissa = n;
                    } else if (state == 1) {
                        mantissa += (double)n * Math.pow(10.0, -nDigits);
                    } else {
                        exponent = n * nSign;
                    }
                    return this.makeNumber(mantissa, exponent);
                }
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: 
                case 71: 
                case 72: 
                case 73: 
                case 74: 
                case 75: 
                case 76: 
                case 77: 
                case 78: 
                case 79: 
                case 80: 
                case 81: 
                case 82: 
                case 83: 
                case 84: 
                case 85: 
                case 86: 
                case 87: 
                case 88: 
                case 89: 
                case 90: 
                case 97: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: 
                case 108: 
                case 109: 
                case 110: 
                case 111: 
                case 112: 
                case 113: 
                case 114: 
                case 115: 
                case 116: 
                case 117: 
                case 118: 
                case 119: 
                case 120: 
                case 121: 
                case 122: {
                    StringBuffer id = new StringBuffer();
                    block55: while (true) {
                        id.append((char)this.nextChar);
                        this.advance();
                        switch (this.nextChar) {
                            case 48: 
                            case 49: 
                            case 50: 
                            case 51: 
                            case 52: 
                            case 53: 
                            case 54: 
                            case 55: 
                            case 56: 
                            case 57: 
                            case 65: 
                            case 66: 
                            case 67: 
                            case 68: 
                            case 69: 
                            case 70: 
                            case 71: 
                            case 72: 
                            case 73: 
                            case 74: 
                            case 75: 
                            case 76: 
                            case 77: 
                            case 78: 
                            case 79: 
                            case 80: 
                            case 81: 
                            case 82: 
                            case 83: 
                            case 84: 
                            case 85: 
                            case 86: 
                            case 87: 
                            case 88: 
                            case 89: 
                            case 90: 
                            case 95: 
                            case 97: 
                            case 98: 
                            case 99: 
                            case 100: 
                            case 101: 
                            case 102: 
                            case 103: 
                            case 104: 
                            case 105: 
                            case 106: 
                            case 107: 
                            case 108: 
                            case 109: 
                            case 110: 
                            case 111: 
                            case 112: 
                            case 113: 
                            case 114: 
                            case 115: 
                            case 116: 
                            case 117: 
                            case 118: 
                            case 119: 
                            case 120: 
                            case 121: 
                            case 122: {
                                continue block55;
                            }
                        }
                        break;
                    }
                    String strId = id.toString();
                    Integer i = (Integer)this.m_resWordsTable.get(strId.toUpperCase());
                    if (i == null) {
                        return this.makeId(strId, false, false);
                    }
                    return this.makeRes(i);
                }
                case 38: {
                    this.advance();
                    if (this.nextChar == 91) {
                        ampersandId = true;
                    } else {
                        return this.makeToken(55, "&");
                    }
                }
                case 91: {
                    StringBuffer id = new StringBuffer();
                    block56: while (true) {
                        this.advance();
                        switch (this.nextChar) {
                            case 93: {
                                this.advance();
                                if (this.nextChar == 93) {
                                    id.append(']');
                                    continue block56;
                                }
                                if (ampersandId) {
                                    ampersandId = false;
                                    return this.makeId(id.toString(), true, true);
                                }
                                return this.makeId(id.toString(), true, false);
                            }
                            case -1: {
                                if (ampersandId) {
                                    ampersandId = false;
                                    return this.makeId(id.toString(), true, true);
                                }
                                return this.makeId(id.toString(), true, false);
                            }
                        }
                        id.append((char)this.nextChar);
                    }
                }
                case 58: {
                    this.advance();
                    return this.makeToken(32, ":");
                }
                case 44: {
                    this.advance();
                    return this.makeToken(33, ",");
                }
                case 61: {
                    this.advance();
                    return this.makeToken(36, "=");
                }
                case 60: {
                    this.advance();
                    switch (this.nextChar) {
                        case 62: {
                            this.advance();
                            return this.makeToken(44, "<>");
                        }
                        case 61: {
                            this.advance();
                            return this.makeToken(40, "<=");
                        }
                    }
                    return this.makeToken(42, "<");
                }
                case 62: {
                    this.advance();
                    switch (this.nextChar) {
                        case 61: {
                            this.advance();
                            return this.makeToken(37, ">=");
                        }
                    }
                    return this.makeToken(38, ">");
                }
                case 123: {
                    this.advance();
                    return this.makeToken(39, "{");
                }
                case 40: {
                    this.advance();
                    return this.makeToken(41, "(");
                }
                case 125: {
                    this.advance();
                    return this.makeToken(46, "}");
                }
                case 41: {
                    this.advance();
                    return this.makeToken(47, ")");
                }
                case 43: {
                    this.advance();
                    return this.makeToken(45, "+");
                }
                case 45: {
                    this.advance();
                    return this.makeToken(43, "-");
                }
                case 42: {
                    this.advance();
                    return this.makeToken(31, "*");
                }
                case 47: {
                    this.advance();
                    return this.makeToken(48, "/");
                }
                case 124: {
                    this.advance();
                    switch (this.nextChar) {
                        case 124: {
                            this.advance();
                            return this.makeToken(34, "||");
                        }
                    }
                    return this.makeToken(55, "|");
                }
                case 34: {
                    StringBuffer id = new StringBuffer();
                    block57: while (true) {
                        this.advance();
                        switch (this.nextChar) {
                            case 34: {
                                this.advance();
                                if (this.nextChar == 34) {
                                    id.append('\"');
                                    continue block57;
                                }
                                return this.makeString(id.toString());
                            }
                            case -1: {
                                return this.makeString(id.toString());
                            }
                        }
                        id.append((char)this.nextChar);
                    }
                }
                case 39: {
                    if (this.previousSymbol == 3) {
                        this.inFormula = true;
                    }
                    StringBuffer id = new StringBuffer();
                    block58: while (true) {
                        this.advance();
                        switch (this.nextChar) {
                            case 39: {
                                this.advance();
                                if (this.nextChar == 39) {
                                    id.append('\'');
                                    continue block58;
                                }
                                return this.makeString(id.toString());
                            }
                            case -1: {
                                return this.makeString(id.toString());
                            }
                        }
                        id.append((char)this.nextChar);
                    }
                }
                case -1: {
                    return this.makeToken(0, "EOF");
                }
                default: {
                    if (this.nextChar <= 65535 && Character.isWhitespace((char)this.nextChar)) break;
                    throw new RuntimeException("Unexpected character '" + (char)this.nextChar + "'");
                }
                case 9: 
                case 10: 
                case 13: 
                case 32: 
            }
            this.iPrevChar = this.iChar;
            this.advance();
        }
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        Class<?> clazz;
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            NoClassDefFoundError noClassDefFoundError = new NoClassDefFoundError(classNotFoundException.getMessage());
            try {
                noClassDefFoundError.initCause(classNotFoundException);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
            throw noClassDefFoundError;
        }
        return clazz;
    }
}

