/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap;

import java.io.PrintWriter;
import mondrian.calc.Calc;
import mondrian.calc.ExpCompiler;
import mondrian.mdx.DimensionExpr;
import mondrian.mdx.HierarchyExpr;
import mondrian.mdx.LevelExpr;
import mondrian.mdx.MdxVisitor;
import mondrian.mdx.UnresolvedFunCall;
import mondrian.olap.AxisOrdinal;
import mondrian.olap.EnumeratedValues;
import mondrian.olap.Exp;
import mondrian.olap.FunCall;
import mondrian.olap.Id;
import mondrian.olap.Level;
import mondrian.olap.MondrianProperties;
import mondrian.olap.QueryPart;
import mondrian.olap.Syntax;
import mondrian.olap.Util;
import mondrian.olap.Validator;
import mondrian.olap.type.Type;
import mondrian.olap.type.TypeUtil;
import mondrian.resource.MondrianResource;

public class QueryAxis
extends QueryPart {
    private boolean nonEmpty;
    private Exp exp;
    private final AxisOrdinal axisOrdinal;
    private int showSubtotals;
    private final Id[] dimensionProperties;
    static final /* synthetic */ boolean $assertionsDisabled;
    private static final /* synthetic */ Class class$mondrian$olap$QueryAxis;

    public QueryAxis(boolean nonEmpty, Exp set, AxisOrdinal axisDef, int showSubtotals, Id[] dimensionProperties) {
        if (!$assertionsDisabled && dimensionProperties == null) {
            throw new AssertionError();
        }
        this.nonEmpty = nonEmpty || MondrianProperties.instance().EnableNonEmptyOnAllAxis.get();
        this.exp = set;
        this.axisOrdinal = axisDef;
        this.showSubtotals = showSubtotals;
        this.dimensionProperties = dimensionProperties;
    }

    public QueryAxis(boolean nonEmpty, Exp set, AxisOrdinal axisDef, int showSubtotals) {
        this(nonEmpty, set, axisDef, showSubtotals, new Id[0]);
    }

    public Object clone() {
        return new QueryAxis(this.nonEmpty, (Exp)this.exp.clone(), this.axisOrdinal, this.showSubtotals, (Id[])this.dimensionProperties.clone());
    }

    static QueryAxis[] cloneArray(QueryAxis[] a) {
        QueryAxis[] a2 = new QueryAxis[a.length];
        for (int i = 0; i < a.length; ++i) {
            a2[i] = (QueryAxis)a[i].clone();
        }
        return a2;
    }

    public Object accept(MdxVisitor visitor) {
        Object o = visitor.visit(this);
        this.exp.accept(visitor);
        return o;
    }

    public Calc compile(ExpCompiler compiler) {
        Exp exp = this.exp;
        if (this.axisOrdinal == AxisOrdinal.Slicer) {
            exp = QueryAxis.normalizeSlicerExpression(exp);
            exp = exp.accept(compiler.getValidator());
        }
        return compiler.compile(exp);
    }

    private static Exp normalizeSlicerExpression(Exp exp) {
        Exp slicer = exp;
        if (slicer instanceof LevelExpr || slicer instanceof HierarchyExpr || slicer instanceof DimensionExpr) {
            slicer = new UnresolvedFunCall("DefaultMember", Syntax.Property, new Exp[]{slicer});
        }
        if (slicer != null) {
            slicer = slicer instanceof FunCall && ((FunCall)slicer).getSyntax() == Syntax.Parentheses ? new UnresolvedFunCall("{}", Syntax.Braces, new Exp[]{slicer}) : new UnresolvedFunCall("{}", Syntax.Braces, new Exp[]{new UnresolvedFunCall("()", Syntax.Parentheses, new Exp[]{slicer})});
        }
        return slicer;
    }

    public String getAxisName() {
        return this.axisOrdinal.getName();
    }

    public AxisOrdinal getAxisOrdinal() {
        return this.axisOrdinal;
    }

    public boolean isNonEmpty() {
        return this.nonEmpty;
    }

    public void setNonEmpty(boolean nonEmpty) {
        this.nonEmpty = nonEmpty;
    }

    public Exp getSet() {
        return this.exp;
    }

    public void setSet(Exp set) {
        this.exp = set;
    }

    public void resolve(Validator validator) {
        this.exp = validator.validate(this.exp, false);
        Type type = this.exp.getType();
        if (!TypeUtil.isSet(type)) {
            throw MondrianResource.instance().MdxAxisIsNotSet.ex(this.axisOrdinal.getName());
        }
    }

    public Object[] getChildren() {
        return new Object[]{this.exp};
    }

    public void unparse(PrintWriter pw) {
        if (this.nonEmpty) {
            pw.print("NON EMPTY ");
        }
        if (this.exp != null) {
            this.exp.unparse(pw);
        }
        if (this.dimensionProperties.length > 0) {
            pw.print(" DIMENSION PROPERTIES ");
            for (int i = 0; i < this.dimensionProperties.length; ++i) {
                Id dimensionProperty = this.dimensionProperties[i];
                if (i > 0) {
                    pw.print(", ");
                }
                dimensionProperty.unparse(pw);
            }
        }
        if (this.axisOrdinal != AxisOrdinal.Slicer) {
            pw.print(" ON " + this.axisOrdinal);
        }
    }

    public void addLevel(Level level) {
        Util.assertTrue(level != null, "addLevel needs level");
        this.exp = new UnresolvedFunCall("Crossjoin", Syntax.Function, new Exp[]{this.exp, new UnresolvedFunCall("Members", Syntax.Property, new Exp[]{new LevelExpr(level)})});
    }

    void setShowSubtotals(boolean bShowSubtotals) {
        this.showSubtotals = bShowSubtotals ? 1 : 0;
    }

    public int getShowSubtotals() {
        return this.showSubtotals;
    }

    public void resetShowHideSubtotals() {
        this.showSubtotals = -1;
    }

    public void validate(Validator validator) {
        if (this.axisOrdinal == AxisOrdinal.Slicer && this.exp != null) {
            this.exp = validator.validate(this.exp, false);
        }
    }

    public Id[] getDimensionProperties() {
        return this.dimensionProperties;
    }

    static {
        $assertionsDisabled = !(class$mondrian$olap$QueryAxis == null ? (class$mondrian$olap$QueryAxis = QueryAxis.class$("mondrian.olap.QueryAxis")) : class$mondrian$olap$QueryAxis).desiredAssertionStatus();
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        Class<?> clazz;
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            NoClassDefFoundError noClassDefFoundError = new NoClassDefFoundError(classNotFoundException.getMessage());
            try {
                noClassDefFoundError.initCause(classNotFoundException);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
            throw noClassDefFoundError;
        }
        return clazz;
    }

    public static class SubtotalVisibility
    extends EnumeratedValues {
        public static final SubtotalVisibility instance = new SubtotalVisibility();
        public static final int Undefined = -1;
        public static final int Hide = 0;
        public static final int Show = 1;

        private SubtotalVisibility() {
            super(new String[]{"undefined", "hide", "show"}, new int[]{-1, 0, 1});
        }
    }
}

