/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap;

import com.rc.retroweaver.runtime.Arrays;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import mondrian.calc.Calc;
import mondrian.calc.ExpCompiler;
import mondrian.calc.impl.BetterExpCompiler;
import mondrian.mdx.MdxVisitor;
import mondrian.mdx.MdxVisitorImpl;
import mondrian.mdx.MemberExpr;
import mondrian.mdx.ParameterExpr;
import mondrian.mdx.QueryPrintWriter;
import mondrian.mdx.ResolvedFunCall;
import mondrian.mdx.UnresolvedFunCall;
import mondrian.olap.Axis;
import mondrian.olap.AxisOrdinal;
import mondrian.olap.Category;
import mondrian.olap.Connection;
import mondrian.olap.Cube;
import mondrian.olap.DelegatingSchemaReader;
import mondrian.olap.Dimension;
import mondrian.olap.Evaluator;
import mondrian.olap.Exp;
import mondrian.olap.Formula;
import mondrian.olap.FunCall;
import mondrian.olap.FunDef;
import mondrian.olap.FunTable;
import mondrian.olap.Hierarchy;
import mondrian.olap.Level;
import mondrian.olap.Literal;
import mondrian.olap.Member;
import mondrian.olap.MemberProperty;
import mondrian.olap.MondrianProperties;
import mondrian.olap.NamedSet;
import mondrian.olap.OlapElement;
import mondrian.olap.Parameter;
import mondrian.olap.ParameterImpl;
import mondrian.olap.Property;
import mondrian.olap.QueryAxis;
import mondrian.olap.QueryPart;
import mondrian.olap.Role;
import mondrian.olap.SchemaReader;
import mondrian.olap.Syntax;
import mondrian.olap.Util;
import mondrian.olap.Validator;
import mondrian.olap.Walker;
import mondrian.olap.fun.FunUtil;
import mondrian.olap.fun.ParameterFunDef;
import mondrian.olap.type.SetType;
import mondrian.olap.type.StringType;
import mondrian.olap.type.TupleType;
import mondrian.olap.type.Type;
import mondrian.olap.type.TypeUtil;
import mondrian.resource.MondrianResource;
import mondrian.rolap.RolapConnectionProperties;
import mondrian.rolap.RolapEvaluator;
import mondrian.rolap.RolapUtil;

public class Query
extends QueryPart {
    public Formula[] formulas;
    public QueryAxis[] axes;
    public QueryAxis slicerAxis;
    private final List parameters = new ArrayList();
    private final Map parametersByName = new HashMap();
    private final QueryPart[] cellProps;
    private final Cube cube;
    private final Connection connection;
    public Calc[] axisCalcs;
    public Calc slicerCalc;
    private long startTime;
    private final int queryTimeout;
    private boolean isCanceled;
    private boolean isExecuting;
    private Set measuresMembers;
    private boolean nativeCrossJoinVirtualCube;
    private Set virtualCubeBaseCubeMaps;
    private Map levelMapToMeasureMap;
    private boolean load;

    public Query(Connection connection, Formula[] formulas, QueryAxis[] axes, String cube, QueryAxis slicerAxis, QueryPart[] cellProps, boolean load) {
        this(connection, connection.getSchema().lookupCube(cube, true), formulas, axes, slicerAxis, cellProps, new Parameter[0], load);
    }

    public Query(Connection connection, Cube mdxCube, Formula[] formulas, QueryAxis[] axes, QueryAxis slicerAxis, QueryPart[] cellProps, Parameter[] parameters, boolean load) {
        this.connection = connection;
        this.cube = mdxCube;
        this.formulas = formulas;
        this.axes = axes;
        this.normalizeAxes();
        this.slicerAxis = slicerAxis;
        this.cellProps = cellProps;
        this.parameters.addAll(Arrays.asList((Object[])parameters));
        this.isExecuting = false;
        this.queryTimeout = MondrianProperties.instance().QueryTimeout.get() * 1000;
        this.measuresMembers = new HashSet();
        this.nativeCrossJoinVirtualCube = true;
        this.load = load;
        this.resolve();
    }

    public void addFormula(String[] names, Exp exp) {
        Formula newFormula = new Formula(names, exp);
        int formulaCount = 0;
        if (this.formulas.length > 0) {
            formulaCount = this.formulas.length;
        }
        Formula[] newFormulas = new Formula[formulaCount + 1];
        for (int i = 0; i < formulaCount; ++i) {
            newFormulas[i] = this.formulas[i];
        }
        newFormulas[formulaCount] = newFormula;
        this.formulas = newFormulas;
        this.resolve();
    }

    public void addFormula(String[] names, Exp exp, MemberProperty[] memberProperties) {
        Formula newFormula = new Formula(names, exp, memberProperties);
        int formulaCount = 0;
        if (this.formulas.length > 0) {
            formulaCount = this.formulas.length;
        }
        Formula[] newFormulas = new Formula[formulaCount + 1];
        for (int i = 0; i < formulaCount; ++i) {
            newFormulas[i] = this.formulas[i];
        }
        newFormulas[formulaCount] = newFormula;
        this.formulas = newFormulas;
        this.resolve();
    }

    public Validator createValidator() {
        return new StackValidator(this.connection.getSchema().getFunTable());
    }

    public Object clone() {
        return new Query(this.connection, this.cube, Formula.cloneArray(this.formulas), QueryAxis.cloneArray(this.axes), this.slicerAxis == null ? null : (QueryAxis)this.slicerAxis.clone(), this.cellProps, this.parameters.toArray(new Parameter[this.parameters.size()]), this.load);
    }

    public Query safeClone() {
        return (Query)this.clone();
    }

    public Connection getConnection() {
        return this.connection;
    }

    public String getQueryString() {
        return this.toMdx();
    }

    public void cancel() {
        this.isCanceled = true;
    }

    public void checkCancelOrTimeout() {
        long currTime;
        if (!this.isExecuting) {
            return;
        }
        if (this.isCanceled) {
            throw MondrianResource.instance().QueryCanceled.ex();
        }
        if (this.queryTimeout > 0 && (currTime = System.currentTimeMillis()) - this.startTime >= (long)this.queryTimeout) {
            throw MondrianResource.instance().QueryTimeout.ex(new Long(this.queryTimeout / 1000));
        }
    }

    public void setQueryStartTime() {
        this.startTime = System.currentTimeMillis();
        this.isExecuting = true;
    }

    public void setQueryEndExecution() {
        this.isExecuting = false;
    }

    private void normalizeAxes() {
        block0: for (int i = 0; i < this.axes.length; ++i) {
            AxisOrdinal correctOrdinal = AxisOrdinal.get(i);
            if (this.axes[i].getAxisOrdinal() == correctOrdinal) continue;
            for (int j = i + 1; j < this.axes.length; ++j) {
                if (this.axes[j].getAxisOrdinal() != correctOrdinal) continue;
                QueryAxis temp = this.axes[i];
                this.axes[i] = this.axes[j];
                this.axes[j] = temp;
                continue block0;
            }
        }
    }

    public void resolve() {
        Validator validator = this.createValidator();
        this.resolve(validator);
        Evaluator evaluator = RolapUtil.createEvaluator(this);
        ExpCompiler compiler = this.createCompiler(evaluator, validator);
        this.compile(compiler);
    }

    public boolean ignoreInvalidMembers() {
        return this.load && MondrianProperties.instance().IgnoreInvalidMembers.get();
    }

    private void compile(ExpCompiler compiler) {
        int i;
        if (this.formulas != null) {
            for (i = 0; i < this.formulas.length; ++i) {
                this.formulas[i].compile();
            }
        }
        if (this.axes != null) {
            this.axisCalcs = new Calc[this.axes.length];
            for (i = 0; i < this.axes.length; ++i) {
                this.axisCalcs[i] = this.axes[i].compile(compiler);
            }
        }
        if (this.slicerAxis != null) {
            this.slicerCalc = this.slicerAxis.compile(compiler);
        }
    }

    void resolve(Validator validator) {
        int i;
        if (this.formulas != null) {
            for (i = 0; i < this.formulas.length; ++i) {
                this.formulas[i].createElement(validator.getQuery());
            }
        }
        this.parameters.clear();
        this.parametersByName.clear();
        this.accept(new MdxVisitorImpl(){

            public Object visit(ParameterExpr parameterExpr) {
                Parameter parameter = parameterExpr.getParameter();
                if (!Query.access$000(Query.this).contains(parameter)) {
                    Query.access$000(Query.this).add(parameter);
                    Query.access$100(Query.this).put(parameter.getName(), parameter);
                }
                return null;
            }

            public Object visit(UnresolvedFunCall call) {
                if (call.getFunName().equals("Parameter")) {
                    String parameterName = ParameterFunDef.getParameterName(call.getArgs());
                    if (Query.access$100(Query.this).get(parameterName) != null) {
                        throw MondrianResource.instance().ParameterDefinedMoreThanOnce.ex(parameterName);
                    }
                    Type type = ParameterFunDef.getParameterType(call.getArgs());
                    ParameterImpl parameter = new ParameterImpl(parameterName, Literal.nullValue, null, type);
                    Query.access$000(Query.this).add(parameter);
                    Query.access$100(Query.this).put(parameterName, parameter);
                }
                return null;
            }
        });
        if (this.formulas != null) {
            for (i = 0; i < this.formulas.length; ++i) {
                validator.validate(this.formulas[i]);
            }
        }
        if (this.axes != null) {
            for (i = 0; i < this.axes.length; ++i) {
                validator.validate(this.axes[i]);
            }
        }
        if (this.slicerAxis != null) {
            this.slicerAxis.validate(validator);
        }
        Dimension[] dimensions = this.getCube().getDimensions();
        for (int i2 = 0; i2 < dimensions.length; ++i2) {
            Dimension dimension = dimensions[i2];
            int useCount = 0;
            for (int j = -1; j < this.axes.length; ++j) {
                QueryAxis axisExp;
                if (j < 0) {
                    if (this.slicerAxis == null) continue;
                    axisExp = this.slicerAxis;
                } else {
                    axisExp = this.axes[j];
                }
                if (!axisExp.getSet().getType().usesDimension(dimension, false)) continue;
                ++useCount;
            }
            if (useCount <= true) continue;
            throw MondrianResource.instance().DimensionInIndependentAxes.ex(dimension.getUniqueName());
        }
    }

    public void unparse(PrintWriter pw) {
        int i;
        if (this.formulas != null) {
            for (i = 0; i < this.formulas.length; ++i) {
                if (i == 0) {
                    pw.print("with ");
                } else {
                    pw.print("  ");
                }
                this.formulas[i].unparse(pw);
                pw.println();
            }
        }
        pw.print("select ");
        if (this.axes != null) {
            for (i = 0; i < this.axes.length; ++i) {
                this.axes[i].unparse(pw);
                if (i < this.axes.length - 1) {
                    pw.println(",");
                    pw.print("  ");
                    continue;
                }
                pw.println();
            }
        }
        if (this.cube != null) {
            pw.println("from [" + this.cube.getName() + "]");
        }
        if (this.slicerAxis != null) {
            pw.print("where ");
            this.slicerAxis.unparse(pw);
            pw.println();
        }
    }

    public String toMdx() {
        StringWriter sw = new StringWriter();
        QueryPrintWriter pw = new QueryPrintWriter(sw);
        this.unparse(pw);
        return sw.toString();
    }

    public String toString() {
        this.resolve();
        return Util.unparse(this);
    }

    public Object[] getChildren() {
        int i;
        ArrayList<QueryPart> list = new ArrayList<QueryPart>();
        for (i = 0; i < this.axes.length; ++i) {
            list.add(this.axes[i]);
        }
        if (this.slicerAxis != null) {
            list.add(this.slicerAxis);
        }
        for (i = 0; i < this.formulas.length; ++i) {
            list.add(this.formulas[i]);
        }
        return list.toArray();
    }

    public QueryAxis getSlicerAxis() {
        return this.slicerAxis;
    }

    public void setSlicerAxis(QueryAxis axis) {
        this.slicerAxis = axis;
    }

    public void addLevelToAxis(int axis, Level level) {
        Util.assertPrecondition(AxisOrdinal.enumeration.isValid(axis), "AxisOrdinal.enumeration.isValid(axis)");
        Util.assertPrecondition(axis < this.axes.length, "axis < axes.length");
        this.axes[axis].addLevel(level);
    }

    private Hierarchy[] collectHierarchies(Exp queryPart) {
        Type exprType = queryPart.getType();
        if (exprType instanceof SetType) {
            exprType = ((SetType)exprType).getElementType();
        }
        if (exprType instanceof TupleType) {
            Type[] types = ((TupleType)exprType).elementTypes;
            ArrayList<Hierarchy> hierarchyList = new ArrayList<Hierarchy>();
            for (int i = 0; i < types.length; ++i) {
                hierarchyList.add(this.getTypeHierarchy(types[i]));
            }
            return hierarchyList.toArray(new Hierarchy[hierarchyList.size()]);
        }
        return new Hierarchy[]{this.getTypeHierarchy(exprType)};
    }

    private Hierarchy getTypeHierarchy(Type type) {
        Hierarchy hierarchy = type.getHierarchy();
        if (hierarchy != null) {
            return hierarchy;
        }
        Dimension dimension = type.getDimension();
        if (dimension != null) {
            return dimension.getHierarchy();
        }
        return null;
    }

    public void setParameter(String parameterName, String value) {
        Parameter param;
        if (this.parameters.isEmpty()) {
            this.resolve();
        }
        if ((param = this.getSchemaReader(false).getParameter(parameterName)) == null) {
            throw MondrianResource.instance().UnknownParameter.ex(parameterName);
        }
        if (!param.isModifiable()) {
            throw MondrianResource.instance().ParameterIsNotModifiable.ex(parameterName, param.getScope().getName());
        }
        Exp exp = Query.quickParse(TypeUtil.typeToCategory(param.getType()), value, this);
        param.setValue(exp);
    }

    private static Exp quickParse(int category, String value, Query query) {
        switch (category) {
            case 7: {
                return Literal.create(new Double(value));
            }
            case 9: {
                return Literal.createString(value);
            }
            case 6: {
                Member member = (Member)Util.lookup(query, Util.explode(value));
                return new MemberExpr(member);
            }
        }
        throw Category.instance.badValue(category);
    }

    public void swapAxes() {
        if (this.axes.length == 2) {
            Exp e0 = this.axes[0].getSet();
            boolean nonEmpty0 = this.axes[0].isNonEmpty();
            Exp e1 = this.axes[1].getSet();
            boolean nonEmpty1 = this.axes[1].isNonEmpty();
            this.axes[1].setSet(e0);
            this.axes[1].setNonEmpty(nonEmpty0);
            this.axes[0].setSet(e1);
            this.axes[0].setNonEmpty(nonEmpty1);
        }
    }

    public Parameter[] getParameters() {
        return this.parameters.toArray(new Parameter[this.parameters.size()]);
    }

    public Cube getCube() {
        return this.cube;
    }

    public SchemaReader getSchemaReader(boolean accessControlled) {
        Role role = accessControlled ? this.getConnection().getRole() : null;
        SchemaReader cubeSchemaReader = this.cube.getSchemaReader(role);
        return new QuerySchemaReader(cubeSchemaReader);
    }

    public Member lookupMemberFromCache(String s) {
        Iterator definedMembers = this.getDefinedMembers().iterator();
        while (definedMembers.hasNext()) {
            Member mdxMember = (Member)definedMembers.next();
            if (!Util.equalName(mdxMember.getUniqueName(), s)) continue;
            return mdxMember;
        }
        return null;
    }

    private NamedSet lookupNamedSet(String name) {
        for (int i = 0; i < this.formulas.length; ++i) {
            Formula formula = this.formulas[i];
            if (formula.isMember() || formula.getElement() == null || !formula.getName().equals(name)) continue;
            return (NamedSet)formula.getElement();
        }
        return null;
    }

    public Formula[] getFormulas() {
        return this.formulas;
    }

    public QueryAxis[] getAxes() {
        return this.axes;
    }

    public void removeFormula(String uniqueName, boolean failIfUsedInQuery) {
        Formula formula = this.findFormula(uniqueName);
        if (failIfUsedInQuery && formula != null) {
            OlapElement mdxElement = formula.getElement();
            Walker walker = new Walker(this);
            while (walker.hasMoreElements()) {
                Object queryElement = walker.nextElement();
                if (!queryElement.equals(mdxElement)) continue;
                String formulaType = formula.isMember() ? MondrianResource.instance().CalculatedMember.str() : MondrianResource.instance().CalculatedSet.str();
                int i = 0;
                Object parent = walker.getAncestor(i);
                Object grandParent = walker.getAncestor(i + 1);
                while (parent != null && grandParent != null) {
                    if (grandParent instanceof Query) {
                        if (parent instanceof Axis) {
                            throw MondrianResource.instance().MdxCalculatedFormulaUsedOnAxis.ex(formulaType, uniqueName, ((QueryAxis)parent).getAxisName());
                        }
                        if (parent instanceof Formula) {
                            String parentFormulaType = ((Formula)parent).isMember() ? MondrianResource.instance().CalculatedMember.str() : MondrianResource.instance().CalculatedSet.str();
                            throw MondrianResource.instance().MdxCalculatedFormulaUsedInFormula.ex(formulaType, uniqueName, parentFormulaType, ((Formula)parent).getUniqueName());
                        }
                        throw MondrianResource.instance().MdxCalculatedFormulaUsedOnSlicer.ex(formulaType, uniqueName);
                    }
                    parent = walker.getAncestor(++i);
                    grandParent = walker.getAncestor(i + 1);
                }
                throw MondrianResource.instance().MdxCalculatedFormulaUsedInQuery.ex(formulaType, uniqueName, Util.unparse(this));
            }
        }
        ArrayList<Formula> formulaList = new ArrayList<Formula>();
        for (int i = 0; i < this.formulas.length; ++i) {
            if (this.formulas[i].getUniqueName().equalsIgnoreCase(uniqueName)) continue;
            formulaList.add(this.formulas[i]);
        }
        this.formulas = formulaList.toArray(new Formula[0]);
    }

    public boolean canRemoveFormula(String uniqueName) {
        Formula formula = this.findFormula(uniqueName);
        if (formula == null) {
            return false;
        }
        OlapElement mdxElement = formula.getElement();
        Walker walker = new Walker(this);
        while (walker.hasMoreElements()) {
            Object queryElement = walker.nextElement();
            if (!queryElement.equals(mdxElement)) continue;
            return false;
        }
        return true;
    }

    public Formula findFormula(String uniqueName) {
        for (int i = 0; i < this.formulas.length; ++i) {
            if (!this.formulas[i].getUniqueName().equalsIgnoreCase(uniqueName)) continue;
            return this.formulas[i];
        }
        return null;
    }

    public void renameFormula(String uniqueName, String newName) {
        Formula formula = this.findFormula(uniqueName);
        if (formula == null) {
            throw MondrianResource.instance().MdxFormulaNotFound.ex("formula", uniqueName, Util.unparse(this));
        }
        formula.rename(newName);
    }

    List getDefinedMembers() {
        ArrayList<OlapElement> definedMembers = new ArrayList<OlapElement>();
        for (int i = 0; i < this.formulas.length; ++i) {
            Formula formula = this.formulas[i];
            if (!formula.isMember() || formula.getElement() == null || !this.getConnection().getRole().canAccess(formula.getElement())) continue;
            definedMembers.add(formula.getElement());
        }
        return definedMembers;
    }

    public void setAxisShowEmptyCells(int axis, boolean showEmpty) {
        if (axis >= this.axes.length) {
            throw MondrianResource.instance().MdxAxisShowSubtotalsNotSupported.ex(new Integer(axis));
        }
        this.axes[axis].setNonEmpty(!showEmpty);
    }

    public Hierarchy[] getMdxHierarchiesOnAxis(int axis) {
        if (axis >= this.axes.length) {
            throw MondrianResource.instance().MdxAxisShowSubtotalsNotSupported.ex(new Integer(axis));
        }
        QueryAxis queryAxis = axis == -1 ? this.slicerAxis : this.axes[axis];
        return this.collectHierarchies(queryAxis.getSet());
    }

    public Calc compileExpression(Exp exp, boolean scalar) {
        Evaluator evaluator = RolapEvaluator.create(this);
        Validator validator = this.createValidator();
        ExpCompiler compiler = this.createCompiler(evaluator, validator);
        Calc calc = scalar ? compiler.compileScalar(exp, false) : exp.accept(compiler);
        return calc;
    }

    private ExpCompiler createCompiler(Evaluator evaluator, Validator validator) {
        ExpCompiler compiler = new BetterExpCompiler(evaluator, validator);
        int expDeps = MondrianProperties.instance().TestExpDependencies.get();
        if (expDeps > 0) {
            compiler = RolapUtil.createDependencyTestingCompiler(compiler);
        }
        return compiler;
    }

    public void addMeasuresMembers(OlapElement olapElement) {
        Member member;
        if (olapElement instanceof Member && (member = (Member)olapElement).getDimension().getOrdinal(this.getCube()) == 0) {
            this.measuresMembers.add(member);
        }
    }

    public Set getMeasuresMembers() {
        return this.measuresMembers;
    }

    public void setVirtualCubeNonNativeCrossJoin() {
        this.nativeCrossJoinVirtualCube = false;
    }

    public boolean nativeCrossJoinVirtualCube() {
        return this.nativeCrossJoinVirtualCube;
    }

    public void setVirtualCubeBaseCubeMaps(Set maps) {
        this.virtualCubeBaseCubeMaps = maps;
    }

    public Set getVirtualCubeBaseCubeMaps() {
        return this.virtualCubeBaseCubeMaps;
    }

    public void setLevelMapToMeasureMap(Map map) {
        this.levelMapToMeasureMap = map;
    }

    public Map getLevelMapToMeasureMap() {
        return this.levelMapToMeasureMap;
    }

    public Object accept(MdxVisitor visitor) {
        int i;
        Object o = visitor.visit(this);
        for (i = 0; i < this.formulas.length; ++i) {
            Formula formula = this.formulas[i];
            formula.accept(visitor);
        }
        for (i = 0; i < this.axes.length; ++i) {
            QueryAxis axis = this.axes[i];
            axis.accept(visitor);
        }
        if (this.slicerAxis != null) {
            this.slicerAxis.accept(visitor);
        }
        return o;
    }

    static List access$000(Query x0) {
        return x0.parameters;
    }

    static Map access$100(Query x0) {
        return x0.parametersByName;
    }

    static Cube access$200(Query x0) {
        return x0.cube;
    }

    static NamedSet access$300(Query x0, String x1) {
        return x0.lookupNamedSet(x1);
    }

    static Connection access$400(Query x0) {
        return x0.connection;
    }

    private static class ConnectionParameterImpl
    extends ParameterImpl {
        public ConnectionParameterImpl(String name, Literal defaultValue) {
            super(name, defaultValue, "Connection property", new StringType());
        }

        public Parameter.Scope getScope() {
            return Parameter.Scope.Connection;
        }

        public void setValue(Object value) {
            throw MondrianResource.instance().ParameterIsNotModifiable.ex(this.getName(), this.getScope().getName());
        }
    }

    private class QuerySchemaReader
    extends DelegatingSchemaReader {
        public QuerySchemaReader(SchemaReader cubeSchemaReader) {
            super(cubeSchemaReader);
        }

        public Member getMemberByUniqueName(String[] uniqueNameParts, boolean failIfNotFound) {
            return this.getMemberByUniqueName(uniqueNameParts, failIfNotFound, 1);
        }

        public Member getMemberByUniqueName(String[] uniqueNameParts, boolean failIfNotFound, int matchType) {
            String uniqueName = Util.implode(uniqueNameParts);
            Member member = Query.this.lookupMemberFromCache(uniqueName);
            if (member == null) {
                member = this.schemaReader.getMemberByUniqueName(uniqueNameParts, failIfNotFound, matchType);
            }
            if (!failIfNotFound && member == null) {
                return null;
            }
            if (this.getRole().canAccess(member)) {
                return member;
            }
            return null;
        }

        public Member[] getLevelMembers(Level level, boolean includeCalculated) {
            Member[] members = super.getLevelMembers(level, false);
            if (includeCalculated) {
                members = Util.addLevelCalculatedMembers(this, level, members);
            }
            return members;
        }

        public Member getCalculatedMember(String[] nameParts) {
            String uniqueName = Util.implode(nameParts);
            return Query.this.lookupMemberFromCache(uniqueName);
        }

        public List getCalculatedMembers(Hierarchy hierarchy) {
            ArrayList<Member> result = new ArrayList<Member>();
            List calculatedMembers = super.getCalculatedMembers(hierarchy);
            result.addAll(calculatedMembers);
            List definedMembers = Query.this.getDefinedMembers();
            for (int i = 0; i < definedMembers.size(); ++i) {
                Member member = (Member)definedMembers.get(i);
                if (!member.getHierarchy().equals(hierarchy)) continue;
                result.add(member);
            }
            return result;
        }

        public List getCalculatedMembers(Level level) {
            List hierarchyMembers = this.getCalculatedMembers(level.getHierarchy());
            ArrayList<Member> result = new ArrayList<Member>();
            for (int i = 0; i < hierarchyMembers.size(); ++i) {
                Member member = (Member)hierarchyMembers.get(i);
                if (!member.getLevel().equals(level)) continue;
                result.add(member);
            }
            return result;
        }

        public List getCalculatedMembers() {
            return Query.this.getDefinedMembers();
        }

        public OlapElement getElementChild(OlapElement parent, String s) {
            return this.getElementChild(parent, s, 1);
        }

        public OlapElement getElementChild(OlapElement parent, String s, int matchType) {
            OlapElement mdxElement = this.schemaReader.getElementChild(parent, s, matchType);
            if (mdxElement != null) {
                return mdxElement;
            }
            for (int i = 0; i < Query.this.formulas.length; ++i) {
                Formula formula = Query.this.formulas[i];
                if (formula.isMember() || !Util.equalName(formula.getNames()[0], s)) continue;
                return formula.getNamedSet();
            }
            return mdxElement;
        }

        public OlapElement lookupCompound(OlapElement parent, String[] names, boolean failIfNotFound, int category) {
            return this.lookupCompound(parent, names, failIfNotFound, category, 1);
        }

        public OlapElement lookupCompound(OlapElement parent, String[] names, boolean failIfNotFound, int category, int matchType) {
            Member member;
            Formula formula;
            switch (category) {
                case 0: 
                case 6: {
                    Member calculatedMember;
                    if (parent != Query.access$200(Query.this) || (calculatedMember = this.getCalculatedMember(names)) == null) break;
                    return calculatedMember;
                }
            }
            switch (category) {
                case 0: 
                case 8: {
                    NamedSet namedSet;
                    if (parent != Query.access$200(Query.this) || (namedSet = this.getNamedSet(names)) == null) break;
                    return namedSet;
                }
            }
            OlapElement olapElement = super.lookupCompound(parent, names, failIfNotFound, category, matchType);
            if (olapElement instanceof Member && (formula = (Formula)(member = (Member)olapElement).getPropertyValue(Property.FORMULA.name)) != null) {
                Formula formulaClone = (Formula)formula.clone();
                formulaClone.createElement(Query.this);
                formulaClone.accept(Query.this.createValidator());
                olapElement = formulaClone.getMdxMember();
            }
            return olapElement;
        }

        public NamedSet getNamedSet(String[] nameParts) {
            if (nameParts.length != 1) {
                return null;
            }
            return Query.access$300(Query.this, nameParts[0]);
        }

        public Parameter getParameter(String name) {
            for (int i = 0; i < Query.access$000(Query.this).size(); ++i) {
                Parameter parameter = (Parameter)Query.access$000(Query.this).get(i);
                if (!parameter.getName().equals(name)) continue;
                return parameter;
            }
            if (RolapConnectionProperties.instance.getValue(name, false) != null) {
                Object value = Query.access$400(Query.this).getProperty(name);
                Literal defaultValue = Literal.createString(String.valueOf(value));
                return new ConnectionParameterImpl(name, defaultValue);
            }
            return super.getParameter(name);
        }
    }

    private class StackValidator
    implements Validator {
        private final Stack stack = new Stack();
        private final FunTable funTable;
        private final Map resolvedNodes = new HashMap();
        private final Object placeHolder = "dummy";
        static final /* synthetic */ boolean $assertionsDisabled;
        private static final /* synthetic */ Class class$mondrian$olap$Query;

        public StackValidator(FunTable funTable) {
            Util.assertPrecondition(funTable != null, "funTable != null");
            this.funTable = funTable;
        }

        public Query getQuery() {
            return Query.this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Exp validate(Exp exp, boolean scalar) {
            Type type;
            Exp resolved;
            try {
                resolved = (Exp)this.resolvedNodes.get(exp);
            }
            catch (ClassCastException e) {
                throw Util.newInternal(e, "Infinite recursion encountered while validating '" + Util.unparse(exp) + "'");
            }
            if (resolved == null) {
                try {
                    this.stack.push(exp);
                    this.resolvedNodes.put(exp, this.placeHolder);
                    resolved = exp.accept(this);
                    Util.assertTrue(resolved != null);
                    this.resolvedNodes.put(exp, resolved);
                }
                finally {
                    this.stack.pop();
                }
            }
            if (scalar && !TypeUtil.canEvaluate(type = resolved.getType())) {
                String exprString = Util.unparse(resolved);
                throw MondrianResource.instance().MdxMemberExpIsSet.ex(exprString);
            }
            return resolved;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void validate(ParameterExpr parameterExpr) {
            ParameterExpr resolved = (ParameterExpr)this.resolvedNodes.get(parameterExpr);
            if (resolved != null) {
                return;
            }
            try {
                this.stack.push(parameterExpr);
                this.resolvedNodes.put(parameterExpr, this.placeHolder);
                resolved = (ParameterExpr)parameterExpr.accept(this);
                if (!$assertionsDisabled && resolved == null) {
                    throw new AssertionError();
                }
                this.resolvedNodes.put(parameterExpr, resolved);
            }
            finally {
                this.stack.pop();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void validate(MemberProperty memberProperty) {
            MemberProperty resolved = (MemberProperty)this.resolvedNodes.get(memberProperty);
            if (resolved != null) {
                return;
            }
            try {
                this.stack.push(memberProperty);
                this.resolvedNodes.put(memberProperty, this.placeHolder);
                memberProperty.resolve(this);
                this.resolvedNodes.put(memberProperty, memberProperty);
            }
            finally {
                this.stack.pop();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void validate(QueryAxis axis) {
            QueryAxis resolved = (QueryAxis)this.resolvedNodes.get(axis);
            if (resolved != null) {
                return;
            }
            try {
                this.stack.push(axis);
                this.resolvedNodes.put(axis, this.placeHolder);
                axis.resolve(this);
                this.resolvedNodes.put(axis, axis);
            }
            finally {
                this.stack.pop();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void validate(Formula formula) {
            Formula resolved = (Formula)this.resolvedNodes.get(formula);
            if (resolved != null) {
                return;
            }
            try {
                this.stack.push(formula);
                this.resolvedNodes.put(formula, this.placeHolder);
                formula.accept(this);
                this.resolvedNodes.put(formula, formula);
            }
            finally {
                this.stack.pop();
            }
        }

        public boolean canConvert(Exp fromExp, int to, int[] conversionCount) {
            return FunUtil.canConvert(fromExp, to, conversionCount);
        }

        public boolean requiresExpression() {
            return this.requiresExpression(this.stack.size() - 1);
        }

        private boolean requiresExpression(int n) {
            if (n < 1) {
                return false;
            }
            Object parent = this.stack.get(n - 1);
            if (parent instanceof Formula) {
                return ((Formula)parent).isMember();
            }
            if (parent instanceof ResolvedFunCall) {
                ResolvedFunCall funCall = (ResolvedFunCall)parent;
                if (funCall.getFunDef().getSyntax() == Syntax.Parentheses) {
                    return this.requiresExpression(n - 1);
                }
                int k = this.whichArg(funCall, (Exp)this.stack.get(n));
                if (k < 0) {
                    return false;
                }
                FunDef funDef = funCall.getFunDef();
                int[] parameterTypes = funDef.getParameterCategories();
                return parameterTypes[k] != 8;
            }
            if (parent instanceof UnresolvedFunCall) {
                UnresolvedFunCall funCall = (UnresolvedFunCall)parent;
                if (funCall.getSyntax() == Syntax.Parentheses) {
                    return this.requiresExpression(n - 1);
                }
                int k = this.whichArg(funCall, (Exp)this.stack.get(n));
                if (k < 0) {
                    return false;
                }
                return this.funTable.requiresExpression(funCall, k, this);
            }
            return false;
        }

        public FunTable getFunTable() {
            return this.funTable;
        }

        public Parameter createOrLookupParam(boolean definition, String name, Type type, Exp defaultExp, String description) {
            SchemaReader schemaReader = Query.this.getSchemaReader(false);
            Parameter param = schemaReader.getParameter(name);
            if (definition) {
                if (param != null) {
                    if (param.getScope() == Parameter.Scope.Statement) {
                        ParameterImpl paramImpl = (ParameterImpl)param;
                        paramImpl.setDescription(description);
                        paramImpl.setDefaultExp(defaultExp);
                        paramImpl.setType(type);
                    }
                    return param;
                }
                param = new ParameterImpl(name, defaultExp, description, type);
                Query.access$000(Query.this).add(param);
                Query.access$100(Query.this).put(name, param);
                return param;
            }
            if (param != null) {
                return param;
            }
            throw MondrianResource.instance().UnknownParameter.ex(name);
        }

        private int whichArg(FunCall node, Exp arg) {
            Exp[] children = node.getArgs();
            for (int i = 0; i < children.length; ++i) {
                if (children[i] != arg) continue;
                return i;
            }
            return -1;
        }

        static {
            $assertionsDisabled = !(class$mondrian$olap$Query == null ? (class$mondrian$olap$Query = StackValidator.class$("mondrian.olap.Query")) : class$mondrian$olap$Query).desiredAssertionStatus();
        }

        static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
            Class<?> clazz;
            try {
                clazz = Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                NoClassDefFoundError noClassDefFoundError = new NoClassDefFoundError(classNotFoundException.getMessage());
                try {
                    noClassDefFoundError.initCause(classNotFoundException);
                }
                catch (NoSuchMethodError noSuchMethodError) {
                    // empty catch block
                }
                throw noClassDefFoundError;
            }
            return clazz;
        }
    }
}

