/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap;

import mondrian.olap.Dimension;
import mondrian.olap.Hierarchy;
import mondrian.olap.Level;
import mondrian.olap.OlapElement;
import mondrian.olap.OlapElementBase;
import mondrian.olap.SchemaReader;
import mondrian.olap.Util;
import mondrian.resource.MondrianResource;

public abstract class HierarchyBase
extends OlapElementBase
implements Hierarchy {
    protected final Dimension dimension;
    protected final String subName;
    protected final String name;
    protected final String uniqueName;
    protected String description;
    protected Level[] levels;
    protected final boolean hasAll;
    protected String allMemberName;
    protected String allLevelName;

    protected HierarchyBase(Dimension dimension, String subName, boolean hasAll) {
        this.dimension = dimension;
        this.hasAll = hasAll;
        this.setCaption(dimension.getCaption());
        this.subName = subName;
        String name = dimension.getName();
        if (this.subName != null) {
            this.name = name + "." + subName;
            this.uniqueName = Util.makeFqName(this.name);
        } else {
            this.name = name;
            this.uniqueName = dimension.getUniqueName();
        }
    }

    public String getUniqueName() {
        return this.uniqueName;
    }

    public String getName() {
        return this.name;
    }

    public String getQualifiedName() {
        return MondrianResource.instance().MdxHierarchyName.str(this.getUniqueName());
    }

    public abstract boolean isRagged();

    public String getDescription() {
        return this.description;
    }

    public Dimension getDimension() {
        return this.dimension;
    }

    public Level[] getLevels() {
        return this.levels;
    }

    public Hierarchy getHierarchy() {
        return this;
    }

    public boolean hasAll() {
        return this.hasAll;
    }

    public boolean equals(OlapElement mdxElement) {
        return this == mdxElement;
    }

    public OlapElement lookupChild(SchemaReader schemaReader, String s) {
        return this.lookupChild(schemaReader, s, 1);
    }

    public OlapElement lookupChild(SchemaReader schemaReader, String s, int matchType) {
        OlapElement oe = Util.lookupHierarchyLevel(this, s);
        if (oe == null) {
            oe = Util.lookupHierarchyRootMember(schemaReader, this, s, matchType);
        }
        if (this.getLogger().isDebugEnabled()) {
            StringBuffer buf = new StringBuffer(64);
            buf.append("HierarchyBase.lookupChild: ");
            buf.append("name=");
            buf.append(this.getName());
            buf.append(", childname=");
            buf.append(s);
            if (oe == null) {
                buf.append(" returning null");
            } else {
                buf.append(" returning elementname=" + oe.getName());
            }
            this.getLogger().debug((Object)buf.toString());
        }
        return oe;
    }

    public String getAllMemberName() {
        return this.allMemberName;
    }
}

