/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap;

import javax.sql.DataSource;
import mondrian.olap.Connection;
import mondrian.olap.Util;
import mondrian.rolap.RolapConnection;
import mondrian.spi.CatalogLocator;
import mondrian.spi.impl.CatalogLocatorImpl;

public class DriverManager {
    public static Connection getConnection(String connectString, CatalogLocator locator, boolean fresh) {
        Util.PropertyList properties = Util.parseConnectString(connectString);
        return DriverManager.getConnection(properties, locator, fresh);
    }

    public static Connection getConnection(Util.PropertyList properties, boolean fresh) {
        return DriverManager.getConnection(properties, CatalogLocatorImpl.INSTANCE, fresh);
    }

    public static Connection getConnection(Util.PropertyList properties, CatalogLocator locator, boolean fresh) {
        return DriverManager.getConnection(properties, locator, null, fresh);
    }

    public static Connection getConnection(Util.PropertyList properties, CatalogLocator locator, DataSource dataSource, boolean fresh) {
        String provider = properties.get("PROVIDER", "mondrian");
        if (!provider.equalsIgnoreCase("mondrian")) {
            throw Util.newError("Provider not recognized: " + provider);
        }
        if (locator != null) {
            String catalog = properties.get("Catalog");
            properties.put("Catalog", locator.locate(catalog));
        }
        return new RolapConnection(properties, dataSource);
    }
}

