/*
 * Decompiled with CFR 0.152.
 */
package mondrian.mdx;

import mondrian.calc.Calc;
import mondrian.calc.ExpCompiler;
import mondrian.calc.impl.ConstantCalc;
import mondrian.mdx.MdxVisitor;
import mondrian.olap.Exp;
import mondrian.olap.ExpBase;
import mondrian.olap.Hierarchy;
import mondrian.olap.Util;
import mondrian.olap.Validator;
import mondrian.olap.type.HierarchyType;
import mondrian.olap.type.Type;

public class HierarchyExpr
extends ExpBase
implements Exp {
    private final Hierarchy hierarchy;

    public HierarchyExpr(Hierarchy hierarchy) {
        Util.assertPrecondition(hierarchy != null, "hierarchy != null");
        this.hierarchy = hierarchy;
    }

    public Hierarchy getHierarchy() {
        return this.hierarchy;
    }

    public String toString() {
        return this.hierarchy.getUniqueName();
    }

    public Type getType() {
        return HierarchyType.forHierarchy(this.hierarchy);
    }

    public Object clone() {
        return new HierarchyExpr(this.hierarchy);
    }

    public int getCategory() {
        return 3;
    }

    public Exp accept(Validator validator) {
        return this;
    }

    public Calc accept(ExpCompiler compiler) {
        return ConstantCalc.constantHierarchy(this.hierarchy);
    }

    public Object accept(MdxVisitor visitor) {
        return visitor.visit(this);
    }
}

