/*
 * Decompiled with CFR 0.152.
 */
package mondrian.jolap.util;

import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import mondrian.olap.Util;
import org.apache.log4j.Logger;

public class Model {
    private static final Logger LOGGER = Logger.getLogger((Class)(class$mondrian$jolap$util$Model == null ? (class$mondrian$jolap$util$Model = Model.class$("mondrian.jolap.util.Model")) : class$mondrian$jolap$util$Model));
    private static Model instance;
    private HashMap mapClassToEntity = new HashMap();
    private static final Entity noEntity;
    private static final Relationship noRelationship;
    private static final Attribute[] emptyAttributeArray;
    private static final Relationship[] emptyRelationshipArray;
    private static final Class[] emptyClassArray;
    static int nextOrdinal;
    private static final /* synthetic */ Class class$java$lang$Class;
    private static final /* synthetic */ Class class$mondrian$jolap$util$Model;
    private static final /* synthetic */ Class class$java$lang$Object;

    public static synchronized Model instance() {
        if (instance == null) {
            instance = new Model();
        }
        return instance;
    }

    public Entity getEntity(Object o) {
        return this.getEntityForClass(o.getClass());
    }

    private Entity getEntityForClass(Class clazz) {
        Entity entity = (Entity)this.mapClassToEntity.get(clazz);
        if (entity == null) {
            entity = this.deduceEntity(clazz);
            if (entity == null) {
                entity = noEntity;
            }
            this.mapClassToEntity.put(clazz, entity);
        }
        if (entity == noEntity) {
            return null;
        }
        return entity;
    }

    private Entity deduceEntity(Class clazz) {
        return new Entity(this, clazz);
    }

    private static String getShortName(Class clazz) {
        String clazzName = clazz.toString();
        int i = clazzName.lastIndexOf(".");
        if (i < 0) {
            return clazzName;
        }
        return clazzName.substring(i + 1);
    }

    public static void main(String[] args) {
        Model.foo(class$java$lang$Class == null ? (class$java$lang$Class = Model.class$("java.lang.Class")) : class$java$lang$Class);
    }

    public static void foo(Object o) {
        Entity entity = Model.instance().getEntity(o);
        Attribute[] attributes = entity.getAttributes();
        for (int i = 0; i < attributes.length; ++i) {
            Attribute attribute = attributes[i];
            LOGGER.debug((Object)("Attribute: " + attribute.getDescription()));
        }
        Relationship[] relationships = entity.getRelationships();
        for (int i = 0; i < relationships.length; ++i) {
            Relationship relationship = relationships[i];
            LOGGER.debug((Object)("Relationship: " + relationship.getDescription()));
        }
    }

    public void toXML(Object o, PrintWriter pw) {
        this.toXML(o, pw, new HashSet(), 0);
    }

    private void toXML(Object o, PrintWriter pw, HashSet active, int indent) {
        int i;
        Entity entity = Model.instance().getEntity(o);
        for (int i2 = 0; i2 < indent; ++i2) {
            pw.print("\t");
        }
        pw.print("<" + entity);
        int relationshipCount = 0;
        Attribute[] attributes = entity.getAttributes();
        for (int i3 = 0; i3 < attributes.length; ++i3) {
            Attribute attribute = attributes[i3];
            Object value = attribute.getValue(o);
            if (value == null) continue;
            pw.print(" " + attribute.name + "=\"" + value + "\"");
        }
        Relationship[] relationships = entity.getRelationships();
        for (i = 0; i < relationships.length; ++i) {
            if (relationshipCount++ == 0) {
                pw.println(">");
            }
            Relationship relationship = relationships[i];
            Collection targets = relationship.getTargets(o);
            Iterator iterator = targets.iterator();
            while (iterator.hasNext()) {
                Object target = iterator.next();
                if (!active.add(target)) continue;
                this.toXML(target, pw, active, indent + 1);
                active.remove(target);
            }
        }
        if (relationshipCount == 0) {
            pw.println("/>");
        } else {
            for (i = 0; i < indent; ++i) {
                pw.print("\t");
            }
            pw.println("</" + entity + ">");
        }
    }

    static String access$000(Class x0) {
        return Model.getShortName(x0);
    }

    static Attribute[] access$100() {
        return emptyAttributeArray;
    }

    static Entity access$200(Model x0, Class x1) {
        return x0.getEntityForClass(x1);
    }

    static Relationship[] access$300() {
        return emptyRelationshipArray;
    }

    static Class[] access$400() {
        return emptyClassArray;
    }

    static Relationship access$500() {
        return noRelationship;
    }

    static Logger access$600() {
        return LOGGER;
    }

    static {
        noEntity = new Entity(null, class$java$lang$Object == null ? (class$java$lang$Object = Model.class$("java.lang.Object")) : class$java$lang$Object);
        noRelationship = new Relationship(noEntity, null, null);
        emptyAttributeArray = new Attribute[0];
        emptyRelationshipArray = new Relationship[0];
        emptyClassArray = new Class[0];
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        Class<?> clazz;
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            NoClassDefFoundError noClassDefFoundError = new NoClassDefFoundError(classNotFoundException.getMessage());
            try {
                noClassDefFoundError.initCause(classNotFoundException);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
            throw noClassDefFoundError;
        }
        return clazz;
    }

    static class Relationship
    extends Member {
        private Relationship inverse;
        private Method getMethod;

        Relationship(Entity entity, java.lang.reflect.Member member, String name) {
            super(entity, member, name);
            if (member != null) {
                String getMethodName = "get" + member.getName().substring("remove".length());
                try {
                    this.getMethod = entity.clazz.getMethod(getMethodName, Model.access$400());
                }
                catch (NoSuchMethodException e) {
                    throw Util.newInternal(e, "Error while traversing relationship");
                }
                catch (SecurityException e) {
                    throw Util.newInternal(e, "Error while traversing relationship");
                }
            }
        }

        public String getDescription() {
            return this.toString() + ": " + Model.access$000(this.getTargetType()) + (this.inverse == null ? "" : " (inverse " + this.inverse.name + ")");
        }

        Class getTargetType() {
            if (this.member instanceof Method) {
                Method method = (Method)this.member;
                Util.assertTrue(method.getName().startsWith("remove") && method.getParameterTypes().length == 1);
                return method.getParameterTypes()[0];
            }
            throw Util.newInternal(this.member + " should be a Method");
        }

        Relationship getInverse() {
            if (this.inverse == null) {
                this.inverse = this.computeInverse();
            }
            if (this.inverse == Model.access$500()) {
                return null;
            }
            return this.inverse;
        }

        private Relationship computeInverse() {
            Class targetClass = this.getTargetType();
            Entity targetEntity = Model.access$200(this.getModel(), targetClass);
            Relationship[] relationships = targetEntity.getDeclaredRelationships();
            Member candidate = null;
            int candidateCount = 0;
            for (int i = 0; i < relationships.length; ++i) {
                Relationship relationship = relationships[i];
                if (relationship.getTargetType() != this.entity.clazz) continue;
                candidate = relationship;
                ++candidateCount;
            }
            Attribute[] attributes = targetEntity.getDeclaredAttributes();
            for (int i = 0; i < attributes.length; ++i) {
                Attribute attribute = attributes[i];
                if (attribute.getType() != this.entity.clazz) continue;
                candidate = attribute;
                ++candidateCount;
            }
            if (candidateCount == 1) {
                return candidate;
            }
            Model.access$600().debug((Object)("Found " + candidateCount + " candidates for inverse of " + this));
            return null;
        }

        boolean isContains() {
            return this.isMany() && this.entity.ordinal < this.getModel().getEntity((Object)this.getTargetType()).ordinal;
        }

        private boolean isMany() {
            return this.member.getName().startsWith("remove");
        }

        public Collection getTargets(Object o) {
            try {
                Object result = this.getMethod.invoke(o, (Object[])null);
                if (result instanceof Collection) {
                    return (Collection)result;
                }
                throw Util.newInternal("Cannot convert " + result.getClass() + " in to a collection");
            }
            catch (IllegalAccessException e) {
                throw Util.newInternal(e, "Error while traversing relationship");
            }
            catch (IllegalArgumentException e) {
                throw Util.newInternal(e, "Error while traversing relationship");
            }
            catch (InvocationTargetException e) {
                throw Util.newInternal(e, "Error while traversing relationship");
            }
        }
    }

    static class MethodAttribute
    extends Attribute {
        MethodAttribute(Entity entity, Method method, String name) {
            super(entity, method, name);
        }

        Class getType() {
            return this.getMethod().getReturnType();
        }

        private Method getMethod() {
            return (Method)this.member;
        }

        public Object getValue(Object o) {
            try {
                return this.getMethod().invoke(o, (Object[])null);
            }
            catch (IllegalAccessException e) {
                throw Util.newInternal(e, "Error while getting attribute value");
            }
            catch (IllegalArgumentException e) {
                throw Util.newInternal(e, "Error while getting attribute value");
            }
            catch (InvocationTargetException e) {
                if (e.getTargetException() instanceof UnsupportedOperationException) {
                    return null;
                }
                throw Util.newInternal(e, "Error while getting attribute value");
            }
        }
    }

    static class FieldAttribute
    extends Attribute {
        FieldAttribute(Entity entity, Field field, String name) {
            super(entity, field, name);
        }

        Class getType() {
            return this.getField().getType();
        }

        private Field getField() {
            return (Field)this.member;
        }

        public Object getValue(Object o) {
            try {
                return this.getField().get(o);
            }
            catch (IllegalArgumentException e) {
                throw Util.newInternal(e, "Error while printing attribute");
            }
            catch (IllegalAccessException e) {
                throw Util.newInternal(e, "Error while printing attribute");
            }
        }
    }

    static abstract class Attribute
    extends Member {
        Attribute(Entity entity, java.lang.reflect.Member member, String name) {
            super(entity, member, name);
        }

        public String getDescription() {
            return this.toString() + ": " + Model.access$000(this.getType());
        }

        abstract Class getType();

        public abstract Object getValue(Object var1);
    }

    static class Member {
        Entity entity;
        java.lang.reflect.Member member;
        String name;

        Member(Entity entity, java.lang.reflect.Member member, String name) {
            this.entity = entity;
            this.member = member;
            this.name = name;
        }

        protected Model getModel() {
            return this.entity.model;
        }

        public String toString() {
            return this.entity + "." + this.name;
        }
    }

    static class Entity {
        Model model;
        Class clazz;
        int ordinal;

        Entity(Model model, Class clazz) {
            this.model = model;
            this.clazz = clazz;
            this.ordinal = nextOrdinal++;
        }

        public String toString() {
            return Model.access$000(this.clazz);
        }

        public String getDescription() {
            return this.toString() + " (class " + this.clazz.getName() + ")";
        }

        Model getModel() {
            return this.model;
        }

        Attribute[] getDeclaredAttributes() {
            ArrayList attributeList = new ArrayList();
            ArrayList relationshipList = new ArrayList();
            this.computeMembers(attributeList, relationshipList);
            return attributeList.toArray(Model.access$100());
        }

        Attribute[] getAttributes() {
            Class[] ancestors = this.getAncestors(this.clazz);
            ArrayList attributeList = new ArrayList();
            ArrayList relationshipList = new ArrayList();
            for (int i = 0; i < ancestors.length; ++i) {
                Class ancestor = ancestors[i];
                Model.access$200(this.getModel(), ancestor).computeMembers(attributeList, relationshipList);
            }
            return attributeList.toArray(Model.access$100());
        }

        Relationship[] getRelationships() {
            Class[] ancestors = this.getAncestors(this.clazz);
            ArrayList attributeList = new ArrayList();
            ArrayList relationshipList = new ArrayList();
            for (int i = 0; i < ancestors.length; ++i) {
                Class ancestor = ancestors[i];
                this.getModel().getEntity(ancestor).computeMembers(attributeList, relationshipList);
            }
            return relationshipList.toArray(Model.access$300());
        }

        private Class[] getAncestors(Class clazz) {
            HashSet<Class<Object>> ancestors = new HashSet<Class<Object>>();
            ancestors.add(clazz);
            ArrayList extra = new ArrayList();
            while (true) {
                Iterator iterator = ancestors.iterator();
                while (iterator.hasNext()) {
                    Class ancestor = (Class)iterator.next();
                    Class superclass = ancestor.getSuperclass();
                    if (superclass != null && !ancestors.contains(superclass)) {
                        extra.add(superclass);
                    }
                    Class<?>[] interfaces = ancestor.getInterfaces();
                    for (int i = 0; i < interfaces.length; ++i) {
                        Class<?> anInterface = interfaces[i];
                        if (ancestors.contains(anInterface)) continue;
                        extra.add(anInterface);
                    }
                }
                if (extra.isEmpty()) {
                    return ancestors.toArray(Model.access$400());
                }
                ancestors.addAll(extra);
                extra.clear();
            }
        }

        Relationship[] getDeclaredRelationships() {
            ArrayList attributeList = new ArrayList();
            ArrayList relationshipList = new ArrayList();
            this.computeMembers(attributeList, relationshipList);
            return relationshipList.toArray(Model.access$300());
        }

        private void computeMembers(ArrayList attributeList, ArrayList relationshipList) {
            int i;
            int clazzModifiers = this.clazz.getModifiers();
            if (!Modifier.isPublic(clazzModifiers)) {
                return;
            }
            Field[] fields = this.clazz.getDeclaredFields();
            for (int i2 = 0; i2 < fields.length; ++i2) {
                Field field = fields[i2];
                int modifiers = field.getModifiers();
                if (!Modifier.isPublic(modifiers) || Modifier.isStatic(modifiers)) continue;
                attributeList.add(new FieldAttribute(this, field, field.getName()));
            }
            Method[] declaredMethods = this.clazz.getDeclaredMethods();
            HashSet<String> methodNames = new HashSet<String>();
            for (i = 0; i < declaredMethods.length; ++i) {
                Method declaredMethod = declaredMethods[i];
                methodNames.add(declaredMethod.getName());
            }
            for (i = 0; i < declaredMethods.length; ++i) {
                String lowerSuffix;
                String suffix;
                Method method = declaredMethods[i];
                int modifiers = method.getModifiers();
                if (!Modifier.isPublic(modifiers) || Modifier.isStatic(modifiers)) continue;
                String name = method.getName();
                if (name.startsWith("get")) {
                    if (method.getParameterTypes().length > 0 || method.getReturnType() == Void.TYPE) continue;
                    suffix = name.substring("add".length());
                    if (methodNames.contains("remove" + suffix)) continue;
                    lowerSuffix = suffix.substring(0, 1).toLowerCase() + suffix.substring(1);
                    attributeList.add(new MethodAttribute(this, method, lowerSuffix));
                    continue;
                }
                if (!name.startsWith("remove") || method.getParameterTypes().length != 1 || method.getReturnType() != Void.TYPE) continue;
                suffix = name.substring("remove".length());
                lowerSuffix = suffix.substring(0, 1).toLowerCase() + suffix.substring(1);
                relationshipList.add(new Relationship(this, method, lowerSuffix));
            }
        }
    }
}

