/*
 * Decompiled with CFR 0.152.
 */
package mondrian.jolap;

import java.util.Iterator;
import javax.olap.OLAPException;
import mondrian.jolap.MondrianCubeView;
import mondrian.jolap.MondrianDimensionStep;
import mondrian.jolap.MondrianDimensionStepManager;
import mondrian.jolap.MondrianDimensionView;
import mondrian.jolap.MondrianEdgeView;
import mondrian.jolap.MondrianJolapCube;
import mondrian.jolap.MondrianJolapDimension;
import mondrian.jolap.MondrianSegment;
import mondrian.mdx.DimensionExpr;
import mondrian.mdx.UnresolvedFunCall;
import mondrian.olap.AxisOrdinal;
import mondrian.olap.Exp;
import mondrian.olap.Formula;
import mondrian.olap.Id;
import mondrian.olap.Parameter;
import mondrian.olap.Query;
import mondrian.olap.QueryAxis;
import mondrian.olap.QueryPart;
import mondrian.olap.Syntax;
import mondrian.olap.Util;

class Converter {
    Converter() {
    }

    Query createQuery(MondrianCubeView cubeView) throws OLAPException {
        QueryAxis[] queryAxes = new QueryAxis[cubeView.getOrdinateEdge().size()];
        for (int i = 0; i < queryAxes.length; ++i) {
            queryAxes[i] = this.convert((MondrianEdgeView)cubeView.getOrdinateEdge().get(i), i);
        }
        QueryAxis slicerAxis = null;
        QueryPart[] cellProps = new QueryPart[]{};
        Parameter[] parameters = new Parameter[]{};
        MondrianJolapCube mondrianJolapCube = (MondrianJolapCube)cubeView.cube;
        if (mondrianJolapCube == null) {
            throw new OLAPException("Cube view " + cubeView + " does not have a cube");
        }
        Query query = new Query(cubeView.connection.mondrianConnection, mondrianJolapCube.cube, new Formula[0], queryAxes, slicerAxis, cellProps, parameters, false);
        return query;
    }

    private QueryAxis convert(MondrianEdgeView edgeView, int axisIndex) throws OLAPException {
        Exp exp = null;
        Iterator segments = edgeView.getSegment().iterator();
        while (segments.hasNext()) {
            MondrianSegment segment = (MondrianSegment)segments.next();
            Exp exp2 = this.convert(segment);
            exp = exp == null ? exp2 : new UnresolvedFunCall("Union", new Exp[]{exp, exp2});
            Util.assertTrue(exp != null);
        }
        if (exp == null) {
            Iterator dimensionViews = edgeView.getDimensionView().iterator();
            while (dimensionViews.hasNext()) {
                MondrianDimensionView dimensionView = (MondrianDimensionView)dimensionViews.next();
                int count = 0;
                MondrianDimensionStepManager stepManager = null;
                Iterator stepManagers = dimensionView.getDimensionStepManager().iterator();
                while (stepManagers.hasNext()) {
                    if (count++ > 1) {
                        throw Util.newInternal("DimensionView should not have more than one DimensionStepManager if its owning EdgeView does not have any Segments");
                    }
                    stepManager = (MondrianDimensionStepManager)stepManagers.next();
                }
                Exp exp2 = this.convert(dimensionView, stepManager);
                if (exp == null) {
                    exp = exp2;
                    continue;
                }
                exp = new UnresolvedFunCall("Crossjoin", new Exp[]{exp, exp2});
            }
        }
        return new QueryAxis(false, exp, AxisOrdinal.get(axisIndex), -1, new Id[0]);
    }

    private Exp convert(MondrianSegment segment) throws OLAPException {
        Exp exp = null;
        Iterator stepManagers = segment.getDimensionStepManager().iterator();
        while (stepManagers.hasNext()) {
            MondrianDimensionStepManager stepManager = (MondrianDimensionStepManager)stepManagers.next();
            Exp exp2 = this.convert(stepManager);
            if (exp == null) {
                exp = exp2;
                continue;
            }
            exp = new UnresolvedFunCall("Crossjoin", new Exp[]{exp, exp2});
        }
        return exp;
    }

    private Exp convert(MondrianDimensionStepManager stepManager) throws OLAPException {
        Exp exp = this.convert((MondrianDimensionView)stepManager.getDimensionView(), stepManager);
        Iterator steps = stepManager.getDimensionStep().iterator();
        while (steps.hasNext()) {
            MondrianDimensionStep step = (MondrianDimensionStep)steps.next();
            exp = step.convert(exp);
        }
        return exp;
    }

    Exp convert(MondrianDimensionView dimensionView, MondrianDimensionStepManager stepManager) throws OLAPException {
        if (dimensionView.dimension == null) {
            throw new OLAPException("Dimension view " + dimensionView + " has no dimension");
        }
        Exp exp = this.convert(dimensionView.dimension);
        if (stepManager != null) {
            Iterator steps = stepManager.getDimensionStep().iterator();
            while (steps.hasNext()) {
                MondrianDimensionStep step = (MondrianDimensionStep)steps.next();
                exp = step.convert(exp);
            }
        }
        return exp;
    }

    Exp convert(MondrianJolapDimension dimension) {
        return new UnresolvedFunCall("Members", Syntax.Property, new Exp[]{new DimensionExpr(dimension.dimension)});
    }
}

