/*
 * Decompiled with CFR 0.152.
 */
package mondrian.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.sql.DriverManager;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDesktopPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLayeredPane;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JToolBar;
import mondrian.gui.JDBCExplorer;
import mondrian.gui.PreferencesDialog;
import mondrian.gui.QueryPanel;
import mondrian.gui.SchemaExplorer;
import mondrian.olap.Connection;
import mondrian.olap.MondrianDef;
import mondrian.olap.MondrianProperties;
import org.eigenbase.xom.XMLOutput;

public class Workbench
extends JFrame {
    private static final String LAST_USED1 = "lastUsed1";
    private static final String LAST_USED1_URL = "lastUsedUrl1";
    private static final String LAST_USED2 = "lastUsed2";
    private static final String LAST_USED2_URL = "lastUsedUrl2";
    private static final String LAST_USED3 = "lastUsed3";
    private static final String LAST_USED3_URL = "lastUsedUrl3";
    private static final String LAST_USED4 = "lastUsed4";
    private static final String LAST_USED4_URL = "lastUsedUrl4";
    private Connection connection;
    private String jdbcDriverClassName;
    private String jdbcConnectionUrl;
    private final ClassLoader myClassLoader = this.getClass().getClassLoader();
    private Properties workbenchProperties;
    private JButton toolbarSaveAsButton;
    private JMenuItem openMenuItem;
    private JMenuItem lastUsed1MenuItem;
    private JMenuItem lastUsed2MenuItem;
    private JMenuItem lastUsed3MenuItem;
    private JMenuItem lastUsed4MenuItem;
    private JMenu fileMenu;
    private JMenuItem newQueryMenuItem;
    private JPanel jPanel1;
    private JButton toolbarOpenButton;
    private JButton toolbarNewButton;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JMenuItem cutMenuItem;
    private JMenuBar menuBar;
    private JMenuItem saveMenuItem;
    private JMenuItem newJDBCExplorerMenuItem;
    private JCheckBoxMenuItem viewCubesMenuItem;
    private JButton toolbarSaveButton;
    private JMenuItem copyMenuItem;
    private JDesktopPane desktopPane;
    private JMenu viewMenu;
    private JMenu newMenu;
    private JMenuItem deleteMenuItem;
    private JMenuItem newSchemaMenuItem;
    private JMenuItem exitMenuItem;
    private JButton toolbarPreferencesButton;
    private JCheckBoxMenuItem viewMeasuresMenuItem;
    private JMenu editMenu;
    private JMenuItem pasteMenuItem;
    private JCheckBoxMenuItem viewDimensionsMenuItem;
    private JMenuItem saveAsMenuItem;
    private JToolBar jToolBar1;

    public Workbench() {
        this.loadWorkbenchProperties();
        this.initDataSource();
        this.initComponents();
        ResourceBundle resources = ResourceBundle.getBundle("mondrian.gui.resources.gui", Locale.getDefault(), this.myClassLoader);
        ImageIcon icon = new ImageIcon(this.myClassLoader.getResource(resources.getString("cube")));
        this.setIconImage(icon.getImage());
    }

    private void loadWorkbenchProperties() {
        this.workbenchProperties = new Properties();
        try {
            this.workbenchProperties.load(new FileInputStream(new File("workbench.properties")));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeWorkbenchProperties() {
        OutputStream out = null;
        try {
            out = new FileOutputStream(new File("workbench.properties"));
            this.workbenchProperties.store(out, "Workbench configuration");
        }
        catch (Exception e) {
        }
        finally {
            try {
                out.close();
            }
            catch (IOException eIO) {}
        }
    }

    private void initDataSource() {
        this.jdbcDriverClassName = this.workbenchProperties.getProperty("jdbcDriverClassName");
        this.jdbcConnectionUrl = this.workbenchProperties.getProperty("jdbcConnectionUrl");
    }

    private void initComponents() {
        this.desktopPane = new JDesktopPane();
        this.jToolBar1 = new JToolBar();
        this.toolbarNewButton = new JButton();
        this.toolbarOpenButton = new JButton();
        this.toolbarSaveButton = new JButton();
        this.toolbarSaveAsButton = new JButton();
        this.jPanel1 = new JPanel();
        this.toolbarPreferencesButton = new JButton();
        this.menuBar = new JMenuBar();
        this.fileMenu = new JMenu();
        this.newMenu = new JMenu();
        this.newSchemaMenuItem = new JMenuItem();
        this.newQueryMenuItem = new JMenuItem();
        this.newJDBCExplorerMenuItem = new JMenuItem();
        this.openMenuItem = new JMenuItem();
        this.lastUsed1MenuItem = new JMenuItem();
        this.lastUsed2MenuItem = new JMenuItem();
        this.lastUsed3MenuItem = new JMenuItem();
        this.lastUsed4MenuItem = new JMenuItem();
        this.saveMenuItem = new JMenuItem();
        this.saveAsMenuItem = new JMenuItem();
        this.jSeparator1 = new JSeparator();
        this.jSeparator2 = new JSeparator();
        this.exitMenuItem = new JMenuItem();
        this.editMenu = new JMenu();
        this.cutMenuItem = new JMenuItem();
        this.copyMenuItem = new JMenuItem();
        this.pasteMenuItem = new JMenuItem();
        this.deleteMenuItem = new JMenuItem();
        this.viewMenu = new JMenu();
        this.viewDimensionsMenuItem = new JCheckBoxMenuItem();
        this.viewMeasuresMenuItem = new JCheckBoxMenuItem();
        this.viewCubesMenuItem = new JCheckBoxMenuItem();
        this.setTitle("Mondrian Workbench");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                Workbench.access$000(Workbench.this, evt);
            }
        });
        this.getContentPane().add((Component)this.desktopPane, "Center");
        this.toolbarNewButton.setIcon(new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/New16.gif")));
        this.toolbarNewButton.setToolTipText("New");
        this.jToolBar1.add(this.toolbarNewButton);
        this.toolbarOpenButton.setIcon(new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/Open16.gif")));
        this.toolbarOpenButton.setToolTipText("New");
        this.toolbarOpenButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Workbench.access$100(Workbench.this, evt);
            }
        });
        this.jToolBar1.add(this.toolbarOpenButton);
        this.toolbarSaveButton.setIcon(new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/Save16.gif")));
        this.toolbarSaveButton.setToolTipText("New");
        this.toolbarSaveButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Workbench.access$200(Workbench.this, evt);
            }
        });
        this.jToolBar1.add(this.toolbarSaveButton);
        this.toolbarSaveAsButton.setIcon(new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/SaveAs16.gif")));
        this.toolbarSaveAsButton.setToolTipText("New");
        this.toolbarSaveAsButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Workbench.access$300(Workbench.this, evt);
            }
        });
        this.jToolBar1.add(this.toolbarSaveAsButton);
        this.jPanel1.setMaximumSize(new Dimension(8, Short.MAX_VALUE));
        this.jToolBar1.add(this.jPanel1);
        this.toolbarPreferencesButton.setIcon(new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/Preferences16.gif")));
        this.toolbarPreferencesButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Workbench.access$400(Workbench.this, evt);
            }
        });
        this.jToolBar1.add(this.toolbarPreferencesButton);
        this.getContentPane().add((Component)this.jToolBar1, "North");
        this.fileMenu.setText("File");
        this.newMenu.setText("New");
        this.newQueryMenuItem.setText("MDX Query");
        this.newQueryMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Workbench.access$500(Workbench.this, evt);
            }
        });
        this.newMenu.add(this.newQueryMenuItem);
        this.newJDBCExplorerMenuItem.setText("JDBC Explorer");
        this.newJDBCExplorerMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Workbench.access$600(Workbench.this, evt);
            }
        });
        this.newMenu.add(this.newJDBCExplorerMenuItem);
        this.fileMenu.add(this.newMenu);
        this.openMenuItem.setText("Open");
        this.openMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Workbench.access$100(Workbench.this, evt);
            }
        });
        this.fileMenu.add(this.openMenuItem);
        this.saveMenuItem.setText("Save");
        this.saveMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Workbench.access$200(Workbench.this, evt);
            }
        });
        this.fileMenu.add(this.saveMenuItem);
        this.saveAsMenuItem.setText("Save As ...");
        this.saveAsMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Workbench.access$300(Workbench.this, evt);
            }
        });
        this.fileMenu.add(this.saveAsMenuItem);
        this.fileMenu.add(this.jSeparator2);
        this.lastUsed1MenuItem.setText(this.workbenchProperties.getProperty(LAST_USED1));
        this.lastUsed1MenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Workbench.access$700(Workbench.this, evt);
            }
        });
        this.fileMenu.add(this.lastUsed1MenuItem);
        this.lastUsed2MenuItem.setText(this.workbenchProperties.getProperty(LAST_USED2));
        this.lastUsed2MenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Workbench.access$800(Workbench.this, evt);
            }
        });
        this.fileMenu.add(this.lastUsed2MenuItem);
        this.lastUsed3MenuItem.setText(this.workbenchProperties.getProperty(LAST_USED3));
        this.lastUsed3MenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Workbench.access$900(Workbench.this, evt);
            }
        });
        this.fileMenu.add(this.lastUsed3MenuItem);
        this.lastUsed4MenuItem.setText(this.workbenchProperties.getProperty(LAST_USED4));
        this.lastUsed4MenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Workbench.access$1000(Workbench.this, evt);
            }
        });
        this.fileMenu.add(this.lastUsed4MenuItem);
        this.updateLastUsedMenu();
        this.fileMenu.add(this.jSeparator1);
        this.exitMenuItem.setText("Exit");
        this.exitMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Workbench.access$1100(Workbench.this, evt);
            }
        });
        this.fileMenu.add(this.exitMenuItem);
        this.menuBar.add(this.fileMenu);
        this.editMenu.setText("Edit");
        this.cutMenuItem.setText("Cut");
        this.editMenu.add(this.cutMenuItem);
        this.copyMenuItem.setText("Copy");
        this.editMenu.add(this.copyMenuItem);
        this.pasteMenuItem.setText("Paste");
        this.editMenu.add(this.pasteMenuItem);
        this.deleteMenuItem.setText("Delete");
        this.editMenu.add(this.deleteMenuItem);
        this.menuBar.add(this.editMenu);
        this.setJMenuBar(this.menuBar);
        this.pack();
    }

    private void newJDBCExplorerMenuItemActionPerformed(ActionEvent evt) {
        try {
            JInternalFrame jf = new JInternalFrame();
            jf.setTitle("JDBC Explorer - " + this.jdbcConnectionUrl);
            Class.forName(this.jdbcDriverClassName);
            java.sql.Connection con = DriverManager.getConnection(this.jdbcConnectionUrl);
            JDBCExplorer jdbce = new JDBCExplorer(con);
            jf.getContentPane().add(jdbce);
            jf.setBounds(0, 0, 500, 480);
            jf.setClosable(true);
            jf.setIconifiable(true);
            jf.setMaximizable(true);
            jf.setResizable(true);
            jf.setVisible(true);
            this.desktopPane.add(jf);
            jf.show();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void toolbarPreferencesButtonActionPerformed(ActionEvent evt) {
        PreferencesDialog pd = new PreferencesDialog((Frame)this, true);
        pd.setJDBCConnectionUrl(this.jdbcConnectionUrl);
        pd.setJDBCDriverClassName(this.jdbcDriverClassName);
        pd.show();
        if (pd.accepted()) {
            this.jdbcConnectionUrl = pd.getJDBCConnectionUrl();
            this.jdbcDriverClassName = pd.getJDBCDriverClassName();
            this.workbenchProperties.setProperty("jdbcDriverClassName", this.jdbcDriverClassName);
            this.workbenchProperties.setProperty("jdbcConnectionUrl", this.jdbcConnectionUrl);
        }
    }

    private void newQueryMenuItemActionPerformed(ActionEvent evt) {
        JInternalFrame jf = new JInternalFrame();
        jf.setTitle("MDX Query");
        QueryPanel qp = new QueryPanel();
        qp.setConnection(this.connection);
        jf.getContentPane().add(qp);
        jf.setBounds(0, 0, 500, 480);
        jf.setClosable(true);
        jf.setIconifiable(true);
        jf.setMaximizable(true);
        jf.setResizable(true);
        jf.setVisible(true);
        this.desktopPane.add(jf);
        jf.show();
    }

    private void saveAsMenuItemActionPerformed(ActionEvent evt) {
        JInternalFrame jf = this.desktopPane.getSelectedFrame();
        if (jf.getContentPane().getComponent(0) instanceof SchemaExplorer) {
            SchemaExplorer se = (SchemaExplorer)jf.getContentPane().getComponent(0);
            File schemaFile = se.getSchemaFile();
            MondrianDef.Schema schema = se.getSchema();
            JFileChooser jfc = new JFileChooser();
            MondrianProperties.instance();
            jfc.setSelectedFile(schemaFile);
            if (jfc.showSaveDialog(this) == 0) {
                try {
                    schemaFile = jfc.getSelectedFile();
                    XMLOutput out = new XMLOutput((Writer)new FileWriter(jfc.getSelectedFile()));
                    schema.displayXML(out);
                    se.setSchemaFile(schemaFile);
                    jf.setTitle("Schema - " + schemaFile.getName());
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    private void saveMenuItemActionPerformed(ActionEvent evt) {
        JInternalFrame jf = this.desktopPane.getSelectedFrame();
        if (jf.getContentPane().getComponent(0) instanceof SchemaExplorer) {
            SchemaExplorer se = (SchemaExplorer)jf.getContentPane().getComponent(0);
            File schemaFile = se.getSchemaFile();
            MondrianDef.Schema schema = se.getSchema();
            MondrianProperties.instance();
            try {
                XMLOutput out = new XMLOutput((Writer)new FileWriter(schemaFile));
                schema.displayXML(out);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private void setLastUsed(String name, String url) {
        if (this.workbenchProperties.getProperty(LAST_USED3) != null) {
            this.workbenchProperties.setProperty(LAST_USED4, this.workbenchProperties.getProperty(LAST_USED3));
            this.workbenchProperties.setProperty(LAST_USED4_URL, this.workbenchProperties.getProperty(LAST_USED3_URL));
        }
        if (this.workbenchProperties.getProperty(LAST_USED2) != null) {
            this.workbenchProperties.setProperty(LAST_USED3, this.workbenchProperties.getProperty(LAST_USED2));
            this.workbenchProperties.setProperty(LAST_USED3_URL, this.workbenchProperties.getProperty(LAST_USED2_URL));
        }
        if (this.workbenchProperties.getProperty(LAST_USED1) != null) {
            this.workbenchProperties.setProperty(LAST_USED2, this.workbenchProperties.getProperty(LAST_USED1));
            this.workbenchProperties.setProperty(LAST_USED2_URL, this.workbenchProperties.getProperty(LAST_USED1_URL));
        }
        this.workbenchProperties.setProperty(LAST_USED1, name);
        this.workbenchProperties.setProperty(LAST_USED1_URL, url);
        this.updateLastUsedMenu();
    }

    private void updateLastUsedMenu() {
        if (this.workbenchProperties.getProperty(LAST_USED1) == null) {
            this.jSeparator2.setVisible(false);
        } else {
            this.jSeparator2.setVisible(true);
        }
        if (this.workbenchProperties.getProperty(LAST_USED1) != null) {
            this.lastUsed1MenuItem.setVisible(true);
        } else {
            this.lastUsed1MenuItem.setVisible(false);
        }
        if (this.workbenchProperties.getProperty(LAST_USED2) != null) {
            this.lastUsed2MenuItem.setVisible(true);
        } else {
            this.lastUsed2MenuItem.setVisible(false);
        }
        if (this.workbenchProperties.getProperty(LAST_USED3) != null) {
            this.lastUsed3MenuItem.setVisible(true);
        } else {
            this.lastUsed3MenuItem.setVisible(false);
        }
        if (this.workbenchProperties.getProperty(LAST_USED4) != null) {
            this.lastUsed4MenuItem.setVisible(true);
        } else {
            this.lastUsed4MenuItem.setVisible(false);
        }
        this.lastUsed1MenuItem.setText(this.workbenchProperties.getProperty(LAST_USED1));
        this.lastUsed2MenuItem.setText(this.workbenchProperties.getProperty(LAST_USED2));
        this.lastUsed3MenuItem.setText(this.workbenchProperties.getProperty(LAST_USED3));
        this.lastUsed4MenuItem.setText(this.workbenchProperties.getProperty(LAST_USED4));
    }

    private void lastUsed1MenuItemActionPerformed(ActionEvent evt) {
        try {
            this.openSchemaFrame(new File(new URI(this.workbenchProperties.getProperty(LAST_USED1_URL))));
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
    }

    private void lastUsed2MenuItemActionPerformed(ActionEvent evt) {
        try {
            this.openSchemaFrame(new File(new URI(this.workbenchProperties.getProperty(LAST_USED2_URL))));
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
    }

    private void lastUsed3MenuItemActionPerformed(ActionEvent evt) {
        try {
            this.openSchemaFrame(new File(new URI(this.workbenchProperties.getProperty(LAST_USED3_URL))));
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
    }

    private void lastUsed4MenuItemActionPerformed(ActionEvent evt) {
        try {
            this.openSchemaFrame(new File(new URI(this.workbenchProperties.getProperty(LAST_USED4_URL))));
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
    }

    private void openSchemaFrame(File file) {
        try {
            JInternalFrame schemaFrame = new JInternalFrame();
            schemaFrame.setTitle("Schema - " + file.getName());
            Class.forName(this.jdbcDriverClassName);
            String connectString = "Provider=mondrian;Jdbc=" + this.jdbcConnectionUrl + ";" + "Catalog=" + file.toURL().toString();
            this.connection = mondrian.olap.DriverManager.getConnection(connectString, null, false);
            schemaFrame.getContentPane().add(new SchemaExplorer(file));
            schemaFrame.setBounds(0, 0, 500, 480);
            schemaFrame.setClosable(true);
            schemaFrame.setIconifiable(true);
            schemaFrame.setMaximizable(true);
            schemaFrame.setResizable(true);
            schemaFrame.setVisible(true);
            this.desktopPane.add((Component)schemaFrame, JLayeredPane.DEFAULT_LAYER);
            schemaFrame.show();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void openMenuItemActionPerformed(ActionEvent evt) {
        JFileChooser jfc = new JFileChooser();
        MondrianProperties.instance();
        if (jfc.showOpenDialog(this) == 0) {
            try {
                this.setLastUsed(jfc.getSelectedFile().getName(), jfc.getSelectedFile().toURL().toString());
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
            this.openSchemaFrame(jfc.getSelectedFile());
        }
    }

    private void exitMenuItemActionPerformed(ActionEvent evt) {
        this.storeWorkbenchProperties();
        System.exit(0);
    }

    private void exitForm(WindowEvent evt) {
        System.exit(0);
    }

    public static void main(String[] args) {
        Workbench w = new Workbench();
        w.setSize(800, 600);
        w.show();
    }

    static void access$000(Workbench x0, WindowEvent x1) {
        x0.exitForm(x1);
    }

    static void access$100(Workbench x0, ActionEvent x1) {
        x0.openMenuItemActionPerformed(x1);
    }

    static void access$200(Workbench x0, ActionEvent x1) {
        x0.saveMenuItemActionPerformed(x1);
    }

    static void access$300(Workbench x0, ActionEvent x1) {
        x0.saveAsMenuItemActionPerformed(x1);
    }

    static void access$400(Workbench x0, ActionEvent x1) {
        x0.toolbarPreferencesButtonActionPerformed(x1);
    }

    static void access$500(Workbench x0, ActionEvent x1) {
        x0.newQueryMenuItemActionPerformed(x1);
    }

    static void access$600(Workbench x0, ActionEvent x1) {
        x0.newJDBCExplorerMenuItemActionPerformed(x1);
    }

    static void access$700(Workbench x0, ActionEvent x1) {
        x0.lastUsed1MenuItemActionPerformed(x1);
    }

    static void access$800(Workbench x0, ActionEvent x1) {
        x0.lastUsed2MenuItemActionPerformed(x1);
    }

    static void access$900(Workbench x0, ActionEvent x1) {
        x0.lastUsed3MenuItemActionPerformed(x1);
    }

    static void access$1000(Workbench x0, ActionEvent x1) {
        x0.lastUsed4MenuItemActionPerformed(x1);
    }

    static void access$1100(Workbench x0, ActionEvent x1) {
        x0.exitMenuItemActionPerformed(x1);
    }
}

