/*
 * Decompiled with CFR 0.152.
 */
package mondrian.gui;

import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import mondrian.olap.MondrianDef;

public class SchemaTreeModel
extends DefaultTreeModel {
    MondrianDef.Schema schema;
    private Vector treeModelListeners = new Vector();

    public SchemaTreeModel() {
        super(null);
    }

    public SchemaTreeModel(MondrianDef.Schema s) {
        super(new DefaultMutableTreeNode(s.name));
        this.schema = s;
    }

    public Object getChild(Object parent, int index) {
        if (parent instanceof MondrianDef.Column) {
            MondrianDef.Column c = (MondrianDef.Column)((Object)parent);
        } else if (parent instanceof MondrianDef.Cube) {
            MondrianDef.Cube c = (MondrianDef.Cube)((Object)parent);
            if (c.dimensions.length > index) {
                return c.dimensions[index];
            }
            if (c.measures.length + c.dimensions.length > index) {
                return c.measures[index - c.dimensions.length];
            }
        } else if (parent instanceof MondrianDef.Dimension) {
            MondrianDef.Dimension d = (MondrianDef.Dimension)((Object)parent);
            if (d.hierarchies.length > index) {
                return d.hierarchies[index];
            }
        } else if (parent instanceof MondrianDef.DimensionUsage) {
            MondrianDef.DimensionUsage c = (MondrianDef.DimensionUsage)((Object)parent);
        } else if (parent instanceof MondrianDef.ExpressionView) {
            MondrianDef.ExpressionView ev = (MondrianDef.ExpressionView)((Object)parent);
            if (ev.expressions.length > index) {
                return ev.expressions[index];
            }
        } else if (parent instanceof MondrianDef.Hierarchy) {
            MondrianDef.Hierarchy h = (MondrianDef.Hierarchy)((Object)parent);
            if (h.levels.length > index) {
                return h.levels[index];
            }
            if (h.memberReaderParameters.length + h.levels.length > index) {
                return h.memberReaderParameters[index];
            }
        } else if (parent instanceof MondrianDef.Join) {
            MondrianDef.Join j = (MondrianDef.Join)((Object)parent);
        } else if (parent instanceof MondrianDef.Level) {
            MondrianDef.Level l = (MondrianDef.Level)((Object)parent);
            if (l.properties.length > index) {
                return l.properties[index];
            }
        } else if (parent instanceof MondrianDef.Measure) {
            MondrianDef.Measure m = (MondrianDef.Measure)((Object)parent);
        } else if (parent instanceof MondrianDef.MemberReaderParameter) {
            MondrianDef.MemberReaderParameter p = (MondrianDef.MemberReaderParameter)((Object)parent);
        } else if (parent instanceof MondrianDef.Property) {
            MondrianDef.Property p = (MondrianDef.Property)((Object)parent);
        } else if (parent instanceof MondrianDef.Schema) {
            MondrianDef.Schema s = (MondrianDef.Schema)((Object)parent);
            if (s.cubes.length > index) {
                return s.cubes[index];
            }
            if (s.virtualCubes.length + s.cubes.length > index) {
                return s.virtualCubes[index - s.cubes.length];
            }
            if (s.dimensions.length + s.virtualCubes.length + s.cubes.length > index) {
                return s.dimensions[index - s.cubes.length - s.virtualCubes.length];
            }
        } else if (parent instanceof MondrianDef.SQL) {
            MondrianDef.SQL s = (MondrianDef.SQL)((Object)parent);
        } else if (parent instanceof MondrianDef.Table) {
            MondrianDef.Table t = (MondrianDef.Table)((Object)parent);
        } else if (parent instanceof MondrianDef.View) {
            MondrianDef.View v = (MondrianDef.View)((Object)parent);
            if (v.selects.length > index) {
                return v.selects[index];
            }
        } else if (parent instanceof MondrianDef.VirtualCube) {
            MondrianDef.VirtualCube c = (MondrianDef.VirtualCube)((Object)parent);
            if (c.dimensions.length > index) {
                return c.dimensions[index];
            }
            if (c.measures.length + c.dimensions.length > index) {
                return c.measures[index - c.dimensions.length];
            }
        } else if (parent instanceof MondrianDef.VirtualCubeDimension) {
            MondrianDef.VirtualCubeDimension vcd = (MondrianDef.VirtualCubeDimension)((Object)parent);
        } else if (parent instanceof MondrianDef.VirtualCubeMeasure) {
            MondrianDef.VirtualCubeMeasure virtualCubeMeasure = (MondrianDef.VirtualCubeMeasure)((Object)parent);
        }
        return null;
    }

    public int getChildCount(Object parent) {
        int childCount = 0;
        if (parent instanceof MondrianDef.Cube) {
            MondrianDef.Cube c = (MondrianDef.Cube)((Object)parent);
            if (c.measures != null) {
                childCount += c.measures.length;
            }
            if (c.dimensions != null) {
                childCount += c.dimensions.length;
            }
        } else if (parent instanceof MondrianDef.Dimension) {
            MondrianDef.Dimension d = (MondrianDef.Dimension)((Object)parent);
            if (d.hierarchies != null) {
                childCount += d.hierarchies.length;
            }
        } else if (parent instanceof MondrianDef.ExpressionView) {
            MondrianDef.ExpressionView ev = (MondrianDef.ExpressionView)((Object)parent);
            if (ev.expressions != null) {
                childCount = ev.expressions.length;
            }
        } else if (parent instanceof MondrianDef.Hierarchy) {
            MondrianDef.Hierarchy h = (MondrianDef.Hierarchy)((Object)parent);
            if (h.memberReaderParameters != null) {
                childCount += h.memberReaderParameters.length;
            }
            if (h.levels != null) {
                childCount += h.levels.length;
            }
        } else if (parent instanceof MondrianDef.Level) {
            MondrianDef.Level l = (MondrianDef.Level)((Object)parent);
            if (l.properties != null) {
                childCount = l.properties.length;
            }
        } else if (parent instanceof MondrianDef.Schema) {
            MondrianDef.Schema s = (MondrianDef.Schema)((Object)parent);
            if (s.dimensions != null) {
                childCount += s.dimensions.length;
            }
            if (s.virtualCubes != null) {
                childCount += s.virtualCubes.length;
            }
            if (s.cubes != null) {
                childCount += s.cubes.length;
            }
        } else if (parent instanceof MondrianDef.View) {
            MondrianDef.View v = (MondrianDef.View)((Object)parent);
            if (v.selects != null) {
                childCount += v.selects.length;
            }
        } else if (parent instanceof MondrianDef.VirtualCube) {
            MondrianDef.VirtualCube c = (MondrianDef.VirtualCube)((Object)parent);
            if (c.measures != null) {
                childCount += c.measures.length;
            }
            if (c.dimensions != null) {
                childCount += c.dimensions.length;
            }
        }
        return childCount;
    }

    public int getIndexOfChild(Object parent, Object child) {
        if (parent instanceof MondrianDef.Column) {
            return -1;
        }
        if (parent instanceof MondrianDef.Cube) {
            MondrianDef.Cube c = (MondrianDef.Cube)((Object)parent);
            if (child instanceof MondrianDef.CubeDimension) {
                for (int i = 0; i < c.dimensions.length; ++i) {
                    if (!c.dimensions[i].equals(child)) continue;
                    return i;
                }
                return -1;
            }
            if (child instanceof MondrianDef.Measure) {
                for (int i = 0; i < c.measures.length; ++i) {
                    if (!c.measures[i].equals(child)) continue;
                    return i + c.dimensions.length;
                }
                return -1;
            }
            return -1;
        }
        if (parent instanceof MondrianDef.Dimension) {
            MondrianDef.Dimension d = (MondrianDef.Dimension)((Object)parent);
            if (child instanceof MondrianDef.Hierarchy) {
                for (int i = 0; i < d.hierarchies.length; ++i) {
                    if (!d.hierarchies[i].equals(child)) continue;
                    return i;
                }
                return -1;
            }
            return -1;
        }
        if (parent instanceof MondrianDef.ExpressionView) {
            MondrianDef.ExpressionView ev = (MondrianDef.ExpressionView)((Object)parent);
            if (child instanceof MondrianDef.SQL) {
                for (int i = 0; i < ev.expressions.length; ++i) {
                    if (!ev.expressions[i].equals(child)) continue;
                    return i;
                }
                return -1;
            }
            return -1;
        }
        if (parent instanceof MondrianDef.Hierarchy) {
            MondrianDef.Hierarchy h = (MondrianDef.Hierarchy)((Object)parent);
            if (child instanceof MondrianDef.Level) {
                for (int i = 0; i < h.levels.length; ++i) {
                    if (!h.levels[i].equals(child)) continue;
                    return i;
                }
                return -1;
            }
            if (child instanceof MondrianDef.MemberReaderParameter) {
                for (int i = 0; i < h.memberReaderParameters.length; ++i) {
                    if (!h.memberReaderParameters[i].equals(child)) continue;
                    return i + h.levels.length;
                }
                return -1;
            }
            return -1;
        }
        if (parent instanceof MondrianDef.Level) {
            MondrianDef.Level l = (MondrianDef.Level)((Object)parent);
            if (child instanceof MondrianDef.Property) {
                for (int i = 0; i < l.properties.length; ++i) {
                    if (!l.properties[i].equals(child)) continue;
                    return i;
                }
                return -1;
            }
            return -1;
        }
        if (parent instanceof MondrianDef.Measure) {
            MondrianDef.Measure m = (MondrianDef.Measure)((Object)parent);
            return -1;
        }
        if (parent instanceof MondrianDef.Schema) {
            MondrianDef.Schema s = (MondrianDef.Schema)((Object)parent);
            if (child instanceof MondrianDef.Cube) {
                for (int i = 0; i < s.cubes.length; ++i) {
                    if (!s.cubes[i].equals(child)) continue;
                    return i;
                }
                return -1;
            }
            if (child instanceof MondrianDef.VirtualCube) {
                for (int i = 0; i < s.virtualCubes.length; ++i) {
                    if (!s.virtualCubes[i].equals(child)) continue;
                    return i + s.cubes.length;
                }
                return -1;
            }
            if (child instanceof MondrianDef.Dimension) {
                for (int i = 0; i < s.dimensions.length; ++i) {
                    if (!s.dimensions[i].equals(child)) continue;
                    return i + s.cubes.length + s.dimensions.length;
                }
                return -1;
            }
            return -1;
        }
        if (parent instanceof MondrianDef.View) {
            MondrianDef.View v = (MondrianDef.View)((Object)parent);
            if (child instanceof MondrianDef.SQL) {
                for (int i = 0; i < v.selects.length; ++i) {
                    if (!v.selects[i].equals(child)) continue;
                    return i;
                }
                return -1;
            }
            return -1;
        }
        if (parent instanceof MondrianDef.VirtualCube) {
            MondrianDef.VirtualCube c = (MondrianDef.VirtualCube)((Object)parent);
            if (child instanceof MondrianDef.VirtualCubeDimension) {
                for (int i = 0; i < c.dimensions.length; ++i) {
                    if (!c.dimensions[i].equals(child)) continue;
                    return i;
                }
                return -1;
            }
            if (child instanceof MondrianDef.VirtualCubeMeasure) {
                for (int i = 0; i < c.measures.length; ++i) {
                    if (!c.measures[i].equals(child)) continue;
                    return i + c.dimensions.length;
                }
                return -1;
            }
            return -1;
        }
        if (parent instanceof MondrianDef.VirtualCubeDimension) {
            MondrianDef.VirtualCubeDimension d = (MondrianDef.VirtualCubeDimension)((Object)parent);
            return -1;
        }
        if (parent instanceof MondrianDef.VirtualCubeMeasure) {
            MondrianDef.VirtualCubeMeasure d = (MondrianDef.VirtualCubeMeasure)((Object)parent);
            return -1;
        }
        return -1;
    }

    public Object getRoot() {
        return this.schema;
    }

    public boolean isLeaf(Object node) {
        return this.getChildCount(node) == 0;
    }
}

