/*
 *  iReport  --  Visual designer for generating JasperReports Documents
 *  Copyright (C) 2002  Giulio Toffoli gt@businesslogic.it
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Giulio Toffoli
 *  Via T.Aspetti, 233
 *  35100 Padova ITALY
 *  gt@businesslogic.it
 */
package com.businesslogic.ireport.ui;
import com.businesslogic.ireport.*;
import com.ms.wfc.app.*;
import com.ms.wfc.core.*;
import com.ms.wfc.ui.*;
import com.ms.wfc.html.*;

/**
 * Questa classe pu accettare un numero variabile di parametri sulla riga
 * di comando. L'esecuzione del programma inizia con il metodo main(). Il costruttore
 * della classe non viene richiamato fino a quando un oggetto di tipo "FieldForm"
 * non viene creato nel metodo main().
 */
public class ParameterForm extends Form
{
	String name="";
	String classType ="";
	String description ="";
	String defaultValueExpression ="";
	boolean  isForPrompting =true;
	
	Report report;
	
	public ParameterForm(Report report)
	{
		super();

		this.report = report;
		// Necessario per il supporto della finestra di progettazione form di Visual J++
		initForm();		

		// TODO: aggiungere il codice del costruttore dopo la chiamata di initForm.
		comboBoxType.setSelectedIndex(0);
	}

	/**
	 * FieldForm esegue l'overriding di dispose e quindi pu svuotare
	 * l'elenco dei componenti.
	 */
	public void dispose()
	{
		super.dispose();
		components.dispose();
	}

	private void groupBox1_enter(Object source, Event e)
	{
		
	}

	private void button2_click(Object source, Event e)
	{
		if (editName.getText().trim().length() == 0)
		{
			MessageBox.show("Please, insert a valid parameter name!","Error!",MessageBox.ICONEXCLAMATION);
			return;
		}
		
		name = this.editName.getText();
		classType = this.comboBoxType.getText();
		
		this.setDialogResult(DialogResult.OK);
		this.dispose();
	}
	
	public void setFieldName(String name)
	{
		this.name = name;
		editName.setText(name);
	}
	public void setClassType(String type)
	{
		this.classType = type;
		comboBoxType.setText(type);
	}
	public void setIsForPrompting(boolean isf)
	{
		this.isForPrompting = isf;
		checkBox1.setChecked(isf);
	}
	
	public void setDesc(String desc)
	{
		this.description  = desc;
		this.editDescription.setText(desc);
	}
	
	public String getDesc()
	{
		return this.description;
	}
	
	public String getFieldName()
	{
		return name;
	}
	public String getClassType()
	{
		return classType;
	}
	
	

	public void setDefaultValueExpression(String val)
	{
		this.defaultValueExpression  = val;
		this.editdefaultValueExpression.setText(val);
	}
	
	public String getDefaultValueExpression()
	{
		return this.defaultValueExpression ;
	}
	
	private void checkBox1_click(Object source, Event e)
	{
		isForPrompting = checkBox1.getChecked();
	}

	private void editDescription_textChanged(Object source, Event e)
	{
		description = editDescription.getText();
	}

	private void editdefaultValueExpression_textChanged(Object source, Event e)
	{
		defaultValueExpression = editdefaultValueExpression.getText();
		if ( ((MainForm)this.report.reportForm.getMDIParent()).ireportProperties.getProperty("SYNTAX_HIGHLIGHTING")!=null &&
			 ((MainForm)this.report.reportForm.getMDIParent()).ireportProperties.getProperty("SYNTAX_HIGHLIGHTING").equalsIgnoreCase("false"))
		{
			return;
		}
		int pos = editdefaultValueExpression.getSelectionStart();
		editdefaultValueExpression.setRTF(report.formatExpression( editdefaultValueExpression.getText()));
		editdefaultValueExpression.setSelectionStart(pos);
	}

	private void editdefaultValueExpression_mouseUp(Object source, MouseEvent e)
	{
		if (e.button == MouseButton.RIGHT)
			this.contextMenu2.show(editdefaultValueExpression, new Point(e.x,e.y));
	}

	private void menuItem4_click(Object source, Event e)
	{
		source = this.getActiveControl();
		if (source instanceof RichEdit)
		{
			ExpressionGeneratorForm ef = new ExpressionGeneratorForm(report );
			ef.setExpression(((RichEdit)source).getText());
			if (ef.showDialog() == DialogResult.OK)
			{
				((RichEdit)source).setRTF(report.formatExpression(ef.getExpression()));
			}
		}
	}

	/**
	 * NOTA: il seguente codice  richiesto dalla finestra di progettazione form 
	 * di Visual J++.  possibile modificarlo con l'Editor di form.  Non modificarlo
	 * con l'Editor del codice.
	 */
	Container components = new Container();
	Edit editName = new Edit();
	Label label1 = new Label();
	GroupBox groupBox1 = new GroupBox();
	Button button1 = new Button();
	Button button2 = new Button();
	Label label2 = new Label();
	ComboBox comboBoxType = new ComboBox();
	CheckBox checkBox1 = new CheckBox();
	Edit editDescription = new Edit();
	Label label3 = new Label();
	RichEdit editdefaultValueExpression = new RichEdit();
	Label label4 = new Label();
	ContextMenu contextMenu2 = new ContextMenu();
	MenuItem menuItem4 = new MenuItem();

	private void initForm()
	{
		this.setText("Parameter properties");
		this.setAutoScaleBaseSize(new Point(5, 13));
		this.setBorderStyle(FormBorderStyle.FIXED_TOOLWINDOW);
		this.setClientSize(new Point(290, 288));
		this.setStartPosition(FormStartPosition.CENTER_SCREEN);

		editName.setLocation(new Point(8, 20));
		editName.setSize(new Point(276, 20));
		editName.setTabIndex(0);
		editName.setText("");

		label1.setLocation(new Point(8, 4));
		label1.setSize(new Point(100, 16));
		label1.setTabIndex(10);
		label1.setTabStop(false);
		label1.setText("Parameter name");

		groupBox1.setLocation(new Point(8, 244));
		groupBox1.setSize(new Point(276, 4));
		groupBox1.setTabIndex(11);
		groupBox1.setTabStop(false);
		groupBox1.setText("");
		groupBox1.addOnEnter(new EventHandler(this.groupBox1_enter));

		button1.setLocation(new Point(216, 256));
		button1.setSize(new Point(68, 24));
		button1.setTabIndex(5);
		button1.setText("Cancel");
		button1.setDialogResult(DialogResult.CANCEL);

		button2.setLocation(new Point(144, 256));
		button2.setSize(new Point(64, 24));
		button2.setTabIndex(4);
		button2.setText("Ok");
		button2.addOnClick(new EventHandler(this.button2_click));

		label2.setLocation(new Point(8, 44));
		label2.setSize(new Point(100, 16));
		label2.setTabIndex(7);
		label2.setTabStop(false);
		label2.setText("Parameter type");

		comboBoxType.setLocation(new Point(8, 60));
		comboBoxType.setSize(new Point(276, 21));
		comboBoxType.setTabIndex(1);
		comboBoxType.setText("");
		comboBoxType.setItems(new Object[] {
							  "java.lang.String", 
							  "java.lang.Object", 
							  "java.lang.Boolean", 
							  "java.lang.Byte", 
							  "java.util.Date", 
							  "java.sql.Timestamp", 
							  "java.lang.Double", 
							  "java.lang.Float", 
							  "java.lang.Integer", 
							  "java.io.InputStream", 
							  "java.lang.Long", 
							  "java.lang.Short", 
							  "java.math.BigDecimal"});

		checkBox1.setLocation(new Point(8, 84));
		checkBox1.setSize(new Point(100, 23));
		checkBox1.setTabIndex(6);
		checkBox1.setText("Is for prompting");
		checkBox1.setChecked(true);
		checkBox1.setCheckState(CheckState.CHECKED);
		checkBox1.addOnClick(new EventHandler(this.checkBox1_click));

		editDescription.setLocation(new Point(8, 192));
		editDescription.setSize(new Point(276, 44));
		editDescription.setTabIndex(3);
		editDescription.setText("");
		editDescription.setMultiline(true);
		editDescription.addOnTextChanged(new EventHandler(this.editDescription_textChanged));

		label3.setLocation(new Point(8, 176));
		label3.setSize(new Point(140, 16));
		label3.setTabIndex(9);
		label3.setTabStop(false);
		label3.setText("Parameter description");

		editdefaultValueExpression.setFont(Font.DEFAULT_GUI);
		editdefaultValueExpression.setForeColor(Color.WINDOWTEXT);
		editdefaultValueExpression.setLocation(new Point(8, 128));
		editdefaultValueExpression.setSize(new Point(276, 44));
		editdefaultValueExpression.setTabIndex(2);
		editdefaultValueExpression.setText("");
		editdefaultValueExpression.addOnMouseUp(new MouseEventHandler(this.editdefaultValueExpression_mouseUp));
		editdefaultValueExpression.addOnTextChanged(new EventHandler(this.editdefaultValueExpression_textChanged));

		label4.setLocation(new Point(8, 112));
		label4.setSize(new Point(140, 16));
		label4.setTabIndex(8);
		label4.setTabStop(false);
		label4.setText("Default value expression");

		menuItem4.setText("Edit with JasperExpression editor...");
		menuItem4.addOnClick(new EventHandler(this.menuItem4_click));

		contextMenu2.setMenuItems(new MenuItem[] {
								  menuItem4});
		/* @designTimeOnly contextMenu2.setLocation(new Point(116, 68)); */

		this.setNewControls(new Control[] {
							label4, 
							editdefaultValueExpression, 
							label3, 
							editDescription, 
							checkBox1, 
							comboBoxType, 
							label2, 
							button2, 
							button1, 
							groupBox1, 
							label1, 
							editName});
	}

	/**
	 * Punto di ingresso principale per l'applicazione. 
	 *
	 * @param args Matrice di parametri passata all'applicazione
	 * tramite la riga di comando.
	 */
	public static void main(String args[])
	{
		Application.run(new ParameterForm(null));
	}
}
