/*
 *  iReport  --  Visual designer for generating JasperReports Documents
 *  Copyright (C) 2002  Giulio Toffoli gt@businesslogic.it
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Giulio Toffoli
 *  Via T.Aspetti, 233
 *  35100 Padova ITALY
 *  gt@businesslogic.it
 */
package com.businesslogic.ireport.ui;
import com.businesslogic.ireport.*;
import com.ms.wfc.app.*;
import com.ms.wfc.core.*;
import com.ms.wfc.ui.*;
import com.ms.wfc.html.*;

/**
 * Questa classe pu accettare un numero variabile di parametri sulla riga
 * di comando. L'esecuzione del programma inizia con il metodo main(). Il costruttore
 * della classe non viene richiamato fino a quando un oggetto di tipo "GroupForm"
 * non viene creato nel metodo main().
 */
public class GroupForm extends Form
{
	Group gr;
	public int headerHeight=0;
	public int footerHeight=0;
	Report report;
	
	
	public GroupForm(Report report)
	{
		super();

		// Necessario per il supporto della finestra di progettazione form di Visual J++
		initForm();	
		this.report = report;

		gr = new Group(report,"");
		headerHeight = 50;
		footerHeight = 50;
		numberEditFooterHeight.setValue(50);
		numberEditHeaderHeight.setValue(50);
		// TODO: aggiungere il codice del costruttore dopo la chiamata di initForm.
	}

	/**
	 * GroupForm esegue l'overriding di dispose e quindi pu svuotare
	 * l'elenco dei componenti.
	 */
	public void dispose()
	{
		super.dispose();
		components.dispose();
	}
	
	public Group getGroup()
	{
		return gr;
	}
		
	public void setGroup(Group g)
	{
		gr = new Group(report,g.name);
		gr.groupExpression = g.groupExpression;
		gr.groupFooter = g.groupFooter;
		gr.groupHeader = g.groupHeader;
		gr.isReprintHeaderOnEachPage = g.isReprintHeaderOnEachPage;
		gr.isResetPageNumber = g.isResetPageNumber;
		gr.isStartNewColumn = g.isStartNewColumn;
		gr.isStartNewPage = g.isStartNewPage;
		gr.minHeightToStartNewPage = g.minHeightToStartNewPage;
		
		headerHeight=gr.groupHeader.height;
		footerHeight=gr.groupFooter.height;
	
		editName.setText(gr.name);
		editExpression.setText(gr.groupExpression);
		checkBoxIsReprintHeaderOnEachPage.setChecked(gr.isReprintHeaderOnEachPage);
		checkBoxIsResetPageNumber.setChecked(gr.isResetPageNumber);
		checkBoxIsStartNewColumn.setChecked(gr.isStartNewColumn);
		checkBoxIsStartNewPage.setChecked(gr.isStartNewPage);
		numberEditMinHeightToStartNewPage.setValue( gr.minHeightToStartNewPage);  
		numberEditFooterHeight.setValue( gr.groupFooter.height);
		numberEditHeaderHeight.setValue( gr.groupHeader.height);
	}

	private void GroupForm_click(Object source, Event e)
	{
		
	}

	private void buttonOK_click(Object source, Event e)
	{
		if (editName.getText().trim().length() == 0)
		{
			MessageBox.show("Please, insert a valid group name!","Error!",MessageBox.ICONEXCLAMATION);
			return;
		}
		
		gr.name = this.editName.getText().trim();
		gr.groupExpression = editExpression.getText();
		gr.isReprintHeaderOnEachPage = checkBoxIsReprintHeaderOnEachPage.getChecked();
		gr.isResetPageNumber = checkBoxIsResetPageNumber.getChecked();
		gr.isStartNewColumn = checkBoxIsStartNewColumn.getChecked();
		gr.isStartNewPage = checkBoxIsStartNewPage.getChecked();
		gr.minHeightToStartNewPage = (int)numberEditMinHeightToStartNewPage.getValue();  
		footerHeight = (int)numberEditFooterHeight.getValue();
		headerHeight = (int)numberEditHeaderHeight.getValue();		
		this.setDialogResult(DialogResult.OK);
		//this.report.reportForm.focus();
		this.dispose();
		
	}

	private void menuItem4_click(Object source, Event e)
	{
		source = this.getActiveControl();
		if (source instanceof RichEdit)
		{
			ExpressionGeneratorForm ef = new ExpressionGeneratorForm(report);
			ef.setExpression(((RichEdit)source).getText());
			if (ef.showDialog() == DialogResult.OK)
			{
				((RichEdit)source).setRTF(report.formatExpression(ef.getExpression()));
			}
		}
	}

	private void editExpression_textChanged(Object source, Event e)
	{
		if ( ((MainForm)this.report.reportForm.getMDIParent()).ireportProperties.getProperty("SYNTAX_HIGHLIGHTING")!=null &&
			 ((MainForm)this.report.reportForm.getMDIParent()).ireportProperties.getProperty("SYNTAX_HIGHLIGHTING").equalsIgnoreCase("false"))
		{
			return;
		}
		int pos = editExpression.getSelectionStart();
		editExpression.setRTF(report.formatExpression( editExpression.getText()));
		editExpression.setSelectionStart(pos);
	}

	private void editExpression_mouseUp(Object source, MouseEvent e)
	{
		if (e.button == MouseButton.RIGHT)
			this.contextMenu2.show(editExpression, new Point(e.x,e.y));
	}

	private void button1_click(Object source, Event e)
	{
		//this.report.reportForm.focus();
		this.setDialogResult(DialogResult.CANCEL);
		this.dispose();
	}

	/**
	 * NOTA: il seguente codice  richiesto dalla finestra di progettazione form 
	 * di Visual J++.  possibile modificarlo con l'Editor di form.  Non modificarlo
	 * con l'Editor del codice.
	 */
	Container components = new Container();
	Edit editName = new Edit();
	Label label1 = new Label();
	CheckBox checkBoxIsStartNewColumn = new CheckBox();
	CheckBox checkBoxIsStartNewPage = new CheckBox();
	CheckBox checkBoxIsResetPageNumber = new CheckBox();
	CheckBox checkBoxIsReprintHeaderOnEachPage = new CheckBox();
	NumberEdit numberEditMinHeightToStartNewPage = new NumberEdit();
	Label label2 = new Label();
	RichEdit editExpression = new RichEdit();
	Label label3 = new Label();
	NumberEdit numberEditHeaderHeight = new NumberEdit();
	NumberEdit numberEditFooterHeight = new NumberEdit();
	Label label4 = new Label();
	Label label5 = new Label();
	GroupBox groupBox1 = new GroupBox();
	Button button1 = new Button();
	Button buttonOK = new Button();
	ContextMenu contextMenu2 = new ContextMenu();
	MenuItem menuItem4 = new MenuItem();

	private void initForm()
	{
		this.setText("GroupForm");
		this.setAutoScaleBaseSize(new Point(5, 13));
		this.setBorderStyle(FormBorderStyle.FIXED_TOOLWINDOW);
		this.setClientSize(new Point(349, 332));
		this.addOnClick(new EventHandler(this.GroupForm_click));

		editName.setLocation(new Point(4, 20));
		editName.setSize(new Point(340, 20));
		editName.setTabIndex(0);
		editName.setText("");

		label1.setLocation(new Point(4, 4));
		label1.setSize(new Point(80, 16));
		label1.setTabIndex(13);
		label1.setTabStop(false);
		label1.setText("Group name");

		checkBoxIsStartNewColumn.setLocation(new Point(4, 48));
		checkBoxIsStartNewColumn.setSize(new Point(136, 23));
		checkBoxIsStartNewColumn.setTabIndex(1);
		checkBoxIsStartNewColumn.setText("Start on a new column");

		checkBoxIsStartNewPage.setLocation(new Point(4, 68));
		checkBoxIsStartNewPage.setSize(new Point(136, 23));
		checkBoxIsStartNewPage.setTabIndex(3);
		checkBoxIsStartNewPage.setText("Start on a new page");

		checkBoxIsResetPageNumber.setLocation(new Point(168, 48));
		checkBoxIsResetPageNumber.setSize(new Point(136, 23));
		checkBoxIsResetPageNumber.setTabIndex(2);
		checkBoxIsResetPageNumber.setText("Reset page number");

		checkBoxIsReprintHeaderOnEachPage.setLocation(new Point(168, 68));
		checkBoxIsReprintHeaderOnEachPage.setSize(new Point(164, 24));
		checkBoxIsReprintHeaderOnEachPage.setTabIndex(4);
		checkBoxIsReprintHeaderOnEachPage.setText("Reprint header on each page");

		numberEditMinHeightToStartNewPage.setLocation(new Point(144, 96));
		numberEditMinHeightToStartNewPage.setSize(new Point(40, 20));
		numberEditMinHeightToStartNewPage.setTabIndex(5);
		numberEditMinHeightToStartNewPage.setText("0");
		numberEditMinHeightToStartNewPage.setIsDouble(false);
		numberEditMinHeightToStartNewPage.setDecimals(0);
		numberEditMinHeightToStartNewPage.setValue(0.0d);
		numberEditMinHeightToStartNewPage.setViewPlus(false);
		numberEditMinHeightToStartNewPage.setSeparatoreMigliaia(true);

		label2.setLocation(new Point(4, 100));
		label2.setSize(new Point(140, 16));
		label2.setTabIndex(11);
		label2.setTabStop(false);
		label2.setText("Min height to start new page");

		editExpression.setFont(Font.DEFAULT_GUI);
		editExpression.setForeColor(Color.WINDOWTEXT);
		editExpression.setLocation(new Point(4, 140));
		editExpression.setSize(new Point(340, 84));
		editExpression.setTabIndex(6);
		editExpression.setText("");
		editExpression.setScrollBars(RichEditScrollBars.BOTH);
		editExpression.setWordWrap(false);
		editExpression.addOnMouseUp(new MouseEventHandler(this.editExpression_mouseUp));
		editExpression.addOnTextChanged(new EventHandler(this.editExpression_textChanged));

		label3.setLocation(new Point(4, 124));
		label3.setSize(new Point(132, 16));
		label3.setTabIndex(12);
		label3.setTabStop(false);
		label3.setText("Group expression");

		numberEditHeaderHeight.setLocation(new Point(136, 236));
		numberEditHeaderHeight.setSize(new Point(40, 20));
		numberEditHeaderHeight.setTabIndex(7);
		numberEditHeaderHeight.setText("0");
		numberEditHeaderHeight.setTextAlign(HorizontalAlignment.RIGHT);
		numberEditHeaderHeight.setIsDouble(false);
		numberEditHeaderHeight.setDecimals(0);
		numberEditHeaderHeight.setValue(0.0d);
		numberEditHeaderHeight.setViewPlus(false);
		numberEditHeaderHeight.setSeparatoreMigliaia(true);

		numberEditFooterHeight.setLocation(new Point(136, 260));
		numberEditFooterHeight.setSize(new Point(40, 20));
		numberEditFooterHeight.setTabIndex(8);
		numberEditFooterHeight.setText("0");
		numberEditFooterHeight.setTextAlign(HorizontalAlignment.RIGHT);
		numberEditFooterHeight.setIsDouble(false);
		numberEditFooterHeight.setDecimals(0);
		numberEditFooterHeight.setValue(0.0d);
		numberEditFooterHeight.setViewPlus(false);
		numberEditFooterHeight.setSeparatoreMigliaia(true);

		label4.setLocation(new Point(4, 240));
		label4.setSize(new Point(128, 16));
		label4.setTabIndex(15);
		label4.setTabStop(false);
		label4.setText("Group header band height");

		label5.setLocation(new Point(4, 260));
		label5.setSize(new Point(124, 16));
		label5.setTabIndex(14);
		label5.setTabStop(false);
		label5.setText("Group footer band height");

		groupBox1.setLocation(new Point(4, 288));
		groupBox1.setSize(new Point(340, 4));
		groupBox1.setTabIndex(16);
		groupBox1.setTabStop(false);
		groupBox1.setText("");

		button1.setLocation(new Point(276, 300));
		button1.setSize(new Point(68, 24));
		button1.setTabIndex(10);
		button1.setText("Cancel");
		button1.addOnClick(new EventHandler(this.button1_click));

		buttonOK.setLocation(new Point(196, 300));
		buttonOK.setSize(new Point(68, 24));
		buttonOK.setTabIndex(9);
		buttonOK.setText("OK");
		buttonOK.addOnClick(new EventHandler(this.buttonOK_click));

		menuItem4.setText("Edit with JasperExpression editor...");
		menuItem4.addOnClick(new EventHandler(this.menuItem4_click));

		contextMenu2.setMenuItems(new MenuItem[] {
								  menuItem4});
		/* @designTimeOnly contextMenu2.setLocation(new Point(172, 212)); */

		this.setNewControls(new Control[] {
							buttonOK, 
							button1, 
							groupBox1, 
							label5, 
							label4, 
							numberEditFooterHeight, 
							numberEditHeaderHeight, 
							label3, 
							editExpression, 
							label2, 
							numberEditMinHeightToStartNewPage, 
							checkBoxIsReprintHeaderOnEachPage, 
							checkBoxIsResetPageNumber, 
							checkBoxIsStartNewPage, 
							checkBoxIsStartNewColumn, 
							label1, 
							editName});
	}

	/**
	 * Punto di ingresso principale per l'applicazione. 
	 *
	 * @param args Matrice di parametri passata all'applicazione
	 * tramite la riga di comando.
	 */
	public static void main(String args[])
	{
		Application.run(new GroupForm(null));
	}
}
