/*
 *  iReport  --  Visual designer for generating JasperReports Documents
 *  Copyright (C) 2002  Giulio Toffoli gt@businesslogic.it
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Giulio Toffoli
 *  Via T.Aspetti, 233
 *  35100 Padova ITALY
 *  gt@businesslogic.it
 */
package com.businesslogic.ireport.ui;

import com.businesslogic.ireport.*;
import com.ms.wfc.app.*;
import com.ms.wfc.core.*;
import com.ms.wfc.ui.*;
import com.ms.wfc.html.*;
import java.util.*;

/**
 * Questa classe pu accettare un numero variabile di parametri sulla riga
 * di comando. L'esecuzione del programma inizia con il metodo main(). Il costruttore
 * della classe non viene richiamato fino a quando un oggetto di tipo "ElementsBrowser"
 * non viene creato nel metodo main().
 */
public class ElementsBrowser extends Form
{
	ReportForm reportForm;
	public ElementsBrowser()
	{
		super();

		// Necessario per il supporto della finestra di progettazione form di Visual J++
		initForm();		

		

		// TODO: aggiungere il codice del costruttore dopo la chiamata di initForm.
	}

	public void setReportForm(ReportForm rf)
	{
		reportForm = rf; 
		updateElementsList();
	}
	
	public void updateElementsList()
	{
		treeView1.removeAll();
		Enumeration enumbands = reportForm.getReport().bands.elements();
		while (enumbands.hasMoreElements())
		{
			Band b = (Band)enumbands.nextElement();
			TreeNode tn = new TreeNode( b.name,0 ,0);
			Enumeration enum = reportForm.getReport().getElements().elements();
			while (enum.hasMoreElements())
			{
				ReportElement re = (ReportElement)enum.nextElement();
				if (re.band == b)
					tn.addNode(createTreeNode(re));
			}
			treeView1.addNode(tn);
		}
	}
	
	public TreeNode createTreeNode(ReportElement re)
	{
		String name = "Unknow";
		int index = -1;
			
		if (re instanceof ImageReportElement)
		{
			name = "Image";
			index = 1;
		}
		else if (re instanceof LineReportElement)
		{	
			name = "Line";
			index = 2;
		}
		else if (re instanceof RectangleReportElement)
		{	
			name = "Rectangle";
			index = 3;
		}
		else if (re instanceof StaticTextReportElement)
		{	
			name = "Static text";
			index = 4;
		}
		else if (re instanceof SubReportElement )
		{	
			name = "Subreport";
			index = 6;
		}
		else if (re instanceof TextFieldReportElement)
		{
			name = "Textfield";
			index = 5;
		}

		int y_relative = reportForm.getReport().getBandYLocation(re.band);
		name += " "+ (re.position.x-10- reportForm.getReport().leftMargin ) + ",";
		name += " "+ (re.position.y-y_relative-10)+ ",";
		name += " "+ (re.height) + ",";
		name += " "+ (re.width) + ")";
		
		return  new  DataTreeNode(index,name,re);
	}
	/**
	 * ElementsBrowser esegue l'overriding di dispose e quindi pu svuotare
	 * l'elenco dei componenti.
	 */
	public void dispose()
	{
		super.dispose();
		components.dispose();
	}

	private void listBox1_doubleClick(Object source, Event e)
	{
		//ReportElement re = (ReportElement)listBox1.getSelectedItem();
		//if (reportForm != null)
		//reportForm.setSelectedElement(re);
	}

	private void treeView1_doubleClick(Object source, Event e)
	{
		TreeNode tn  = treeView1.getSelectedNode();
		if (tn != null && tn instanceof DataTreeNode)
		{
			reportForm.setSelectedElement( (ReportElement)((DataTreeNode)tn).data );
		}
	}


	private void treeView1_keyUp(Object source, KeyEvent e)
	{
		if (e.getKeyCode() == Key.DELETE)
		{
			TreeNode tn  = treeView1.getSelectedNode();
			if (tn != null && tn instanceof DataTreeNode)
			{
				reportForm.getReport().getElements().removeElement((ReportElement)((DataTreeNode)tn).data);
				reportForm.setSelectedElement( null );
				reportForm.refreshAll();
				tn.remove();
			}
		}
	}

	/**
	 * NOTA: il seguente codice  richiesto dalla finestra di progettazione form 
	 * di Visual J++.  possibile modificarlo con l'Editor di form.  Non modificarlo
	 * con l'Editor del codice.
	 */
	Container components = new Container();
	TreeView treeView1 = new TreeView();
	ImageList imageList1 = new ImageList();

	private void initForm()
	{
		// NOTA: questo form contiene informazioni relative alle risorse in
		// un file esterno. Non modificare il parametro di tipo String delle
		// chiamate alla funzione resources.getObject(). Ad esempio, non
		// modificare"foo1_location" nella seguente riga di codice,
		// nemmeno se il nome dell'oggetto Foo viene modificato: 
		//	 foo1.setLocation((Point)resources.getObject("foo1_location"));

		IResourceManager resources = new ResourceManager(this, "ElementsBrowser");
		this.setText("ElementsBrowser");
		this.setAutoScaleBaseSize(new Point(5, 13));
		this.setClientSize(new Point(300, 300));
		this.setIcon((Icon)resources.getObject("this_icon"));
		this.setShowInTaskbar(false);

		imageList1.setColorDepth(ColorDepth.COLORDEPTH_64K_COLORS);
		imageList1.setImageStream((ImageListStreamer)resources.getObject("imageList1_imageStream"));
		/* @designTimeOnly imageList1.setLocation(new Point(104, 168)); */

		treeView1.setDock(ControlDock.FILL);
		treeView1.setSize(new Point(300, 300));
		treeView1.setTabIndex(0);
		treeView1.setText("treeView1");
		treeView1.setImageList(imageList1);
		treeView1.setIndent(19);
		treeView1.addOnDoubleClick(new EventHandler(this.treeView1_doubleClick));
		treeView1.addOnKeyUp(new KeyEventHandler(this.treeView1_keyUp));

		this.setNewControls(new Control[] {
							treeView1});
	}

	/**
	 * Punto di ingresso principale per l'applicazione. 
	 *
	 * @param args Matrice di parametri passata all'applicazione
	 * tramite la riga di comando.
	 */
	public static void main(String args[])
	{
		Application.run(new ElementsBrowser());
	}
}
